/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.awt.Toolkit;
import javax.annotation.Nonnull;
import org.fest.assertions.Assertions;
import org.fest.assertions.IntArrayAssert;
import org.fest.swing.util.Modifiers;
import org.fest.swing.util.OSFamily;
import org.fest.swing.util.OSIdentifier;
import org.fest.swing.util.ToolkitProvider;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

public final class Platform {
    private static OSIdentifier osIdentifier;
    private static Toolkit toolkit;

    @VisibleForTesting
    static void reload() {
        Platform.initialize(new OSIdentifier(), ToolkitProvider.instance().defaultToolkit());
    }

    @VisibleForTesting
    static void initialize(@Nonnull OSIdentifier osIdentifier, @Nonnull Toolkit toolkit) {
        if (osIdentifier == null) {
            Platform.$$$reportNull$$$0(0);
        }
        if (toolkit == null) {
            Platform.$$$reportNull$$$0(1);
        }
        Platform.osIdentifier = osIdentifier;
        Platform.toolkit = toolkit;
    }

    public static int controlOrCommandKey() {
        int menuShortcutKeyMask = Platform.controlOrCommandMask();
        int[] keys = Modifiers.keysFor(menuShortcutKeyMask);
        ((IntArrayAssert)((IntArrayAssert)Assertions.assertThat((int[])keys).as(Strings.concat((Object[])new Object[]{"Key code for mask ", String.valueOf(menuShortcutKeyMask)}))).isNotNull()).hasSize(1);
        return keys[0];
    }

    public static int controlOrCommandMask() {
        return toolkit.getMenuShortcutKeyMask();
    }

    public static boolean canResizeWindows() {
        return !Platform.isWindows() && !Platform.isMacintosh();
    }

    public static boolean canMoveWindows() {
        return !Platform.isWindows() && !Platform.isMacintosh();
    }

    public static boolean isWindows() {
        return osIdentifier.isWindows();
    }

    public static boolean isWindows9x() {
        return osIdentifier.isWindows9x();
    }

    public static boolean isWindowsXP() {
        return osIdentifier.isWindowsXP();
    }

    public static boolean isMacintosh() {
        return osIdentifier.isMacintosh();
    }

    public static boolean isOSX() {
        return osIdentifier.isOSX();
    }

    public static boolean isX11() {
        return osIdentifier.isX11();
    }

    public static boolean isSolaris() {
        return osIdentifier.isSolaris();
    }

    public static boolean isHPUX() {
        return osIdentifier.isHPUX();
    }

    public static boolean isLinux() {
        return osIdentifier.isLinux();
    }

    @Nonnull
    public static OSFamily osFamily() {
        OSFamily oSFamily = osIdentifier.osFamily();
        if (oSFamily == null) {
            Platform.$$$reportNull$$$0(2);
        }
        return oSFamily;
    }

    private Platform() {
    }

    static {
        Platform.reload();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osIdentifier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/util/Platform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/util/Platform";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "osFamily";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

