/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate;

import com.intellij.hibernate.facet.HibernateVersion;
import com.intellij.hibernate.model.converters.ClassWithShortcutsResolvingConverter;
import com.intellij.hibernate.model.converters.GeneratorClassResolvingConverter;
import com.intellij.hibernate.model.enums.EntityModeType;
import com.intellij.hibernate.model.enums.HBM2DDLAutoType;
import com.intellij.hibernate.model.enums.ReleaseConnectionsType;
import com.intellij.hibernate.model.xml.config.Property;
import com.intellij.hibernate.model.xml.mapping.HbmGenerator;
import com.intellij.hibernate.model.xml.mapping.HbmParam;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.javaee.model.JavaeePersistenceORMResolveConverters;
import com.intellij.javaee.model.xml.GenericNamedValueConvertersRegistry;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.ModuleContextProvider;
import com.intellij.util.xml.ResolvingConverter;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateConverters
implements Consumer<GenericNamedValueConvertersRegistry> {
    private static final Map<HibernateVersion, Map<String, String>> SESSION_CONTEXT_MAP = new THashMap();
    private static final Condition<com.intellij.javaee.model.xml.persistence.Property> ourHibernateProviderCondition;

    public void consume(GenericNamedValueConvertersRegistry registry) {
        HibernateConverters.registerAllConverters(registry);
    }

    private static void sessionContextMap(HibernateVersion version, @NotNull String key, @NotNull String value) {
        if (key == null) {
            HibernateConverters.$$$reportNull$$$0(0);
        }
        if (value == null) {
            HibernateConverters.$$$reportNull$$$0(1);
        }
        if (!SESSION_CONTEXT_MAP.containsKey((Object)version)) {
            SESSION_CONTEXT_MAP.put(version, (Map<String, String>)new THashMap());
        }
        SESSION_CONTEXT_MAP.get((Object)version).put(key, value);
    }

    private static void registerAllConverters(GenericNamedValueConvertersRegistry registry) {
        ConverterManager converterManager = (ConverterManager)ServiceManager.getService(ConverterManager.class);
        HibernateConverters.registerConfigProperty(registry, "transaction.auto_close_session", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "connection.driver_class", HibernateConverters.getPsiClassConverter("java.sql.Driver"));
        HibernateConverters.registerConfigProperty(registry, "connection.isolation", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "connection.url", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "connection.username", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "connection.password", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "connection.autocommit", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "connection.pool_size", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "connection.datasource", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "jndi.class", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "jndi.url", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "session_factory_name", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "default_schema", HibernateConverters.getSchemaConverter(converterManager));
        HibernateConverters.registerConfigProperty(registry, "default_catalog", HibernateConverters.getCatalogConverter(converterManager));
        HibernateConverters.registerConfigProperty(registry, "show_sql", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "format_sql", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "use_sql_comments", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "max_fetch_depth", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "default_batch_fetch_size", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "jdbc.use_streams_for_binary", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "jdbc.use_scrollable_resultset", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "jdbc.use_get_generated_keys", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "jdbc.fetch_size", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "jdbc.batch_size", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "jdbc.batch_versioned_data", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "xml.output_stylesheet", HibernateConverters.getResourceConverter());
        HibernateConverters.registerConfigProperty(registry, "c3p0.max_size", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "c3p0.min_size", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "c3p0.timeout", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "c3p0.max_statements", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "c3p0.acquire_increment", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "c3p0.idle_test_period", ResolvingConverter.INTEGER_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "proxool.xml", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "proxool.properties", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "proxool.existing_pool", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "proxool.pool_alias", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "transaction.auto_close_session", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "transaction.flush_before_completion", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "connection.release_mode", (Converter)EnumConverter.createEnumConverter(ReleaseConnectionsType.class));
        HibernateConverters.registerConfigProperty(registry, "jta.UserTransaction", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "cache.provider_configuration_file_resource_path", HibernateConverters.getFilePathConverter());
        HibernateConverters.registerConfigProperty(registry, "cache.jndi", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "cache.use_query_cache", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "cache.use_second_level_cache", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "cache.use_minimal_puts", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "cache.region_prefix", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "cache.use_structured_entries", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "generate_statistics", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "use_identifier_rollback", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "bytecode.use_reflection_optimizer", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "query.substitutions", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "hbm2ddl.auto", (Converter)EnumConverter.createEnumConverter(HBM2DDLAutoType.class));
        HibernateConverters.registerConfigProperty(registry, "jdbc.wrap_result_sets", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "order_updates", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "default_entity_mode", (Converter)EnumConverter.createEnumConverter(EntityModeType.class));
        HibernateConverters.registerConfigProperty(registry, "jacc_context_id", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "query.jpaql_strict_compliance", ResolvingConverter.BOOLEAN_CONVERTER);
        HibernateConverters.registerConfigProperty(registry, "connection.provider_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.connection.ConnectionProvider", HibernateVersion.Hibernate_3_X).add("org.hibernate.service.jdbc.connections.spi.ConnectionProvider", HibernateVersion.Hibernate_4_X, HibernateVersion.Hibernate_5_0, HibernateVersion.Hibernate_5_2)));
        HibernateConverters.registerConfigProperty(registry, "dialect", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.dialect.Dialect", HibernateVersion.values())));
        HibernateConverters.registerConfigProperty(registry, "jdbc.factory_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.jdbc.Batcher", HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(registry, "ejb.naming_strategy", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.cfg.NamingStrategy", HibernateVersion.values())));
        HibernateConverters.registerConfigProperty(registry, "transaction.factory_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.transaction.TransactionFactory", HibernateVersion.Hibernate_3_X).add("org.hibernate.engine.transaction.spi.TransactionFactory", HibernateVersion.Hibernate_4_X)));
        HibernateConverters.registerConfigProperty(registry, "transaction.manager_lookup_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.transaction.TransactionManagerLookup", HibernateVersion.Hibernate_4_X, HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(registry, "cache.provider_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.cache.CacheProvider", HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(registry, "cache.query_cache_factory", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.cache.spi.QueryCacheFactory", HibernateVersion.Hibernate_5_2, HibernateVersion.Hibernate_5_0, HibernateVersion.Hibernate_4_X).add("org.hibernate.cache.QueryCacheFactory", HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(registry, "query.factory_class", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.hql.spi.QueryTranslatorFactory", HibernateVersion.Hibernate_5_2, HibernateVersion.Hibernate_5_0, HibernateVersion.Hibernate_4_X).add("org.hibernate.hql.QueryTranslatorFactory", HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registerConfigProperty(registry, "jdbc.sql_exception_converter", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.exception.SQLExceptionConverter", HibernateVersion.values())));
        HibernateConverters.registerConfigProperty(registry, "bytecode.provider", HibernateConverters.getConverter(VersionsHelper.get("org.hibernate.bytecode.spi.BytecodeProvider", HibernateVersion.Hibernate_5_2, HibernateVersion.Hibernate_5_0, HibernateVersion.Hibernate_4_X).add("org.hibernate.bytecode.BytecodeProvider", HibernateVersion.Hibernate_3_X)));
        HibernateConverters.registrySessionContexClass(registry);
        Condition<HbmParam> genAssignedCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.Assigned");
        registry.registerValueConverter(HbmParam.class, genAssignedCondition, "entity_name", HibernateConverters.getEntityConverter());
        Condition<HbmParam> genIncrementCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.IncrementGenerator");
        registry.registerValueConverter(HbmParam.class, genIncrementCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genIncrementCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genIncrementCondition, "tables", HibernateConverters.getTableConverter(true, converterManager));
        registry.registerValueConverter(HbmParam.class, genIncrementCondition, "identity_tables", HibernateConverters.getTableConverter(true, converterManager));
        registry.registerValueConverter(HbmParam.class, genIncrementCondition, "target_column", HibernateConverters.getColumnConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genIncrementCondition, "column", HibernateConverters.getCatalogConverter(converterManager));
        Condition<HbmParam> genSequenceCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.SequenceGenerator");
        registry.registerValueConverter(HbmParam.class, genSequenceCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genSequenceCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genSequenceCondition, "sequence", HibernateConverters.getSequenceConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genSequenceCondition, "parameters", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        Condition<HbmParam> genHiLoCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.TableHiLoGenerator");
        registry.registerValueConverter(HbmParam.class, genHiLoCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genHiLoCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genHiLoCondition, "table", HibernateConverters.getTableConverter(false, converterManager));
        registry.registerValueConverter(HbmParam.class, genHiLoCondition, "max_lo", ResolvingConverter.INTEGER_CONVERTER);
        Condition<HbmParam> genSeqHiLoCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.SequenceHiLoGenerator");
        registry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "sequence", HibernateConverters.getSequenceConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "parameters", (Converter)ResolvingConverter.EMPTY_CONVERTER);
        registry.registerValueConverter(HbmParam.class, genSeqHiLoCondition, "max_lo", ResolvingConverter.INTEGER_CONVERTER);
        Condition<HbmParam> genSelectCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.SelectGenerator");
        registry.registerValueConverter(HbmParam.class, genSelectCondition, "key", HibernateConverters.getPropertyConverter());
        Condition<HbmParam> genForeignCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.ForeignGenerator");
        registry.registerValueConverter(HbmParam.class, genForeignCondition, "property", HibernateConverters.getPropertyConverter());
        registry.registerValueConverter(HbmParam.class, genForeignCondition, "entity_name", HibernateConverters.getEntityConverter());
        Condition<HbmParam> genSequenceIdentityCondition = HibernateConverters.createGeneratorTypeCondition("org.hibernate.id.SequenceIdentityGenerator");
        registry.registerValueConverter(HbmParam.class, genSequenceIdentityCondition, "schema", HibernateConverters.getSchemaConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genSequenceIdentityCondition, "catalog", HibernateConverters.getCatalogConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genSequenceIdentityCondition, "sequence", HibernateConverters.getSequenceConverter(converterManager));
        registry.registerValueConverter(HbmParam.class, genSequenceIdentityCondition, "parameters", (Converter)ResolvingConverter.EMPTY_CONVERTER);
    }

    private static void registrySessionContexClass(GenericNamedValueConvertersRegistry registry) {
        ClassWithShortcutsResolvingConverter converter = new ClassWithShortcutsResolvingConverter(){

            @Nullable
            protected String getBaseClassName(ConvertContext context) {
                String className = null;
                for (Module module : ModuleContextProvider.getModules((PsiFile)context.getFile())) {
                    HibernateVersion version = HibernateUtil.getHibernateVersion(module);
                    if (version == HibernateVersion.Hibernate_3_X) {
                        className = "org.hibernate.context.CurrentSessionContext";
                        break;
                    }
                    if (version != HibernateVersion.Hibernate_4_X && version != HibernateVersion.Hibernate_5_0 && version != HibernateVersion.Hibernate_5_2) continue;
                    className = "org.hibernate.context.spi.CurrentSessionContext";
                    break;
                }
                return className;
            }

            @Override
            @NotNull
            protected Map<String, String> getShortcutsMap(ConvertContext context) {
                Module module = context.getModule();
                if (module != null) {
                    HibernateVersion version = HibernateUtil.getHibernateVersion(module);
                    Map sessionContextMap = (Map)SESSION_CONTEXT_MAP.get((Object)version);
                    if (sessionContextMap != null) {
                        Map map = sessionContextMap;
                        if (map == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return map;
                    }
                }
                Map<String, String> map = Collections.emptyMap();
                if (map == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/HibernateConverters$1", "getShortcutsMap"));
            }
        };
        HibernateConverters.registerConfigProperty(registry, "current_session_context_class", (Converter)converter);
    }

    protected static void registerConfigProperty(GenericNamedValueConvertersRegistry registry, String name, Converter converter) {
        registry.registerValueConverter(Property.class, Conditions.alwaysTrue(), name, converter);
        registry.registerValueConverter(Property.class, Conditions.alwaysTrue(), "hibernate." + name, converter);
        registry.registerValueConverter(com.intellij.javaee.model.xml.persistence.Property.class, ourHibernateProviderCondition, name, converter);
        registry.registerValueConverter(com.intellij.javaee.model.xml.persistence.Property.class, ourHibernateProviderCondition, "hibernate." + name, converter);
    }

    private static Condition<HbmParam> createGeneratorTypeCondition(String generatorClassName) {
        return domElement -> {
            DomElement parent = domElement.getParent();
            if (!(parent instanceof HbmGenerator)) {
                return false;
            }
            HbmGenerator generator = (HbmGenerator)parent;
            String className = GeneratorClassResolvingConverter.getGeneratorClassName(generator.getClazz().getStringValue());
            return Comparing.equal((String)className, (String)generatorClassName);
        };
    }

    private static Converter getPsiClassConverter(String baseClassName) {
        return HibernateConverters.getPsiClassConverter(baseClassName, Collections.emptyMap());
    }

    private static Converter getPsiClassConverter(final String baseClassName, final Map<String, String> shortcutMap) {
        return new ClassWithShortcutsResolvingConverter(){

            @Nullable
            protected String getBaseClassName(ConvertContext context) {
                return baseClassName;
            }

            @Override
            @NotNull
            protected Map<String, String> getShortcutsMap(ConvertContext context) {
                Map map = shortcutMap;
                if (map == null) {
                    2.$$$reportNull$$$0(0);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/HibernateConverters$2", "getShortcutsMap"));
            }
        };
    }

    private static Converter getConverter(final VersionsHelper helper) {
        return new ClassWithShortcutsResolvingConverter(){

            @Nullable
            protected String getBaseClassName(ConvertContext context) {
                for (Module module : ModuleContextProvider.getModules((PsiFile)context.getFile())) {
                    HibernateVersion version = HibernateUtil.getHibernateVersion(module);
                    String s = helper.getVersionsMap().get((Object)version);
                    if (s == null) continue;
                    return s;
                }
                return null;
            }

            @Override
            @NotNull
            protected Map<String, String> getShortcutsMap(ConvertContext context) {
                Map<String, String> map = Collections.emptyMap();
                if (map == null) {
                    3.$$$reportNull$$$0(0);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/HibernateConverters$3", "getShortcutsMap"));
            }
        };
    }

    private static Converter getSchemaConverter(ConverterManager converterManager) {
        return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.SchemaResolver.class);
    }

    private static Converter getCatalogConverter(ConverterManager converterManager) {
        return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.CatalogResolver.class);
    }

    private static Converter getTableConverter(boolean isList, ConverterManager converterManager) {
        if (!isList) {
            return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.TableResolver.class);
        }
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static Converter getSequenceConverter(ConverterManager converterManager) {
        return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.SequenceResolver.class);
    }

    private static Converter getColumnConverter(ConverterManager converterManager) {
        return converterManager.getConverterInstance(JavaeePersistenceORMResolveConverters.ColumnResolver.class);
    }

    private static Converter getEntityConverter() {
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static Converter getPropertyConverter() {
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static Converter getResourceConverter() {
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    private static Converter getFilePathConverter() {
        return ResolvingConverter.EMPTY_CONVERTER;
    }

    static {
        HibernateConverters.sessionContextMap(HibernateVersion.Hibernate_3_X, "jta", "org.hibernate.context.JTASessionContext");
        HibernateConverters.sessionContextMap(HibernateVersion.Hibernate_3_X, "thread", "org.hibernate.context.ThreadLocalSessionContext");
        HibernateConverters.sessionContextMap(HibernateVersion.Hibernate_3_X, "managed", "org.hibernate.context.ManagedSessionContext");
        HibernateConverters.sessionContextMap(HibernateVersion.Hibernate_4_X, "jta", "org.hibernate.context.internal.JTASessionContext");
        HibernateConverters.sessionContextMap(HibernateVersion.Hibernate_4_X, "thread", "org.hibernate.context.internal.ThreadLocalSessionContext");
        HibernateConverters.sessionContextMap(HibernateVersion.Hibernate_4_X, "managed", "org.hibernate.context.internal.ManagedSessionContext");
        HibernateConverters.sessionContextMap(HibernateVersion.Hibernate_5_0, "jta", "org.hibernate.context.internal.JTASessionContext");
        HibernateConverters.sessionContextMap(HibernateVersion.Hibernate_5_0, "thread", "org.hibernate.context.internal.ThreadLocalSessionContext");
        HibernateConverters.sessionContextMap(HibernateVersion.Hibernate_5_0, "managed", "org.hibernate.context.internal.ManagedSessionContext");
        HibernateConverters.sessionContextMap(HibernateVersion.Hibernate_5_2, "jta", "org.hibernate.context.internal.JTASessionContext");
        HibernateConverters.sessionContextMap(HibernateVersion.Hibernate_5_2, "thread", "org.hibernate.context.internal.ThreadLocalSessionContext");
        HibernateConverters.sessionContextMap(HibernateVersion.Hibernate_5_2, "managed", "org.hibernate.context.internal.ManagedSessionContext");
        ourHibernateProviderCondition = domElement -> JpaUtil.isHibernate((JpaImplementationProvider)JpaUtil.findJpaProvider(null, (PersistencePackage)((PersistencePackage)domElement.getParentOfType(PersistenceUnit.class, true)), (boolean)false), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "key";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "value";
                break;
            }
        }
        objectArray[1] = "com/intellij/hibernate/HibernateConverters";
        objectArray[2] = "sessionContextMap";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VersionsHelper {
        Map<HibernateVersion, String> myMap = ContainerUtil.newHashMap();

        private VersionsHelper() {
        }

        public Map<HibernateVersion, String> getVersionsMap() {
            return this.myMap;
        }

        public static VersionsHelper get(String s, HibernateVersion ... versions) {
            VersionsHelper c = new VersionsHelper();
            c.add(s, versions);
            return c;
        }

        public VersionsHelper add(HibernateVersion version, String s) {
            this.myMap.put(version, s);
            return this;
        }

        public VersionsHelper add(String s, HibernateVersion ... versions) {
            for (HibernateVersion version : versions) {
                this.myMap.put(version, s);
            }
            return this;
        }
    }
}

