/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.enums;

import com.intellij.hibernate.HibernateMessages;
import com.intellij.hibernate.model.annotations.mapping.CollectionOfElementsImpl;
import com.intellij.hibernate.model.common.mapping.CollectionOfElements;
import com.intellij.hibernate.model.xml.mapping.HbmAny;
import com.intellij.hibernate.model.xml.mapping.HbmArray;
import com.intellij.hibernate.model.xml.mapping.HbmAttributeBase;
import com.intellij.hibernate.model.xml.mapping.HbmBag;
import com.intellij.hibernate.model.xml.mapping.HbmComponent;
import com.intellij.hibernate.model.xml.mapping.HbmCompositeElement;
import com.intellij.hibernate.model.xml.mapping.HbmCompositeId;
import com.intellij.hibernate.model.xml.mapping.HbmContainer;
import com.intellij.hibernate.model.xml.mapping.HbmDynamicComponent;
import com.intellij.hibernate.model.xml.mapping.HbmElement;
import com.intellij.hibernate.model.xml.mapping.HbmId;
import com.intellij.hibernate.model.xml.mapping.HbmIdbag;
import com.intellij.hibernate.model.xml.mapping.HbmKeyManyToOne;
import com.intellij.hibernate.model.xml.mapping.HbmKeyProperty;
import com.intellij.hibernate.model.xml.mapping.HbmList;
import com.intellij.hibernate.model.xml.mapping.HbmManyToMany;
import com.intellij.hibernate.model.xml.mapping.HbmManyToOne;
import com.intellij.hibernate.model.xml.mapping.HbmMap;
import com.intellij.hibernate.model.xml.mapping.HbmNestedCompositeElement;
import com.intellij.hibernate.model.xml.mapping.HbmOneToMany;
import com.intellij.hibernate.model.xml.mapping.HbmOneToOne;
import com.intellij.hibernate.model.xml.mapping.HbmPrimitiveArray;
import com.intellij.hibernate.model.xml.mapping.HbmProperty;
import com.intellij.hibernate.model.xml.mapping.HbmSet;
import com.intellij.hibernate.model.xml.mapping.HbmTimestamp;
import com.intellij.hibernate.model.xml.mapping.HbmVersion;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.javaee.model.common.persistence.mapping.JpaAttributeType;
import com.intellij.jpa.model.annotations.mapping.JamAttributeBase;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ModelMergerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HibernateAttributeType
extends AttributeType {
    public static final HibernateAttributeType ID;
    public static final HibernateAttributeType COMPOSITE_ID;
    public static final HibernateAttributeType VERSION;
    public static final HibernateAttributeType TIMESTAMP;
    public static final HibernateAttributeType PROPERTY;
    public static final HibernateAttributeType ONE_TO_ONE;
    public static final HibernateAttributeType ONE_TO_MANY;
    public static final HibernateAttributeType MANY_TO_ONE;
    public static final HibernateAttributeType MANY_TO_MANY;
    public static final HibernateAttributeType ELEMENTS;
    public static final HibernateAttributeType COMPOSITE_ELEMENTS;
    public static final HibernateAttributeType COLLECTION_OF_ELEMENTS;
    public static final HibernateAttributeType COMPONENT;
    public static final HibernateAttributeType ANY;
    public static final HibernateAttributeType DYNAMIC_COMPONENT;

    protected HibernateAttributeType(Class attributeClass, String typeName, JamMemberMeta<PsiMember, ? extends JamAttributeBase> ... jamMeta) {
        super(attributeClass, typeName, jamMeta);
    }

    @Nullable
    public RelationshipType getRelationshipType() {
        if (this == MANY_TO_MANY) {
            return RelationshipType.MANY_TO_MANY;
        }
        if (this == MANY_TO_ONE) {
            return RelationshipType.MANY_TO_ONE;
        }
        if (this == ONE_TO_MANY) {
            return RelationshipType.ONE_TO_MANY;
        }
        if (this == ONE_TO_ONE) {
            return RelationshipType.ONE_TO_ONE;
        }
        return null;
    }

    @NotNull
    public PsiType getDefaultPsiType(PersistentAttribute attribute) {
        if (!this.accepts(PersistentAttributeType.AttributeComponent.COLLECTION_VALUE, PersistentAttributeType.ComponentType.ANY)) {
            PsiType psiType = super.getDefaultPsiType(attribute);
            if (psiType == null) {
                HibernateAttributeType.$$$reportNull$$$0(0);
            }
            return psiType;
        }
        HbmAttributeBase domAttribute = (HbmAttributeBase)ModelMergerUtil.getImplementation((Object)attribute, HbmAttributeBase.class);
        if (domAttribute == null) {
            PsiType psiType = super.getDefaultPsiType(attribute);
            if (psiType == null) {
                HibernateAttributeType.$$$reportNull$$$0(1);
            }
            return psiType;
        }
        HbmContainer container = (HbmContainer)domAttribute.getParentOfType(HbmContainer.class, false);
        if (container == null) {
            PsiType psiType = super.getDefaultPsiType(attribute);
            if (psiType == null) {
                HibernateAttributeType.$$$reportNull$$$0(2);
            }
            return psiType;
        }
        PsiType psiType = HibernateAttributeType.createContainerType(container, this.getDefaultElementPsiType(attribute));
        if (psiType == null) {
            HibernateAttributeType.$$$reportNull$$$0(3);
        }
        return psiType;
    }

    public static PsiType createContainerType(HbmContainer container, PsiType componentType) {
        JavaContainerType containerType;
        PsiClassType mapKeyType = null;
        if (container instanceof HbmArray) {
            containerType = JavaContainerType.ARRAY;
        } else if (container instanceof HbmBag) {
            containerType = DomUtil.hasXml(((HbmBag)container).getOrderBy()) ? JavaContainerType.LIST : JavaContainerType.COLLECTION;
        } else if (container instanceof HbmIdbag) {
            containerType = DomUtil.hasXml(((HbmIdbag)container).getOrderBy()) ? JavaContainerType.LIST : JavaContainerType.COLLECTION;
        } else if (container instanceof HbmList) {
            containerType = JavaContainerType.LIST;
        } else if (container instanceof HbmMap) {
            containerType = JavaContainerType.MAP;
            PsiManager psiManager = container.getPsiManager();
            mapKeyType = PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)ProjectScope.getAllScope((Project)psiManager.getProject()));
        } else {
            containerType = container instanceof HbmPrimitiveArray ? JavaContainerType.ARRAY : (container instanceof HbmSet ? JavaContainerType.SET : JavaContainerType.COLLECTION);
        }
        return containerType.createCollectionType(container.getIdentifyingPsiElement(), componentType, mapKeyType);
    }

    @NotNull
    protected PsiType getDefaultElementPsiType(PersistentAttribute attribute) {
        if (this == DYNAMIC_COMPONENT) {
            PsiType psiType;
            try {
                PsiManager psiManager = attribute.getPsiManager();
                PsiClassType stringClass = PsiType.getJavaLangString((PsiManager)psiManager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)psiManager.getProject()));
                PsiClassType objectClass = PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)psiManager.getProject()));
                psiType = JavaContainerType.MAP.createCollectionType(attribute.getIdentifyingPsiElement(), (PsiType)objectClass, (PsiType)stringClass);
            }
            catch (IncorrectOperationException e) {
                throw new AssertionError((Object)e);
            }
            if (psiType == null) {
                HibernateAttributeType.$$$reportNull$$$0(4);
            }
            return psiType;
        }
        PsiType psiType = super.getDefaultElementPsiType(attribute);
        if (psiType == null) {
            HibernateAttributeType.$$$reportNull$$$0(5);
        }
        return psiType;
    }

    static {
        JpaAttributeType.BASIC.getAttributeClass();
        ID = new HibernateAttributeType((Class)HbmId.class, HibernateMessages.message("type.hibernate.attr.id", new Object[0]), new JamMemberMeta[]{CollectionOfElementsImpl.ID_ATTR_META}){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return JpaAttributeType.ID.accepts(component, targetType);
            }

            public boolean isIdAttribute() {
                return true;
            }
        };
        COMPOSITE_ID = new HibernateAttributeType((Class)HbmCompositeId.class, HibernateMessages.message("type.hibernate.attr.composite.id", new Object[0]), new JamMemberMeta[]{CollectionOfElementsImpl.EMBEDDED_ID_ATTR_META}){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return JpaAttributeType.EMBEDDED_ID.accepts(component, targetType);
            }

            public boolean isIdAttribute() {
                return true;
            }
        };
        VERSION = new HibernateAttributeType((Class)HbmVersion.class, HibernateMessages.message("type.hibernate.attr.version", new Object[0]), new JamMemberMeta[]{CollectionOfElementsImpl.VERSION_ATTR_META}){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return JpaAttributeType.VERSION.accepts(component, targetType);
            }

            public boolean isVersionAttribute() {
                return true;
            }
        };
        TIMESTAMP = new HibernateAttributeType((Class)HbmTimestamp.class, HibernateMessages.message("type.hibernate.attr.timestamp", new Object[0]), new JamMemberMeta[]{CollectionOfElementsImpl.BASIC_ATTR_META}){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return JpaAttributeType.BASIC.accepts(component, targetType);
            }
        };
        PROPERTY = new HibernateAttributeType((Class)HbmProperty.class, HibernateMessages.message("type.hibernate.attr.property", new Object[0]), new JamMemberMeta[]{CollectionOfElementsImpl.BASIC_ATTR_META}){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return JpaAttributeType.BASIC.accepts(component, targetType);
            }

            protected boolean accepts(PersistentAttribute attribute) {
                return super.accepts(attribute) || HbmKeyProperty.class.isInstance(attribute);
            }
        };
        ONE_TO_ONE = new HibernateAttributeType((Class)HbmOneToOne.class, HibernateMessages.message("type.hibernate.attr.one.to.one", new Object[0]), new JamMemberMeta[]{CollectionOfElementsImpl.ONE_TO_ONE_ATTR_META}){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return JpaAttributeType.ONE_TO_ONE.accepts(component, targetType);
            }
        };
        ONE_TO_MANY = new HibernateAttributeType((Class)HbmOneToMany.class, HibernateMessages.message("type.hibernate.attr.one.to.many", new Object[0]), new JamMemberMeta[]{CollectionOfElementsImpl.ONE_TO_MANY_ATTR_META}){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return JpaAttributeType.ONE_TO_MANY.accepts(component, targetType);
            }
        };
        MANY_TO_ONE = new HibernateAttributeType((Class)HbmManyToOne.class, HibernateMessages.message("type.hibernate.attr.many.to.one", new Object[0]), new JamMemberMeta[]{CollectionOfElementsImpl.MANY_TO_ONE_ATTR_META}){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return JpaAttributeType.MANY_TO_ONE.accepts(component, targetType);
            }

            protected boolean accepts(PersistentAttribute attribute) {
                return super.accepts(attribute) || HbmKeyManyToOne.class.isInstance(attribute);
            }
        };
        MANY_TO_MANY = new HibernateAttributeType((Class)HbmManyToMany.class, HibernateMessages.message("type.hibernate.attr.many.to.many", new Object[0]), new JamMemberMeta[]{CollectionOfElementsImpl.MANY_TO_MANY_ATTR_META}){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return JpaAttributeType.MANY_TO_MANY.accepts(component, targetType);
            }
        };
        ELEMENTS = new HibernateAttributeType((Class)HbmElement.class, HibernateMessages.message("type.hibernate.attr.elements", new Object[0]), new JamMemberMeta[]{CollectionOfElementsImpl.BASIC_COLLECTION_ATTR_META, CollectionOfElementsImpl.COLLECTION_OF_ELEMENTS_ATTR_META}){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return component == PersistentAttributeType.AttributeComponent.COLLECTION_VALUE && (targetType == PersistentAttributeType.ComponentType.ANY || targetType == PersistentAttributeType.ComponentType.BASIC) || component == PersistentAttributeType.AttributeComponent.COLLECTION_VALUE_KEY;
            }
        };
        COMPOSITE_ELEMENTS = new HibernateAttributeType((Class)HbmCompositeElement.class, HibernateMessages.message("type.hibernate.attr.composite.elements", new Object[0]), new JamMemberMeta[]{CollectionOfElementsImpl.EMBEDDED_COLLECTION_ATTR_META, CollectionOfElementsImpl.COLLECTION_OF_EMBEDDED_ELEMENTS_ATTR_META}){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return component == PersistentAttributeType.AttributeComponent.COLLECTION_VALUE && (targetType == PersistentAttributeType.ComponentType.ANY || targetType == PersistentAttributeType.ComponentType.EMBEDDABLE) || component == PersistentAttributeType.AttributeComponent.COLLECTION_VALUE_KEY;
            }
        };
        COLLECTION_OF_ELEMENTS = new HibernateAttributeType((Class)CollectionOfElements.class, HibernateMessages.message("type.hibernate.attr.collection.of.elements", new Object[0]), new JamMemberMeta[]{CollectionOfElementsImpl.BASIC_COLLECTION_ATTR_META, CollectionOfElementsImpl.EMBEDDED_COLLECTION_ATTR_META, CollectionOfElementsImpl.COLLECTION_OF_ELEMENTS_ATTR_META, CollectionOfElementsImpl.COLLECTION_OF_EMBEDDED_ELEMENTS_ATTR_META}){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return JpaAttributeType.ELEMENT_COLLECTION.accepts(component, targetType);
            }
        };
        COMPONENT = new HibernateAttributeType((Class)HbmComponent.class, HibernateMessages.message("type.hibernate.attr.component", new Object[0]), new JamMemberMeta[]{CollectionOfElementsImpl.EMBEDDED_ATTR_META}){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return JpaAttributeType.EMBEDDED.accepts(component, targetType);
            }

            protected boolean accepts(PersistentAttribute attribute) {
                return super.accepts(attribute) || HbmNestedCompositeElement.class.isInstance(attribute);
            }
        };
        ANY = new HibernateAttributeType((Class)HbmAny.class, HibernateMessages.message("type.hibernate.attr.any", new Object[0]), new JamMemberMeta[0]){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return JpaAttributeType.ONE_TO_ONE.accepts(component, targetType);
            }
        };
        DYNAMIC_COMPONENT = new HibernateAttributeType((Class)HbmDynamicComponent.class, HibernateMessages.message("type.hibernate.attr.dynamic.component", new Object[0]), new JamMemberMeta[0]){

            public boolean accepts(PersistentAttributeType.AttributeComponent component, PersistentAttributeType.ComponentType targetType) {
                return COMPONENT.accepts(component, targetType);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/hibernate/model/enums/HibernateAttributeType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPsiType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultElementPsiType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

