/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.graph;

import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.renderer.BasicGraphNodeRenderer;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.pom.Navigatable;
import com.intellij.psi.xml.XmlElement;
import com.intellij.struts2.graph.StrutsNodeRenderer;
import com.intellij.struts2.graph.beans.BasicStrutsEdge;
import com.intellij.struts2.graph.beans.BasicStrutsNode;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.xml.ElementPresentationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsPresentationModel
extends BasicGraphPresentationModel<BasicStrutsNode, BasicStrutsEdge> {
    private BasicGraphNodeRenderer myRenderer;

    public StrutsPresentationModel(Graph2D graph) {
        super((Graph)graph);
        this.setShowEdgeLabels(true);
    }

    @NotNull
    public NodeRealizer getNodeRealizer(BasicStrutsNode node) {
        NodeRealizer nodeRealizer = GraphViewUtil.createNodeRealizer((String)"Struts2NodeRenderer", (NodeCellRenderer)this.getRenderer());
        if (nodeRealizer == null) {
            StrutsPresentationModel.$$$reportNull$$$0(0);
        }
        return nodeRealizer;
    }

    private BasicGraphNodeRenderer getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new StrutsNodeRenderer((GraphBuilder<BasicStrutsNode, BasicStrutsEdge>)this.getGraphBuilder());
        }
        return this.myRenderer;
    }

    public boolean editNode(BasicStrutsNode node) {
        if (node == null) {
            return false;
        }
        XmlElement xmlElement = node.getIdentifyingElement().getXmlElement();
        if (xmlElement != null && xmlElement instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)xmlElement});
            return true;
        }
        return super.editNode((Object)node);
    }

    public boolean editEdge(BasicStrutsEdge edge) {
        if (edge == null) {
            return false;
        }
        XmlElement xmlElement = edge.getSource().getIdentifyingElement().getXmlElement();
        if (xmlElement instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)xmlElement});
            return true;
        }
        return super.editEdge((Object)edge);
    }

    public String getNodeTooltip(@Nullable BasicStrutsNode node) {
        if (node == null) {
            return null;
        }
        return ElementPresentationManager.getDocumentationForElement(node.getIdentifyingElement());
    }

    public void customizeSettings(Graph2DView view, EditMode editMode) {
        editMode.allowBendCreation(false);
        editMode.allowEdgeCreation(false);
        view.setFitContentOnResize(false);
        view.setAntialiasedPainting(false);
        view.setGridVisible(false);
        view.fitContent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/graph/StrutsPresentationModel", "getNodeRealizer"));
    }
}

