/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.cache;

import com.google.common.hash.HashCode;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.cache.FileContentCache;
import org.gradle.api.internal.cache.FileContentCacheFactory;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.api.internal.changedetection.state.InMemoryCacheDecoratorFactory;
import org.gradle.api.internal.tasks.execution.TaskOutputsGenerationListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.nativeintegration.filesystem.FileType;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileContentCacheFactory
implements FileContentCacheFactory,
Closeable {
    private final ListenerManager listenerManager;
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory;
    private final PersistentCache cache;
    private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();

    public DefaultFileContentCacheFactory(ListenerManager listenerManager, FileSystemSnapshotter fileSystemSnapshotter, CacheRepository cacheRepository, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory, Gradle gradle) {
        this.listenerManager = listenerManager;
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.inMemoryCacheDecoratorFactory = inMemoryCacheDecoratorFactory;
        this.cache = cacheRepository.cache(gradle, "fileContent").withDisplayName("file content cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).open();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    @Override
    public <V> FileContentCache<V> newCache(String name, int normalizedCacheSize, FileContentCacheFactory.Calculator<? extends V> calculator, Serializer<V> serializer) {
        PersistentIndexedCacheParameters parameters = new PersistentIndexedCacheParameters(name, this.hashCodeSerializer, serializer).cacheDecorator(this.inMemoryCacheDecoratorFactory.decorator(normalizedCacheSize, true));
        PersistentIndexedCache store = this.cache.createCache(parameters);
        DefaultFileContentCache<? extends V> cache = new DefaultFileContentCache<V>(name, this.fileSystemSnapshotter, store, calculator);
        this.listenerManager.addListener(cache);
        return cache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultFileContentCache<V>
    implements FileContentCache<V>,
    TaskOutputsGenerationListener {
        private final Map<File, V> cache = new ConcurrentHashMap<File, V>();
        private final FileSystemSnapshotter fileSystemSnapshotter;
        private final PersistentIndexedCache<HashCode, V> contentCache;
        private final String name;
        private final FileContentCacheFactory.Calculator<? extends V> calculator;

        DefaultFileContentCache(String name, FileSystemSnapshotter fileSystemSnapshotter, PersistentIndexedCache<HashCode, V> contentCache, FileContentCacheFactory.Calculator<? extends V> calculator) {
            this.name = name;
            this.fileSystemSnapshotter = fileSystemSnapshotter;
            this.contentCache = contentCache;
            this.calculator = calculator;
        }

        @Override
        public void beforeTaskOutputsGenerated() {
            this.cache.clear();
        }

        @Override
        public V get(File file) {
            V value = this.cache.get(file);
            if (value == null) {
                FileSnapshot fileSnapshot = this.fileSystemSnapshotter.snapshotSelf(file);
                FileType fileType = fileSnapshot.getType();
                if (fileType == FileType.RegularFile) {
                    HashCode hashCode = fileSnapshot.getContent().getContentMd5();
                    value = this.contentCache.get(hashCode);
                    if (value == null) {
                        value = this.calculator.calculate(file, fileType);
                        this.contentCache.put(hashCode, value);
                    }
                } else {
                    value = this.calculator.calculate(file, fileType);
                }
                this.cache.put(file, value);
            }
            return value;
        }
    }
}

