/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.hash.HashCode;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.caching.internal.tasks.DefaultTaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;

public class TaskCacheKeyCalculator {
    public TaskOutputCachingBuildCacheKey calculate(TaskExecution execution) {
        DefaultTaskOutputCachingBuildCacheKeyBuilder builder = new DefaultTaskOutputCachingBuildCacheKeyBuilder();
        builder.appendTaskImplementation(execution.getTaskImplementation());
        builder.appendTaskActionImplementations((Collection<ImplementationSnapshot>)execution.getTaskActionImplementations());
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = execution.getInputProperties();
        for (Map.Entry entry : inputProperties.entrySet()) {
            DefaultBuildCacheHasher newHasher = new DefaultBuildCacheHasher();
            ((ValueSnapshot)entry.getValue()).appendToHasher(newHasher);
            HashCode hash = newHasher.hash();
            builder.appendInputPropertyHash((String)entry.getKey(), hash);
        }
        ImmutableSortedMap<String, FileCollectionSnapshot> inputFilesSnapshots = execution.getInputFilesSnapshot();
        for (Map.Entry entry : inputFilesSnapshots.entrySet()) {
            FileCollectionSnapshot snapshot = (FileCollectionSnapshot)entry.getValue();
            DefaultBuildCacheHasher newHasher = new DefaultBuildCacheHasher();
            snapshot.appendToHasher(newHasher);
            HashCode hash = newHasher.hash();
            builder.appendInputPropertyHash((String)entry.getKey(), hash);
        }
        ImmutableSortedSet<String> outputPropertyNamesForCacheKey = execution.getOutputPropertyNamesForCacheKey();
        for (String cacheableOutputPropertyName : outputPropertyNamesForCacheKey) {
            builder.appendOutputPropertyName(cacheableOutputPropertyName);
        }
        return builder.build();
    }
}

