/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;

public class ExplainPlanAction
extends QueryActionBase {
    @Override
    protected void invokeImpl(@NotNull AnActionEvent e, JdbcConsole console, @NotNull JdbcConsoleProvider.Info info) {
        ExplainPlanProvider provider;
        if (e == null) {
            ExplainPlanAction.$$$reportNull$$$0(0);
        }
        if (info == null) {
            ExplainPlanAction.$$$reportNull$$$0(1);
        }
        if ((provider = ExplainPlanAction.getPlanProvider(console.getDataSource())) == ExplainPlanProvider.NULL_PROVIDER) {
            return;
        }
        JdbcConsoleProvider.chooseStatements(info, "No query found", false, scriptModel -> {
            ScriptModel adjusted = provider.adjustModel(scriptModel);
            if (!console.beforeExecuteQueries(adjusted)) {
                return;
            }
            for (ScriptModel.StatementIt it : adjusted.statements()) {
                try {
                    String text2 = it.text(console.getPStorage(), Conditions.alwaysFalse());
                    this.explainStatement(provider, console, text2);
                }
                catch (IllegalArgumentException ex) {
                    if (ex.getMessage().contains("@NotNull")) {
                        throw ex;
                    }
                    Messages.showErrorDialog((Project)console.getProject(), (String)ex.getMessage(), (String)"Explain Plan Error");
                }
                catch (UnsupportedOperationException ex) {
                    Messages.showErrorDialog((Project)console.getProject(), (String)ex.getMessage(), (String)"Explain Plan Error");
                }
            }
        });
    }

    @Override
    public void update(AnActionEvent e) {
        JdbcConsole console = this.getConsole(e);
        if (console == null || ExplainPlanAction.getPlanProvider(console.getDataSource()) == ExplainPlanProvider.NULL_PROVIDER) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        super.update(e);
    }

    @NotNull
    private static ExplainPlanProvider getPlanProvider(@NotNull LocalDataSource source) {
        ExplainPlanProvider provider;
        if (source == null) {
            ExplainPlanAction.$$$reportNull$$$0(2);
        }
        if ((provider = ExplainPlanProvider.getProviderByClassName(source.getExplainPlanConfiguration().getProviderClass())) != ExplainPlanProvider.NULL_PROVIDER) {
            ExplainPlanProvider explainPlanProvider = provider;
            if (explainPlanProvider == null) {
                ExplainPlanAction.$$$reportNull$$$0(3);
            }
            return explainPlanProvider;
        }
        ExplainPlanProvider explainPlanProvider = ExplainPlanProvider.getDefaultProvider(source);
        if (explainPlanProvider == null) {
            ExplainPlanAction.$$$reportNull$$$0(4);
        }
        return explainPlanProvider;
    }

    protected void explainStatement(@NotNull ExplainPlanProvider provider, @NotNull JdbcConsole console, @NotNull String statement) {
        DataRequest.RawRequest request;
        if (provider == null) {
            ExplainPlanAction.$$$reportNull$$$0(5);
        }
        if (console == null) {
            ExplainPlanAction.$$$reportNull$$$0(6);
        }
        if (statement == null) {
            ExplainPlanAction.$$$reportNull$$$0(7);
        }
        if ((request = provider.createExplainRequest(console, (Consumer<PlanModel>)((Consumer)model -> {
            if (console == null) {
                ExplainPlanAction.$$$reportNull$$$0(8);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (console == null) {
                    ExplainPlanAction.$$$reportNull$$$0(9);
                }
                console.showPlan((PlanModel)model);
            });
        }), console.getDataSource(), statement, false)) == null) {
            return;
        }
        console.getMessageBus().getDataProducer().processRequest(request);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ExplainPlanAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ExplainPlanAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlanProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPlanProvider";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "explainStatement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$explainStatement$2";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Raw
    extends ExplainPlanAction {
        @Override
        protected void explainStatement(@NotNull ExplainPlanProvider provider, @NotNull JdbcConsole console, @NotNull String script) {
            if (provider == null) {
                Raw.$$$reportNull$$$0(0);
            }
            if (console == null) {
                Raw.$$$reportNull$$$0(1);
            }
            if (script == null) {
                Raw.$$$reportNull$$$0(2);
            }
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
            StringBuilder sb = new StringBuilder();
            DdlBuilder builder = new DdlBuilder(sb);
            builder.applyCodeStyle(console.getProject());
            dialect.sqlExplainPlan(builder, script, false);
            AsyncPromise<Void> promise = this.execute(console, builder.getStatement(), true);
            builder.clear();
            dialect.sqlPostExplainPlan(builder, false);
            promise.processed(aVoid -> {
                if (console == null) {
                    Raw.$$$reportNull$$$0(9);
                }
                this.execute(console, builder.getStatement(), false);
            });
        }

        private AsyncPromise<Void> execute(@NotNull JdbcConsole console, @NotNull String script, boolean stopOnError) {
            if (console == null) {
                Raw.$$$reportNull$$$0(3);
            }
            if (script == null) {
                Raw.$$$reportNull$$$0(4);
            }
            SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)console.getProject());
            PsiFile psi = PsiFileFactory.getInstance((Project)console.getProject()).createFileFromText("a.sql", console.getLanguageConsole().getLanguage(), (CharSequence)script);
            ScriptModel model = facade.createScriptModel(psi);
            return this.perform(console, model.statements().transform(ScriptModelUtil.TO_TEXT).iterator(), stopOnError);
        }

        AsyncPromise<Void> perform(@NotNull JdbcConsole console, @NotNull Iterator<String> it, boolean stopOnError) {
            if (console == null) {
                Raw.$$$reportNull$$$0(5);
            }
            if (it == null) {
                Raw.$$$reportNull$$$0(6);
            }
            if (!it.hasNext()) {
                return null;
            }
            String query = it.next();
            if (StringUtil.isEmptyOrSpaces((String)query)) {
                return this.perform(console, it, stopOnError);
            }
            DataRequest request = DataRequest.newRequest(console, console.getCurrentTx(), query);
            Consumer next = o -> {
                if (console == null) {
                    Raw.$$$reportNull$$$0(7);
                }
                if (it == null) {
                    Raw.$$$reportNull$$$0(8);
                }
                this.perform(console, it, stopOnError);
            };
            if (stopOnError) {
                request.getPromise().done(next);
            } else {
                request.getPromise().processed(next);
            }
            console.getMessageBus().getDataProducer().processRequest(request);
            return request.getPromise();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "script";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "it";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/ExplainPlanAction$Raw";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "explainStatement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$perform$1";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$explainStatement$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

