/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatter {
    private final CsvFormat myFormat;

    public CsvFormatter(@NotNull CsvFormat format) {
        if (format == null) {
            CsvFormatter.$$$reportNull$$$0(0);
        }
        this.myFormat = format;
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvFormat csvFormat = this.myFormat;
        if (csvFormat == null) {
            CsvFormatter.$$$reportNull$$$0(1);
        }
        return csvFormat;
    }

    @NotNull
    public String formatValue(@Nullable Object value) {
        String string = this.formatValue(this.myFormat.dataRecord, value);
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String formatHeaderValue(@Nullable Object value) {
        String string = this.formatValue((CsvRecordFormat)ObjectUtils.notNull((Object)this.myFormat.headerRecord, (Object)this.myFormat.dataRecord), value);
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String valueSeparator() {
        String string = CsvFormatter.valueSeparator(this.myFormat.dataRecord);
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String headerValueSeparator() {
        String string = CsvFormatter.valueSeparator((CsvRecordFormat)ObjectUtils.notNull((Object)this.myFormat.headerRecord, (Object)this.myFormat.dataRecord));
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String recordSeparator() {
        String string = this.myFormat.dataRecord.recordSeparator;
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String formatRecord(@NotNull List<?> values) {
        if (values == null) {
            CsvFormatter.$$$reportNull$$$0(7);
        }
        String string = this.formatRecord(this.myFormat.dataRecord, values);
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String formatHeader(@NotNull List<?> values) {
        if (values == null) {
            CsvFormatter.$$$reportNull$$$0(9);
        }
        return this.formatRecord((CsvRecordFormat)ObjectUtils.notNull((Object)this.myFormat.headerRecord, (Object)this.myFormat.dataRecord), values);
    }

    public boolean requiresRowNumbers() {
        return this.myFormat.rowNumbers;
    }

    @NotNull
    protected String valueToRawText(@Nullable Object value) {
        String string = String.valueOf(value);
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private String formatRecord(@NotNull CsvRecordFormat recordTemplate, @NotNull List<?> values) {
        if (recordTemplate == null) {
            CsvFormatter.$$$reportNull$$$0(11);
        }
        if (values == null) {
            CsvFormatter.$$$reportNull$$$0(12);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.notNullize((String)recordTemplate.prefix));
        for (Object value : values) {
            sb.append(this.formatValue(recordTemplate, value)).append(CsvFormatter.valueSeparator(recordTemplate));
        }
        sb.setLength(values.isEmpty() ? sb.length() : sb.length() - CsvFormatter.valueSeparator(recordTemplate).length());
        sb.append(StringUtil.notNullize((String)recordTemplate.suffix));
        String string = sb.toString();
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private String formatValue(@NotNull CsvRecordFormat recordTemplate, @Nullable Object value) {
        if (recordTemplate == null) {
            CsvFormatter.$$$reportNull$$$0(14);
        }
        String valueText = value == null ? recordTemplate.nullText : this.valueToRawText(value);
        valueText = recordTemplate.trimWhitespace ? StringUtil.trimLeading((String)StringUtil.trimTrailing((String)valueText)) : valueText;
        CsvRecordFormat.QuotationPolicy quotationPolicy = recordTemplate.quotationPolicy;
        CsvRecordFormat.Quotes quotes = null;
        if (quotationPolicy == CsvRecordFormat.QuotationPolicy.ALWAYS) {
            quotes = (CsvRecordFormat.Quotes)ContainerUtil.getFirstItem(recordTemplate.quotes);
        } else if (quotationPolicy == CsvRecordFormat.QuotationPolicy.AS_NEEDED) {
            if (CsvFormatter.shouldQuote(recordTemplate, valueText)) {
                quotes = (CsvRecordFormat.Quotes)ContainerUtil.getFirstItem(recordTemplate.quotes);
            }
        } else {
            throw new AssertionError((Object)("Unhandled quotation policy: " + (Object)((Object)quotationPolicy)));
        }
        String string = quotes != null ? quotes.leftQuote + CsvFormatter.escapeQuotes(valueText, quotes) + quotes.rightQuote : valueText;
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String escapeQuotes(@NotNull CharSequence s, @NotNull CsvRecordFormat.Quotes quotes) {
        if (s == null) {
            CsvFormatter.$$$reportNull$$$0(16);
        }
        if (quotes == null) {
            CsvFormatter.$$$reportNull$$$0(17);
        }
        boolean leftIsEmpty = quotes.leftQuote.isEmpty();
        boolean rightIsEmpty = quotes.rightQuote.isEmpty();
        List escapedQuotes = ContainerUtil.filter(Arrays.asList(leftIsEmpty ? null : quotes.leftQuoteEscaped, rightIsEmpty ? null : quotes.rightQuoteEscaped), (Condition)Conditions.notNull());
        List unescapedQuotes = ContainerUtil.filter(Arrays.asList(leftIsEmpty ? null : quotes.leftQuote, rightIsEmpty ? null : quotes.rightQuote), (Condition)Conditions.notNull());
        String string = StringUtil.replace((String)s.toString(), (List)unescapedQuotes, (List)escapedQuotes);
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String valueSeparator(@NotNull CsvRecordFormat template) {
        if (template == null) {
            CsvFormatter.$$$reportNull$$$0(19);
        }
        String string = template.valueSeparator;
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static boolean shouldQuote(@NotNull CsvRecordFormat recordTemplate, @NotNull String valueText) {
        if (recordTemplate == null) {
            CsvFormatter.$$$reportNull$$$0(21);
        }
        if (valueText == null) {
            CsvFormatter.$$$reportNull$$$0(22);
        }
        return StringUtil.contains((CharSequence)valueText, (CharSequence)recordTemplate.valueSeparator) || StringUtil.contains((CharSequence)valueText, (CharSequence)recordTemplate.recordSeparator) || StringUtil.isNotEmpty((String)recordTemplate.prefix) && StringUtil.contains((CharSequence)valueText, (CharSequence)recordTemplate.prefix) || StringUtil.isNotEmpty((String)recordTemplate.suffix) && StringUtil.contains((CharSequence)valueText, (CharSequence)recordTemplate.suffix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/CsvFormatter";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 11: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordTemplate";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotes";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/CsvFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 2: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "formatValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatHeaderValue";
                break;
            }
            case 4: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "valueSeparator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "headerValueSeparator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "recordSeparator";
                break;
            }
            case 8: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "formatRecord";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "valueToRawText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatRecord";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatHeader";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "formatValue";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "valueSeparator";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

