/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModConstraint;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.JdbcParameterType;
import com.intellij.database.model.properties.JdbcProcedureType;
import com.intellij.database.model.properties.JdbcTableType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class LegacyDeserializer {
    private static final String TABLE_ELEMENT_NAME = "table";
    private static final String COLUMN_ELEMENT_NAME = "column";
    private static final String PROCEDURE_ELEMENT_NAME = "procedure";
    private static final String PROCEDURE_PROTO_ELEMENT_NAME = "prototype";
    private static final String ARGUMENT_ELEMENT_NAME = "parameter";
    private static final Pattern COLUMN_SPLITTER_PATTERN = Pattern.compile("\\s*,\\s*");

    private static boolean isSchemaBased(@NotNull IntrospectionScope scope) {
        if (scope == null) {
            LegacyDeserializer.$$$reportNull$$$0(0);
        }
        Set<String> dbs = scope.databases();
        Set<String> schemas = scope.allSchemas();
        return dbs.size() == 1 && dbs.contains("*") && (schemas.size() != 1 || !schemas.contains("*"));
    }

    @NotNull
    public static BasicModModel deserialize(@NotNull HierarchicalStreamReader reader, @NotNull ModelFactory modelFactory, @NotNull DatabaseDialectEx dialect, IntrospectionScope intro, IntrospectionScope res) {
        BasicModModel model;
        boolean schemaDbMode;
        Rdbms rdbms;
        if (reader == null) {
            LegacyDeserializer.$$$reportNull$$$0(1);
        }
        if (modelFactory == null) {
            LegacyDeserializer.$$$reportNull$$$0(2);
        }
        if (dialect == null) {
            LegacyDeserializer.$$$reportNull$$$0(3);
        }
        if ((rdbms = DataSourceUiUtil.getRdbmsForIntrospection(dialect.getFamilyId())) == null) {
            rdbms = UnknownDatabase.RDBMS;
        }
        if ((schemaDbMode = GenericIntrospectorLegacyModelUtils.isSchemaDbMode(model = modelFactory.createModel(rdbms), dialect.getFamilyId())) && (LegacyDeserializer.isSchemaBased(intro) || LegacyDeserializer.isSchemaBased(res))) {
            schemaDbMode = false;
        }
        HashMap refCols = ContainerUtil.newHashMap();
        while (true) {
            String nodeName;
            if (TABLE_ELEMENT_NAME.equals(nodeName = reader.getNodeName())) {
                LegacyDeserializer.deserializeTable(reader, model, schemaDbMode, refCols);
            } else if (PROCEDURE_ELEMENT_NAME.equals(nodeName)) {
                LegacyDeserializer.deserializeProcedure(reader, model, schemaDbMode);
            } else if ("schema".equals(nodeName)) {
                LegacyDeserializer.getOrCreateSchema(model, reader.getAttribute("catalog"), reader.getAttribute("name"), schemaDbMode);
            }
            reader.moveUp();
            if (!reader.hasMoreChildren()) break;
            reader.moveDown();
        }
        for (BasicModForeignKey fkey : ((JBTreeTraverser)model.traverser().expand(Conditions.alwaysTrue())).filter(BasicModForeignKey.class)) {
            List refColNames = (List)refCols.get(fkey);
            if (refColNames == null) continue;
            GenericIntrospectorLegacyModelUtils.resolveKey(fkey, refColNames);
        }
        BasicModModel basicModModel = model;
        if (basicModModel == null) {
            LegacyDeserializer.$$$reportNull$$$0(4);
        }
        return basicModModel;
    }

    @Nullable
    private static BasicModRoutine createRoutine(@NotNull ModNamingFamily<?> targetFamily, String name, DasRoutine.Kind kind, String comment) {
        BasicModRoutine routine;
        if (targetFamily == null) {
            LegacyDeserializer.$$$reportNull$$$0(5);
        }
        if ((routine = (BasicModRoutine)ObjectUtils.tryCast(targetFamily.createNewOne(), BasicModRoutine.class)) == null) {
            return null;
        }
        ((BasicModNamedElement)((Object)routine)).setName(name);
        ((BasicModNamedElement)((Object)routine)).setComment(comment);
        routine.setRoutineKind(kind);
        return routine;
    }

    private static void deserializeArgument(HierarchicalStreamReader xmlReader, @NotNull BasicModRoutine routine, boolean ret, int idx) {
        if (routine == null) {
            LegacyDeserializer.$$$reportNull$$$0(6);
        }
        if (!ARGUMENT_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
            return;
        }
        ModNamingFamily arguments = GenericIntrospectorLegacyModelUtils.familyOf(routine, ObjectKind.ARGUMENT);
        if (arguments == null) {
            return;
        }
        BasicModArgument arg = (BasicModArgument)arguments.createNewOne();
        arg.setName(DbUtil.intern((String)xmlReader.getAttribute("name")));
        arg.setDataType(LegacyDeserializer.deserializeDataType(xmlReader));
        arg.setDefaultExpression(LegacyDeserializer.deserializeAttribute(xmlReader, "def"));
        arg.setComment(LegacyDeserializer.deserializeAttribute(xmlReader, "remarks"));
        DasArgument.Direction direction = JdbcParameterType.findByID(StringUtil.parseInt((String)xmlReader.getAttribute("type"), (int)JdbcParameterType.IN.getID())).getArgumentDirection();
        if (ret) {
            direction = DasArgument.Direction.RETURN;
        }
        arg.setArgumentDirection(direction);
        short pos = (short)StringUtil.parseInt((String)xmlReader.getAttribute("index"), (int)-1);
        arg.setPosition(pos);
    }

    @NotNull
    private static DataType deserializeDataType(HierarchicalStreamReader xmlReader) {
        int scale;
        int precision;
        String sqlType = DbUtil.intern((String)xmlReader.getAttribute("sqlType"));
        String lengthStr = xmlReader.getAttribute("length");
        if (lengthStr != null) {
            precision = StringUtil.parseInt((String)lengthStr, (int)-1);
            scale = StringUtil.parseInt((String)xmlReader.getAttribute("precision"), (int)-1);
        } else {
            precision = StringUtil.parseInt((String)xmlReader.getAttribute("precision"), (int)-1);
            scale = StringUtil.parseInt((String)xmlReader.getAttribute("scale"), (int)-1);
        }
        int jdbcType = StringUtil.parseInt((String)xmlReader.getAttribute("jdbcType"), (int)1111);
        DataType dataType = DataTypeFactory.of(null, DbUtil.intern((String)sqlType), precision, scale, null, null, false, false, jdbcType);
        if (dataType == null) {
            LegacyDeserializer.$$$reportNull$$$0(7);
        }
        return dataType;
    }

    private static BasicModRoutine deserializeProcedure(HierarchicalStreamReader xmlReader, @NotNull BasicModModel model, boolean schemaDbMode) {
        ModNamingFamily pkgFamily;
        if (model == null) {
            LegacyDeserializer.$$$reportNull$$$0(8);
        }
        if (!PROCEDURE_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
            return null;
        }
        BasicModSchema schema = LegacyDeserializer.getOrCreateSchema(model, xmlReader.getAttribute("catalog"), xmlReader.getAttribute("schema"), schemaDbMode);
        String pkg = DbUtil.intern((String)xmlReader.getAttribute("package"), null);
        ModNamingFamily targetFamily = null;
        if (!StringUtil.isEmpty((String)pkg) && (pkgFamily = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.PACKAGE)) != null) {
            Object pkgObj = pkgFamily.createOrGet(pkg);
            targetFamily = GenericIntrospectorLegacyModelUtils.familyOf(pkgObj, ObjectKind.ROUTINE);
        }
        if (targetFamily == null) {
            targetFamily = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.ROUTINE);
        }
        if (targetFamily == null) {
            return null;
        }
        String name = DbUtil.intern((String)xmlReader.getAttribute("name"));
        DasRoutine.Kind kind = JdbcProcedureType.findByID(StringUtil.parseInt((String)xmlReader.getAttribute("type"), (int)0)).getKind();
        String comment = LegacyDeserializer.deserializeAttribute(xmlReader, "remarks");
        BasicModRoutine routine = null;
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String nodeName = xmlReader.getNodeName();
            if (PROCEDURE_PROTO_ELEMENT_NAME.equals(nodeName) && (routine = LegacyDeserializer.createRoutine(targetFamily, name, kind, comment)) != null) {
                boolean hasReturn = "true".equals(xmlReader.getAttribute("return"));
                int idx = 0;
                while (xmlReader.hasMoreChildren()) {
                    xmlReader.moveDown();
                    if (ARGUMENT_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
                        LegacyDeserializer.deserializeArgument(xmlReader, routine, hasReturn, ++idx);
                        if (hasReturn) {
                            hasReturn = false;
                        }
                    }
                    xmlReader.moveUp();
                }
                ModNamingFamily arguments = GenericIntrospectorLegacyModelUtils.familyOf(routine, ObjectKind.ARGUMENT);
                if (arguments != null) {
                    arguments.sort();
                    for (BasicModArgument argument : JBIterable.from(arguments).filter(BasicModArgument.class)) {
                        argument.setPosition((short)0);
                    }
                }
            }
            xmlReader.moveUp();
        }
        if (routine == null) {
            routine = LegacyDeserializer.createRoutine(targetFamily, name, kind, comment);
        }
        return routine;
    }

    @NotNull
    private static BasicModSchema getOrCreateSchema(@NotNull BasicModModel model, String cat, String schema, boolean schemaDbMode) {
        BasicModSchema res;
        ModNamingFamily root2;
        if (model == null) {
            LegacyDeserializer.$$$reportNull$$$0(9);
        }
        if ((root2 = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)model.getRoot()), ObjectKind.DATABASE)) != null) {
            BasicModMateDatabase modCat = (BasicModMateDatabase)root2.createOrGet(StringUtil.notNullize((String)DbUtil.intern((String)cat)));
            modCat.setVisible(true);
            res = (BasicModSchema)modCat.getSchemas().createOrGet(StringUtil.notNullize((String)DbUtil.intern((String)schema)));
        } else {
            root2 = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)model.getRoot()), ObjectKind.SCHEMA);
            if (root2 != null) {
                res = (BasicModSchema)root2.createOrGet(StringUtil.notNullize((String)DbUtil.intern((String)(schemaDbMode ? cat : schema))));
            } else {
                throw new AssertionError((Object)"Root has no database or schema family");
            }
        }
        res.setVisible(true);
        BasicModSchema basicModSchema = res;
        if (basicModSchema == null) {
            LegacyDeserializer.$$$reportNull$$$0(10);
        }
        return basicModSchema;
    }

    private static void deserializeTable(HierarchicalStreamReader xmlReader, @NotNull BasicModModel model, boolean schemaDbMode, Map<BasicModForeignKey, List<String>> refCols) {
        if (model == null) {
            LegacyDeserializer.$$$reportNull$$$0(11);
        }
        if (!TABLE_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
            return;
        }
        BasicModSchema schema = LegacyDeserializer.getOrCreateSchema(model, xmlReader.getAttribute("catalog"), xmlReader.getAttribute("schema"), schemaDbMode);
        String name = DbUtil.intern((String)xmlReader.getAttribute("name"));
        JdbcTableType tableType = JdbcTableType.findByName(xmlReader.getAttribute("type"));
        ModNamingFamily tables = GenericIntrospectorLegacyModelUtils.familyOf(schema, tableType.getKind());
        if (tables == null) {
            tables = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.TABLE);
        }
        if (tables == null) {
            return;
        }
        BasicModTableOrView table = (BasicModTableOrView)ObjectUtils.tryCast(tables.createOrGet(name), BasicModTableOrView.class);
        if (table == null) {
            return;
        }
        ((BasicModNamedElement)((Object)table)).setComment(LegacyDeserializer.deserializeAttribute(xmlReader, "remarks"));
        boolean count2 = false;
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String nodeName = xmlReader.getNodeName();
            if (COLUMN_ELEMENT_NAME.equals(nodeName)) {
                BasicModTableOrViewColumn column = LegacyDeserializer.deserializeColumn(xmlReader, table);
                if (column != null && Boolean.parseBoolean(xmlReader.getAttribute("autoIncrement")) && column instanceof BasicModTableColumn) {
                    BasicModTableColumn tColumn = (BasicModTableColumn)column;
                    tColumn.setSequenceIdentity(GenericIntrospectorLegacyModelUtils.SEQUENCE_IDENTITY);
                }
            } else if ("primary-key".equals(nodeName)) {
                BasicModKey key2 = LegacyDeserializer.deserializeKey(xmlReader, table);
                if (key2 != null) {
                    key2.setPrimary(true);
                }
            } else if ("foreign-key".equals(nodeName)) {
                LegacyDeserializer.deserializeFk(xmlReader, table, schemaDbMode, refCols);
            } else if ("index".equals(nodeName)) {
                LegacyDeserializer.deserializeIndex(xmlReader, table);
            }
            xmlReader.moveUp();
        }
    }

    @Nullable
    private static BasicModKey deserializeKey(HierarchicalStreamReader xmlReader, @NotNull BasicModTableOrView table) {
        ModNamingFamily keys;
        if (table == null) {
            LegacyDeserializer.$$$reportNull$$$0(12);
        }
        if ((keys = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.KEY)) == null) {
            return null;
        }
        BasicModKey key2 = (BasicModKey)keys.createOrGet(DbUtil.intern((String)xmlReader.getAttribute("name")));
        LegacyDeserializer.deserializeConstraint(xmlReader, key2);
        return key2;
    }

    @Nullable
    private static BasicModIndex deserializeIndex(HierarchicalStreamReader xmlReader, @NotNull BasicModTableOrView table) {
        ModNamingFamily indices;
        if (table == null) {
            LegacyDeserializer.$$$reportNull$$$0(13);
        }
        if ((indices = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.INDEX)) == null) {
            return null;
        }
        BasicModIndex index = (BasicModIndex)indices.createOrGet(DbUtil.intern((String)xmlReader.getAttribute("name")));
        index.setUnique(Boolean.valueOf(xmlReader.getAttribute("unique")));
        index.setColNames(COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)xmlReader.getAttribute("columns")), 0));
        return index;
    }

    private static void deserializeConstraint(HierarchicalStreamReader xmlReader, @NotNull BasicModConstraint constraint) {
        if (constraint == null) {
            LegacyDeserializer.$$$reportNull$$$0(14);
        }
        constraint.setColNames(COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)xmlReader.getAttribute("columns")), 0));
    }

    @Nullable
    private static BasicModForeignKey deserializeFk(HierarchicalStreamReader xmlReader, BasicModTableOrView table, boolean schemaDbMode, Map<BasicModForeignKey, List<String>> refCols) {
        ModNamingFamily foreignKeys = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.FOREIGN_KEY);
        if (foreignKeys == null) {
            return null;
        }
        BasicModForeignKey fk = (BasicModForeignKey)foreignKeys.createOrGet(DbUtil.intern((String)xmlReader.getAttribute("name")));
        LegacyDeserializer.deserializeConstraint(xmlReader, fk);
        String tTab = DbUtil.intern((String)xmlReader.getAttribute("ref-table"));
        String tSchema = DbUtil.intern((String)xmlReader.getAttribute("ref-schema"));
        String tCat = DbUtil.intern((String)xmlReader.getAttribute("ref-catalog"));
        fk.setRefTableName(StringUtil.nullize((String)tTab));
        String refSchema = StringUtil.nullize((String)(schemaDbMode ? tCat : tSchema));
        if (!Comparing.equal((String)refSchema, (String)DasUtil.getName((DasObject)table.getParent()))) {
            fk.setRefSchemaName(refSchema);
        }
        List<String> refColNames = Arrays.asList(COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)xmlReader.getAttribute("ref-columns")), 0));
        fk.setRefColNames(refColNames);
        refCols.put(fk, refColNames);
        Rdbms rdbms = table.getModel().getRdbms();
        int updateRuleOrd = StringUtil.parseInt((String)StringUtil.notNullize((String)xmlReader.getAttribute("update-rule")), (int)-1);
        fk.setOnUpdate(GenericIntrospectorLegacyModelUtils.asCascadeRule(LegacyDeserializer.itemAt(updateRuleOrd, DasForeignKey.RuleAction.values()), rdbms));
        int deleteRuleOrd = StringUtil.parseInt((String)StringUtil.notNullize((String)xmlReader.getAttribute("delete-rule")), (int)-1);
        fk.setOnDelete(GenericIntrospectorLegacyModelUtils.asCascadeRule(LegacyDeserializer.itemAt(deleteRuleOrd, DasForeignKey.RuleAction.values()), rdbms));
        DasForeignKey.Deferrability deferrability = LegacyDeserializer.itemAt(StringUtil.parseInt((String)StringUtil.notNullize((String)xmlReader.getAttribute("deferrability")), (int)-1), DasForeignKey.Deferrability.values());
        if (deferrability == null) {
            deferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
        }
        fk.setDeferrable(deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE);
        fk.setInitiallyDeferred(deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED);
        return fk;
    }

    @Nullable
    private static BasicModTableOrViewColumn deserializeColumn(HierarchicalStreamReader xmlReader, BasicModTableOrView table) {
        ModNamingFamily columns2 = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.COLUMN);
        if (columns2 == null) {
            return null;
        }
        BasicModTableOrViewColumn column = (BasicModTableOrViewColumn)columns2.createOrGet(DbUtil.intern((String)xmlReader.getAttribute("name")));
        column.setDataType(LegacyDeserializer.deserializeDataType(xmlReader));
        column.setNotNull(!Boolean.parseBoolean(xmlReader.getAttribute("nullable")));
        column.setDefaultExpression(LegacyDeserializer.deserializeAttribute(xmlReader, "def"));
        column.setComment(LegacyDeserializer.deserializeAttribute(xmlReader, "remarks"));
        return column;
    }

    @Nullable
    static String deserializeAttribute(@NotNull HierarchicalStreamReader xmlReader, String name) {
        String value;
        if (xmlReader == null) {
            LegacyDeserializer.$$$reportNull$$$0(15);
        }
        if ((value = xmlReader.getAttribute(name)) != null) {
            return DbUtil.intern((String)new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8));
        }
        return null;
    }

    @Nullable
    private static <E> E itemAt(int ordinal, E[] values) {
        return ordinal >= 0 && ordinal < values.length ? (E)values[ordinal] : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/LegacyDeserializer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFamily";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = TABLE_ELEMENT_NAME;
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/LegacyDeserializer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeDataType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSchema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaBased";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRoutine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserializeArgument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserializeProcedure";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateSchema";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deserializeTable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deserializeKey";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deserializeIndex";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deserializeConstraint";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deserializeAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

