/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.DasSchemaExporters;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDatabaseDialect
extends DatabaseDialectEx {
    public static final String ALIAS = "t";
    private final MetaModel myMetaModel;
    private final TypeHelper myTypeHelper;
    private final KeywordHelper myKeywordHelper;
    private final Casing myCasing;
    private AtomicNotNullLazyValue<SchemaEditor> mySchemaEditor;

    protected AbstractDatabaseDialect(@NotNull MetaModel metaModel, TypeHelper typeHelper, KeywordHelper keywordHelper, Casing casing) {
        if (metaModel == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(0);
        }
        this.mySchemaEditor = new AtomicNotNullLazyValue<SchemaEditor>(){

            @NotNull
            protected SchemaEditor compute() {
                SchemaEditor schemaEditor = new SchemaEditor(AbstractDatabaseDialect.this.getSchemaExporters(), AbstractDatabaseDialect.this.getDdlOperations(), AbstractDatabaseDialect.this.getDbEditorCaps());
                if (schemaEditor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return schemaEditor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect$1", "compute"));
            }
        };
        this.myMetaModel = metaModel;
        this.myTypeHelper = typeHelper;
        this.myKeywordHelper = keywordHelper;
        this.myCasing = casing;
    }

    public boolean supportsColumnCommentsInTableDefinition() {
        return true;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(1);
        }
        Casing casing = this.myCasing;
        if (casing == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(2);
        }
        return casing;
    }

    @Override
    @Contract(value="!null->!null; null->null")
    public String convertNameCatalogFormToScriptForm(String catalogName) {
        if (catalogName == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)catalogName)) {
            return this.quoteIdentifierUnconditionally(catalogName);
        }
        boolean hasLowerCase = false;
        boolean hasUpperCase = false;
        boolean hasOtherChars = false;
        boolean startsWithDigit = false;
        int n = catalogName.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = catalogName.charAt(i2);
            boolean digit = Character.isDigit(c);
            startsWithDigit |= i2 == 0 && digit;
            if ((hasLowerCase |= Character.isLowerCase(c)) && (hasUpperCase |= Character.isUpperCase(c)) && (hasOtherChars |= !digit && !Character.isLetter(c) && !this.isNameFriendlyCharacter(c))) break;
        }
        boolean toQuote = startsWithDigit || hasOtherChars || this.myCasing.plain == Case.UPPER && hasLowerCase || this.myCasing.plain == Case.LOWER && hasUpperCase || this.myKeywordHelper.isReservedKeyword(catalogName);
        return toQuote ? this.quoteIdentifierUnconditionally(catalogName) : catalogName;
    }

    protected boolean isNameFriendlyCharacter(char ch) {
        return ch == '_' || ch == '$' || ch == '#' || ch == '@';
    }

    protected String quoteIdentifierUnconditionally(@NotNull String name) {
        int q;
        if (name == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(3);
        }
        if ((q = name.indexOf(34)) < 0) {
            return '\"' + name + '\"';
        }
        StringBuilder b = new StringBuilder(name.length() * 2);
        b.append(name);
        while (q >= 0) {
            b.insert(q + 1, '\"');
            q = b.indexOf("\"", q + 2);
        }
        b.insert(0, '\"');
        b.insert(b.length(), '\"');
        return b.toString();
    }

    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new DasDdlOperations.DefaultDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(4);
        }
        return ddlOperations;
    }

    @NotNull
    protected DatabaseEditorCapabilities.ColumnEditorCaps getColumnEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.ColumnEditorCaps columnEditorCaps = new DatabaseEditorCapabilities.ColumnEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || this.supportsRenameColumn()), DatabaseEditorCapabilities.Capability.supported(this.supportsColumnComment()), DatabaseEditorCapabilities.Capability.available(!existing || this.supportsAlterColumnType()), DatabaseEditorCapabilities.Capability.supported(this.supportsAutoIncrement()), DatabaseEditorCapabilities.Capability.available(!existing || this.supportsAlterColumnDefault()), DatabaseEditorCapabilities.Capability.available(!existing || this.supportsAlterColumnNull()));
        if (columnEditorCaps == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(5);
        }
        return columnEditorCaps;
    }

    @NotNull
    protected DatabaseEditorCapabilities.IndexColumnEditorCaps getIndexColumnEditorCaps(boolean existing) {
        boolean indexRecreateable = this.supportsDropIndex() && this.supportsCreateIndex();
        DatabaseEditorCapabilities.IndexColumnEditorCaps indexColumnEditorCaps = new DatabaseEditorCapabilities.IndexColumnEditorCaps(DatabaseEditorCapabilities.Capability.from(true, !existing || indexRecreateable));
        if (indexColumnEditorCaps == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(6);
        }
        return indexColumnEditorCaps;
    }

    @NotNull
    protected DatabaseEditorCapabilities.IndexEditorCaps getIndexEditorCaps(boolean existing) {
        boolean indexRecreateable = this.supportsDropIndex() && this.supportsCreateIndex();
        DatabaseEditorCapabilities.IndexEditorCaps indexEditorCaps = new DatabaseEditorCapabilities.IndexEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || indexRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.Capability.available(!existing || indexRecreateable), this.getIndexColumnEditorCaps(existing));
        if (indexEditorCaps == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(7);
        }
        return indexEditorCaps;
    }

    @NotNull
    protected DatabaseEditorCapabilities.TableKeyColumnEditorCaps getTableKeyColumnEditorCaps() {
        DatabaseEditorCapabilities.TableKeyColumnEditorCaps tableKeyColumnEditorCaps = new DatabaseEditorCapabilities.TableKeyColumnEditorCaps();
        if (tableKeyColumnEditorCaps == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(8);
        }
        return tableKeyColumnEditorCaps;
    }

    @NotNull
    protected DatabaseEditorCapabilities.KeyEditorCaps getKeyEditorCaps(boolean existing) {
        boolean keyRecreateable = this.supportsDropConstraint() && this.supportsAddUniqueConstraint() || this.supportsDropPrimaryKey() && this.supportsAddPrimaryKey();
        DatabaseEditorCapabilities.KeyEditorCaps keyEditorCaps = new DatabaseEditorCapabilities.KeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || keyRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, this.getTableKeyColumnEditorCaps());
        if (keyEditorCaps == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(9);
        }
        return keyEditorCaps;
    }

    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.Deferrability.values()), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()));
        if (foreignKeyEditorCaps == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(10);
        }
        return foreignKeyEditorCaps;
    }

    @NotNull
    protected DatabaseEditorCapabilities.TableEditorCaps getTableEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = new DatabaseEditorCapabilities.TableEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || this.supportsRenameTable()), DatabaseEditorCapabilities.Capability.supported(this.supportsTableComment()), DatabaseEditorCapabilities.ListCapability.get(true, !existing, !existing || this.supportsAddColumn(), !existing || this.supportsDropColumn()), DatabaseEditorCapabilities.ListCapability.get(this.supportsIndexes(), false, !existing || this.supportsCreateIndex(), !existing || this.supportsDropIndex()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddForeignKey(), !existing || this.supportsDropForeignKey()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddPrimaryKey(), !existing || this.supportsDropPrimaryKey()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddUniqueConstraint(), !existing || this.supportsDropConstraint()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddUniqueConstraint(), !existing || this.supportsDropConstraint()), this.getColumnEditorCaps(false), this.getColumnEditorCaps(existing), this.getKeyEditorCaps(false), this.getKeyEditorCaps(existing), this.getIndexEditorCaps(false), this.getIndexEditorCaps(existing), this.getForeignKeyEditorCaps(false), this.getForeignKeyEditorCaps(existing));
        if (tableEditorCaps == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(11);
        }
        return tableEditorCaps;
    }

    public boolean supportsTableComment() {
        return false;
    }

    @NotNull
    protected DatabaseEditorCapabilities.DbEditorCaps getDbEditorCaps() {
        DatabaseEditorCapabilities.DbEditorCaps dbEditorCaps = new DatabaseEditorCapabilities.DbEditorCaps(new DatabaseEditorCapabilities.ObjectEditorCaps(DatabaseEditorCapabilities.Capability.supported(this.supportsCreateDatabase()), DatabaseEditorCapabilities.Capability.UNSUPPORTED), new DatabaseEditorCapabilities.ObjectEditorCaps(DatabaseEditorCapabilities.Capability.supported(this.supportsRenameDatabase()), DatabaseEditorCapabilities.Capability.UNSUPPORTED), new DatabaseEditorCapabilities.ObjectEditorCaps(DatabaseEditorCapabilities.Capability.supported(this.supportsCreateSchema()), DatabaseEditorCapabilities.Capability.UNSUPPORTED), new DatabaseEditorCapabilities.ObjectEditorCaps(DatabaseEditorCapabilities.Capability.supported(this.supportsRenameSchema()), DatabaseEditorCapabilities.Capability.UNSUPPORTED), this.getTableEditorCaps(false), this.getTableEditorCaps(true));
        if (dbEditorCaps == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(12);
        }
        return dbEditorCaps;
    }

    @NotNull
    protected SchemaExporters getSchemaExporters() {
        SchemaExporters schemaExporters = DasSchemaExporters.createDefaultExporters();
        if (schemaExporters == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(13);
        }
        return schemaExporters;
    }

    @Override
    @NotNull
    public SchemaEditor getSchemaEditor() {
        SchemaEditor schemaEditor = (SchemaEditor)this.mySchemaEditor.getValue();
        if (schemaEditor == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(14);
        }
        return schemaEditor;
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        MetaModel metaModel = this.myMetaModel;
        if (metaModel == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(15);
        }
        return metaModel;
    }

    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(16);
        }
        return identifier.indexOf(this.closeQuote()) == -1;
    }

    public String quoteIdentifier(String identifier, boolean force, boolean suppress) {
        return this.quoteIdentifier(identifier, force, suppress, this.myCasing);
    }

    public String unquoteIdentifier(String identifier) {
        if (!this.isQuotedIdentifier(identifier)) {
            return identifier;
        }
        return AbstractDatabaseDialect.unescapeCharSql(identifier.substring(1, identifier.length() - 1), identifier.charAt(identifier.length() - 1));
    }

    public boolean isQuotedIdentifier(@Nullable String identifier) {
        if (StringUtil.isEmpty((String)identifier) || identifier.length() < 2) {
            return false;
        }
        return StringUtil.startsWithChar((CharSequence)identifier, (char)this.openQuote()) && StringUtil.endsWithChar((CharSequence)identifier, (char)this.closeQuote()) || this.openQuote() != '\"' && StringUtil.startsWithChar((CharSequence)identifier, (char)'\"') && StringUtil.startsWithChar((CharSequence)identifier, (char)'\"');
    }

    public String quoteIdentifier(String identifier, boolean force, boolean suppress, @NotNull Casing casing) {
        if (casing == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(17);
        }
        if (StringUtil.isEmpty((String)identifier) || this.isQuotedIdentifier(identifier)) {
            return identifier;
        }
        force |= !this.isValidPlainIdentifier(identifier);
        if (!(force |= this.myKeywordHelper.isReservedKeyword(identifier)) && !suppress && casing.quoted == Case.EXACT && casing.plain != Case.EXACT && casing.plain != Case.MIXED) {
            Case identifierCase = Case.forString((String)identifier);
            force = identifierCase == Case.MIXED || identifierCase != casing.plain;
        }
        return force ? this.openQuote() + AbstractDatabaseDialect.escapeCharSql(identifier, this.closeQuote()) + this.closeQuote() : identifier;
    }

    @NotNull
    private static String escapeCharSql(@NotNull String s, char c) {
        if (s == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(18);
        }
        if (s.indexOf(c) == -1) {
            String string = s;
            if (string == null) {
                AbstractDatabaseDialect.$$$reportNull$$$0(19);
            }
            return string;
        }
        String cs = String.valueOf(c);
        String string = StringUtil.replace((String)s, (String)cs, (String)(cs + cs));
        if (string == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static String unescapeCharSql(@NotNull String s, char c) {
        if (s == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(21);
        }
        if (s.indexOf(c) == -1) {
            String string = s;
            if (string == null) {
                AbstractDatabaseDialect.$$$reportNull$$$0(22);
            }
            return string;
        }
        String cs = String.valueOf(c);
        String string = StringUtil.replace((String)s, (String)(cs + cs), (String)cs);
        if (string == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull String sequenceName) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(24);
        }
        if (column == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(25);
        }
        if (sequenceName == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(26);
        }
        DdlBuilder ddlBuilder = this.sqlAddColumnAutoIncrement(builder, column);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSelectAll(@NotNull DdlBuilder builder, @NotNull DasTable dasTable, @Nullable DatabaseSystem system, @Nullable BiConsumer<String, DdlBuilder> appendWhereClause, @Nullable Consumer<DdlBuilder> orderByAppender, boolean appendRowId, int rows) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(28);
        }
        if (dasTable == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(29);
        }
        DdlBuilder ddlBuilder = this.sqlSelectColumns(builder, dasTable, system, appendWhereClause, orderByAppender, ContainerUtil.emptyList(), appendRowId, rows);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(30);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSelectColumns(@NotNull DdlBuilder builder, @NotNull DasTable dasTable, @Nullable DatabaseSystem system, @Nullable BiConsumer<String, DdlBuilder> appendWhereClause, @Nullable Consumer<DdlBuilder> orderByAppender, @NotNull List<DasColumn> columns2, boolean appendRowId, int rows) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(31);
        }
        if (dasTable == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(32);
        }
        if (columns2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(33);
        }
        LimitPlace place = this.getPlaceForLimit(system);
        boolean isUnlimited = DbImplUtil.isPageSizeUnlimited(rows);
        builder.keyword("SELECT").space();
        if (!isUnlimited) {
            LimitPlace.BEGIN.appendLimit(builder, this, place, system, rows);
        }
        if (columns2.isEmpty()) {
            builder.alias(ALIAS).symbol(".").symbol("*");
        } else {
            DialectUtils.appendColumnList(ALIAS, builder, columns2);
        }
        if (this.hasRowId(system) && appendRowId) {
            this.appendRowId(builder, system);
        }
        builder.space().keyword("FROM").space().qualifiedRef((DasObject)dasTable).space().alias(ALIAS);
        if (appendWhereClause != null) {
            appendWhereClause.accept(ALIAS, builder);
        }
        if (orderByAppender != null) {
            orderByAppender.consume((Object)builder);
        }
        DdlBuilder ddlBuilder = !isUnlimited ? LimitPlace.END.appendLimit(builder, this, place, system, rows) : builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(34);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(35);
        }
        if (pk == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(36);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(37);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(38);
        }
        if (column == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(39);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable()).space();
        builder.keyword("DROP").space();
        builder.columnRef((DasObject)column);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(40);
        }
        return ddlBuilder;
    }

    protected static boolean isSameName(@NotNull DasColumn from, @NotNull DasColumn to) {
        if (from == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(41);
        }
        if (to == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(42);
        }
        return StringUtil.equals((CharSequence)from.getName(), (CharSequence)to.getName());
    }

    protected boolean isSameType(@NotNull DasColumn from, @NotNull DasColumn to) {
        if (from == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(43);
        }
        if (to == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(44);
        }
        DdlBuilder tmp = new DdlBuilder().withDialect(this);
        String fromStr = tmp.type((DasTypedObject)from).getStatement();
        String toStr = tmp.clear().type((DasTypedObject)to).getStatement();
        return StringUtil.equalsIgnoreCase((CharSequence)fromStr, (CharSequence)toStr);
    }

    protected static boolean isSameDefault(@NotNull DasColumn from, @NotNull DasColumn to) {
        if (from == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(45);
        }
        if (to == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(46);
        }
        return StringUtil.equals((CharSequence)((CharSequence)ObjectUtils.notNull((Object)from.getDefault(), (Object)"")), (CharSequence)((CharSequence)ObjectUtils.notNull((Object)to.getDefault(), (Object)"")));
    }

    protected static boolean isSameNullability(@NotNull DasColumn from, @NotNull DasColumn to) {
        if (from == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(47);
        }
        if (to == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(48);
        }
        return from.isNotNull() == to.isNotNull();
    }

    protected static boolean isSameComment(@NotNull DasColumn from, @NotNull DasColumn to) {
        if (from == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(49);
        }
        if (to == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(50);
        }
        return Comparing.equal((String)from.getComment(), (String)to.getComment());
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to, boolean forceOutput) {
        SplitAlterColumnSupport support;
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(51);
        }
        if (from == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(52);
        }
        if (to == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(53);
        }
        if ((support = (SplitAlterColumnSupport)ObjectUtils.tryCast((Object)this, SplitAlterColumnSupport.class)) == null) {
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                AbstractDatabaseDialect.$$$reportNull$$$0(54);
            }
            return ddlBuilder;
        }
        int before = builder.getStatements().size();
        if (!AbstractDatabaseDialect.isSameName(from, to)) {
            support.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        if (!this.isSameType(from, to)) {
            support.sqlAlterColumnType(builder, from, to).newStatement();
        }
        if (!AbstractDatabaseDialect.isSameDefault(from, to)) {
            support.sqlAlterColumnDefault(builder, to).newStatement();
        }
        if (!AbstractDatabaseDialect.isSameNullability(from, to)) {
            support.sqlAlterColumnNullable(builder, to).newStatement();
        }
        if (!AbstractDatabaseDialect.isSameComment(from, to)) {
            support.sqlAlterColumnComment(builder, to).newStatement();
        }
        if (!AbstractDatabaseDialect.isSameAutoInc(from, to)) {
            this.sqlAddColumnAutoIncrement(builder, to).newStatement();
        }
        if (builder.getStatements().size() == before && forceOutput) {
            support.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(55);
        }
        return ddlBuilder;
    }

    protected static boolean isSameAutoInc(@NotNull DasColumn from, @NotNull DasColumn to) {
        if (from == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(56);
        }
        if (to == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(57);
        }
        Set fAttr = ContainerUtil.notNullize(from.getTable() == null ? null : from.getTable().getColumnAttrs(from));
        Set tAttr = ContainerUtil.notNullize(to.getTable() == null ? null : to.getTable().getColumnAttrs(to));
        return fAttr.contains(DasColumn.Attribute.AUTO_GENERATED) == tAttr.contains(DasColumn.Attribute.AUTO_GENERATED);
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateTable(@NotNull DdlBuilder builder, @NotNull List<? extends DasTable> tables, boolean constraintsAtEnd, @Nullable Set<? extends DasForeignKey> ignoreFks) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(58);
        }
        if (tables == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(59);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateTableSQL(builder, tables, constraintsAtEnd, this, ignoreFks);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(60);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace schema) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(61);
        }
        if (schema == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(62);
        }
        if (!this.supportsCreateSchema()) {
            throw new UnsupportedOperationException("Create schema is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("CREATE", "SCHEMA").space().qualifiedRef((DasObject)schema);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(63);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateDatabase(@NotNull DdlBuilder builder, @NotNull DasNamespace database) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(64);
        }
        if (database == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(65);
        }
        if (!this.supportsCreateDatabase()) {
            throw new UnsupportedOperationException("Create database is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("CREATE", "DATABASE").space().qualifiedRef((DasObject)database);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(66);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace schema, @NotNull String name) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(67);
        }
        if (schema == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(68);
        }
        if (name == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(69);
        }
        if (!this.supportsRenameSchema()) {
            throw new UnsupportedOperationException("Rename schema is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("ALTER", "SCHEMA").space().qualifiedRef((DasObject)schema).space().keywords("RENAME", "TO").space().identifier((DasObject)schema, name);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(70);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameDatabase(@NotNull DdlBuilder builder, @NotNull DasNamespace database, @NotNull String name) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(71);
        }
        if (database == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(72);
        }
        if (name == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(73);
        }
        if (!this.supportsRenameDatabase()) {
            throw new UnsupportedOperationException("Rename database is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("ALTER", "DATABASE").space().qualifiedRef((DasObject)database).space().keywords("RENAME", "TO").space().identifier((DasObject)database, name);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(74);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(75);
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, null, false, null, null);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(76);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column, boolean singlePk) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(77);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefinitionSQL(builder, column, singlePk);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(78);
        }
        return ddlBuilder;
    }

    public boolean supportsDropProcedure() {
        return true;
    }

    public boolean supportsDropTrigger() {
        return true;
    }

    public boolean supportsDropRule() {
        return false;
    }

    public boolean supportsDropPackage() {
        return false;
    }

    public boolean supportsDropCluster() {
        return false;
    }

    public boolean supportsDropForeignDataWrapper() {
        return false;
    }

    public boolean supportsDropForeignServer() {
        return false;
    }

    public boolean supportsDropUserMapping() {
        return false;
    }

    public boolean supportsDropSynonym() {
        return false;
    }

    public boolean supportsSystemViewDefinition() {
        return this.supportsViewDefinition();
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(79);
        }
        if (procedure == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(80);
        }
        DdlBuilder ddlBuilder = DialectUtils.sqlDropProcedure(builder, procedure, false);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(81);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTrigger(@NotNull DdlBuilder builder, @NotNull DasTrigger trigger) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(82);
        }
        if (trigger == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(83);
        }
        builder.keywords("DROP", "TRIGGER").space().qualifiedRef((DasObject)trigger);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(84);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropRule(@NotNull DdlBuilder builder, @NotNull DasTableChild rule) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(85);
        }
        if (rule == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(86);
        }
        throw new UnsupportedOperationException("drop rule is not supported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace namespace) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(87);
        }
        if (namespace == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(88);
        }
        if (!this.supportsDropSchema()) {
            throw new UnsupportedOperationException("drop schema is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "SCHEMA").space().qualifiedRef((DasObject)namespace);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(89);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropDatabase(@NotNull DdlBuilder builder, @NotNull DasNamespace namespace) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(90);
        }
        if (namespace == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(91);
        }
        if (!this.supportsDropDatabase()) {
            throw new UnsupportedOperationException("drop database is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "DATABASE").space().qualifiedRef((DasObject)namespace);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(92);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPackage(@NotNull DdlBuilder builder, @NotNull DasSchemaChild pkg) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(93);
        }
        if (pkg == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(94);
        }
        throw new UnsupportedOperationException("drop package is not supported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropCluster(@NotNull DdlBuilder builder, @NotNull DasCluster cluster) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(95);
        }
        if (cluster == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(96);
        }
        throw new UnsupportedOperationException("drop cluster is not supported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropForeignDataWrapper(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(97);
        }
        if (object == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(98);
        }
        throw new UnsupportedOperationException("drop foreign data wrapper is not supported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropForeignServer(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(99);
        }
        if (object == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(100);
        }
        throw new UnsupportedOperationException("drop foreign data wrapper is not supported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropUserMapping(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(101);
        }
        if (object == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(102);
        }
        throw new UnsupportedOperationException("drop foreign data wrapper is not supported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSynonym(@NotNull DdlBuilder builder, @NotNull DasSynonym synonym) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(103);
        }
        if (synonym == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(104);
        }
        if (!this.supportsDropSynonym()) {
            throw new UnsupportedOperationException("drop synonym is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "SYNONYM").space().qualifiedRef((DasObject)synonym);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(105);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropMaterializedView(@NotNull DdlBuilder builder, @NotNull DasTable view) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(106);
        }
        if (view == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(107);
        }
        if (!this.supportsDropMaterializedView()) {
            throw new UnsupportedOperationException("drop materialized view is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "MATERIALIZED", "VIEW").space().qualifiedRef((DasObject)view);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(108);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropOperator(@NotNull DdlBuilder builder, @NotNull DasOperator operator) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(109);
        }
        if (operator == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(110);
        }
        throw new UnsupportedOperationException("Unable to drop operator");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropType(@NotNull DdlBuilder builder, @NotNull DasUserDefinedType type) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(111);
        }
        if (type == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(112);
        }
        if (!this.supportsDropType()) {
            throw new UnsupportedOperationException("Unable to drop type");
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "TYPE").space().qualifiedRef((DasObject)type);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(113);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropCollation(@NotNull DdlBuilder builder, @NotNull DasObject collation) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(114);
        }
        if (collation == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(115);
        }
        throw new UnsupportedOperationException("Unable to drop collation");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropForeignKey(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasForeignKey fk, @NotNull String fkName) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(116);
        }
        if (table == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(117);
        }
        if (fkName == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(118);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropForeignKeySQL(builder, fk, fkName, table);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(119);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlInsertInto(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull List<String> columns2, @NotNull List<String> values) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(120);
        }
        if (table == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(121);
        }
        if (columns2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(122);
        }
        if (values == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(123);
        }
        builder.keyword("INSERT").space().keyword("INTO").space().qualifiedRef((DasObject)table);
        if (!columns2.isEmpty()) {
            builder.space().symbol("(");
            DialectUtils.appendStringList(builder, columns2);
            builder.symbol(")");
        }
        if (values.isEmpty() && this.supportsInsertDefaultValues()) {
            builder.space().keyword("DEFAULT").space().keyword("VALUES");
        } else {
            builder.space().keyword("VALUES").space().symbol("(");
            DialectUtils.appendPlainList(builder, values);
            builder.symbol(")");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(124);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsInsertDefaultValues() {
        return false;
    }

    @Override
    public boolean supportsInsertDefaultIntoAutoVal() {
        return false;
    }

    protected boolean isCommentDroppedByNull() {
        return false;
    }

    @Override
    public DdlBuilder sqlAlterObjectComment(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(125);
        }
        if (object == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(126);
        }
        String type = null;
        if (object.getKind() == ObjectKind.COLUMN) {
            type = "COLUMN";
        } else if (object.getKind() == ObjectKind.TABLE) {
            type = "TABLE";
        }
        if (type != null) {
            DialectUtils.getObjectCommentAlterSQL(builder, type, object, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this));
        }
        return builder;
    }

    @NotNull
    public String getLengthFunction() {
        if ("length" == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(127);
        }
        return "length";
    }

    public boolean supportsCreateDatabase() {
        return false;
    }

    public boolean supportsRenameDatabase() {
        return this.supportsCreateDatabase();
    }

    public boolean supportsCreateSchema() {
        return true;
    }

    public boolean supportsRenameSchema() {
        return this.supportsCreateSchema();
    }

    @NotNull
    public String getMaxFunction() {
        if ("max" == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(128);
        }
        return "max";
    }

    @NotNull
    public String getNullColumnString() {
        if ("" == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(129);
        }
        return "";
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(130);
        }
        if (table == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(131);
        }
        if (model == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(132);
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, true, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(133);
        }
        return ddlBuilder;
    }

    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        String typeName;
        if (dataType == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(134);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                AbstractDatabaseDialect.$$$reportNull$$$0(135);
            }
            return string;
        }
        int jdbcType = dataType.jdbcType;
        int length = dataType.getLength();
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if (jdbcType == 1111) {
            jdbcType = this.getJavaTypeForNativeType(dataType.getSpecification());
        }
        String string = (typeName = this.myTypeHelper.getTypeName(jdbcType, length, precision, scale)) != null ? typeName : JdbcUtil.getJdbcTypeName((DataType)dataType);
        if (string == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(136);
        }
        return string;
    }

    @NotNull
    public TypeHelper getTypeHelper() {
        TypeHelper typeHelper = this.myTypeHelper;
        if (typeHelper == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(137);
        }
        return typeHelper;
    }

    @NotNull
    public String getTypeWithSubstitution(@NotNull String name, int length, int precision, int scale) {
        if (name == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(138);
        }
        String string = this.myTypeHelper.getTypeWithSubstitution(name, length, precision, scale);
        if (string == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(139);
        }
        return string;
    }

    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(140);
        }
        return this.myTypeHelper.findJdbcType(nativeColumnTypeName);
    }

    public boolean supportsTableDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(141);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.table.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(142);
        }
        if (connection == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(143);
        }
        if ("" == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(144);
        }
        return "";
    }

    public boolean supportsTableInfo() {
        return false;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(145);
        }
        if (connection == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(146);
        }
        Map<String, Object> map2 = Collections.emptyMap();
        if (map2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(147);
        }
        return map2;
    }

    @Override
    public boolean supportsSearchPath() {
        return false;
    }

    @Override
    public ObjectKind getSearchPathObjectKind() {
        return ObjectKind.SCHEMA;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull DatabaseConnection connection) throws SQLException {
        if (system == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(148);
        }
        if (connection == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(149);
        }
        return null;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(150);
        }
        return null;
    }

    public boolean supportsCreateTable() {
        return true;
    }

    public boolean supportsDropMaterializedView() {
        return false;
    }

    public boolean supportsDropOperator() {
        return false;
    }

    public boolean supportsDropType() {
        return false;
    }

    public boolean supportsDropCollation() {
        return false;
    }

    public boolean supportsDropSchema() {
        return false;
    }

    public boolean supportsDropDatabase() {
        return this.supportsCreateDatabase();
    }

    public boolean supportsDropColumn() {
        return true;
    }

    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsSchemasInTableDefinition() {
        return true;
    }

    public char closeQuote() {
        return '\"';
    }

    public char openQuote() {
        return '\"';
    }

    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(151);
        }
        return kind.name();
    }

    public boolean supportsSubSecondTimestamps() {
        return true;
    }

    public boolean supportsAddPrimaryKey() {
        return true;
    }

    public boolean supportsRenameRoutine() {
        return true;
    }

    public boolean supportsModifyColumn() {
        return this.supportsRenameColumn();
    }

    public boolean supportsDropPrimaryKey() {
        return true;
    }

    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(152);
        }
        return "'" + DialectUtils.toHexString(binaryData) + "'";
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(153);
        }
        if (pk == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(154);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropPrimaryKeySQL(builder, pk, false, false);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(155);
        }
        return ddlBuilder;
    }

    public boolean supportsDropForeignKey() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey primaryKey) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(156);
        }
        if (primaryKey == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(157);
        }
        builder.keywords("PRIMARY", "KEY").space().symbol("(");
        boolean first = true;
        MultiRef.It it = primaryKey.getColumnsRef().iterate();
        while (it.hasNext()) {
            String pk = (String)it.next();
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.constraintRef((DasObject)it.resolve(), pk);
        }
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(158);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine proc, @NotNull DatabaseConnection connection) throws Exception {
        if (proc == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(159);
        }
        if (connection == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(160);
        }
        if ("" == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(161);
        }
        return "";
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element) {
        if (element == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(162);
        }
        throw new UnsupportedOperationException("Package body definition is not supported");
    }

    public boolean supportsPackageDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element) {
        if (element == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(163);
        }
        throw new UnsupportedOperationException("Package definition is not supported");
    }

    public boolean supportsSequenceDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element) {
        if (element == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(164);
        }
        throw new UnsupportedOperationException("Sequence definition is not supported");
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSynonymDefinition(@NotNull DasObject element) {
        if (element == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(165);
        }
        throw new UnsupportedOperationException("Synonym definition is not supported");
    }

    @Override
    @NotNull
    public String tryToLoadSynonymDefinition(DasTable tableElement, DatabaseConnection connection) throws Exception {
        if ("" == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(166);
        }
        return "";
    }

    @Override
    @NotNull
    public DdlBuilder sqlPostExplainPlan(@NotNull DdlBuilder builder, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(167);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(168);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsInlineAddPrimaryKey() {
        return false;
    }

    public boolean supportsSynonymDefinition() {
        return false;
    }

    public boolean supportsQualifiedAsteriskInCalls() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(169);
        }
        if (procedure == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(170);
        }
        String type = procedure.getRoutineKind().name();
        String pkgName = procedure.getPackageName();
        if (pkgName == null) {
            builder.keyword("create").space();
        }
        builder.keyword(type).space().qualifiedRef((DasObject)procedure);
        this.sqlDefinePrototype(builder, procedure, true, true);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(171);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrototype(@NotNull DdlBuilder builder, @NotNull DasRoutine routine, boolean longMode, boolean withReturn) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(172);
        }
        if (routine == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(173);
        }
        JBIterable parameters = DasUtil.getParameters((DasRoutine)routine);
        DasArgument returnArg = routine.getReturnArgument();
        builder.symbol("(");
        boolean first = true;
        for (DasArgument parameter : parameters) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            this.sqlParameter(builder, parameter, longMode);
        }
        builder.symbol(")");
        if (returnArg != null && withReturn) {
            if (longMode) {
                builder.space().keyword("returns").space();
            } else {
                builder.plain(": ");
            }
            builder.type((DasTypedObject)returnArg);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(174);
        }
        return ddlBuilder;
    }

    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(175);
        }
        DialectUtils.sqlParameter(builder, parameter, longMode, 0, false);
    }

    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return false;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws Exception {
        if (connection == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(176);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(177);
        }
        return list;
    }

    @NotNull
    public static DdlBuilder multiInsertStatement(@NotNull DdlBuilder builder, DasTable table, @NotNull List<String> columns2, @NotNull DatabaseDialectEx myDialect, @NotNull List<List<String>> params2) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(178);
        }
        if (columns2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(179);
        }
        if (myDialect == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(180);
        }
        if (params2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(181);
        }
        builder.keyword("INSERT").space().keyword("INTO").space().qualifiedRef((DasObject)table);
        boolean empty = columns2.isEmpty();
        if (empty) {
            if (myDialect.supportsInsertDefaultValues()) {
                builder.space().keyword("DEFAULT").space().keyword("VALUES");
                DdlBuilder ddlBuilder = builder;
                if (ddlBuilder == null) {
                    AbstractDatabaseDialect.$$$reportNull$$$0(182);
                }
                return ddlBuilder;
            }
            throw new IllegalArgumentException("Can't insert values without columns");
        }
        builder.space().symbol("(");
        DialectUtils.appendStringList(builder, columns2);
        builder.symbol(")");
        builder.space().keyword("VALUES").space();
        int linesCount = params2.size();
        for (int i2 = 0; i2 < linesCount; ++i2) {
            builder.symbol("(");
            DialectUtils.appendPlainList(builder, (Iterable<String>)params2.get(i2));
            builder.symbol(")");
            if (i2 >= linesCount - 1) continue;
            builder.literal(",");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(183);
        }
        return ddlBuilder;
    }

    @Override
    public boolean hasRowId(@Nullable DatabaseSystem system) {
        return false;
    }

    @NotNull
    protected LimitPlace getPlaceForLimit(@Nullable DatabaseSystem system) {
        LimitPlace limitPlace = LimitPlace.END;
        if (limitPlace == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(184);
        }
        return limitPlace;
    }

    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system, int rows) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(185);
        }
        DdlBuilder ddlBuilder = builder.space().keyword("LIMIT").space().literal(String.valueOf(rows));
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(186);
        }
        return ddlBuilder;
    }

    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(187);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(188);
        }
        return ddlBuilder;
    }

    @NotNull
    protected static DdlBuilder top(@NotNull DdlBuilder builder, @NotNull String topWord, int rows) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(189);
        }
        if (topWord == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(190);
        }
        DdlBuilder ddlBuilder = builder.keyword(topWord).space().literal(String.valueOf(rows)).space();
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(191);
        }
        return ddlBuilder;
    }

    @NotNull
    protected static DdlBuilder fetchFirst(@NotNull DdlBuilder builder, int rows) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(192);
        }
        DdlBuilder ddlBuilder = builder.space().keywords("FETCH", "FIRST").space().literal(String.valueOf(rows)).space().keywords("ROWS", "ONLY");
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(193);
        }
        return ddlBuilder;
    }

    @NotNull
    protected static DdlBuilder rowNumLimit(@NotNull DdlBuilder builder, int rows) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(194);
        }
        String statement = builder.getStatement();
        builder.clear();
        builder.keyword("SELECT").space().symbol("*").space().keyword("FROM").space().symbol("(").plain(statement).symbol(")").space().keyword("WHERE").space().keyword("ROWNUM").space().symbol("<=").space().literal(String.valueOf(rows));
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(195);
        }
        return ddlBuilder;
    }

    @Override
    @Nullable
    public DatabaseDialectEx.VersionParser getVersionParser() {
        return null;
    }

    @Override
    @Nullable
    public String sqlResetSearchPath() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 54: 
            case 55: 
            case 60: 
            case 63: 
            case 66: 
            case 70: 
            case 74: 
            case 76: 
            case 78: 
            case 81: 
            case 84: 
            case 89: 
            case 92: 
            case 105: 
            case 108: 
            case 113: 
            case 119: 
            case 124: 
            case 127: 
            case 128: 
            case 129: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 144: 
            case 147: 
            case 155: 
            case 158: 
            case 161: 
            case 166: 
            case 168: 
            case 171: 
            case 174: 
            case 177: 
            case 182: 
            case 183: 
            case 184: 
            case 186: 
            case 188: 
            case 191: 
            case 193: 
            case 195: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 54: 
            case 55: 
            case 60: 
            case 63: 
            case 66: 
            case 70: 
            case 74: 
            case 76: 
            case 78: 
            case 81: 
            case 84: 
            case 89: 
            case 92: 
            case 105: 
            case 108: 
            case 113: 
            case 119: 
            case 124: 
            case 127: 
            case 128: 
            case 129: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 144: 
            case 147: 
            case 155: 
            case 158: 
            case 161: 
            case 166: 
            case 168: 
            case 171: 
            case 174: 
            case 177: 
            case 182: 
            case 183: 
            case 184: 
            case 186: 
            case 188: 
            case 191: 
            case 193: 
            case 195: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaModel";
                break;
            }
            case 1: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 54: 
            case 55: 
            case 60: 
            case 63: 
            case 66: 
            case 70: 
            case 74: 
            case 76: 
            case 78: 
            case 81: 
            case 84: 
            case 89: 
            case 92: 
            case 105: 
            case 108: 
            case 113: 
            case 119: 
            case 124: 
            case 127: 
            case 128: 
            case 129: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 144: 
            case 147: 
            case 155: 
            case 158: 
            case 161: 
            case 166: 
            case 168: 
            case 171: 
            case 174: 
            case 177: 
            case 182: 
            case 183: 
            case 184: 
            case 186: 
            case 188: 
            case 191: 
            case 193: 
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/AbstractDatabaseDialect";
                break;
            }
            case 3: 
            case 69: 
            case 73: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 24: 
            case 28: 
            case 31: 
            case 35: 
            case 38: 
            case 51: 
            case 58: 
            case 61: 
            case 64: 
            case 67: 
            case 71: 
            case 75: 
            case 77: 
            case 79: 
            case 82: 
            case 85: 
            case 87: 
            case 90: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 106: 
            case 109: 
            case 111: 
            case 114: 
            case 116: 
            case 120: 
            case 125: 
            case 130: 
            case 153: 
            case 156: 
            case 167: 
            case 169: 
            case 172: 
            case 175: 
            case 178: 
            case 185: 
            case 187: 
            case 189: 
            case 192: 
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 25: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequenceName";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasTable";
                break;
            }
            case 33: 
            case 122: 
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 36: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 62: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 65: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 80: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trigger";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 88: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cluster";
                break;
            }
            case 98: 
            case 100: 
            case 102: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "synonym";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collation";
                break;
            }
            case 117: 
            case 121: 
            case 131: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fkName";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 141: 
            case 145: 
            case 162: 
            case 163: 
            case 164: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 143: 
            case 146: 
            case 149: 
            case 160: 
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryKey";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDialect";
                break;
            }
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topWord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/AbstractDatabaseDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnEditorCaps";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexColumnEditorCaps";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexEditorCaps";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableKeyColumnEditorCaps";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyEditorCaps";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeyEditorCaps";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableEditorCaps";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbEditorCaps";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaExporters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaEditor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharSql";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeCharSql";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSelectAll";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSelectColumns";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefinition";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateTable";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateSchema";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateDatabase";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameSchema";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameDatabase";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineForeignKey";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTrigger";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSchema";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropDatabase";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSynonym";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropMaterializedView";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropType";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropForeignKey";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlInsertInto";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getLengthFunction";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxFunction";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullColumnString";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHelper";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithSubstitution";
                break;
            }
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 155: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropPrimaryKey";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefinePrimaryKey";
                break;
            }
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadSynonymDefinition";
                break;
            }
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPostExplainPlan";
                break;
            }
            case 171: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineProcedure";
                break;
            }
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefinePrototype";
                break;
            }
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
            case 182: 
            case 183: {
                objectArray = objectArray2;
                objectArray2[1] = "multiInsertStatement";
                break;
            }
            case 184: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceForLimit";
                break;
            }
            case 186: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLimit";
                break;
            }
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRowId";
                break;
            }
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "top";
                break;
            }
            case 193: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchFirst";
                break;
            }
            case 195: {
                objectArray = objectArray2;
                objectArray2[1] = "rowNumLimit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 54: 
            case 55: 
            case 60: 
            case 63: 
            case 66: 
            case 70: 
            case 74: 
            case 76: 
            case 78: 
            case 81: 
            case 84: 
            case 89: 
            case 92: 
            case 105: 
            case 108: 
            case 113: 
            case 119: 
            case 124: 
            case 127: 
            case 128: 
            case 129: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 144: 
            case 147: 
            case 155: 
            case 158: 
            case 161: 
            case 166: 
            case 168: 
            case 171: 
            case 174: 
            case 177: 
            case 182: 
            case 183: 
            case 184: 
            case 186: 
            case 188: 
            case 191: 
            case 193: 
            case 195: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifierUnconditionally";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharSql";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unescapeCharSql";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "sqlSelectAll";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "sqlSelectColumns";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isSameName";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isSameType";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isSameDefault";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isSameNullability";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isSameComment";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefinition";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isSameAutoInc";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateTable";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSchema";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateDatabase";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameSchema";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameDatabase";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineForeignKey";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTrigger";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropRule";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSchema";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropDatabase";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropPackage";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropCluster";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropForeignDataWrapper";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropForeignServer";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropUserMapping";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSynonym";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropMaterializedView";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropOperator";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropType";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropCollation";
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropForeignKey";
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "sqlInsertInto";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterObjectComment";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithSubstitution";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropPrimaryKey";
                break;
            }
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefinePrimaryKey";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageBodyDefinition";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageDefinition";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "sqlSynonymDefinition";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "sqlPostExplainPlan";
                break;
            }
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineProcedure";
                break;
            }
            case 172: 
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefinePrototype";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "multiInsertStatement";
                break;
            }
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "appendLimit";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "appendRowId";
                break;
            }
            case 189: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "top";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "fetchFirst";
                break;
            }
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "rowNumLimit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 54: 
            case 55: 
            case 60: 
            case 63: 
            case 66: 
            case 70: 
            case 74: 
            case 76: 
            case 78: 
            case 81: 
            case 84: 
            case 89: 
            case 92: 
            case 105: 
            case 108: 
            case 113: 
            case 119: 
            case 124: 
            case 127: 
            case 128: 
            case 129: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 144: 
            case 147: 
            case 155: 
            case 158: 
            case 161: 
            case 166: 
            case 168: 
            case 171: 
            case 174: 
            case 177: 
            case 182: 
            case 183: 
            case 184: 
            case 186: 
            case 188: 
            case 191: 
            case 193: 
            case 195: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static enum LimitPlace {
        BEGIN,
        END;


        DdlBuilder appendLimit(@NotNull DdlBuilder builder, @NotNull AbstractDatabaseDialect dialect, @NotNull LimitPlace place, @Nullable DatabaseSystem system, int rows) {
            if (builder == null) {
                LimitPlace.$$$reportNull$$$0(0);
            }
            if (dialect == null) {
                LimitPlace.$$$reportNull$$$0(1);
            }
            if (place == null) {
                LimitPlace.$$$reportNull$$$0(2);
            }
            return place == this ? dialect.appendLimit(builder, system, rows) : builder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialect";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "place";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/AbstractDatabaseDialect$LimitPlace";
            objectArray[2] = "appendLimit";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static interface SplitAlterColumnSupport {
        @NotNull
        public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder var1, @NotNull DasColumn var2);

        @NotNull
        public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder var1, @NotNull DasColumn var2);

        @NotNull
        public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder var1, @NotNull DasColumn var2, @NotNull String var3);

        @NotNull
        public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder var1, @NotNull DasColumn var2, @NotNull DasColumn var3);

        @NotNull
        public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder var1, @NotNull DasColumn var2);
    }
}

