/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.extractors.tz.TimeZonedValue;
import com.intellij.database.model.DataType;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.remote.jdbc.impl.ZonedValue;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.NumberFormatter;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentClassMap;
import com.intellij.util.containers.ContainerUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectFormatter {
    private static final int MIN_IMAGE_BYTES = 100;
    private static final int MAX_FRACTION_DIGITS = 340;
    private static final int H2_DEFAULT_SCALE = Short.MAX_VALUE;
    private static final int H2_DEFAULT_PRECISION = 65535;
    private static final Pattern PG_HSTORE_REQUIRES_QUOTATION = Pattern.compile("\\s|,|=|>");
    private final Map<DataConsumer.Column, Formatter> myFormatCache = ContainerUtil.newConcurrentMap((int)10, (float)0.75f, (int)Runtime.getRuntime().availableProcessors());
    private Formatter myDateFormat;
    private Formatter myTimeFormat;
    private Formatter myZonedTimeFormat;
    private Formatter myShortZonedTimeFormat;
    private Formatter myShortZonedTimestampFormat;
    private NumberFormatter myNumberFormat;
    private NumberFormatter myBigIntFormat;
    private static final MyMap<Object> ourToObject = new MyMap();
    private final MyMap<String> myToString = new MyMap();

    public ObjectFormatter() {
        this.myToString.register(String.class, new Converter<String, String>(){

            @Override
            public String convert(String o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return o;
            }
        });
        this.myToString.register(Object[].class, new Converter<Object[], String>(){

            @Override
            public String convert(Object[] o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (o.length == 0) {
                    return forDisplay ? "{}" : "";
                }
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                int len = Math.min(o.length, forDisplay ? 100 : o.length);
                for (int i2 = 0; i2 < len; ++i2) {
                    if (i2 > 0) {
                        sb.append(",");
                    }
                    sb.append(ObjectFormatter.this.objectToString(o[i2], column, dialect, true));
                }
                if (len < o.length) {
                    sb.append(",...");
                }
                sb.append("}");
                return sb.toString();
            }
        });
        this.myToString.register(byte[].class, new Converter<byte[], String>(){

            @Override
            public String convert(byte[] o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (forDisplay && ObjectFormatter.isOracleGUID(o, column, dialect)) {
                    return DialectUtils.toHexString(o);
                }
                return ObjectFormatter.this.bytesToStringImpl(o, o.length, dialect, forDisplay);
            }
        });
        this.myToString.register(BitString.class, new Converter<BitString, String>(){

            @Override
            public String convert(BitString o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.bitsToString(o, column);
            }
        });
        this.myToString.register(char[].class, new Converter<char[], String>(){

            @Override
            public String convert(char[] o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                String text2 = new String(o);
                return ObjectFormatter.charToStringImpl(text2, text2.length(), forDisplay);
            }
        });
        this.myToString.register(Clob.class, new Converter<Clob, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String convert(Clob o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                try {
                    long length = o.length();
                    int trimmed = ObjectFormatter.trimToMax(length);
                    String string = ObjectFormatter.charToStringImpl(trimmed > 0 ? o.getSubString(1L, trimmed) : "", length, forDisplay);
                    return string;
                }
                catch (Exception e) {
                    String string = e.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Clob)o);
                }
            }
        });
        this.myToString.register(LobInfo.ClobInfo.class, new Converter<LobInfo.ClobInfo, String>(){

            @Override
            public String convert(LobInfo.ClobInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (o.isTruncated() && o.data == null) {
                    return ObjectFormatter.getValueNotLoadedString(column, dialect, o.length);
                }
                return ObjectFormatter.charToStringImpl(o.data, o.length, forDisplay);
            }
        });
        this.myToString.register(LobInfo.FileClobInfo.class, new Converter<LobInfo.FileClobInfo, String>(){

            @Override
            public String convert(LobInfo.FileClobInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return CharOut.Util.newSink().append(ExtractorsUtil.getPresentableSize(o.length)).append(" [").append(o.file.getPath()).append("]").toString();
            }
        });
        this.myToString.register(Blob.class, new Converter<Blob, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String convert(Blob o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                try {
                    long length = o.length();
                    int trimmed = ObjectFormatter.trimToMax(length);
                    String string = ObjectFormatter.this.bytesToStringImpl(o.getBytes(1L, trimmed), length, dialect, forDisplay);
                    return string;
                }
                catch (Exception e) {
                    String string = e.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Blob)o);
                }
            }
        });
        this.myToString.register(LobInfo.BlobInfo.class, new Converter<LobInfo.BlobInfo, String>(){

            @Override
            public String convert(LobInfo.BlobInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (o.isTruncated() && o.data == null) {
                    return ObjectFormatter.getValueNotLoadedString(column, dialect, o.length);
                }
                return ObjectFormatter.this.bytesToStringImpl(o.data, o.length, dialect, forDisplay);
            }
        });
        this.myToString.register(LobInfo.FileBlobInfo.class, new Converter<LobInfo.FileBlobInfo, String>(){

            @Override
            public String convert(LobInfo.FileBlobInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return CharOut.Util.newSink().append(ExtractorsUtil.getPresentableSize(o.length)).append(" [").append(o.file.getPath()).append("]").toString();
            }
        });
        this.myToString.register(Timestamp.class, new Converter<Timestamp, String>(){

            @Override
            public String convert(Timestamp o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.dateToString(ObjectFormatter.this.getTimestampFormat(column, dialect), o, dialect, column);
            }
        });
        this.myToString.register(Time.class, new Converter<Time, String>(){

            @Override
            public String convert(Time o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.this.getTimeFormat().format(o);
            }
        });
        this.myToString.register(Date.class, new Converter<Date, String>(){

            @Override
            public String convert(Date o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                Formatter format = column == null || column.clazz == null ? ObjectFormatter.this.getDateFormat(column, dialect) : (column.clazz.endsWith("Timestamp") ? ObjectFormatter.this.getTimestampFormat(column, dialect) : (column.clazz.endsWith("Time") ? ObjectFormatter.this.getTimeFormat() : ObjectFormatter.this.getDateFormat(column, dialect)));
                return ObjectFormatter.dateToString(format, o, dialect, column);
            }
        });
        this.myToString.register(BigInteger.class, new Converter<BigInteger, String>(){

            @Override
            public String convert(BigInteger o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.this.getBigIntFormat().format(o);
            }
        });
        this.myToString.register(Number.class, new Converter<Number, String>(){

            @Override
            public String convert(Number o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.this.getDecimalFormat(column).format(o);
            }
        });
        this.myToString.register(ImageInfo.class, new Converter<ImageInfo, String>(){

            @Override
            public String convert(ImageInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (!forDisplay && o.bytes != null) {
                    return ObjectFormatter.this.bytesToStringImpl(o.bytes, o.size, dialect, false);
                }
                return o.width + "x" + o.height + " " + StringUtil.toUpperCase((String)o.format) + " image " + ExtractorsUtil.getPresentableSize(o.size);
            }
        });
        this.myToString.register(TextInfo.class, new Converter<TextInfo, String>(){

            @Override
            public String convert(TextInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return forDisplay ? o.text : ObjectFormatter.bytesToString(o.bytes, dialect, false);
            }
        });
        this.myToString.register(Map.class, new Converter<Map, String>(){

            @Override
            public String convert(Map o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.isHstore(column) ? ObjectFormatter.hstoreToString(o, forDisplay) : null;
            }
        });
        this.myToString.register(Boolean.class, new Converter<Boolean, String>(){

            @Override
            public String convert(Boolean o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (forDisplay) {
                    return String.valueOf(o);
                }
                DatabaseFamilyId familyId = dialect.getFamilyId();
                if (familyId.isTransactSql()) {
                    return o != false ? "1" : "0";
                }
                return String.valueOf(o);
            }
        });
        this.myToString.register(TimeZonedTimestamp.class, new Converter<TimeZonedTimestamp, String>(){

            @Override
            public String convert(TimeZonedTimestamp o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.dateToString(ObjectFormatter.this.getShortZonedTimestampFormat(column, dialect), o, dialect, column);
            }
        });
        this.myToString.register(TimeZonedTime.class, new Converter<TimeZonedTime, String>(){

            @Override
            public String convert(TimeZonedTime o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.this.getShortZonedTimeFormat().format(o);
            }
        });
        this.myToString.register(ZonedValue.class, new Converter<ZonedValue, String>(){

            @Override
            public String convert(ZonedValue o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (forDisplay) {
                    Object object = ObjectFormatter.objectToObject(o, column);
                    return ObjectFormatter.this.objectToString(object, column, dialect, true);
                }
                return o.getStringRepresentation();
            }
        });
    }

    private static boolean isOracleGUID(byte[] o, DataConsumer.Column column, DatabaseDialect dialect) {
        return dialect.getFamilyId().isOracle() && o != null && o.length == 16 && "RAW".equals(column.typeName);
    }

    public static boolean isHstore(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(0);
        }
        return "hstore".equals(column.typeName) && "java.util.Map".equals(column.clazz);
    }

    public static boolean isJson(@NotNull DataConsumer.Column column, DatabaseFamilyId family) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(1);
        }
        return (family.isMysql() || family.isPostgres()) && StringUtil.findIgnoreCase((String)column.typeName, (String[])new String[]{"json", "jsonb"});
    }

    public static boolean isPostgresArray(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(2);
        }
        return column.type == 2003;
    }

    public static boolean isBinaryTextColumn(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(3);
        }
        return StringUtil.equals((CharSequence)"bytea", (CharSequence)column.typeName);
    }

    public static boolean isPostgresRangeType(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(4);
        }
        return StringUtil.findIgnoreCase((String)column.typeName, (String[])new String[]{"int4range", "int8range", "numrange", "tsrange", "tstzrange", "daterange"});
    }

    private static String hstoreToString(Map<String, String> hstore, boolean forDisplay) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : hstore.entrySet()) {
            if (!first) {
                sb.append(',');
                sb.append(forDisplay ? (char)'\n' : ' ');
            }
            ObjectFormatter.appendHstoreValue(sb, entry.getKey(), !forDisplay, false);
            sb.append(" => ");
            ObjectFormatter.appendHstoreValue(sb, StringUtil.notNullize((String)entry.getValue(), (String)"null"), !forDisplay, false);
            first = false;
        }
        return sb.toString();
    }

    public static void appendHstoreValue(StringBuilder sb, String value, boolean escape, boolean forceQuotation) {
        boolean requiresQuotation;
        boolean bl = requiresQuotation = forceQuotation || PG_HSTORE_REQUIRES_QUOTATION.matcher(value).find();
        if (requiresQuotation) {
            sb.append('\"');
        }
        sb.append(escape ? StringUtil.escapeQuotes((String)value) : value);
        if (requiresQuotation) {
            sb.append('\"');
        }
    }

    private static String dateToString(@NotNull Formatter formatter, @NotNull Object value, @Nullable DatabaseDialect dialect, @Nullable DataConsumer.Column column) {
        if (formatter == null) {
            ObjectFormatter.$$$reportNull$$$0(5);
        }
        if (value == null) {
            ObjectFormatter.$$$reportNull$$$0(6);
        }
        String boundaryString = BoundaryValueResolver.getInfinityString(dialect == null ? null : dialect.getFamilyId(), column, value);
        return boundaryString == null ? formatter.format(value) : boundaryString;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static String charToStringImpl(@NotNull String text2, long wholeLength, boolean bl) {
        void forDisplay;
        if (text2 == null) {
            ObjectFormatter.$$$reportNull$$$0(7);
        }
        String string = forDisplay == false || (long)text2.length() == wholeLength ? text2 : ObjectFormatter.valueToString(text2, text2.length(), wholeLength);
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(8);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String bytesToStringImpl(@NotNull byte[] o, long wholeLength, DatabaseDialect dialect, boolean bl) {
        void forDisplay;
        String stringValue;
        if (o == null) {
            ObjectFormatter.$$$reportNull$$$0(9);
        }
        boolean truncated = wholeLength != (long)o.length;
        boolean wholeValueLoaded = !truncated && o.length < DatabaseSettings.getSettings().getMaxLobLength();
        String string = stringValue = wholeValueLoaded || forDisplay != false ? ObjectFormatter.tryDecodeString(o, CharsetToolkit.UTF8_CHARSET) : null;
        if (wholeValueLoaded && stringValue != null) {
            String string2 = stringValue;
            if (string2 == null) {
                ObjectFormatter.$$$reportNull$$$0(10);
            }
            return string2;
        }
        if (forDisplay != false) {
            stringValue = stringValue != null ? stringValue : ObjectFormatter.bytesToString(o, dialect, true);
            String string3 = ObjectFormatter.valueToString(stringValue, o.length, wholeLength);
            if (string3 == null) {
                ObjectFormatter.$$$reportNull$$$0(11);
            }
            return string3;
        }
        String string4 = ObjectFormatter.bytesToString(o, dialect, false);
        if (string4 == null) {
            ObjectFormatter.$$$reportNull$$$0(12);
        }
        return string4;
    }

    private static String getValueNotLoadedString(DataConsumer.Column column, DatabaseDialect dialect, long wholeValueSize) {
        DataType dataType = column.asDataType();
        String type = dialect != null ? dialect.getTypeName(dataType) : StringUtil.notNullize((String)column.typeName, (String)"unknown");
        return "(" + StringUtil.toUpperCase((String)type) + "):" + ExtractorsUtil.getPresentableSize(wholeValueSize);
    }

    private static String valueToString(String value, long loadedLength, long wholeLength) {
        boolean truncated = wholeLength != loadedLength;
        CharOut out = CharOut.Util.newSink();
        out.append(ExtractorsUtil.getPresentableSize(wholeLength));
        if (!truncated) {
            out.append("\n").append(value);
        } else {
            out.append(" (").append(ExtractorsUtil.getPresentableSize(loadedLength)).append(" loaded)\n").append(value).append("...");
        }
        return out.toString();
    }

    @Nullable
    public static Object objectToObject(@Nullable Object o, DataConsumer.Column column) {
        if (o == null) {
            return null;
        }
        Converter converter = (Converter)ourToObject.get(o.getClass());
        Object result2 = converter != null ? (Object)converter.convert(o, column, GenericDialect.INSTANCE, false) : null;
        return result2 != null ? result2 : ObjectFormatter.objectToObject(String.valueOf(o), column);
    }

    public static void convertRows(@NotNull List<DataConsumer.Row> rows, @Nullable List<DataConsumer.Column> columns2) {
        if (rows == null) {
            ObjectFormatter.$$$reportNull$$$0(13);
        }
        if (columns2 == null) {
            return;
        }
        for (DataConsumer.Row row : rows) {
            if (row == null || row.values.length != columns2.size()) continue;
            for (int i2 = 0; i2 < row.values.length; ++i2) {
                row.values[i2] = ObjectFormatter.objectToObject(row.values[i2], columns2.get(i2));
            }
        }
    }

    @Nullable
    @NonNls
    public String objectToString(@Nullable Object o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
        if (o == null) {
            return null;
        }
        Converter converter = (Converter)this.myToString.get(o.getClass());
        String result2 = converter != null ? (String)converter.convert(o, column, dialect, forDisplay) : null;
        result2 = result2 != null ? result2 : this.objectToString(String.valueOf(o), column, dialect, forDisplay);
        return (String)ObjectUtils.assertNotNull((Object)result2);
    }

    @Nullable
    public String getValueLiteral(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
        if (row == null) {
            ObjectFormatter.$$$reportNull$$$0(14);
        }
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(15);
        }
        Object value = column.getValue(row);
        return this.objectToString(value, column, dialect, forDisplay);
    }

    @NotNull
    public String getPlainValue(@NotNull DataConsumer.Column column, @NotNull DataConsumer.Row row, DatabaseDialect dialect) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(16);
        }
        if (row == null) {
            ObjectFormatter.$$$reportNull$$$0(17);
        }
        String string = this.getPlainValue(column.getValue(row), column, dialect);
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public String getPlainValue(@Nullable Object object, @NotNull DataConsumer.Column column, DatabaseDialect dialect) {
        String literal;
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(19);
        }
        String string = (literal = this.objectToString(object, column, dialect, true)) == null ? "null" : literal;
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    private static Object tryDetectObject(@NotNull byte[] bytes) {
        ImageInfo image;
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(21);
        }
        if ((image = ObjectFormatter.tryDetectImage(bytes)) != null) {
            return image;
        }
        TextInfo text2 = ObjectFormatter.tryDetectString(bytes);
        if (text2 != null) {
            return text2;
        }
        return null;
    }

    @Nullable
    public static TextInfo tryDetectString(@NotNull byte[] bytes) {
        String guessed;
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(22);
        }
        return (guessed = LoadTextUtil.getTextFromBytesOrNull((byte[])bytes, (int)0, (int)bytes.length)) == null ? null : new TextInfo(guessed, bytes);
    }

    @Nullable
    private static String tryDecodeString(@NotNull byte[] bytes, @NotNull Charset charset) {
        if (charset == null) {
            ObjectFormatter.$$$reportNull$$$0(23);
        }
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(24);
        }
        CharsetDecoder d = charset.newDecoder();
        d.onMalformedInput(CodingErrorAction.REPORT);
        d.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            CharBuffer buf = d.decode(ByteBuffer.wrap(bytes));
            boolean bad = false;
            int len = buf.length();
            for (int i2 = 0; !bad && i2 < len; ++i2) {
                char c = buf.charAt(i2);
                bad = c < ' ' && c != '\n' && c != '\r' && c != '\t';
            }
            if (!bad) {
                return buf.toString();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static ImageInfo tryDetectImage(final @NotNull byte[] bytes) {
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(25);
        }
        return ObjectFormatter.extractImageData(bytes, new ImageDataExtractor<ImageInfo>(){

            @Override
            public ImageInfo extract(ImageReader reader) throws Exception {
                String format = reader.getFormatName();
                int width = reader.getWidth(0);
                int height = reader.getHeight(0);
                return new ImageInfo(format, width, height, bytes.length, bytes);
            }
        });
    }

    @Nullable
    private static BufferedImage readImage(@NotNull byte[] bytes) {
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(26);
        }
        return ObjectFormatter.extractImageData(bytes, new ImageDataExtractor<BufferedImage>(){

            @Override
            public BufferedImage extract(ImageReader reader) throws Exception {
                return reader.read(0, reader.getDefaultReadParam());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T extractImageData(@NotNull byte[] bytes, @NotNull ImageDataExtractor<T> dataExtractor) {
        if (dataExtractor == null) {
            ObjectFormatter.$$$reportNull$$$0(27);
        }
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(28);
        }
        if (bytes.length < 100) {
            return null;
        }
        try {
            ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
            Iterator<ImageReader> readers = stream != null ? ImageIO.getImageReaders(stream) : ContainerUtil.emptyIterator();
            ImageReader reader = readers.hasNext() ? readers.next() : null;
            try {
                if (reader == null) return null;
                reader.setInput(stream, true, true);
                T t = dataExtractor.extract(reader);
                return t;
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Formatter getTimeFormat() {
        this.initFormats();
        return this.myTimeFormat;
    }

    public Formatter getZonedTimeFormat() {
        this.initFormats();
        return this.myZonedTimeFormat;
    }

    public Formatter getShortZonedTimeFormat() {
        this.initFormats();
        return this.myShortZonedTimeFormat;
    }

    public Formatter getShortZonedTimestampFormat(DataConsumer.Column column, DatabaseDialect dialect) {
        if (this.myShortZonedTimestampFormat == null) {
            int scale = ObjectFormatter.calculateScale(column, dialect);
            this.myShortZonedTimestampFormat = FormatterCreator.newShortEraZonedTimestampFormat(scale);
        }
        return this.myShortZonedTimestampFormat;
    }

    public Formatter getTimestampFormat(@NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        Formatter format;
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(29);
        }
        if (dialect == null) {
            ObjectFormatter.$$$reportNull$$$0(30);
        }
        if ((format = this.myFormatCache.get(column)) != null) {
            return format;
        }
        Formatter result2 = ObjectFormatter.newTimestampFormat(column, dialect);
        this.myFormatCache.putIfAbsent(column, result2);
        return result2;
    }

    public CompositeFormatter getZonedTimestampFormat(@NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        Formatter format;
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(31);
        }
        if (dialect == null) {
            ObjectFormatter.$$$reportNull$$$0(32);
        }
        if ((format = this.myFormatCache.get(column)) instanceof CompositeFormatter) {
            return (CompositeFormatter)format;
        }
        CompositeFormatter result2 = FormatterCreator.newZonedTimestampFormat(dialect.getFamilyId(), column, ObjectFormatter.calculateScale(column, dialect));
        this.myFormatCache.putIfAbsent(column, result2);
        return result2;
    }

    public Formatter getDateFormat(@Nullable DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            ObjectFormatter.$$$reportNull$$$0(33);
        }
        if (this.myDateFormat != null) {
            return this.myDateFormat;
        }
        this.myDateFormat = ObjectFormatter.newDateFormat(column, dialect);
        return this.myDateFormat;
    }

    @NotNull
    private static Formatter newTimestampFormat(@NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(34);
        }
        if (dialect == null) {
            ObjectFormatter.$$$reportNull$$$0(35);
        }
        Formatter formatter = FormatterCreator.supportsEra(dialect.getFamilyId()) ? FormatterCreator.newEraTimestampFormat(dialect.getFamilyId(), column, ObjectFormatter.calculateScale(column, dialect)) : FormatterCreator.newTimestampFormat(ObjectFormatter.calculateScale(column, dialect));
        if (formatter == null) {
            ObjectFormatter.$$$reportNull$$$0(36);
        }
        return formatter;
    }

    @NotNull
    private static Formatter newDateFormat(@Nullable DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            ObjectFormatter.$$$reportNull$$$0(37);
        }
        Formatter formatter = FormatterCreator.supportsEra(dialect.getFamilyId()) ? FormatterCreator.newEraDateFormatter(dialect.getFamilyId(), column) : FormatterCreator.newDateFormatter();
        if (formatter == null) {
            ObjectFormatter.$$$reportNull$$$0(38);
        }
        return formatter;
    }

    @NotNull
    private static String bitsToString(@NotNull BitString string, @NotNull DataConsumer.Column column) {
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(39);
        }
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(40);
        }
        long length = string.getLength();
        byte[] bytes = string.getBytes();
        StringBuilder sb = new StringBuilder();
        int j = 0;
        while ((long)j < length) {
            byte b = bytes[j / 8];
            sb.append((b & 128 >>> j % 8) != 0 ? (char)'1' : '0');
            ++j;
        }
        while (sb.length() > column.precision && sb.length() > 0 && sb.charAt(0) == '0') {
            sb.delete(0, 1);
        }
        String string2 = sb.toString();
        if (string2 == null) {
            ObjectFormatter.$$$reportNull$$$0(41);
        }
        return string2;
    }

    private static int calculateScale(@NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(42);
        }
        if (dialect == null) {
            ObjectFormatter.$$$reportNull$$$0(43);
        }
        int scale = column.scale;
        if (dialect.getFamilyId().isMysql() && column.type == 93 && (StringUtil.equalsIgnoreCase((CharSequence)"datetime", (CharSequence)column.typeName) || StringUtil.equalsIgnoreCase((CharSequence)"timestamp", (CharSequence)column.typeName))) {
            scale = column.precision - 20;
        }
        return Math.min(9, Math.max(0, scale));
    }

    public NumberFormatter getDecimalFormat(@NotNull DataConsumer.Column column) {
        Formatter format;
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(44);
        }
        if ((format = this.myFormatCache.get(column)) instanceof NumberFormatter) {
            return (NumberFormatter)format;
        }
        NumberFormatter result2 = ObjectFormatter.isFloat(column) ? FormatterCreator.newFloatFormat() : FormatterCreator.newDecimalFormat();
        int fractionDigits = column.scale;
        result2.setParseBigDecimal(BigDecimal.class.getName().equals(column.clazz));
        result2.setMinimumFractionDigits(ObjectFormatter.isFloatingPoint(column) || ObjectFormatter.isH2DecimalWithUnspecifiedPrecision(column) ? 0 : fractionDigits);
        result2.setMaximumFractionDigits(340);
        this.myFormatCache.putIfAbsent(column, result2);
        return result2;
    }

    @Nullable
    public static Object unwrap(@Nullable Object o) {
        if (o instanceof LobInfo.ClobInfo) {
            return ((LobInfo.ClobInfo)o).data;
        }
        if (o instanceof LobInfo.BlobInfo) {
            return ((LobInfo.BlobInfo)o).data;
        }
        if (o instanceof TextInfo) {
            return ((TextInfo)o).bytes;
        }
        if (o instanceof ImageInfo) {
            return ((ImageInfo)o).bytes;
        }
        return o;
    }

    @Nullable
    public static Boolean getBooleanValue(@Nullable Object value) {
        return value instanceof Boolean ? (Boolean)value : (value instanceof Number ? Boolean.valueOf(((Number)value).intValue() == 1) : (value instanceof String ? ObjectFormatter.parseBoolean((String)value) : null));
    }

    @Nullable
    private static Boolean parseBoolean(@NotNull String value) {
        if (value == null) {
            ObjectFormatter.$$$reportNull$$$0(45);
        }
        return StringUtil.findIgnoreCase((String)value, (String[])new String[]{"1", "true"}) ? Boolean.TRUE : (StringUtil.findIgnoreCase((String)value, (String[])new String[]{"0", "false"}) ? Boolean.FALSE : null);
    }

    public static boolean isFloatingPoint(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(46);
        }
        return ObjectFormatter.isFloat(column) || ObjectFormatter.isDouble(column);
    }

    public static boolean isBooleanColumn(@NotNull DataConsumer.Column column) {
        int type;
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(47);
        }
        return (type = ExtractorsUtil.guessJdbcType(column)) == 16 || (ObjectFormatter.isBit(column.typeName, type) || "java.lang.Boolean".equals(column.clazz)) && column.precision <= 1;
    }

    public static boolean isNumericColumn(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(48);
        }
        int type = ExtractorsUtil.guessJdbcType(column);
        return ArrayUtil.contains((Object)type, (Object[])new Integer[]{4, 5, -6, -5, 7, 6, 8, 3, 2}) || ObjectFormatter.isFloatingPoint(column);
    }

    public static boolean isBitString(@NotNull DataConsumer.Column c) {
        if (c == null) {
            ObjectFormatter.$$$reportNull$$$0(49);
        }
        return c.precision > 1 && ObjectFormatter.isBit(c.typeName, c.type);
    }

    private static boolean isBit(@NotNull String typeName, int jdbcType) {
        if (typeName == null) {
            ObjectFormatter.$$$reportNull$$$0(50);
        }
        return jdbcType == -7 || StringUtil.findIgnoreCase((String)typeName, (String[])new String[]{"bit", "bit varying", "varbit"});
    }

    private static boolean isFloat(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(51);
        }
        return Float.class.getName().equals(column.clazz) || "oracle.sql.BINARY_FLOAT".equals(column.clazz);
    }

    private static boolean isDouble(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(52);
        }
        return Double.class.getName().equals(column.clazz) || "oracle.sql.BINARY_DOUBLE".equals(column.clazz);
    }

    private static boolean isH2DecimalWithUnspecifiedPrecision(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(53);
        }
        return "DECIMAL".equals(column.typeName) && 65535 == column.precision && Short.MAX_VALUE == column.scale;
    }

    @NotNull
    private static String bytesToString(@NotNull byte[] bytes, DatabaseDialect dialect, boolean forDisplay) {
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(54);
        }
        if (forDisplay) {
            String string = DialectUtils.toPresentableHexString(bytes);
            if (string == null) {
                ObjectFormatter.$$$reportNull$$$0(55);
            }
            return string;
        }
        String string = dialect.getBinaryLiteralString(bytes);
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(56);
        }
        return string;
    }

    private void initFormats() {
        if (this.myTimeFormat != null) {
            return;
        }
        this.myTimeFormat = FormatterCreator.newTimeFormat();
        this.myZonedTimeFormat = FormatterCreator.newZonedTimeFormat();
        this.myShortZonedTimeFormat = FormatterCreator.newShortZonedTimeFormat();
        this.myNumberFormat = FormatterCreator.newDecimalFormat();
        this.myNumberFormat.setParseIntegerOnly(true);
        this.myBigIntFormat = FormatterCreator.newDecimalFormat();
        this.myBigIntFormat.setParseIntegerOnly(true);
        this.myBigIntFormat.setParseBigDecimal(true);
    }

    @NotNull
    public Formatter getNumberFormat() {
        this.initFormats();
        NumberFormatter numberFormatter = this.myNumberFormat;
        if (numberFormatter == null) {
            ObjectFormatter.$$$reportNull$$$0(57);
        }
        return numberFormatter;
    }

    @NotNull
    public Formatter getBigIntFormat() {
        this.initFormats();
        NumberFormatter numberFormatter = this.myBigIntFormat;
        if (numberFormatter == null) {
            ObjectFormatter.$$$reportNull$$$0(58);
        }
        return numberFormatter;
    }

    private static int trimToMax(long length) {
        int maxLobLength = DatabaseSettings.getSettings().getMaxLobLength();
        return (long)maxLobLength < length ? maxLobLength : (int)length;
    }

    static {
        Converter<Object, Object> identity = new Converter<Object, Object>(){

            @Override
            public Object convert(Object o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return o;
            }
        };
        ourToObject.put(Object[].class, identity);
        ourToObject.put(TimeZonedValue.class, identity);
        ourToObject.put(LobInfo.ClobInfo.class, identity);
        ourToObject.register(LobInfo.BlobInfo.class, new Converter<LobInfo.BlobInfo, Object>(){

            @Override
            public Object convert(LobInfo.BlobInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (o.isTruncated()) {
                    return o;
                }
                Object detectedObject = ObjectFormatter.tryDetectObject(o.data);
                return ObjectUtils.chooseNotNull((Object)detectedObject, (Object)o);
            }
        });
        ourToObject.put(Boolean.class, identity);
        ourToObject.put(Number.class, identity);
        ourToObject.put(Timestamp.class, identity);
        ourToObject.put(Time.class, identity);
        ourToObject.register(ZonedValue.class, new Converter<ZonedValue, Object>(){

            @Override
            public Object convert(ZonedValue o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                String stringValue = o.getStringRepresentation();
                ParsePosition position = new ParsePosition(0);
                return ObjectUtils.notNull((Object)(DbImplUtil.isZonedTimeColumn(column, PostgresDialect.INSTANCE) ? FormatterCreator.newZonedTimeFormat().parse(stringValue, position) : FormatterCreator.newZonedTimestampFormat(DatabaseFamilyId.POSTGRES, column, ObjectFormatter.calculateScale(column, dialect)).parse(stringValue, position)), (Object)stringValue);
            }
        });
        ourToObject.register(BitString.class, new Converter<BitString, Object>(){

            @Override
            public Object convert(BitString o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.bitsToString(o, column);
            }
        });
        ourToObject.register(Date.class, new Converter<Date, Object>(){

            @Override
            public Object convert(Date o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (column != null && column.clazz != null && column.clazz.endsWith("Timestamp")) {
                    return new Timestamp(o.getTime());
                }
                if (column != null && column.clazz != null && column.clazz.endsWith("Time")) {
                    return new Time(o.getTime());
                }
                return o;
            }
        });
        ourToObject.register(byte[].class, new Converter<byte[], Object>(){

            @Override
            public Object convert(byte[] o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                Object detectedObject = ObjectFormatter.tryDetectObject(o);
                return detectedObject != null ? detectedObject : LobInfo.fromByteArray((byte[])o, (int)DatabaseSettings.getSettings().getMaxLobLength());
            }
        });
        ourToObject.register(Clob.class, new Converter<Clob, Object>(){

            @Override
            public Object convert(Clob o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                try {
                    return LobInfo.fromClob((Clob)o, (int)DatabaseSettings.getSettings().getMaxLobLength());
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        ourToObject.register(Blob.class, new Converter<Blob, Object>(){

            @Override
            public Object convert(Blob o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                try {
                    return LobInfo.fromBlob((Blob)o, (int)DatabaseSettings.getSettings().getMaxLobLength());
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        ourToObject.register(String.class, new Converter<String, Object>(){

            @Override
            public Object convert(String o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return LobInfo.fromString((String)o, (int)DatabaseSettings.getSettings().getMaxLobLength());
            }
        });
        ourToObject.register(Map.class, new Converter<Map, Object>(){

            @Override
            public Object convert(Map o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.isHstore(column) ? o : null;
            }
        });
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            ourToObject.register(ReservedCellValue.class, new Converter<ReservedCellValue, Object>(){

                @Override
                public Object convert(ReservedCellValue o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                    return o;
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 20: 
            case 36: 
            case 38: 
            case 41: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 20: 
            case 36: 
            case 38: 
            case 41: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 6: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 20: 
            case 36: 
            case 38: 
            case 41: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/ObjectFormatter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataExtractor";
                break;
            }
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/ObjectFormatter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "charToStringImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "bytesToStringImpl";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainValue";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "newTimestampFormat";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "newDateFormat";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "bitsToString";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "bytesToString";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumberFormat";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getBigIntFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isHstore";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isJson";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresArray";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryTextColumn";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresRangeType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dateToString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "charToStringImpl";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 20: 
            case 36: 
            case 38: 
            case 41: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bytesToStringImpl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertRows";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getValueLiteral";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPlainValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectObject";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectString";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "tryDecodeString";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectImage";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "readImage";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "extractImageData";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTimestampFormat";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getZonedTimestampFormat";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDateFormat";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "newTimestampFormat";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "newDateFormat";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "bitsToString";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "calculateScale";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getDecimalFormat";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "parseBoolean";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isFloatingPoint";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanColumn";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isNumericColumn";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isBitString";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isBit";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isFloat";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isDouble";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isH2DecimalWithUnspecifiedPrecision";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "bytesToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 20: 
            case 36: 
            case 38: 
            case 41: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TextInfo {
        public final String text;
        public final byte[] bytes;

        public TextInfo(@NotNull String text2, @NotNull byte[] bytes) {
            if (text2 == null) {
                TextInfo.$$$reportNull$$$0(0);
            }
            if (bytes == null) {
                TextInfo.$$$reportNull$$$0(1);
            }
            this.text = text2;
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextInfo info = (TextInfo)o;
            if (!this.text.equals(info.text)) {
                return false;
            }
            return Arrays.equals(this.bytes, info.bytes);
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.bytes);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bytes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/extractors/ObjectFormatter$TextInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ImageInfo {
        public final String format;
        public final int width;
        public final int height;
        public final int size;
        public final byte[] bytes;

        public ImageInfo(@NotNull String format, int width, int height, int size, @Nullable byte[] bytes) {
            if (format == null) {
                ImageInfo.$$$reportNull$$$0(0);
            }
            this.format = format;
            this.width = width;
            this.height = height;
            this.size = size;
            this.bytes = bytes;
        }

        @Nullable
        public BufferedImage createImage() {
            return this.bytes != null ? ObjectFormatter.readImage(this.bytes) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageInfo info = (ImageInfo)o;
            if (this.width != info.width) {
                return false;
            }
            if (this.height != info.height) {
                return false;
            }
            if (this.size != info.size) {
                return false;
            }
            if (!this.format.equals(info.format)) {
                return false;
            }
            return Arrays.equals(this.bytes, info.bytes);
        }

        public int hashCode() {
            int result2 = this.format.hashCode();
            result2 = 31 * result2 + this.width;
            result2 = 31 * result2 + this.height;
            result2 = 31 * result2 + this.size;
            result2 = 31 * result2 + (this.bytes != null ? Arrays.hashCode(this.bytes) : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/extractors/ObjectFormatter$ImageInfo", "<init>"));
        }
    }

    private static abstract class ImageDataExtractor<T> {
        private ImageDataExtractor() {
        }

        public abstract T extract(ImageReader var1) throws Exception;
    }

    private static class MyMap<T>
    extends ConcurrentClassMap<Converter<Object, T>> {
        private MyMap() {
        }

        public <X> void register(@NotNull Class<X> aClass, Converter<X, T> value) {
            if (aClass == null) {
                MyMap.$$$reportNull$$$0(0);
            }
            super.put(aClass, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/database/extractors/ObjectFormatter$MyMap", "register"));
        }
    }

    static interface Converter<X, V> {
        public V convert(X var1, DataConsumer.Column var2, DatabaseDialect var3, boolean var4);
    }
}

