/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.ExasolIntroQueries;
import com.intellij.database.introspection.ExasolIntrospector;
import com.intellij.database.introspection.GenericIntrospectorHelper;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.introspection.jdbcMetadataWrappers.TableColumnIt;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.exasol.ExasolDatabase;
import com.intellij.database.model.exasol.ExasolModConnection;
import com.intellij.database.model.exasol.ExasolModConstraint;
import com.intellij.database.model.exasol.ExasolModDatabase;
import com.intellij.database.model.exasol.ExasolModForeignKey;
import com.intellij.database.model.exasol.ExasolModKey;
import com.intellij.database.model.exasol.ExasolModModel;
import com.intellij.database.model.exasol.ExasolModRole;
import com.intellij.database.model.exasol.ExasolModRoot;
import com.intellij.database.model.exasol.ExasolModRoutine;
import com.intellij.database.model.exasol.ExasolModSchema;
import com.intellij.database.model.exasol.ExasolModScript;
import com.intellij.database.model.exasol.ExasolModTable;
import com.intellij.database.model.exasol.ExasolModTableColumn;
import com.intellij.database.model.exasol.ExasolModUser;
import com.intellij.database.model.exasol.ExasolModView;
import com.intellij.database.model.exasol.ExasolRoot;
import com.intellij.database.model.exasol.ExasolSchema;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.ExasolScriptType;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.database.SqlLanguageObjectBuilder;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.script.SqlReader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringKt;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Exasol;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.sql.SqlQuery;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0001:\u0003GHIB\u0005\u00a2\u0006\u0002\u0010\tJ3\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001d0\u001cH\u0082\bJ(\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00192\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002JF\u0010$\u001a00%R,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u0007H\u0014J\b\u0010(\u001a\u00020\u0016H\u0014J \u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020'2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,H\u0014J\u0010\u0010.\u001a\u00020\u00162\u0006\u0010*\u001a\u00020'H\u0002J!\u0010/\u001a\u00020\u00162\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020201\"\u000202H\u0016\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u00020\u00162\u0006\u0010*\u001a\u00020'H\u0014J\u0018\u00105\u001a\u00020\u00162\u0006\u0010*\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0010\u00106\u001a\u00020\u00162\u0006\u0010*\u001a\u00020'H\u0002J\u0010\u00107\u001a\u00020\u00162\u0006\u0010*\u001a\u00020'H\u0002J\u0010\u00108\u001a\u00020\u00162\u0006\u0010*\u001a\u00020'H\u0002J\u001e\u00109\u001a\u00020\u00162\u0006\u0010*\u001a\u00020'2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u0019H\u0002J\u0010\u0010:\u001a\u00020\u00162\u0006\u0010*\u001a\u00020'H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020#H\u0002J&\u0010>\u001a\f\u0012\u0006\b\u0001\u0012\u00020@\u0018\u00010?*\u00020\b2\u0006\u0010A\u001a\u00020<2\u0006\u0010=\u001a\u00020#H\u0002JU\u0010B\u001a\u00020\u0016\"\u0004\b\u0000\u0010C*\b\u0012\u0004\u0012\u0002HC0\u00192\u0018\u0010D\u001a\u0014\u0012\u0004\u0012\u0002HC\u0012\u0004\u0012\u0002HC\u0012\u0004\u0012\u00020<0E2 \b\u0004\u0010F\u001a\u001a\u0012\u0004\u0012\u0002HC\u0012\n\u0012\b\u0012\u0004\u0012\u0002HC0\u0019\u0012\u0004\u0012\u00020\u00160EH\u0082\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/intellij/database/introspection/ExasolIntrospector;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/exasol/ExasolModModel;", "Lcom/intellij/database/model/exasol/ExasolRoot;", "Lcom/intellij/database/model/exasol/ExasolModRoot;", "Lcom/intellij/database/model/exasol/ExasolDatabase;", "Lcom/intellij/database/model/exasol/ExasolModDatabase;", "Lcom/intellij/database/model/exasol/ExasolSchema;", "Lcom/intellij/database/model/exasol/ExasolModSchema;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SURROGATE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "myBuilder", "Lcom/intellij/sql/database/SqlObjectBuilder;", "myLanguage", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "myReader", "Lcom/intellij/sql/script/SqlReader;", "applyObjects", "", "schema", "objects", "", "Lcom/intellij/database/introspection/ExasolIntroQueries$ObjectInfo;", "o2id", "Lkotlin/Function1;", "", "applySchemas", "db", "schemas", "Lcom/intellij/database/introspection/ExasolIntroQueries$SchemaInfo;", "opened", "", "createSchemaRetriever", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractSchemaRetriever;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "initConnectionRelatedState", "introspectAutoInTran", "tran", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "introspectConnections", "introspectDatabaseSchemas", "databases", "", "Lcom/intellij/database/model/basic/BasicDatabase;", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "introspectNamespacesInTran", "introspectOneSchema", "introspectPrivileges", "introspectRoles", "introspectRootObjects", "introspectSchemasAuto", "introspectUsers", "isSystemSchema", "", "name", "columns", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "Lcom/intellij/database/model/basic/BasicModTableOrViewColumn;", "isTable", "groupedForEach", "T", "breaker", "Lkotlin/Function2;", "groupConsumer", "ExaSchemaRetriever", "ExaSysSchemaRetriever", "VERSION", "database-introspection"})
public final class ExasolIntrospector
extends BaseIntrospector<ExasolModModel, ExasolRoot, ExasolModRoot, ExasolDatabase, ExasolModDatabase, ExasolSchema, ExasolModSchema> {
    private final Logger LOG;
    private final SqlReader myReader;
    private final SqlLanguageDialect myLanguage;
    private final SqlObjectBuilder myBuilder;
    private final Pattern SURROGATE_PATTERN;

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 6, this.queryParameters);
    }

    @Override
    protected void introspectAutoInTran(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces) {
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        if (namespaces == null || namespaces.isEmpty()) {
            this.introspectNamespacesInTran(tran);
            NamingFamily<? extends ExasolDatabase> namingFamily = ((ExasolModModel)this.getModel()).getRoot().getDatabases();
            Intrinsics.checkExpressionValueIsNotNull(namingFamily, (String)"model.root.databases");
            iterable = namingFamily;
        } else {
            iterable = namespaces;
        }
        Iterable toProcess = iterable;
        ArrayList schemas = ContainerUtil.newArrayList();
        for (BasicNamespace namespace : toProcess) {
            if (namespace instanceof ExasolModSchema) {
                schemas.add(namespace);
                continue;
            }
            if (!(namespace instanceof ExasolModDatabase)) continue;
            Iterable $receiver$iv = ((ExasolModDatabase)namespace).getSchemas();
            for (Object element$iv : $receiver$iv) {
                ExasolModSchema it = (ExasolModSchema)element$iv;
                if (!it.isVisible()) continue;
                ((Collection)schemas).add(element$iv);
            }
        }
        this.introspectRootObjects(tran);
        ArrayList arrayList = schemas;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"schemas");
        this.introspectSchemasAuto(tran, arrayList);
    }

    private final void introspectRootObjects(DBTransaction tran) {
        this.introspectPrivileges(tran);
        this.introspectConnections(tran);
        this.introspectUsers(tran);
        this.introspectRoles(tran);
    }

    private final void introspectPrivileges(DBTransaction tran) {
        List privileges = (List)tran.query(ExasolIntroQueries.QUERIES.retrievePrivileges).run();
        this.queryParameters.put("SEL_ANY_DICT", privileges.contains("SELECT ANY DICTIONARY"));
    }

    private final void introspectConnections(DBTransaction tran) {
        SqlQuery<List<ExasolIntroQueries.ConnectionInfo>> sqlQuery = ExasolIntroQueries.QUERIES.retrieveConnections;
        Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"QUERIES.retrieveConnections");
        List<ExasolIntroQueries.ConnectionInfo> connections = this.performQuery(tran, sqlQuery);
        ((ExasolModModel)this.getModel()).modify(ExasolModRoot.class, new ModelModifier<ExasolModRoot>(connections){
            final /* synthetic */ List $connections;

            public final void perform(ExasolModRoot it) {
                NamingFamily namingFamily;
                NamingFamily $receiver = namingFamily = it.getConnections();
                $receiver.markChildrenAsSyncPending();
                for (ExasolIntroQueries.ConnectionInfo connection : this.$connections) {
                    E e = $receiver.createOrGet(connection.name);
                    ExasolModConnection $receiver2 = (ExasolModConnection)e;
                    $receiver2.setComment(connection.comment);
                    $receiver2.setConnectionString(connection.connection_string);
                    $receiver2.setUser(connection.user_name);
                }
                $receiver.removeSyncPendingChildren();
                $receiver.sort();
            }
            {
                this.$connections = list;
            }
        });
    }

    private final void introspectUsers(DBTransaction tran) {
        List users = (List)tran.query(ExasolIntroQueries.QUERIES.retrieveUsers).run();
        ((ExasolModModel)this.getModel()).modify(ExasolModRoot.class, new ModelModifier<ExasolModRoot>(users){
            final /* synthetic */ List $users;

            public final void perform(ExasolModRoot it) {
                NamingFamily namingFamily;
                NamingFamily $receiver = namingFamily = it.getUsers();
                $receiver.markChildrenAsSyncPending();
                for (ExasolIntroQueries.UserInfo user : this.$users) {
                    E e = $receiver.createOrGet(user.name);
                    ExasolModUser $receiver2 = (ExasolModUser)e;
                    $receiver2.setComment(user.comment);
                    Boolean bl = user.is_system;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"user.is_system");
                    $receiver2.setSystem(bl);
                }
                $receiver.removeSyncPendingChildren();
                $receiver.sort();
            }
            {
                this.$users = list;
            }
        });
    }

    private final void introspectRoles(DBTransaction tran) {
        List roles = (List)tran.query(ExasolIntroQueries.QUERIES.retrieveRoles).run();
        ((ExasolModModel)this.getModel()).modify(ExasolModRoot.class, new ModelModifier<ExasolModRoot>(roles){
            final /* synthetic */ List $roles;

            public final void perform(ExasolModRoot it) {
                NamingFamily namingFamily;
                NamingFamily $receiver = namingFamily = it.getRoles();
                $receiver.markChildrenAsSyncPending();
                for (ExasolIntroQueries.RoleInfo role : this.$roles) {
                    E e = $receiver.createOrGet(role.name);
                    ExasolModRole $receiver2 = (ExasolModRole)e;
                    $receiver2.setComment(role.comment);
                    Boolean bl = role.is_system;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"role.is_system");
                    $receiver2.setSystem(bl);
                }
                $receiver.removeSyncPendingChildren();
                $receiver.sort();
            }
            {
                this.$roles = list;
            }
        });
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        SqlQuery<List<ExasolIntroQueries.SchemaInfo>> sqlQuery = ExasolIntroQueries.QUERIES.retrieveAllSchemas;
        Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"QUERIES.retrieveAllSchemas");
        List<ExasolIntroQueries.SchemaInfo> schemas = this.performQuery(tran, sqlQuery);
        boolean wasEmpty = ((ExasolModModel)this.getModel()).getModelRoots().isEmpty();
        String opened = wasEmpty ? (String)tran.query(ExasolIntroQueries.QUERIES.askOpenedSchema).run() : null;
        ((ExasolModModel)this.getModel()).modify((ModelModifier<? super ExasolModRoot>)new ModelModifier<ExasolModRoot>(this, wasEmpty, schemas, opened){
            final /* synthetic */ ExasolIntrospector this$0;
            final /* synthetic */ boolean $wasEmpty;
            final /* synthetic */ List $schemas;
            final /* synthetic */ String $opened;

            public final void perform(ExasolModRoot r) {
                NamingFamily databases = r.getDatabases();
                databases.markChildrenAsSyncPending();
                ExasolModDatabase db = (ExasolModDatabase)databases.createOrGet("EXA_DB");
                db.setCurrent(true);
                if (this.$wasEmpty) {
                    db.setVisible(true);
                }
                databases.removeSyncPendingChildren();
                ExasolModDatabase exasolModDatabase = db;
                Intrinsics.checkExpressionValueIsNotNull((Object)exasolModDatabase, (String)"db");
                List list = this.$schemas;
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"schemas");
                ExasolIntrospector.access$applySchemas(this.this$0, exasolModDatabase, list, this.$opened);
            }
            {
                this.this$0 = exasolIntrospector;
                this.$wasEmpty = bl;
                this.$schemas = list;
                this.$opened = string;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private final void applySchemas(ExasolModDatabase db, List<ExasolIntroQueries.SchemaInfo> schemas, String opened) {
        dbSchemas = db.getSchemas();
        wasEmpty = dbSchemas.isEmpty();
        dbSchemas.markChildrenAsSyncPending();
        for (ExasolIntroQueries.SchemaInfo info : schemas) {
            v0 = info.id;
            if (v0 == null || v0 != 0L) ** GOTO lbl-1000
            v1 = info.name;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"info.name");
            if (this.isSystemSchema(v1)) {
                v2 = -9223372036854775808L;
            } else lbl-1000:
            // 2 sources

            {
                v2 = info.id;
            }
            v3 = id = v2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"id");
            schema = (ExasolModSchema)dbSchemas.renew(v3, info.name);
            v4 = info.is_virtual;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"info.is_virtual");
            schema.setVirtual(v4);
            schema.setComment(info.comment);
            if (!wasEmpty) continue;
            schema.setCurrent(Intrinsics.areEqual((Object)schema.getName(), (Object)opened));
            if (!schema.isCurrent()) continue;
            schema.setVisible(true);
        }
        dbSchemas.removeSyncPendingChildren();
        dbSchemas.sort();
    }

    private final boolean isSystemSchema(String name) {
        return Intrinsics.areEqual((Object)name, (Object)"SYS") || Intrinsics.areEqual((Object)name, (Object)"EXA_STATISTICS");
    }

    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        Intrinsics.checkParameterIsNotNull((Object)databases, (String)"databases");
        this.introspectNamespaces();
    }

    private final void introspectSchemasAuto(DBTransaction tran, List<? extends ExasolModSchema> schemas) {
        for (ExasolModSchema exasolModSchema : schemas) {
            this.introspectOneSchema(tran, exasolModSchema);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void introspectOneSchema(DBTransaction tran, ExasolModSchema schema) {
        void this_$iv;
        ExasolIntrospector exasolIntrospector = this;
        String operationName$iv = "Introspect schema " + schema.getName();
        try {
            BaseIntrospector.AbstractSchemaRetriever retriever = this.createSchemaRetriever(tran, schema);
            retriever.init();
            retriever.process();
        }
        catch (InterruptedException ie$iv) {
            throw (Throwable)ie$iv;
        }
        catch (DBException d$iv) {
            String message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
        }
        catch (NullPointerException npe$iv) {
            String message$iv = "NPE encountered when performing " + operationName$iv;
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
            BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv).error(message$iv, (Throwable)npe$iv);
        }
        catch (Exception e$iv) {
            String message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
        }
    }

    @Override
    @NotNull
    protected BaseIntrospector.AbstractSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull ExasolSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        String string = schema.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"schema.name");
        return this.isSystemSchema(string) ? (BaseIntrospector.AbstractSchemaRetriever)new ExaSysSchemaRetriever(transaction, schema) : (BaseIntrospector.AbstractSchemaRetriever)new ExaSchemaRetriever(transaction, schema);
    }

    /*
     * Unable to fully structure code
     */
    private final void applyObjects(ExasolModSchema schema, List<ExasolIntroQueries.ObjectInfo> objects, Function1<? super ExasolIntroQueries.ObjectInfo, Long> o2id) {
        v0 = new ModNamingIdentifyingFamily[4];
        v1 = schema.getTables();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"schema.tables");
        v0[0] = v1;
        v2 = schema.getViews();
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"schema.views");
        v0[1] = v2;
        v3 = schema.getRoutines();
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"schema.routines");
        v0[2] = v3;
        v4 = schema.getScripts();
        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"schema.scripts");
        v0[3] = v4;
        families = v0;
        $receiver$iv = families;
        for (var7_6 = 0; var7_6 < $receiver$iv.length; ++var7_6) {
            element$iv = $receiver$iv[var7_6];
            it = (ModNamingIdentifyingFamily)element$iv;
            it.markChildrenAsSyncPending();
        }
        for (ExasolIntroQueries.ObjectInfo info : objects) {
            block13: {
                block9: {
                    block10: {
                        block12: {
                            block11: {
                                v5 = element$iv = info.type;
                                if (v5 == null) break block9;
                                switch (v5.hashCode()) {
                                    case 79578030: {
                                        if (!element$iv.equals("TABLE")) ** break;
                                        break;
                                    }
                                    case -1854356277: {
                                        if (!element$iv.equals("SCRIPT")) ** break;
                                        break block10;
                                    }
                                    case 2634405: {
                                        if (!element$iv.equals("VIEW")) ** break;
                                        break block11;
                                    }
                                    case -2131401768: {
                                        if (!element$iv.equals("FUNCTION")) ** break;
                                        break block12;
                                    }
                                }
                                v6 = schema.getTables();
                                break block13;
                            }
                            v6 = schema.getViews();
                            break block13;
                        }
                        v6 = schema.getRoutines();
                        break block13;
                    }
                    v6 = schema.getScripts();
                    break block13;
                }
                v6 = null;
            }
            if (v6 == null) continue;
            it = element$iv = v6;
            obj = it.renew(((Number)o2id.invoke((Object)info)).longValue(), info.name);
            obj.setComment(info.comment);
            if (!(obj instanceof ExasolModRoutine)) continue;
            ((ExasolModRoutine)obj).setRoutineKind(DasRoutine.Kind.FUNCTION);
        }
        $receiver$iv = families;
        for (var7_8 = 0; var7_8 < $receiver$iv.length; ++var7_8) {
            element$iv = $receiver$iv[var7_8];
            it = (ModNamingIdentifyingFamily)element$iv;
            it.removeSyncPendingChildren();
            it.sort();
        }
    }

    private final ModPositioningNamingFamily<? extends BasicModTableOrViewColumn> columns(@NotNull ExasolModSchema $receiver, boolean isTable, String name) {
        PositioningNamingFamily positioningNamingFamily;
        boolean bl = isTable;
        if (bl) {
            ExasolModTable exasolModTable = (ExasolModTable)$receiver.getTables().get(name);
            positioningNamingFamily = exasolModTable != null ? exasolModTable.getColumns() : null;
        } else if (!bl) {
            ExasolModView exasolModView = (ExasolModView)$receiver.getViews().get(name);
            positioningNamingFamily = exasolModView != null ? exasolModView.getColumns() : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return positioningNamingFamily;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> void groupedForEach(@NotNull List<? extends T> $receiver, Function2<? super T, ? super T, Boolean> breaker, Function2<? super T, ? super List<? extends T>, Unit> groupConsumer) {
        if ($receiver.isEmpty()) {
            return;
        }
        int prevIdx = 0;
        T prev = $receiver.get(prevIdx);
        Iterable $receiver$iv = $receiver;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void item;
            int n = index$iv++;
            Object t = item$iv;
            int idx = n;
            if (idx == 0 || !((Boolean)breaker.invoke(prev, (Object)item)).booleanValue()) continue;
            groupConsumer.invoke(prev, $receiver.subList(prevIdx, idx));
            prevIdx = idx;
            prev = $receiver.get(prevIdx);
        }
        groupConsumer.invoke($receiver.get(prevIdx), $receiver.subList(prevIdx, $receiver.size()));
    }

    public ExasolIntrospector() {
        Rdbms rdbms = Exasol.RDBMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"Exasol.RDBMS");
        super(rdbms, ExasolModModel.class, ExasolModRoot.class, ExasolModDatabase.class, ExasolModSchema.class);
        this.LOG = Logger.getInstance(ExasolIntrospector.class);
        this.myReader = SqlPsiFacade.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).createSqlReader();
        Language language = Language.findLanguageByID((String)"Exasol");
        if (language == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.dialects.SqlLanguageDialect");
        }
        this.myLanguage = (SqlLanguageDialect)language;
        this.myBuilder = (SqlObjectBuilder)SqlLanguageObjectBuilder.INSTANCE.forLanguage((Language)this.myLanguage);
        this.SURROGATE_PATTERN = Pattern.compile("SYS_\\d+");
    }

    public static final /* synthetic */ void access$groupedForEach(ExasolIntrospector $this, @NotNull List $receiver, @NotNull Function2 breaker, @NotNull Function2 groupConsumer) {
        $this.groupedForEach($receiver, breaker, groupConsumer);
    }

    public static final /* synthetic */ void access$applyObjects(ExasolIntrospector $this, @NotNull ExasolModSchema schema, @NotNull List objects, @NotNull Function1 o2id) {
        $this.applyObjects(schema, objects, (Function1<? super ExasolIntroQueries.ObjectInfo, Long>)o2id);
    }

    public static final /* synthetic */ void access$applySchemas(ExasolIntrospector $this, @NotNull ExasolModDatabase db, @NotNull List schemas, @Nullable String opened) {
        $this.applySchemas(db, schemas, opened);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u0000200\u0001R,\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0002B\u0015\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\tH\u0002J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\t\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/introspection/ExasolIntrospector$ExaSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/exasol/ExasolModModel;", "Lcom/intellij/database/model/exasol/ExasolRoot;", "Lcom/intellij/database/model/exasol/ExasolModRoot;", "Lcom/intellij/database/model/exasol/ExasolDatabase;", "Lcom/intellij/database/model/exasol/ExasolModDatabase;", "Lcom/intellij/database/model/exasol/ExasolSchema;", "Lcom/intellij/database/model/exasol/ExasolModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/ExasolIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/exasol/ExasolSchema;)V", "parseRoutine", "Lcom/intellij/database/model/DasRoutine;", "src", "", "process", "", "refineFunctionArgumentsFromSource", "func", "Lcom/intellij/database/model/basic/BasicModRoutine;", "retrieveAllObjects", "retrieveColumns", "retrieveConstraints", "retrieveFunctionSources", "retrieveScriptSources", "retrieveViewSources", "database-introspection"})
    private final class ExaSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever {
        @Override
        public void process() {
            ExaSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ ExaSchemaRetriever this$0;
                {
                    this.this$0 = exaSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    ExasolModSchema schema2 = (ExasolModSchema)MS;
                    ExaSchemaRetriever.access$retrieveAllObjects(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ ExaSchemaRetriever this$0;
                {
                    this.this$0 = exaSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    ExasolModSchema schema2 = (ExasolModSchema)MS;
                    ExaSchemaRetriever.access$retrieveColumns(this.this$0, schema2);
                    ExaSchemaRetriever.access$retrieveConstraints(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ ExaSchemaRetriever this$0;
                {
                    this.this$0 = exaSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    ExasolModSchema schema2 = (ExasolModSchema)MS;
                    this.this$0.retrieveViewSources(schema2);
                    this.this$0.retrieveFunctionSources(schema2);
                    this.this$0.retrieveScriptSources(schema2);
                }
            });
        }

        public final void retrieveScriptSources(@NotNull ExasolModSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            SqlQuery<List<ExasolIntroQueries.ScriptInfo>> sqlQuery = ExasolIntroQueries.QUERIES.retrieveScripts;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"QUERIES.retrieveScripts");
            List<ExasolIntroQueries.ScriptInfo> infos = this.performQuery(sqlQuery);
            ExasolIntrospector this_$iv = ExasolIntrospector.this;
            this_$iv.getModel().writeSources(new Runnable(this, infos, schema){
                final /* synthetic */ ExaSchemaRetriever this$0;
                final /* synthetic */ List $infos$inlined;
                final /* synthetic */ ExasolModSchema $schema$inlined;
                {
                    this.this$0 = exaSchemaRetriever;
                    this.$infos$inlined = list;
                    this.$schema$inlined = exasolModSchema;
                }

                /*
                 * Unable to fully structure code
                 */
                public final void run() {
                    for (ExasolIntroQueries.ScriptInfo info : this.$infos$inlined) {
                        block12: {
                            block9: {
                                block10: {
                                    block11: {
                                        if ((ExasolModScript)this.$schema$inlined.getScripts().get(info.name) == null) {
                                            continue;
                                        }
                                        v0 = var4_4 = info.type;
                                        if (v0 == null) break block9;
                                        switch (v0.hashCode()) {
                                            case 83863: {
                                                if (!var4_4.equals("UDF")) ** break;
                                                break;
                                            }
                                            case -432525521: {
                                                if (!var4_4.equals("ADAPTER")) ** break;
                                                break block10;
                                            }
                                            case -1258414313: {
                                                if (!var4_4.equals("SCRIPTING")) ** break;
                                                break block11;
                                            }
                                        }
                                        v1 = ExasolScriptType.UDF;
                                        break block12;
                                    }
                                    v1 = ExasolScriptType.SCRIPTING;
                                    break block12;
                                }
                                v1 = ExasolScriptType.ADAPTER;
                                break block12;
                            }
                            v1 = ExasolScriptType.SCRIPTING;
                        }
                        script.setScriptType(v1);
                        v2 = script;
                        v3 = info.text;
                        if (v3 != null) {
                            var4_4 = v3;
                            var5_5 = v2;
                            it = var4_4;
                            var7_7 = new SimpleCompositeText(it, CompositeText.Kind.ORIGINAL_TEXT);
                            v2 = var5_5;
                            v4 = var7_7;
                        } else {
                            v4 = null;
                        }
                        v2.setSourceText(v4);
                        if (info.text == null) continue;
                        v5 = script;
                        v6 = info.text;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"info.text");
                        this.this$0.refineFunctionArgumentsFromSource(v5, v6);
                    }
                }
            });
        }

        public final void retrieveViewSources(@NotNull ExasolModSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            SqlQuery<List<ExasolIntroQueries.ViewInfo>> sqlQuery = ExasolIntroQueries.QUERIES.retrieveViews;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"QUERIES.retrieveViews");
            List<ExasolIntroQueries.ViewInfo> infos = this.performQuery(sqlQuery);
            ExasolIntrospector this_$iv = ExasolIntrospector.this;
            this_$iv.getModel().writeSources(new Runnable(infos, schema){
                final /* synthetic */ List $infos$inlined;
                final /* synthetic */ ExasolModSchema $schema$inlined;
                {
                    this.$infos$inlined = list;
                    this.$schema$inlined = exasolModSchema;
                }

                public final void run() {
                    for (ExasolIntroQueries.ViewInfo info : this.$infos$inlined) {
                        SimpleCompositeText simpleCompositeText;
                        ExasolModView view;
                        if ((ExasolModView)this.$schema$inlined.getViews().get(info.name) == null) {
                            continue;
                        }
                        ExasolModView exasolModView = view;
                        if (info.text != null) {
                            String string;
                            ExasolModView exasolModView2 = exasolModView;
                            String it = string;
                            SimpleCompositeText simpleCompositeText2 = new SimpleCompositeText(it, CompositeText.Kind.ORIGINAL_TEXT);
                            exasolModView = exasolModView2;
                            simpleCompositeText = simpleCompositeText2;
                        } else {
                            simpleCompositeText = null;
                        }
                        exasolModView.setSourceText(simpleCompositeText);
                    }
                }
            });
        }

        public final void retrieveFunctionSources(@NotNull ExasolModSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            SqlQuery<List<ExasolIntroQueries.FunctionInfo>> sqlQuery = ExasolIntroQueries.QUERIES.retrieveFunctions;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"QUERIES.retrieveFunctions");
            List<ExasolIntroQueries.FunctionInfo> infos = this.performQuery(sqlQuery);
            ExasolIntrospector this_$iv = ExasolIntrospector.this;
            this_$iv.getModel().writeSources(new Runnable(this, infos, schema){
                final /* synthetic */ ExaSchemaRetriever this$0;
                final /* synthetic */ List $infos$inlined;
                final /* synthetic */ ExasolModSchema $schema$inlined;
                {
                    this.this$0 = exaSchemaRetriever;
                    this.$infos$inlined = list;
                    this.$schema$inlined = exasolModSchema;
                }

                public final void run() {
                    for (ExasolIntroQueries.FunctionInfo info : this.$infos$inlined) {
                        SimpleCompositeText simpleCompositeText;
                        ExasolModRoutine func;
                        if ((ExasolModRoutine)this.$schema$inlined.getRoutines().get(info.name) == null) {
                            continue;
                        }
                        ExasolModRoutine exasolModRoutine = func;
                        if (info.text != null) {
                            String string;
                            ExasolModRoutine exasolModRoutine2 = exasolModRoutine;
                            String it = string;
                            SimpleCompositeText simpleCompositeText2 = new SimpleCompositeText(it, CompositeText.Kind.ORIGINAL_TEXT);
                            exasolModRoutine = exasolModRoutine2;
                            simpleCompositeText = simpleCompositeText2;
                        } else {
                            simpleCompositeText = null;
                        }
                        exasolModRoutine.setSourceText(simpleCompositeText);
                        if (info.text == null) continue;
                        this.this$0.refineFunctionArgumentsFromSource(func, "create " + info.text);
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public final void refineFunctionArgumentsFromSource(@NotNull BasicModRoutine func, @NotNull String src) {
            Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
            Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
            DasRoutine dasRoutine = this.parseRoutine(src);
            if (dasRoutine == null) {
                return;
            }
            DasRoutine psiFunc = dasRoutine;
            ExasolIntrospector.this.myBuilder.partialBuild((DasObject)func, (DasObject)psiFunc);
            Iterable $receiver$iv = psiFunc.getArguments();
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void psiArg;
                int n = index$iv++;
                DasArgument dasArgument = (DasArgument)item$iv;
                int i2 = n;
                ExasolIntrospector.this.myBuilder.partialBuild((DasObject)func.getArguments().renewAt((short)(i2 + 1), psiArg.getName()), (DasObject)psiArg);
            }
            DasArgument ret = psiFunc.getReturnArgument();
            if (Intrinsics.areEqual((Object)func.getRoutineKind(), (Object)DasRoutine.Kind.PROCEDURE) || ret == null) {
                BasicModArgument basicModArgument = (BasicModArgument)func.getReturnArgument();
                if (basicModArgument != null) {
                    basicModArgument.drop();
                }
            } else {
                ExasolIntrospector.this.myBuilder.partialBuild((DasObject)func.createOrGetReturnArgument(), (DasObject)ret);
            }
        }

        private final DasRoutine parseRoutine(String src) {
            try {
                return (DasRoutine)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)ExasolIntrospector.this.myReader.getReadOnlyPsi(ExasolIntrospector.this.myLanguage, (CharSequence)src))).expandAndSkip((Condition)parseRoutine.1.INSTANCE)).filter(DasRoutine.class).first();
            }
            catch (Exception e) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    ExasolIntrospector.this.LOG.error((Throwable)e);
                }
                ExasolIntrospector.this.LOG.warn("Failed to parse sources", (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveConstraints(ExasolModSchema schema) {
            void $receiver$iv;
            List<ExasolIntroQueries.ConstraintColumnInfo> infos;
            SqlQuery<List<ExasolIntroQueries.ConstraintColumnInfo>> sqlQuery = ExasolIntroQueries.QUERIES.retrieveConstraints;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"QUERIES.retrieveConstraints");
            List<ExasolIntroQueries.ConstraintColumnInfo> list = infos = this.performQuery(sqlQuery);
            ExasolIntrospector this_$iv = ExasolIntrospector.this;
            if (!$receiver$iv.isEmpty()) {
                String string;
                ExasolIntroQueries.ConstraintColumnInfo it;
                Collection<String> collection;
                Iterable $receiver$iv$iv;
                Collection destination$iv$iv;
                Iterable $receiver$iv2;
                ExasolModConstraint exasolModConstraint;
                List columnsInfo;
                ExasolModConstraint $receiver;
                Object e;
                boolean surrogate;
                ExasolIntroQueries.ConstraintColumnInfo constraintInfo;
                List next;
                ExasolIntroQueries.ConstraintColumnInfo prev;
                Object item$iv;
                int idx$iv;
                int index$iv$iv;
                Iterable $receiver$iv$iv2;
                Object prev$iv;
                int prevIdx$iv;
                List $receiver$iv3;
                ExasolIntrospector this_$iv2;
                List forTableInfo;
                ExasolModTable table;
                ExasolIntroQueries.ConstraintColumnInfo tableInfo;
                int prevIdx$iv2 = 0;
                Object prev$iv2 = $receiver$iv.get(prevIdx$iv2);
                Iterable $receiver$iv$iv3 = (Iterable)$receiver$iv;
                int index$iv$iv2 = 0;
                for (Object item$iv$iv : $receiver$iv$iv3) {
                    List next2;
                    void item$iv2;
                    int n = index$iv$iv2++;
                    Object t = item$iv$iv;
                    int idx$iv2 = n;
                    if (idx$iv2 == 0) continue;
                    ExasolIntroQueries.ConstraintColumnInfo constraintColumnInfo = (ExasolIntroQueries.ConstraintColumnInfo)item$iv2;
                    ExasolIntroQueries.ConstraintColumnInfo prev2 = (ExasolIntroQueries.ConstraintColumnInfo)prev$iv2;
                    if (!(Intrinsics.areEqual((Object)prev2.table_name, (Object)((ExasolIntroQueries.ConstraintColumnInfo)((Object)next2)).table_name) ^ true)) continue;
                    next2 = $receiver$iv.subList(prevIdx$iv2, idx$iv2);
                    tableInfo = (ExasolIntroQueries.ConstraintColumnInfo)prev$iv2;
                    if ((ExasolModTable)schema.getTables().get(tableInfo.table_name) == null) {
                    } else {
                        table.getKeys().markChildrenAsSyncPending();
                        table.getForeignKeys().markChildrenAsSyncPending();
                        List list2 = forTableInfo;
                        this_$iv2 = ExasolIntrospector.this;
                        if (!$receiver$iv3.isEmpty()) {
                            prevIdx$iv = 0;
                            prev$iv = $receiver$iv3.get(prevIdx$iv);
                            $receiver$iv$iv2 = $receiver$iv3;
                            index$iv$iv = 0;
                            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                                int n2 = index$iv$iv++;
                                Object t2 = item$iv$iv2;
                                idx$iv = n2;
                                if (idx$iv == 0) continue;
                                ExasolIntroQueries.ConstraintColumnInfo constraintColumnInfo2 = (ExasolIntroQueries.ConstraintColumnInfo)item$iv;
                                prev = (ExasolIntroQueries.ConstraintColumnInfo)prev$iv;
                                if (!(Intrinsics.areEqual((Object)prev.name, (Object)((ExasolIntroQueries.ConstraintColumnInfo)((Object)next)).name) ^ true)) continue;
                                next = $receiver$iv3.subList(prevIdx$iv, idx$iv);
                                constraintInfo = (ExasolIntroQueries.ConstraintColumnInfo)prev$iv;
                                CharSequence charSequence = constraintInfo.name;
                                Pattern pattern = ExasolIntrospector.this.SURROGATE_PATTERN;
                                Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"SURROGATE_PATTERN");
                                surrogate = BaseIntrospectionFunctions.matches(charSequence, pattern);
                                Boolean bl = constraintInfo.is_pk;
                                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"constraintInfo.is_pk");
                                if (bl.booleanValue()) {
                                    e = table.getKeys().createOrGet(constraintInfo.name);
                                    $receiver = (ExasolModKey)e;
                                    $receiver.setNameSurrogate(surrogate);
                                    $receiver.setPrimary(true);
                                    Iterable iterable = columnsInfo;
                                    exasolModConstraint = $receiver;
                                    Iterable iterable2 = $receiver$iv2;
                                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                                    for (Object item$iv$iv3 : $receiver$iv$iv) {
                                        ExasolIntroQueries.ConstraintColumnInfo constraintColumnInfo3 = (ExasolIntroQueries.ConstraintColumnInfo)item$iv$iv3;
                                        collection = destination$iv$iv;
                                        string = it.column_name;
                                        collection.add(string);
                                    }
                                    collection = (List)destination$iv$iv;
                                    exasolModConstraint.setColNames((List<String>)collection);
                                } else {
                                    e = table.getForeignKeys().createOrGet(constraintInfo.name);
                                    $receiver = (ExasolModForeignKey)e;
                                    $receiver.setNameSurrogate(surrogate);
                                    $receiver.setRefSchemaName(constraintInfo.ref_schema);
                                    $receiver.setRefTableName(constraintInfo.ref_table);
                                    $receiver$iv2 = columnsInfo;
                                    exasolModConstraint = $receiver;
                                    $receiver$iv$iv = $receiver$iv2;
                                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                                    for (Object item$iv$iv3 : $receiver$iv$iv) {
                                        it = (ExasolIntroQueries.ConstraintColumnInfo)item$iv$iv3;
                                        collection = destination$iv$iv;
                                        string = it.ref_column;
                                        collection.add(string);
                                    }
                                    collection = (List)destination$iv$iv;
                                    exasolModConstraint.setRefColNames((List<String>)collection);
                                    $receiver$iv2 = columnsInfo;
                                    exasolModConstraint = $receiver;
                                    $receiver$iv$iv = $receiver$iv2;
                                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                                    for (Object item$iv$iv3 : $receiver$iv$iv) {
                                        it = (ExasolIntroQueries.ConstraintColumnInfo)item$iv$iv3;
                                        collection = destination$iv$iv;
                                        string = it.column_name;
                                        collection.add(string);
                                    }
                                    collection = (List)destination$iv$iv;
                                    exasolModConstraint.setColNames((List<String>)collection);
                                }
                                prevIdx$iv = idx$iv;
                                prev$iv = $receiver$iv3.get(prevIdx$iv);
                            }
                            columnsInfo = $receiver$iv3.subList(prevIdx$iv, $receiver$iv3.size());
                            constraintInfo = (ExasolIntroQueries.ConstraintColumnInfo)$receiver$iv3.get(prevIdx$iv);
                            CharSequence charSequence = constraintInfo.name;
                            Pattern pattern = ExasolIntrospector.this.SURROGATE_PATTERN;
                            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"SURROGATE_PATTERN");
                            surrogate = BaseIntrospectionFunctions.matches(charSequence, pattern);
                            Boolean bl = constraintInfo.is_pk;
                            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"constraintInfo.is_pk");
                            if (bl.booleanValue()) {
                                e = table.getKeys().createOrGet(constraintInfo.name);
                                $receiver = (ExasolModKey)e;
                                $receiver.setNameSurrogate(surrogate);
                                $receiver.setPrimary(true);
                                $receiver$iv2 = columnsInfo;
                                exasolModConstraint = $receiver;
                                $receiver$iv$iv = $receiver$iv2;
                                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                                for (Object item$iv$iv3 : $receiver$iv$iv) {
                                    it = (ExasolIntroQueries.ConstraintColumnInfo)item$iv$iv3;
                                    collection = destination$iv$iv;
                                    string = it.column_name;
                                    collection.add(string);
                                }
                                collection = (List)destination$iv$iv;
                                exasolModConstraint.setColNames((List<String>)collection);
                            } else {
                                e = table.getForeignKeys().createOrGet(constraintInfo.name);
                                $receiver = (ExasolModForeignKey)e;
                                $receiver.setNameSurrogate(surrogate);
                                $receiver.setRefSchemaName(constraintInfo.ref_schema);
                                $receiver.setRefTableName(constraintInfo.ref_table);
                                $receiver$iv2 = columnsInfo;
                                exasolModConstraint = $receiver;
                                $receiver$iv$iv = $receiver$iv2;
                                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                                for (Object item$iv$iv3 : $receiver$iv$iv) {
                                    it = (ExasolIntroQueries.ConstraintColumnInfo)item$iv$iv3;
                                    collection = destination$iv$iv;
                                    string = it.ref_column;
                                    collection.add(string);
                                }
                                collection = (List)destination$iv$iv;
                                exasolModConstraint.setRefColNames((List<String>)collection);
                                $receiver$iv2 = columnsInfo;
                                exasolModConstraint = $receiver;
                                $receiver$iv$iv = $receiver$iv2;
                                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                                for (Object item$iv$iv3 : $receiver$iv$iv) {
                                    it = (ExasolIntroQueries.ConstraintColumnInfo)item$iv$iv3;
                                    collection = destination$iv$iv;
                                    string = it.column_name;
                                    collection.add(string);
                                }
                                collection = (List)destination$iv$iv;
                                exasolModConstraint.setColNames((List<String>)collection);
                            }
                        }
                        table.getKeys().removeSyncPendingChildren();
                        table.getKeys().sort();
                        table.getForeignKeys().removeSyncPendingChildren();
                        table.getForeignKeys().sort();
                    }
                    prevIdx$iv2 = idx$iv2;
                    prev$iv2 = $receiver$iv.get(prevIdx$iv2);
                }
                forTableInfo = $receiver$iv.subList(prevIdx$iv2, $receiver$iv.size());
                tableInfo = (ExasolIntroQueries.ConstraintColumnInfo)$receiver$iv.get(prevIdx$iv2);
                ExasolModTable exasolModTable = (ExasolModTable)schema.getTables().get(tableInfo.table_name);
                if (exasolModTable == null) {
                } else {
                    table = exasolModTable;
                    table.getKeys().markChildrenAsSyncPending();
                    table.getForeignKeys().markChildrenAsSyncPending();
                    $receiver$iv3 = forTableInfo;
                    this_$iv2 = ExasolIntrospector.this;
                    if (!$receiver$iv3.isEmpty()) {
                        prevIdx$iv = 0;
                        prev$iv = $receiver$iv3.get(prevIdx$iv);
                        $receiver$iv$iv2 = $receiver$iv3;
                        index$iv$iv = 0;
                        for (Object item$iv$iv2 : $receiver$iv$iv2) {
                            int n = index$iv$iv++;
                            item$iv = item$iv$iv2;
                            idx$iv = n;
                            if (idx$iv == 0) continue;
                            columnsInfo = (ExasolIntroQueries.ConstraintColumnInfo)item$iv;
                            prev = (ExasolIntroQueries.ConstraintColumnInfo)prev$iv;
                            if (!(Intrinsics.areEqual((Object)prev.name, (Object)((ExasolIntroQueries.ConstraintColumnInfo)((Object)next)).name) ^ true)) continue;
                            next = $receiver$iv3.subList(prevIdx$iv, idx$iv);
                            constraintInfo = (ExasolIntroQueries.ConstraintColumnInfo)prev$iv;
                            CharSequence charSequence = constraintInfo.name;
                            Pattern pattern = ExasolIntrospector.this.SURROGATE_PATTERN;
                            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"SURROGATE_PATTERN");
                            surrogate = BaseIntrospectionFunctions.matches(charSequence, pattern);
                            Boolean bl = constraintInfo.is_pk;
                            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"constraintInfo.is_pk");
                            if (bl.booleanValue()) {
                                e = table.getKeys().createOrGet(constraintInfo.name);
                                $receiver = (ExasolModKey)e;
                                $receiver.setNameSurrogate(surrogate);
                                $receiver.setPrimary(true);
                                $receiver$iv2 = columnsInfo;
                                exasolModConstraint = $receiver;
                                $receiver$iv$iv = $receiver$iv2;
                                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                                for (Object item$iv$iv3 : $receiver$iv$iv) {
                                    it = (ExasolIntroQueries.ConstraintColumnInfo)item$iv$iv3;
                                    collection = destination$iv$iv;
                                    string = it.column_name;
                                    collection.add(string);
                                }
                                collection = (List)destination$iv$iv;
                                exasolModConstraint.setColNames((List<String>)collection);
                            } else {
                                e = table.getForeignKeys().createOrGet(constraintInfo.name);
                                $receiver = (ExasolModForeignKey)e;
                                $receiver.setNameSurrogate(surrogate);
                                $receiver.setRefSchemaName(constraintInfo.ref_schema);
                                $receiver.setRefTableName(constraintInfo.ref_table);
                                $receiver$iv2 = columnsInfo;
                                exasolModConstraint = $receiver;
                                $receiver$iv$iv = $receiver$iv2;
                                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                                for (Object item$iv$iv3 : $receiver$iv$iv) {
                                    it = (ExasolIntroQueries.ConstraintColumnInfo)item$iv$iv3;
                                    collection = destination$iv$iv;
                                    string = it.ref_column;
                                    collection.add(string);
                                }
                                collection = (List)destination$iv$iv;
                                exasolModConstraint.setRefColNames((List<String>)collection);
                                $receiver$iv2 = columnsInfo;
                                exasolModConstraint = $receiver;
                                $receiver$iv$iv = $receiver$iv2;
                                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                                for (Object item$iv$iv3 : $receiver$iv$iv) {
                                    it = (ExasolIntroQueries.ConstraintColumnInfo)item$iv$iv3;
                                    collection = destination$iv$iv;
                                    string = it.column_name;
                                    collection.add(string);
                                }
                                collection = (List)destination$iv$iv;
                                exasolModConstraint.setColNames((List<String>)collection);
                            }
                            prevIdx$iv = idx$iv;
                            prev$iv = $receiver$iv3.get(prevIdx$iv);
                        }
                        columnsInfo = $receiver$iv3.subList(prevIdx$iv, $receiver$iv3.size());
                        constraintInfo = (ExasolIntroQueries.ConstraintColumnInfo)$receiver$iv3.get(prevIdx$iv);
                        CharSequence charSequence = constraintInfo.name;
                        Pattern pattern = ExasolIntrospector.this.SURROGATE_PATTERN;
                        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"SURROGATE_PATTERN");
                        surrogate = BaseIntrospectionFunctions.matches(charSequence, pattern);
                        Boolean bl = constraintInfo.is_pk;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"constraintInfo.is_pk");
                        if (bl.booleanValue()) {
                            e = table.getKeys().createOrGet(constraintInfo.name);
                            $receiver = (ExasolModKey)e;
                            $receiver.setNameSurrogate(surrogate);
                            $receiver.setPrimary(true);
                            $receiver$iv2 = columnsInfo;
                            exasolModConstraint = $receiver;
                            $receiver$iv$iv = $receiver$iv2;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                            for (Object item$iv$iv3 : $receiver$iv$iv) {
                                it = (ExasolIntroQueries.ConstraintColumnInfo)item$iv$iv3;
                                collection = destination$iv$iv;
                                string = it.column_name;
                                collection.add(string);
                            }
                            collection = (List)destination$iv$iv;
                            exasolModConstraint.setColNames((List<String>)collection);
                        } else {
                            e = table.getForeignKeys().createOrGet(constraintInfo.name);
                            $receiver = (ExasolModForeignKey)e;
                            $receiver.setNameSurrogate(surrogate);
                            $receiver.setRefSchemaName(constraintInfo.ref_schema);
                            $receiver.setRefTableName(constraintInfo.ref_table);
                            $receiver$iv2 = columnsInfo;
                            exasolModConstraint = $receiver;
                            $receiver$iv$iv = $receiver$iv2;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                            for (Object item$iv$iv3 : $receiver$iv$iv) {
                                it = (ExasolIntroQueries.ConstraintColumnInfo)item$iv$iv3;
                                collection = destination$iv$iv;
                                string = it.ref_column;
                                collection.add(string);
                            }
                            collection = (List)destination$iv$iv;
                            exasolModConstraint.setRefColNames((List<String>)collection);
                            $receiver$iv2 = columnsInfo;
                            exasolModConstraint = $receiver;
                            $receiver$iv$iv = $receiver$iv2;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                            for (Object item$iv$iv3 : $receiver$iv$iv) {
                                it = (ExasolIntroQueries.ConstraintColumnInfo)item$iv$iv3;
                                collection = destination$iv$iv;
                                string = it.column_name;
                                collection.add(string);
                            }
                            collection = (List)destination$iv$iv;
                            exasolModConstraint.setColNames((List<String>)collection);
                        }
                    }
                    table.getKeys().removeSyncPendingChildren();
                    table.getKeys().sort();
                    table.getForeignKeys().removeSyncPendingChildren();
                    table.getForeignKeys().sort();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumns(ExasolModSchema schema) {
            void $receiver$iv;
            List<ExasolIntroQueries.ColumnInfo> infos;
            SqlQuery<List<ExasolIntroQueries.ColumnInfo>> sqlQuery = ExasolIntroQueries.QUERIES.retrieveColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"QUERIES.retrieveColumns");
            List<ExasolIntroQueries.ColumnInfo> list = infos = this.performQuery(sqlQuery);
            ExasolIntrospector this_$iv = ExasolIntrospector.this;
            if (!$receiver$iv.isEmpty()) {
                SequenceIdentity sequenceIdentity;
                long it;
                Long l;
                ExasolModTableColumn exasolModTableColumn;
                BasicModTableOrViewColumn $receiver;
                Object e;
                ExasolIntroQueries.ColumnInfo info;
                Iterable $receiver$iv2;
                List columnsInfo;
                ModPositioningNamingFamily columns2;
                ExasolIntroQueries.ColumnInfo tableInfo;
                int prevIdx$iv = 0;
                Object prev$iv = $receiver$iv.get(prevIdx$iv);
                Iterable $receiver$iv$iv = (Iterable)$receiver$iv;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $receiver$iv$iv) {
                    List next;
                    void item$iv;
                    int n = index$iv$iv++;
                    Object t = item$iv$iv;
                    int idx$iv = n;
                    if (idx$iv == 0) continue;
                    ExasolIntroQueries.ColumnInfo columnInfo = (ExasolIntroQueries.ColumnInfo)item$iv;
                    ExasolIntroQueries.ColumnInfo prev = (ExasolIntroQueries.ColumnInfo)prev$iv;
                    if (!(Intrinsics.areEqual((Object)prev.table_name, (Object)((ExasolIntroQueries.ColumnInfo)((Object)next)).table_name) ^ true)) continue;
                    next = $receiver$iv.subList(prevIdx$iv, idx$iv);
                    tableInfo = (ExasolIntroQueries.ColumnInfo)prev$iv;
                    Boolean bl = tableInfo.is_table;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"tableInfo.is_table");
                    boolean bl2 = bl;
                    String string = tableInfo.table_name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tableInfo.table_name");
                    if (ExasolIntrospector.this.columns(schema, bl2, string) == null) {
                    } else {
                        columns2.markChildrenAsSyncPending();
                        $receiver$iv2 = columnsInfo;
                        for (Object element$iv : $receiver$iv2) {
                            SequenceIdentity sequenceIdentity2;
                            info = (ExasolIntroQueries.ColumnInfo)element$iv;
                            Short s = info.pos;
                            Intrinsics.checkExpressionValueIsNotNull((Object)s, (String)"info.pos");
                            e = columns2.renewAt(s, info.name);
                            $receiver = (BasicModTableOrViewColumn)e;
                            $receiver.setComment(info.comment);
                            $receiver.setDataType(DataTypeFactory.of(info.type));
                            $receiver.setNotNull(Intrinsics.areEqual((Object)info.is_nullable, (Object)false));
                            if (!($receiver instanceof ExasolModTableColumn)) continue;
                            ExasolModTableColumn exasolModTableColumn2 = (ExasolModTableColumn)$receiver;
                            if (info.ident != null) {
                                exasolModTableColumn = exasolModTableColumn2;
                                it = ((Number)l).longValue();
                                sequenceIdentity = SequenceIdentity.of(null, it, null, null);
                                exasolModTableColumn2 = exasolModTableColumn;
                                sequenceIdentity2 = sequenceIdentity;
                            } else {
                                sequenceIdentity2 = null;
                            }
                            exasolModTableColumn2.setSequenceIdentity(sequenceIdentity2);
                            ((ExasolModTableColumn)$receiver).setDefaultExpression(info.def);
                            ExasolModTableColumn exasolModTableColumn3 = (ExasolModTableColumn)$receiver;
                            Boolean bl3 = info.is_dist_key;
                            Intrinsics.checkExpressionValueIsNotNull((Object)bl3, (String)"info.is_dist_key");
                            exasolModTableColumn3.setDistKey(bl3);
                        }
                        columns2.removeSyncPendingChildren();
                        columns2.sort();
                    }
                    prevIdx$iv = idx$iv;
                    prev$iv = $receiver$iv.get(prevIdx$iv);
                }
                columnsInfo = $receiver$iv.subList(prevIdx$iv, $receiver$iv.size());
                tableInfo = (ExasolIntroQueries.ColumnInfo)$receiver$iv.get(prevIdx$iv);
                Boolean bl = tableInfo.is_table;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"tableInfo.is_table");
                boolean bl4 = bl;
                String string = tableInfo.table_name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tableInfo.table_name");
                ModPositioningNamingFamily modPositioningNamingFamily = ExasolIntrospector.this.columns(schema, bl4, string);
                if (modPositioningNamingFamily == null) {
                } else {
                    columns2 = modPositioningNamingFamily;
                    columns2.markChildrenAsSyncPending();
                    $receiver$iv2 = columnsInfo;
                    for (Object element$iv : $receiver$iv2) {
                        SequenceIdentity sequenceIdentity3;
                        info = (ExasolIntroQueries.ColumnInfo)element$iv;
                        Short s = info.pos;
                        Intrinsics.checkExpressionValueIsNotNull((Object)s, (String)"info.pos");
                        e = columns2.renewAt(s, info.name);
                        $receiver = (BasicModTableOrViewColumn)e;
                        $receiver.setComment(info.comment);
                        $receiver.setDataType(DataTypeFactory.of(info.type));
                        $receiver.setNotNull(Intrinsics.areEqual((Object)info.is_nullable, (Object)false));
                        if (!($receiver instanceof ExasolModTableColumn)) continue;
                        ExasolModTableColumn exasolModTableColumn4 = (ExasolModTableColumn)$receiver;
                        if (info.ident != null) {
                            exasolModTableColumn = exasolModTableColumn4;
                            it = ((Number)l).longValue();
                            sequenceIdentity = SequenceIdentity.of(null, it, null, null);
                            exasolModTableColumn4 = exasolModTableColumn;
                            sequenceIdentity3 = sequenceIdentity;
                        } else {
                            sequenceIdentity3 = null;
                        }
                        exasolModTableColumn4.setSequenceIdentity(sequenceIdentity3);
                        ((ExasolModTableColumn)$receiver).setDefaultExpression(info.def);
                        ExasolModTableColumn exasolModTableColumn5 = (ExasolModTableColumn)$receiver;
                        Boolean bl5 = info.is_dist_key;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bl5, (String)"info.is_dist_key");
                        exasolModTableColumn5.setDistKey(bl5);
                    }
                    columns2.removeSyncPendingChildren();
                    columns2.sort();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void retrieveAllObjects(ExasolModSchema schema) {
            v0 = ExasolIntroQueries.QUERIES.retrieveAllObjects;
            Intrinsics.checkExpressionValueIsNotNull(v0, (String)"QUERIES.retrieveAllObjects");
            objects = this.performQuery(v0);
            var3_3 = ExasolIntrospector.this;
            v1 = objects;
            Intrinsics.checkExpressionValueIsNotNull(v1, (String)"objects");
            objects$iv = v1;
            v2 = new ModNamingIdentifyingFamily[4];
            v3 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"schema.tables");
            v2[0] = v3;
            v4 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"schema.views");
            v2[1] = v4;
            v5 = schema.getRoutines();
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"schema.routines");
            v2[2] = v5;
            v6 = schema.getScripts();
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"schema.scripts");
            v2[3] = v6;
            families$iv = v2;
            $receiver$iv$iv = families$iv;
            for (var7_7 = 0; var7_7 < $receiver$iv$iv.length; ++var7_7) {
                element$iv$iv = $receiver$iv$iv[var7_7];
                it$iv = (ModNamingIdentifyingFamily)element$iv$iv;
                it$iv.markChildrenAsSyncPending();
            }
            for (ExasolIntroQueries.ObjectInfo info$iv : objects$iv) {
                block13: {
                    block9: {
                        block10: {
                            block12: {
                                block11: {
                                    v7 = element$iv$iv = info$iv.type;
                                    if (v7 == null) break block9;
                                    switch (v7.hashCode()) {
                                        case 79578030: {
                                            if (!element$iv$iv.equals("TABLE")) ** break;
                                            break;
                                        }
                                        case -1854356277: {
                                            if (!element$iv$iv.equals("SCRIPT")) ** break;
                                            break block10;
                                        }
                                        case 2634405: {
                                            if (!element$iv$iv.equals("VIEW")) ** break;
                                            break block11;
                                        }
                                        case -2131401768: {
                                            if (!element$iv$iv.equals("FUNCTION")) ** break;
                                            break block12;
                                        }
                                    }
                                    v8 = schema.getTables();
                                    break block13;
                                }
                                v8 = schema.getViews();
                                break block13;
                            }
                            v8 = schema.getRoutines();
                            break block13;
                        }
                        v8 = schema.getScripts();
                        break block13;
                    }
                    v8 = null;
                }
                if (v8 == null) continue;
                it$iv = element$iv$iv = v8;
                var10_12 = info$iv;
                var15_14 = it$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)it.id, (String)"it.id");
                obj$iv = var15_14.renew(((Number)var16_15).longValue(), info$iv.name);
                obj$iv.setComment(info$iv.comment);
                if (!(obj$iv instanceof ExasolModRoutine)) continue;
                ((ExasolModRoutine)obj$iv).setRoutineKind(DasRoutine.Kind.FUNCTION);
            }
            $receiver$iv$iv = families$iv;
            for (var7_9 = 0; var7_9 < $receiver$iv$iv.length; ++var7_9) {
                element$iv$iv = $receiver$iv$iv[var7_9];
                it$iv = (ModNamingIdentifyingFamily)element$iv$iv;
                it$iv.removeSyncPendingChildren();
                it$iv.sort();
            }
        }

        public ExaSchemaRetriever(@NotNull DBTransaction transaction, ExasolSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)ExasolIntrospector.this, transaction, (BasicSchema)schema);
        }

        public static final /* synthetic */ void access$retrieveAllObjects(ExaSchemaRetriever $this, @NotNull ExasolModSchema schema) {
            $this.retrieveAllObjects(schema);
        }

        public static final /* synthetic */ void access$retrieveColumns(ExaSchemaRetriever $this, @NotNull ExasolModSchema schema) {
            $this.retrieveColumns(schema);
        }

        public static final /* synthetic */ void access$retrieveConstraints(ExaSchemaRetriever $this, @NotNull ExasolModSchema schema) {
            $this.retrieveConstraints(schema);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u0000200\u0001R,\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0002B\u0015\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/introspection/ExasolIntrospector$ExaSysSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/exasol/ExasolModModel;", "Lcom/intellij/database/model/exasol/ExasolRoot;", "Lcom/intellij/database/model/exasol/ExasolModRoot;", "Lcom/intellij/database/model/exasol/ExasolDatabase;", "Lcom/intellij/database/model/exasol/ExasolModDatabase;", "Lcom/intellij/database/model/exasol/ExasolSchema;", "Lcom/intellij/database/model/exasol/ExasolModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/ExasolIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/exasol/ExasolSchema;)V", "process", "", "retrieveAllSysObjects", "retrieveSysColumns", "database-introspection"})
    private final class ExaSysSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever {
        @Override
        public void process() {
            ExaSysSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ ExaSysSchemaRetriever this$0;
                {
                    this.this$0 = exaSysSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    ExasolModSchema schema2 = (ExasolModSchema)MS;
                    ExaSysSchemaRetriever.access$retrieveAllSysObjects(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ ExaSysSchemaRetriever this$0;
                {
                    this.this$0 = exaSysSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    ExasolModSchema schema2 = (ExasolModSchema)MS;
                    ExaSysSchemaRetriever.access$retrieveSysColumns(this.this$0, schema2);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void retrieveSysColumns(ExasolModSchema schema) {
            DBTransaction dBTransaction = this.getTransaction();
            if (dBTransaction == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.dekaf.core.DBSession");
            }
            Object object = ((DBSession)dBTransaction).getSpecificService(Connection.class, "jdbc-connection");
            if (object == null) {
                Intrinsics.throwNpe();
            }
            DatabaseMetaData metaData = ((Connection)object).getMetaData();
            DatabaseMetaDataWrapper.Schema sc = new DatabaseMetaDataWrapper.Schema(schema.getName(), schema.getDatabase().getName());
            ResultSet rset = metaData.getColumns(schema.getDatabase().getName(), schema.getName(), null, null);
            Closeable closeable = new TableColumnIt.Grouping(new TableColumnIt(rset, DatabaseFamilyId.EXASOL, sc));
            Throwable throwable = null;
            try {
                Iterator $receiver$iv;
                Iterator iterator;
                TableColumnIt.Grouping gIt = (TableColumnIt.Grouping)closeable;
                Iterator iterator2 = iterator = ($receiver$iv = (Iterator)((Object)gIt));
                while (iterator2.hasNext()) {
                    Iterator $receiver$iv2;
                    Iterator iterator3;
                    Object element$iv = iterator2.next();
                    DatabaseMetaDataWrapper.Table it = (DatabaseMetaDataWrapper.Table)element$iv;
                    BasicModTableOrView basicModTableOrView = (BasicModTableOrView)schema.getTableOrView(it.name);
                    PositioningNamingFamily positioningNamingFamily = basicModTableOrView != null ? basicModTableOrView.getColumns() : null;
                    if (!(positioningNamingFamily instanceof ModPositioningNamingFamily)) {
                        positioningNamingFamily = null;
                    }
                    if ((ModPositioningNamingFamily)positioningNamingFamily == null) {
                        continue;
                    }
                    Iterator iterator4 = iterator3 = ($receiver$iv2 = (Iterator)gIt.groupIt());
                    while (iterator4.hasNext()) {
                        ModPositioningNamingFamily columns2;
                        Object element$iv2 = iterator4.next();
                        DatabaseMetaDataWrapper.TableColumn col = (DatabaseMetaDataWrapper.TableColumn)element$iv2;
                        String string = col.typeName;
                        if (string == null) {
                            string = "";
                        }
                        DataType dataType = GenericIntrospectorHelper.makeDataType(string, col.length, col.scale, col.type);
                        String string2 = col.name;
                        if (string2 == null) {
                            string2 = "";
                        }
                        Object e = columns2.createOrGet(string2);
                        if (e == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModTableOrViewColumn");
                        }
                        BasicModTableOrViewColumn column = (BasicModTableOrViewColumn)e;
                        column.setPosition((short)col.position);
                        column.setDataType(dataType);
                        column.setNotNull(!col.nullable);
                        column.setDefaultExpression(col.def);
                        column.setComment(StringKt.nullize$default((String)col.comment, (boolean)false, (int)1, null));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void retrieveAllSysObjects(ExasolModSchema schema) {
            v0 = ExasolIntroQueries.QUERIES.retrieveAllSysObjects;
            Intrinsics.checkExpressionValueIsNotNull(v0, (String)"QUERIES.retrieveAllSysObjects");
            objects = this.performQuery(v0);
            var3_3 = ExasolIntrospector.this;
            v1 = objects;
            Intrinsics.checkExpressionValueIsNotNull(v1, (String)"objects");
            objects$iv = v1;
            v2 = new ModNamingIdentifyingFamily[4];
            v3 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"schema.tables");
            v2[0] = v3;
            v4 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"schema.views");
            v2[1] = v4;
            v5 = schema.getRoutines();
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"schema.routines");
            v2[2] = v5;
            v6 = schema.getScripts();
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"schema.scripts");
            v2[3] = v6;
            families$iv = v2;
            $receiver$iv$iv = families$iv;
            for (var7_7 = 0; var7_7 < $receiver$iv$iv.length; ++var7_7) {
                element$iv$iv = $receiver$iv$iv[var7_7];
                it$iv = (ModNamingIdentifyingFamily)element$iv$iv;
                it$iv.markChildrenAsSyncPending();
            }
            for (ExasolIntroQueries.ObjectInfo info$iv : objects$iv) {
                block13: {
                    block9: {
                        block10: {
                            block12: {
                                block11: {
                                    v7 = element$iv$iv = info$iv.type;
                                    if (v7 == null) break block9;
                                    switch (v7.hashCode()) {
                                        case 79578030: {
                                            if (!element$iv$iv.equals("TABLE")) ** break;
                                            break;
                                        }
                                        case -1854356277: {
                                            if (!element$iv$iv.equals("SCRIPT")) ** break;
                                            break block10;
                                        }
                                        case 2634405: {
                                            if (!element$iv$iv.equals("VIEW")) ** break;
                                            break block11;
                                        }
                                        case -2131401768: {
                                            if (!element$iv$iv.equals("FUNCTION")) ** break;
                                            break block12;
                                        }
                                    }
                                    v8 = schema.getTables();
                                    break block13;
                                }
                                v8 = schema.getViews();
                                break block13;
                            }
                            v8 = schema.getRoutines();
                            break block13;
                        }
                        v8 = schema.getScripts();
                        break block13;
                    }
                    v8 = null;
                }
                if (v8 == null) continue;
                it$iv = element$iv$iv = v8;
                var10_12 = info$iv;
                var15_14 = it$iv;
                var16_15 = -9223372036854775808L;
                obj$iv = var15_14.renew(var16_15, info$iv.name);
                obj$iv.setComment(info$iv.comment);
                if (!(obj$iv instanceof ExasolModRoutine)) continue;
                ((ExasolModRoutine)obj$iv).setRoutineKind(DasRoutine.Kind.FUNCTION);
            }
            $receiver$iv$iv = families$iv;
            for (var7_9 = 0; var7_9 < $receiver$iv$iv.length; ++var7_9) {
                element$iv$iv = $receiver$iv$iv[var7_9];
                it$iv = (ModNamingIdentifyingFamily)element$iv$iv;
                it$iv.removeSyncPendingChildren();
                it$iv.sort();
            }
        }

        public ExaSysSchemaRetriever(@NotNull DBTransaction transaction, ExasolSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)ExasolIntrospector.this, transaction, (BasicSchema)schema);
        }

        public static final /* synthetic */ void access$retrieveAllSysObjects(ExaSysSchemaRetriever $this, @NotNull ExasolModSchema schema) {
            $this.retrieveAllSysObjects(schema);
        }

        public static final /* synthetic */ void access$retrieveSysColumns(ExaSysSchemaRetriever $this, @NotNull ExasolModSchema schema) {
            $this.retrieveSysColumns(schema);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/introspection/ExasolIntrospector$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "database-introspection"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
        }

        static {
            VERSION vERSION;
            INSTANCE = vERSION = new VERSION();
        }
    }
}

