/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.sybase.SybaseProcedure;
import com.intellij.util.ObjectUtils;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelUtil {
    public static final Comparator<? super BasicElement> DISPLAY_ORDER_COMPARATOR = (e1, e2) -> {
        String s1 = e1.getDisplayOrder();
        String s2 = e2.getDisplayOrder();
        return s1.compareTo(s2);
    };
    public static final Comparator<? super BasicArrangedElement> POSITIONS_COMPARATOR = (e1, e2) -> {
        short p2;
        short p1 = e1.getPosition();
        return p1 < (p2 = e2.getPosition()) ? -1 : (p1 > p2 ? 1 : 0);
    };

    @Nullable
    public static String nameOf(@Nullable BasicNamedElement element) {
        return element != null ? element.getRealName() : null;
    }

    public static String calculateSybProcedureIdentity(short pos) {
        return Short.toString(pos);
    }

    public static String calculateRoutineIdentity(@Nullable String name, @NotNull Iterable<? extends DasArgument> args) {
        if (args == null) {
            ModelUtil.$$$reportNull$$$0(0);
        }
        StringBuilder b = new StringBuilder();
        b.append(name);
        boolean w = false;
        b.append('(');
        for (DasArgument dasArgument : args) {
            if (!dasArgument.getArgumentDirection().isIn()) continue;
            if (w) {
                b.append(',');
            }
            b.append(dasArgument.getDataType().getSpecification());
            w = true;
        }
        b.append(')');
        return b.toString();
    }

    @NotNull
    public static String calculateOverloadableIdentity(@NotNull BasicOverloadable o, boolean includingSurrogate) {
        String name;
        if (o == null) {
            ModelUtil.$$$reportNull$$$0(1);
        }
        if (o instanceof SybaseProcedure) {
            String string = ModelUtil.calculateSybProcedureIdentity(((SybaseProcedure)o).getPosition());
            if (string == null) {
                ModelUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        BasicNamedElement ne = (BasicNamedElement)ObjectUtils.tryCast((Object)o, BasicNamedElement.class);
        String string = ne == null ? "" : (name = includingSurrogate ? ne.getRealName() : ne.getNaturalName());
        if (o instanceof BasicRoutine) {
            String string2 = ModelUtil.calculateRoutineIdentity(name, ((BasicRoutine)((Object)o)).getArguments());
            if (string2 == null) {
                ModelUtil.$$$reportNull$$$0(3);
            }
            return string2;
        }
        String string3 = String.valueOf(name);
        if (string3 == null) {
            ModelUtil.$$$reportNull$$$0(4);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateOverloadableIdentity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateRoutineIdentity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateOverloadableIdentity";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

