/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.CommonBundle;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.TextCopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorNotificationPanel
extends JPanel {
    private static final String CLOSE_COMMAND = "close";
    private final JEditorPane myMessagePane;
    private final Map<String, Runnable> myActions;
    private final CopyProvider myCopyProvider;

    private ErrorNotificationPanel(String htmlErrorMessage, @NotNull Map<String, Runnable> actions) {
        if (actions == null) {
            ErrorNotificationPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myActions = actions;
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        this.myMessagePane = IdeTooltipManager.initPane((String)htmlErrorMessage, (HintHint)new HintHint().setAwtTooltip(false).setTextBg(this.getBackground()).setBorderColor(this.getBackground()).setBorderInsets((Insets)JBUI.emptyInsets()), null);
        this.myMessagePane.setBorder(null);
        this.myMessagePane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ErrorNotificationPanel.this.performAction(e.getDescription());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/ErrorNotificationPanel$1", "hyperlinkActivated"));
            }
        });
        this.add((Component)this.myMessagePane, "Center");
        this.myCopyProvider = new TextCopyProvider(){

            @Nullable
            public Collection<String> getTextLinesToCopy() {
                String text2 = ErrorNotificationPanel.this.myMessagePane.getSelectedText();
                return StringUtil.isEmpty((String)text2) ? null : Collections.singleton(text2);
            }
        };
        new DumbAwareAction(CLOSE_COMMAND){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ErrorNotificationPanel.this.performAction(ErrorNotificationPanel.CLOSE_COMMAND);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/ErrorNotificationPanel$3", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{27}), (JComponent)this);
        DataManager.registerDataProvider((JComponent)this.myMessagePane, (DataProvider)new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                    return ErrorNotificationPanel.this.myCopyProvider;
                }
                return null;
            }
        });
    }

    private void performAction(String actionName) {
        Runnable action = this.myActions.get(actionName);
        if (action != null) {
            action.run();
        }
    }

    @Override
    @NotNull
    public Color getBackground() {
        Color color = MessageType.ERROR.getPopupBackground();
        if (color == null) {
            ErrorNotificationPanel.$$$reportNull$$$0(1);
        }
        return color;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        JBDimension jBDimension = JBUI.emptySize();
        if (jBDimension == null) {
            ErrorNotificationPanel.$$$reportNull$$$0(2);
        }
        return jBDimension;
    }

    public JComponent getContent() {
        return this.myMessagePane;
    }

    @NotNull
    public static Builder create(@Nullable String message, @Nullable Throwable error, @NotNull JComponent baseComponent) {
        if (baseComponent == null) {
            ErrorNotificationPanel.$$$reportNull$$$0(3);
        }
        Builder builder = new Builder(message, error, baseComponent);
        if (builder == null) {
            ErrorNotificationPanel.$$$reportNull$$$0(4);
        }
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/ErrorNotificationPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/ErrorNotificationPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackground";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumSize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private final boolean myLongMessage;
        private final Throwable myError;
        private final String myMessage;
        private final JComponent myBaseComponent;
        private final Map<String, Runnable> myActions;
        private final List<Consumer<Disposable>> myShowHideHandlers;
        private final StringBuilder myHtmlBuilder;

        private Builder(@Nullable String message, @Nullable Throwable error, @NotNull JComponent baseComponent) {
            if (baseComponent == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myActions = ContainerUtil.newLinkedHashMap();
            this.myShowHideHandlers = ContainerUtil.newArrayList();
            this.myHtmlBuilder = new StringBuilder();
            this.myError = error;
            this.myMessage = message;
            this.myBaseComponent = baseComponent;
            String errorMessage = message == null ? (error == null ? null : Builder.getNormalizedMessage(error)) : Builder.getNormalized(message);
            Font font = IdeTooltipManager.getInstance().getTextFont(true);
            FontMetrics fm = baseComponent.getFontMetrics(font);
            boolean bl = this.myLongMessage = SwingUtilities.computeStringWidth(fm, errorMessage) > baseComponent.getWidth() * 3 / 4;
            if (errorMessage != null) {
                errorMessage = StringUtil.escapeXml((String)errorMessage).replace("\n", "<br>");
            }
            this.myHtmlBuilder.append("<html><head><style type=\"text/css\">a:link {text-decoration:none;}</style></head><body>");
            this.myHtmlBuilder.append("<font face=\"verdana\"><table width=\"100%\"><tr valign=\"top\"><td>");
            this.myHtmlBuilder.append(errorMessage);
            this.myHtmlBuilder.append("</td>");
        }

        @NotNull
        public Builder addIconLink(String command, String icon, String tooltipText, @NotNull Icon realIcon, @Nullable Runnable action) {
            if (realIcon == null) {
                Builder.$$$reportNull$$$0(1);
            }
            String imgURL = DataSourceUiUtil.getIconUrl(icon);
            this.startActionColumn();
            this.myHtmlBuilder.append("<a href=\"").append(command).append("\"><img alt=\"").append(tooltipText).append("\" hspace=\"0\" vspace=\"0\" border=\"0\" width=\"").append(realIcon.getIconWidth()).append("\" height=\"").append(realIcon.getIconHeight()).append("\" src=\"");
            this.myHtmlBuilder.append(imgURL).append("\"></a>");
            this.endActionColumn();
            if (action != null) {
                this.myActions.put(command, action);
            }
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder addLink(@NotNull String command, @NotNull String linkHtml, @NotNull Runnable action) {
            if (command == null) {
                Builder.$$$reportNull$$$0(3);
            }
            if (linkHtml == null) {
                Builder.$$$reportNull$$$0(4);
            }
            if (action == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.startActionColumn();
            int mnemonicIndex = UIUtil.getDisplayMnemonicIndex((String)command);
            String fixedCommand = mnemonicIndex < 0 ? command : command.substring(0, mnemonicIndex) + command.substring(mnemonicIndex + 1);
            ContainerUtil.addIfNotNull(this.myShowHideHandlers, Builder.createMnemonicActionIfNeeded(fixedCommand, mnemonicIndex, action, this.myBaseComponent));
            this.myHtmlBuilder.append("<a style=\"text-decoration:none;\" href=\"").append(fixedCommand).append("\">").append(linkHtml).append("</a>");
            this.endActionColumn();
            this.myActions.put(fixedCommand, action);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder addDetailsButton() {
            String message;
            String string = this.myError == null ? this.myMessage : (message = this.myError.getStackTrace().length > 0 ? ExceptionUtil.getThrowableText((Throwable)this.myError, (String)"com.intellij.") : this.myError.getMessage());
            if (StringUtil.contains((CharSequence)this.myHtmlBuilder, (CharSequence)message)) {
                Builder builder = this;
                if (builder == null) {
                    Builder.$$$reportNull$$$0(7);
                }
                return builder;
            }
            Builder builder = this.addLink("details", "Details", () -> Messages.showIdeaMessageDialog(null, (String)message, (String)"Query Error", (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getErrorIcon(), null));
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder addCloseButton(Runnable action) {
            Builder builder = this.addIconLink(ErrorNotificationPanel.CLOSE_COMMAND, "/actions/cross.png", "Close (Esc)", AllIcons.Actions.Cross, action);
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public ErrorNotificationPanel build() {
            this.myHtmlBuilder.append("</tr></table></font></body>");
            ErrorNotificationPanel result2 = new ErrorNotificationPanel(this.myHtmlBuilder.toString(), this.myActions);
            this.registerShowHideHandlers(result2);
            ErrorNotificationPanel errorNotificationPanel = result2;
            if (errorNotificationPanel == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return errorNotificationPanel;
        }

        private void startActionColumn() {
            this.myHtmlBuilder.append("<td width=\"1%\" align=\"right\" valign=\"").append(this.myLongMessage ? "top" : "middle").append("\" nowrap>");
        }

        private void endActionColumn() {
            this.myHtmlBuilder.append("</td>");
        }

        @NotNull
        private static String getNormalizedMessage(@NotNull Throwable error) {
            String sourceMessage;
            int divPos;
            if (error == null) {
                Builder.$$$reportNull$$$0(11);
            }
            if ((divPos = (sourceMessage = StringUtil.notNullize((String)error.getMessage(), (String)"An unknown problem occurred (see Details)")).indexOf("\n\tat ")) != -1) {
                sourceMessage = sourceMessage.substring(0, divPos);
            }
            String string = Builder.getNormalized(sourceMessage);
            if (string == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return string;
        }

        @NotNull
        private static String getNormalized(@NotNull String sourceMessage) {
            if (sourceMessage == null) {
                Builder.$$$reportNull$$$0(13);
            }
            int lineLimit = StringUtil.lineColToOffset((CharSequence)sourceMessage, (int)5, (int)0);
            int charLimit = 1024;
            int limit = lineLimit == -1 || lineLimit > charLimit ? charLimit : lineLimit;
            String string = StringUtil.trimLog((String)sourceMessage, (int)(limit + 1));
            if (string == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return string;
        }

        protected void registerShowHideHandlers(@NotNull JComponent component) {
            if (component == null) {
                Builder.$$$reportNull$$$0(15);
            }
            if (this.myShowHideHandlers.isEmpty()) {
                return;
            }
            new UiNotifyConnector((Component)component, new Activatable(){
                private Disposable showNotified;

                public void showNotify() {
                    this.showNotified = Disposer.newDisposable();
                    for (Consumer handler : myShowHideHandlers) {
                        handler.consume((Object)this.showNotified);
                    }
                }

                public void hideNotify() {
                    if (this.showNotified != null) {
                        Disposer.dispose((Disposable)this.showNotified);
                    }
                    this.showNotified = null;
                }
            });
        }

        @Nullable
        private static Consumer<Disposable> createMnemonicActionIfNeeded(String command, int mnemonicIndex, final Runnable runnable, JComponent component) {
            if (mnemonicIndex < 0) {
                return null;
            }
            return parentDisposable -> {
                DumbAwareAction a = new DumbAwareAction(command){

                    public void actionPerformed(AnActionEvent e) {
                        runnable.run();
                    }
                };
                int modifiers = SystemInfo.isMac && !Registry.is((String)"ide.mac.alt.mnemonic.without.ctrl") ? 10 : 8;
                KeyStroke keyStroke = KeyStroke.getKeyStroke((int)Character.toUpperCase(Character.valueOf(command.charAt(mnemonicIndex)).charValue()), modifiers);
                a.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), component, parentDisposable);
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseComponent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "realIcon";
                    break;
                }
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/ErrorNotificationPanel$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linkHtml";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceMessage";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/ErrorNotificationPanel$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addIconLink";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addLink";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addDetailsButton";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addCloseButton";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNormalizedMessage";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNormalized";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addIconLink";
                    break;
                }
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addLink";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getNormalizedMessage";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getNormalized";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "registerShowHideHandlers";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

