/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.google.common.collect.Iterables;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeArgument;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeConstraint;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeRoutine;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.schemaEditor.model.DeTrigger;
import com.intellij.database.schemaEditor.model.DeView;
import com.intellij.database.schemaEditor.model.DeWrapper;
import com.intellij.database.schemaEditor.model.DeWrapperImpl;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DasSchemaExporters {
    public static SchemaExporters createDefaultExporters() {
        SchemaExporters dasSchemaExporter = new SchemaExporters();
        dasSchemaExporter.add(new DeObjectCloner());
        dasSchemaExporter.add(new DeTableExporter());
        dasSchemaExporter.add(new DeColumnExporter());
        dasSchemaExporter.add(new DeIndexExporter());
        dasSchemaExporter.add(new DeForeignKeyExporter());
        dasSchemaExporter.add(new DeTableKeyExporter());
        dasSchemaExporter.add(new DeNamespaceExporter());
        dasSchemaExporter.add(new DeRoutineExporter());
        dasSchemaExporter.add(new DeArgumentExporter());
        dasSchemaExporter.add(new DeViewExporter());
        dasSchemaExporter.add(new DeMatViewExporter());
        dasSchemaExporter.add(new DeObjectTypeExporter());
        dasSchemaExporter.add(new DePackageExporter());
        dasSchemaExporter.add(new DeBodyExporter());
        dasSchemaExporter.add(new DeTriggerExporter());
        return dasSchemaExporter;
    }

    protected static class DeMatViewExporter
    extends DeGenericExporter {
        public DeMatViewExporter() {
            super(ObjectKind.MAT_VIEW);
        }
    }

    protected static class DeBodyExporter
    extends DeGenericExporter {
        public DeBodyExporter() {
            super(ObjectKind.BODY);
        }
    }

    protected static class DePackageExporter
    extends DeGenericExporter {
        public DePackageExporter() {
            super(ObjectKind.PACKAGE);
        }
    }

    protected static class DeObjectTypeExporter
    extends DeGenericExporter {
        public DeObjectTypeExporter() {
            super(ObjectKind.OBJECT_TYPE);
        }
    }

    protected static class DeGenericExporter
    extends DeObjectExporter<DeWrapperImpl<DasObject>, DasObject> {
        public DeGenericExporter(@NotNull ObjectKind kindFilter) {
            if (kindFilter == null) {
                DeGenericExporter.$$$reportNull$$$0(0);
            }
            super(DeWrapperImpl.class, DasObject.class, kindFilter);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeWrapperImpl<DasObject> to, @NotNull DasObject from) {
            if (helper == null) {
                DeGenericExporter.$$$reportNull$$$0(1);
            }
            if (to == null) {
                DeGenericExporter.$$$reportNull$$$0(2);
            }
            if (from == null) {
                DeGenericExporter.$$$reportNull$$$0(3);
            }
            super.lightExport(helper, to, from);
            to.parent = helper.export(from.getDasParent(), false);
            if (to.parent == null) {
                to.model.addRoot(to);
            }
        }

        @Override
        @NotNull
        public DeWrapperImpl<DasObject> create(@NotNull SchemaExportHelper helper, @NotNull DasObject from) {
            if (helper == null) {
                DeGenericExporter.$$$reportNull$$$0(4);
            }
            if (from == null) {
                DeGenericExporter.$$$reportNull$$$0(5);
            }
            DeWrapperImpl<DasObject> deWrapperImpl = new DeWrapperImpl<DasObject>(DeGenericExporter.getName(helper, from), helper.getModel(), null);
            if (deWrapperImpl == null) {
                DeGenericExporter.$$$reportNull$$$0(6);
            }
            return deWrapperImpl;
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull DeWrapperImpl<DasObject> to, @NotNull DasObject from) {
            if (helper == null) {
                DeGenericExporter.$$$reportNull$$$0(7);
            }
            if (to == null) {
                DeGenericExporter.$$$reportNull$$$0(8);
            }
            if (from == null) {
                DeGenericExporter.$$$reportNull$$$0(9);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kindFilter";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 3: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "exportChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeNamespaceExporter
    extends DeObjectExporter<DeNamespace, DasNamespace> {
        public DeNamespaceExporter() {
            super(DeNamespace.class, DasNamespace.class, null);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeNamespace to, @NotNull DasNamespace from) {
            if (helper == null) {
                DeNamespaceExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeNamespaceExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeNamespaceExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            to.parent = (DeNamespace)helper.export((DasObject)ObjectUtils.tryCast((Object)from.getDasParent(), DasNamespace.class), false);
            if (to.parent == null) {
                to.model.addRoot(to);
            }
        }

        @Override
        @NotNull
        public DeNamespace create(@NotNull SchemaExportHelper helper, @NotNull DasNamespace from) {
            if (helper == null) {
                DeNamespaceExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeNamespaceExporter.$$$reportNull$$$0(4);
            }
            DeNamespace deNamespace = new DeNamespace(DeNamespaceExporter.getName(helper, (DasObject)from), from.getKind(), helper.getModel());
            if (deNamespace == null) {
                DeNamespaceExporter.$$$reportNull$$$0(5);
            }
            return deNamespace;
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull DeNamespace to, @NotNull DasNamespace from) {
            if (helper == null) {
                DeNamespaceExporter.$$$reportNull$$$0(6);
            }
            if (to == null) {
                DeNamespaceExporter.$$$reportNull$$$0(7);
            }
            if (from == null) {
                DeNamespaceExporter.$$$reportNull$$$0(8);
            }
            for (DasObject object : DasUtil.getTraversableChildren((DasObject)from, (DasModel)helper.getContext().getModel())) {
                if (!helper.canExport(object)) continue;
                to.children.add((DeObject)helper.export(object, true));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "exportChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeArgumentExporter
    extends DeObjectExporter<DeArgument, DasArgument> {
        public DeArgumentExporter() {
            super(DeArgument.class, DasArgument.class, ObjectKind.ARGUMENT);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeArgument to, @NotNull DasArgument from) {
            if (helper == null) {
                DeArgumentExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeArgumentExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeArgumentExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            to.routine = (DeRoutine)helper.export(from.getDasParent(), false);
        }

        @Override
        @NotNull
        public DeArgument create(@NotNull SchemaExportHelper helper, @NotNull DasArgument from) {
            if (helper == null) {
                DeArgumentExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeArgumentExporter.$$$reportNull$$$0(4);
            }
            DeArgument deArgument = new DeArgument(DeArgumentExporter.getName(helper, (DasObject)from), helper.getModel(), null);
            if (deArgument == null) {
                DeArgumentExporter.$$$reportNull$$$0(5);
            }
            return deArgument;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeArgumentExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeArgumentExporter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeTriggerExporter
    extends DeDumbExporter<DeTrigger, DasTrigger> {
        public DeTriggerExporter() {
            super(DeTrigger.class, DasTrigger.class, ObjectKind.TRIGGER);
        }

        @Override
        @NotNull
        public DeTrigger create(@NotNull SchemaExportHelper helper, @NotNull DasTrigger from) {
            if (helper == null) {
                DeTriggerExporter.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DeTriggerExporter.$$$reportNull$$$0(1);
            }
            DeTrigger deTrigger = new DeTrigger(DeTriggerExporter.getName(helper, (DasObject)from), helper.getModel(), null);
            if (deTrigger == null) {
                DeTriggerExporter.$$$reportNull$$$0(2);
            }
            return deTrigger;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTriggerExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTriggerExporter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeViewExporter
    extends DeDumbExporter<DeView, DasTable> {
        public DeViewExporter() {
            super(DeView.class, DasTable.class, ObjectKind.VIEW);
        }

        @Override
        @NotNull
        public DeView create(@NotNull SchemaExportHelper helper, @NotNull DasTable from) {
            if (helper == null) {
                DeViewExporter.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DeViewExporter.$$$reportNull$$$0(1);
            }
            DeView deView = new DeView(DeViewExporter.getName(helper, (DasObject)from), helper.getModel(), null);
            if (deView == null) {
                DeViewExporter.$$$reportNull$$$0(2);
            }
            return deView;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeViewExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeViewExporter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeRoutineExporter
    extends DeDumbExporter<DeRoutine, DasRoutine> {
        public DeRoutineExporter() {
            super(DeRoutine.class, DasRoutine.class, ObjectKind.ROUTINE);
        }

        @Override
        @NotNull
        public DeRoutine create(@NotNull SchemaExportHelper helper, @NotNull DasRoutine from) {
            if (helper == null) {
                DeRoutineExporter.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DeRoutineExporter.$$$reportNull$$$0(1);
            }
            DeRoutine deRoutine = new DeRoutine(DeRoutineExporter.getName(helper, (DasObject)from), helper.getModel(), null);
            if (deRoutine == null) {
                DeRoutineExporter.$$$reportNull$$$0(2);
            }
            return deRoutine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeRoutineExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeRoutineExporter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class DeDumbExporter<De extends DeWrapper, Das extends DasObject>
    extends DeObjectExporter<De, Das> {
        public DeDumbExporter(@NotNull Class<De> exportedClass, @NotNull Class<Das> exportableClass, @Nullable ObjectKind kindFilter) {
            if (exportedClass == null) {
                DeDumbExporter.$$$reportNull$$$0(0);
            }
            if (exportableClass == null) {
                DeDumbExporter.$$$reportNull$$$0(1);
            }
            super(exportedClass, exportableClass, kindFilter);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeDumbExporter.$$$reportNull$$$0(2);
            }
            if (to == null) {
                DeDumbExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeDumbExporter.$$$reportNull$$$0(4);
            }
            super.lightExport(helper, to, from);
            ((DeWrapper)to).parent = helper.export(from.getDasParent(), false);
            if (((DeWrapper)to).parent == null) {
                ((DeWrapper)to).model.addRoot((DeObject)to);
            }
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeDumbExporter.$$$reportNull$$$0(5);
            }
            if (to == null) {
                DeDumbExporter.$$$reportNull$$$0(6);
            }
            if (from == null) {
                DeDumbExporter.$$$reportNull$$$0(7);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportedClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportableClass";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeDumbExporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lightExport";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exportChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DeTableKeyExporter
    extends DeTableChildExporter<DeTableKey, DasTableKey> {
        public DeTableKeyExporter() {
            super(DeTableKey.class, DasTableKey.class, ObjectKind.KEY);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeTableKey to, @NotNull DasTableKey from) {
            if (helper == null) {
                DeTableKeyExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeTableKeyExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeTableKeyExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            if (from.isPrimary()) {
                DeTable table = to.table;
                if (table.keys.getPrimaryKey() != to) {
                    if (table.keys.getPrimaryKey() != null) {
                        this.myLogger.warn("Already have primary key");
                    }
                    table.keys.setPrimaryKey(to);
                }
            }
            to.columns.addAll(DeTableKeyExporter.getColumnsOrStubs(helper, to.table, (MultiRef<? extends DasTypedObject>)from.getColumnsRef()));
        }

        @Override
        @NotNull
        public DeTableKey create(@NotNull SchemaExportHelper helper, @NotNull DasTableKey from) {
            if (helper == null) {
                DeTableKeyExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeTableKeyExporter.$$$reportNull$$$0(4);
            }
            DeTableKey deTableKey = new DeTableKey(DeTableKeyExporter.getName(helper, (DasObject)from), DeTable.STUB, helper.getModel());
            if (deTableKey == null) {
                DeTableKeyExporter.$$$reportNull$$$0(5);
            }
            return deTableKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableKeyExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableKeyExporter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeForeignKeyExporter
    extends DeTableChildExporter<DeForeignKey, DasForeignKey> {
        public DeForeignKeyExporter() {
            super(DeForeignKey.class, DasForeignKey.class, ObjectKind.FOREIGN_KEY);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeForeignKey to, @NotNull DasForeignKey from) {
            if (helper == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            DasTable refTable = from.getRefTable();
            to.target = refTable == null || refTable.getKind() != ObjectKind.TABLE ? null : DeForeignKeyExporter.getTable(helper, refTable, true);
            to.deferrability = (DasForeignKey.Deferrability)ObjectUtils.chooseNotNull((Object)from.getDeferrability(), (Object)DasForeignKey.Deferrability.NOT_DEFERRABLE);
            to.updateRule = (DasForeignKey.RuleAction)ObjectUtils.chooseNotNull((Object)from.getUpdateRule(), (Object)DasForeignKey.RuleAction.NO_ACTION);
            to.deleteRule = (DasForeignKey.RuleAction)ObjectUtils.chooseNotNull((Object)from.getDeleteRule(), (Object)DasForeignKey.RuleAction.NO_ACTION);
            List<DeColumn> refs = DeForeignKeyExporter.getColumnsOrStubs(helper, to.table, (MultiRef<? extends DasTypedObject>)from.getColumnsRef());
            List<DeColumn> targets = DeForeignKeyExporter.getColumnsOrStubs(helper, to.table, (MultiRef<? extends DasTypedObject>)from.getRefColumns());
            int cnt = Math.max(refs.size(), targets.size());
            for (int i2 = 0; i2 < cnt; ++i2) {
                DeColumn ref = i2 < refs.size() ? refs.get(i2) : null;
                DeColumn target = i2 < targets.size() ? targets.get(i2) : null;
                to.refs.add(new DeForeignKey.Ref(ref, target));
            }
        }

        @Override
        @NotNull
        public DeForeignKey create(@NotNull SchemaExportHelper helper, @NotNull DasForeignKey from) {
            if (helper == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(4);
            }
            DeForeignKey deForeignKey = new DeForeignKey(DeForeignKeyExporter.getName(helper, (DasObject)from), DeTable.STUB, helper.getModel());
            if (deForeignKey == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(5);
            }
            return deForeignKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeForeignKeyExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeForeignKeyExporter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeIndexExporter
    extends DeTableChildExporter<DeIndex, DasIndex> {
        public DeIndexExporter() {
            super(DeIndex.class, DasIndex.class, ObjectKind.INDEX);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeIndex to, @NotNull DasIndex from) {
            if (helper == null) {
                DeIndexExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeIndexExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeIndexExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            for (DeColumn column : DeIndexExporter.getColumnsOrStubs(helper, to.table, (MultiRef<? extends DasTypedObject>)from.getColumnsRef())) {
                DasTypedObject editedColumn = (DasTypedObject)column.editedObject;
                to.items.add(new DeIndex.Item(column, editedColumn == null ? DasIndex.Sorting.NONE : from.getColumnSorting(editedColumn)));
            }
            to.unique = from.isUnique();
        }

        @Override
        @NotNull
        public DeIndex create(@NotNull SchemaExportHelper helper, @NotNull DasIndex from) {
            if (helper == null) {
                DeIndexExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeIndexExporter.$$$reportNull$$$0(4);
            }
            DeIndex deIndex = new DeIndex(DeIndexExporter.getName(helper, (DasObject)from), DeTable.STUB, helper.getModel());
            if (deIndex == null) {
                DeIndexExporter.$$$reportNull$$$0(5);
            }
            return deIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeIndexExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeIndexExporter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeColumnExporter
    extends DeTableChildExporter<DeColumn, DasColumn> {
        public DeColumnExporter() {
            super(DeColumn.class, DasColumn.class, ObjectKind.COLUMN);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeColumn to, @NotNull DasColumn from) {
            if (helper == null) {
                DeColumnExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeColumnExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeColumnExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            to.dataType = DatabaseDialogsHelper.createDdlBuilder(helper.getContext(), true).type((DasTypedObject)from).getStatement();
            to.defaultValue = from.getDefault();
            Set attrs = from.getTable().getColumnAttrs(from);
            if (attrs.contains(DasColumn.Attribute.AUTO_GENERATED)) {
                to.flags.add(DeColumn.Flag.AUTO_INC);
            }
            if (from.isNotNull()) {
                to.flags.add(DeColumn.Flag.NOT_NULL);
            }
        }

        @Override
        @NotNull
        public DeColumn create(@NotNull SchemaExportHelper helper, @NotNull DasColumn from) {
            if (helper == null) {
                DeColumnExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeColumnExporter.$$$reportNull$$$0(4);
            }
            DeColumn deColumn = new DeColumn(DeColumnExporter.getName(helper, (DasObject)from), DeTable.STUB, helper.getModel());
            if (deColumn == null) {
                DeColumnExporter.$$$reportNull$$$0(5);
            }
            return deColumn;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeColumnExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeColumnExporter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class DeTableChildExporter<De extends DeTableChild, Das extends DasTableChild>
    extends DeObjectExporter<De, Das> {
        public DeTableChildExporter(@NotNull Class<De> exportedClass, @NotNull Class<Das> exportableClass, @Nullable ObjectKind kindFilter) {
            if (exportedClass == null) {
                DeTableChildExporter.$$$reportNull$$$0(0);
            }
            if (exportableClass == null) {
                DeTableChildExporter.$$$reportNull$$$0(1);
            }
            super(exportedClass, exportableClass, kindFilter);
        }

        @NotNull
        public static DeTable getTable(@NotNull SchemaExportHelper helper, @NotNull DasTable table, boolean withChildren) {
            if (helper == null) {
                DeTableChildExporter.$$$reportNull$$$0(2);
            }
            if (table == null) {
                DeTableChildExporter.$$$reportNull$$$0(3);
            }
            DeTable deTable = (DeTable)helper.export((DasObject)table, withChildren);
            if (deTable == null) {
                DeTableChildExporter.$$$reportNull$$$0(4);
            }
            return deTable;
        }

        @NotNull
        public DeTable getTable(@NotNull SchemaExportHelper helper, @NotNull Das object) {
            if (helper == null) {
                DeTableChildExporter.$$$reportNull$$$0(5);
            }
            if (object == null) {
                DeTableChildExporter.$$$reportNull$$$0(6);
            }
            DeTable deTable = DeTableChildExporter.getTable(helper, object.getTable(), true);
            if (deTable == null) {
                DeTableChildExporter.$$$reportNull$$$0(7);
            }
            return deTable;
        }

        @NotNull
        public static List<DeColumn> getColumnsOrStubs(@NotNull SchemaExportHelper helper, @NotNull DeTable table, @NotNull MultiRef<? extends DasTypedObject> ref) {
            if (helper == null) {
                DeTableChildExporter.$$$reportNull$$$0(8);
            }
            if (table == null) {
                DeTableChildExporter.$$$reportNull$$$0(9);
            }
            if (ref == null) {
                DeTableChildExporter.$$$reportNull$$$0(10);
            }
            ArrayList res = ContainerUtil.newArrayListWithCapacity((int)ref.size());
            MultiRef.It it = ref.iterate();
            while (it.hasNext()) {
                String name = (String)it.next();
                DeColumn column = (DeColumn)helper.export((DasObject)it.resolve(), true);
                res.add(EditorModelUtil.stubbize(column, name, table, table.model));
            }
            ArrayList arrayList = res;
            if (arrayList == null) {
                DeTableChildExporter.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        @Override
        public boolean canExport(@NotNull Das object) {
            if (object == null) {
                DeTableChildExporter.$$$reportNull$$$0(12);
            }
            DasObject parent = object.getDasParent();
            return super.canExport(object) && parent != null && parent.getKind() == ObjectKind.TABLE;
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeTableChildExporter.$$$reportNull$$$0(13);
            }
            if (to == null) {
                DeTableChildExporter.$$$reportNull$$$0(14);
            }
            if (from == null) {
                DeTableChildExporter.$$$reportNull$$$0(15);
            }
            super.lightExport(helper, to, from);
            ((DeTableChild)to).table = this.getTable(helper, from);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportedClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportableClass";
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter";
                    break;
                }
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTable";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnsOrStubs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getTable";
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumnsOrStubs";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "canExport";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeTableExporter
    extends DeObjectExporter<DeTable, DasTable> {
        public DeTableExporter() {
            super(DeTable.class, DasTable.class, ObjectKind.TABLE);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeTable to, @NotNull DasTable from) {
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeTableExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeTableExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            to.parent = helper.export(from.getDasParent(), false);
            to.temporary = from.isTemporary();
        }

        @Override
        @NotNull
        public DeTable create(@NotNull SchemaExportHelper helper, @NotNull DasTable from) {
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeTableExporter.$$$reportNull$$$0(4);
            }
            DeTable deTable = new DeTable(DeTableExporter.getName(helper, (DasObject)from), null, helper.getModel());
            if (deTable == null) {
                DeTableExporter.$$$reportNull$$$0(5);
            }
            return deTable;
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull DeTable to, @NotNull DasTable from) {
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(6);
            }
            if (to == null) {
                DeTableExporter.$$$reportNull$$$0(7);
            }
            if (from == null) {
                DeTableExporter.$$$reportNull$$$0(8);
            }
            for (DasObject child : DasUtil.getTraversableChildren((DasObject)from, (DasModel)helper.getContext().getModel())) {
                this.processTableChild(helper, to, child);
            }
            if (to.keys.getPrimaryKey() == null) {
                this.processTableInlinePk(helper, to, from);
            }
        }

        protected void processTableChild(@NotNull SchemaExportHelper helper, @NotNull DeTable table, @NotNull DasObject child) {
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(9);
            }
            if (table == null) {
                DeTableExporter.$$$reportNull$$$0(10);
            }
            if (child == null) {
                DeTableExporter.$$$reportNull$$$0(11);
            }
            if (!helper.canExport(child)) {
                return;
            }
            Object exported = helper.export(child, true);
            if (exported instanceof DeColumn) {
                table.columns.add((DeColumn)exported);
            } else if (exported instanceof DeIndex) {
                table.indices.add((DeIndex)exported);
            } else if (exported instanceof DeForeignKey) {
                table.foreignKeys.add((DeForeignKey)exported);
            } else if (exported instanceof DeTableKey) {
                table.keys.add((DeTableKey)exported);
            } else if (exported instanceof DeConstraint) {
                table.constraints.add((DeConstraint)exported);
            }
        }

        protected void processTableInlinePk(@NotNull SchemaExportHelper helper, @NotNull DeTable table, @NotNull DasTable object) {
            JBIterable key2;
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(12);
            }
            if (table == null) {
                DeTableExporter.$$$reportNull$$$0(13);
            }
            if (object == null) {
                DeTableExporter.$$$reportNull$$$0(14);
            }
            if (!(key2 = DasUtil.getTraversableChildren((DasObject)object, (DasModel)helper.getContext().getModel()).filter(DasUtil.byKind((ObjectKind)ObjectKind.COLUMN)).filter(DasColumn.class).filter(child -> {
                if (object == null) {
                    DeTableExporter.$$$reportNull$$$0(15);
                }
                return object.getColumnAttrs(child).contains(DasColumn.Attribute.PRIMARY_KEY);
            }).collect()).isEmpty()) {
                DeTableKey primaryKey = new DeTableKey(table.name + "_autogenerated_pk", table, helper.getModel());
                for (DasColumn column : key2) {
                    primaryKey.columns.add(helper.export((DasObject)column, true));
                }
                if (table.keys.getPrimaryKey() != null) {
                    this.myLogger.warn("Already have primary key");
                }
                table.keys.setPrimaryKey(primaryKey);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter";
                    break;
                }
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "exportChildren";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "processTableChild";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "processTableInlinePk";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$processTableInlinePk$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DeObjectCloner
    extends DeObjectExporter<DeObject, DeObject> {
        public DeObjectCloner() {
            super(DeObject.class, DeObject.class, null);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeObject to, @NotNull DeObject from) {
            if (helper == null) {
                DeObjectCloner.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeObjectCloner.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeObjectCloner.$$$reportNull$$$0(2);
            }
            to.copyFrom(from, false, helper.getCopier());
            DeObject parent = to.getParent();
            if (parent != null && parent instanceof DeTable) {
                helper.export(parent.editedObject, true);
            }
            to.editedObject = from;
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull DeObject to, @NotNull DeObject from) {
            if (helper == null) {
                DeObjectCloner.$$$reportNull$$$0(3);
            }
            if (to == null) {
                DeObjectCloner.$$$reportNull$$$0(4);
            }
            if (from == null) {
                DeObjectCloner.$$$reportNull$$$0(5);
            }
            to.copyChildrenFrom(from, helper.getCopier());
        }

        @Override
        @NotNull
        public DeObject create(@NotNull SchemaExportHelper helper, @NotNull DeObject from) {
            if (helper == null) {
                DeObjectCloner.$$$reportNull$$$0(6);
            }
            if (from == null) {
                DeObjectCloner.$$$reportNull$$$0(7);
            }
            DeObject object = from.emptyClone(helper.getModel());
            if (from.getParent() == null && Iterables.contains(from.model.getModelRoots(), (Object)from)) {
                object.model.addRoot(object);
            }
            DeObject deObject = object;
            if (deObject == null) {
                DeObjectCloner.$$$reportNull$$$0(8);
            }
            return deObject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectCloner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectCloner";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "exportChildren";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class DeObjectExporter<De extends DeObject, Das extends DasObject>
    implements SchemaExporters.Exporter<De, Das> {
        protected final Logger myLogger;
        private final Class<De> myExportedClass;
        private final Class<Das> myExportableClass;
        private final ObjectKind myKindFilter;

        public DeObjectExporter(@NotNull Class<De> exportedClass, @NotNull Class<Das> exportableClass, @Nullable ObjectKind kindFilter) {
            if (exportedClass == null) {
                DeObjectExporter.$$$reportNull$$$0(0);
            }
            if (exportableClass == null) {
                DeObjectExporter.$$$reportNull$$$0(1);
            }
            this.myLogger = Logger.getInstance(this.getClass());
            this.myExportedClass = exportedClass;
            this.myExportableClass = exportableClass;
            this.myKindFilter = kindFilter;
        }

        @Override
        @NotNull
        public Class<De> getExportedClass() {
            Class<De> clazz = this.myExportedClass;
            if (clazz == null) {
                DeObjectExporter.$$$reportNull$$$0(2);
            }
            return clazz;
        }

        @Override
        @NotNull
        public Class<Das> getExportableClass() {
            Class<Das> clazz = this.myExportableClass;
            if (clazz == null) {
                DeObjectExporter.$$$reportNull$$$0(3);
            }
            return clazz;
        }

        @Override
        public int compareTo(SchemaExporters.Exporter<? extends DeObject, ? extends DasObject> o) {
            return Comparing.compare((int)System.identityHashCode(this), (int)System.identityHashCode(o));
        }

        @Override
        public boolean canExport(@NotNull Das object) {
            if (object == null) {
                DeObjectExporter.$$$reportNull$$$0(4);
            }
            return this.myKindFilter == null || this.myKindFilter == object.getKind();
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeObjectExporter.$$$reportNull$$$0(5);
            }
            if (to == null) {
                DeObjectExporter.$$$reportNull$$$0(6);
            }
            if (from == null) {
                DeObjectExporter.$$$reportNull$$$0(7);
            }
            ((DeObject)to).comment = StringUtil.nullize((String)from.getComment());
            ((DeObject)to).editedObject = from;
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeObjectExporter.$$$reportNull$$$0(8);
            }
            if (to == null) {
                DeObjectExporter.$$$reportNull$$$0(9);
            }
            if (from == null) {
                DeObjectExporter.$$$reportNull$$$0(10);
            }
            assert (DasUtil.getTraversableChildren(from, (DasModel)helper.getContext().getModel()).isEmpty());
        }

        @NotNull
        protected static String getName(@NotNull SchemaExportHelper helper, @NotNull DasObject object) {
            if (helper == null) {
                DeObjectExporter.$$$reportNull$$$0(11);
            }
            if (object == null) {
                DeObjectExporter.$$$reportNull$$$0(12);
            }
            String name = object.getName();
            if (!DbSqlUtil.isSqlObject(object) || !DbSqlUtil.isQuoted(object)) {
                String string = name;
                if (string == null) {
                    DeObjectExporter.$$$reportNull$$$0(13);
                }
                return string;
            }
            String string = helper.getContext().getDialect().quoteIdentifier(name, true, false);
            if (string == null) {
                DeObjectExporter.$$$reportNull$$$0(14);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportedClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportableClass";
                    break;
                }
                case 2: 
                case 3: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter";
                    break;
                }
                case 4: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 5: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExportedClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExportableClass";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 13: 
                case 14: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canExport";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "exportChildren";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

