/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.fix;

import com.intellij.database.schemaEditor.fix.DdlGraphFixing;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixCyclicCreateTableFk
implements DdlGraphFixing.CycleFixer {
    @Override
    public boolean fixCycle(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DdlGraph graph, @NotNull List<DdlOperationKey> cycle) {
        if (generator == null) {
            FixCyclicCreateTableFk.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            FixCyclicCreateTableFk.$$$reportNull$$$0(1);
        }
        if (graph == null) {
            FixCyclicCreateTableFk.$$$reportNull$$$0(2);
        }
        if (cycle == null) {
            FixCyclicCreateTableFk.$$$reportNull$$$0(3);
        }
        for (int i2 = 0; i2 < cycle.size(); ++i2) {
            if (!FixCyclicCreateTableFk.processItem(generator, builder, cycle, i2)) continue;
            return true;
        }
        return false;
    }

    private static boolean processItem(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull List<DdlOperationKey> cycle, int idx) {
        Set keys;
        if (generator == null) {
            FixCyclicCreateTableFk.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            FixCyclicCreateTableFk.$$$reportNull$$$0(5);
        }
        if (cycle == null) {
            FixCyclicCreateTableFk.$$$reportNull$$$0(6);
        }
        DdlOperationKey current = cycle.get(idx);
        DdlOperationKey next = cycle.get((idx + 1) % cycle.size());
        if (current.operation != DasDdlOperations.CREATE_TABLE || next.operation != DasDdlOperations.CREATE_TABLE) {
            return false;
        }
        UserDataHolder data = builder.getData(current);
        JBIterable<DeForeignKey> toFix = FixCyclicCreateTableFk.getKeysToFix((DeTable)current.target, (DeTable)next.target, data);
        if (toFix.isEmpty()) {
            return false;
        }
        generator.removeOperation(builder, current.operation, current.target, data);
        if (data == null) {
            data = builder.newData(null);
        }
        if ((keys = (Set)DasDdlOperations.CreateTableOperation.DEFERRED_FKS.get(data)) == null) {
            keys = ContainerUtil.newHashSet();
            DasDdlOperations.CreateTableOperation.DEFERRED_FKS.set(data, (Object)keys);
        }
        for (DeForeignKey key2 : toFix) {
            keys.add(key2);
        }
        generator.addOperation(builder, current.operation, current.target, data);
        return true;
    }

    private static JBIterable<DeForeignKey> getKeysToFix(@NotNull DeTable table, @NotNull DeTable target, @Nullable UserDataHolder data) {
        if (table == null) {
            FixCyclicCreateTableFk.$$$reportNull$$$0(7);
        }
        if (target == null) {
            FixCyclicCreateTableFk.$$$reportNull$$$0(8);
        }
        Set<DeForeignKey> keys = DasDdlOperations.CreateTableOperation.getDeferredFks(data);
        return JBIterable.from(table.foreignKeys).filter(key2 -> {
            if (target == null) {
                FixCyclicCreateTableFk.$$$reportNull$$$0(9);
            }
            return key2.target == target && !keys.contains(key2);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cycle";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/fix/FixCyclicCreateTableFk";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fixCycle";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processItem";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getKeysToFix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getKeysToFix$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

