/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationGenerator;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeConstraint;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.schemaEditor.model.DeTrigger;
import com.intellij.database.schemaEditor.model.DeView;
import com.intellij.database.schemaEditor.operations.AlterViewOperation;
import com.intellij.database.schemaEditor.operations.CreateDropRoutineOperation;
import com.intellij.database.schemaEditor.operations.TruncateTableOperation;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DasDdlOperations {
    public static final DdlOperation RECOMPILE = new DdlOperation("recompile", new DdlOperation[0]);
    public static final DdlOperation UNABLE = new DdlOperation("unable", new DdlOperation[0]);
    public static final DdlOperation DROP_TABLE = new DdlOperation("drop-table", DdlOperation.DROP);
    public static final DdlOperation CREATE_TABLE = new DdlOperation("create-table", DdlOperation.CREATE);
    public static final DdlOperation DROP_COLUMN = new DdlOperation("drop-column", DdlOperation.DROP);
    public static final DdlOperation CREATE_COLUMN = new DdlOperation("create-column", DdlOperation.CREATE);
    public static final DdlOperation DROP_INDEX = new DdlOperation("drop-index", DdlOperation.DROP);
    public static final DdlOperation CREATE_INDEX = new DdlOperation("create-index", DdlOperation.CREATE);
    public static final DdlOperation DROP_DATABASE = new DdlOperation("drop-database", DdlOperation.DROP);
    public static final DdlOperation CREATE_DATABASE = new DdlOperation("create-database", DdlOperation.CREATE);
    public static final DdlOperation ALTER_DATABASE = new DdlOperation("alter-database", DdlOperation.ALTER);
    public static final DdlOperation RENAME_DATABASE = new DdlOperation("rename-database", DdlOperation.RENAME);
    public static final DdlOperation DROP_SCHEMA = new DdlOperation("drop-schema", DdlOperation.DROP);
    public static final DdlOperation CREATE_SCHEMA = new DdlOperation("create-schema", DdlOperation.CREATE);
    public static final DdlOperation ALTER_SCHEMA = new DdlOperation("alter-schema", DdlOperation.ALTER);
    public static final DdlOperation RENAME_SCHEMA = new DdlOperation("rename-schema", DdlOperation.RENAME);
    public static final DdlOperation DROP_PRIMARY_KEY = new DdlOperation("drop-primary-key", DdlOperation.DROP);
    public static final DdlOperation CREATE_PRIMARY_KEY = new DdlOperation("create-primary-key", DdlOperation.CREATE);
    public static final DdlOperation DROP_ALT_KEY = new DdlOperation("drop-alt-key", DdlOperation.DROP);
    public static final DdlOperation CREATE_ALT_KEY = new DdlOperation("create-alt-key", DdlOperation.CREATE);
    public static final DdlOperation DROP_CONSTRAINT = new DdlOperation("drop-constraint", DdlOperation.DROP);
    public static final DdlOperation CREATE_CONSTRAINT = new DdlOperation("create-constraint", DdlOperation.CREATE);
    public static final DdlOperation DROP_FOREIGN_KEY = new DdlOperation("drop-foreign-key", DdlOperation.DROP);
    public static final DdlOperation CREATE_FOREIGN_KEY = new DdlOperation("create-foreign-key", DdlOperation.CREATE);
    public static final DdlOperation DROP_TRIGGER = new DdlOperation("drop-trigger", DdlOperation.DROP);
    public static final DdlOperation ALTER_COLUMN = new DdlOperation("alter-column", DdlOperation.ALTER);
    public static final DdlOperation ALTER_TABLE_KEY = new DdlOperation("alter-table-key", DdlOperation.ALTER);
    public static final DdlOperation ALTER_CONSTRAINT = new DdlOperation("alter-constraint", DdlOperation.ALTER);
    public static final DdlOperation ALTER_INDEX = new DdlOperation("alter-index", DdlOperation.ALTER);
    public static final DdlOperation ALTER_FOREIGN_KEY = new DdlOperation("alter-foreign-key", DdlOperation.ALTER);
    public static final DdlOperation ALTER_TABLE = new DdlOperation("alter-table", DdlOperation.ALTER);
    public static final DdlOperation RENAME_TABLE = new DdlOperation("rename-table", DdlOperation.RENAME);
    public static final DdlOperation RENAME_VIEW = new DdlOperation("rename-view", DdlOperation.RENAME);
    public static final DdlOperation REORDER_COLUMNS = new DdlOperation("reorder-columns", new DdlOperation[0]);
    public static final DdlOperation ALTER_ROUTINE = new DdlOperation("alter-routine", DdlOperation.ALTER);
    public static final DdlOperation ALTER_VIEW = new DdlOperation("alter-view", DdlOperation.ALTER);
    public static final DdlOperation RENAME_ROUTINE = new DdlOperation("rename-routine", DdlOperation.RENAME);
    public static final DdlOperation TRUNCATE_TABLE = new DdlOperation("truncate-table", new DdlOperation[0]);
    public static final DdlOperation REFRESH = new DdlOperation("refresh", new DdlOperation[0]);
    public static final DdlOperation REFRESH_MATERIALIZED_VIEW = new DdlOperation("refresh-materialized-view", REFRESH);
    public static final Condition<DeObject> PRIMARY_KEY_CONDITION = object -> ((DeTableKey)object).isPrimary();
    public static final Condition<DeObject> ALT_KEY_CONDITION = Conditions.not(PRIMARY_KEY_CONDITION);

    @NotNull
    public static <T> UserDataHolder set(@NotNull UserDataHolder data, @NotNull Key<T> key2, T value) {
        if (data == null) {
            DasDdlOperations.$$$reportNull$$$0(0);
        }
        if (key2 == null) {
            DasDdlOperations.$$$reportNull$$$0(1);
        }
        key2.set(data, value);
        UserDataHolder userDataHolder = data;
        if (userDataHolder == null) {
            DasDdlOperations.$$$reportNull$$$0(2);
        }
        return userDataHolder;
    }

    @NotNull
    public static DeObject getAlterFrom(@NotNull DeObject das, @Nullable UserDataHolder data) {
        if (das == null) {
            DasDdlOperations.$$$reportNull$$$0(3);
        }
        DeObject deObject = (DeObject)ObjectUtils.chooseNotNull((Object)DdlGraph.ALTER_FROM.get(data), (Object)das);
        if (deObject == null) {
            DasDdlOperations.$$$reportNull$$$0(4);
        }
        return deObject;
    }

    @NotNull
    public static DeObject getAlterTo(@NotNull DeObject das, @Nullable UserDataHolder data) {
        if (das == null) {
            DasDdlOperations.$$$reportNull$$$0(5);
        }
        DeObject deObject = (DeObject)ObjectUtils.chooseNotNull((Object)DdlGraph.ALTER_TO.get(data), (Object)das);
        if (deObject == null) {
            DasDdlOperations.$$$reportNull$$$0(6);
        }
        return deObject;
    }

    @NotNull
    public static DeObject getAlterFrom(@NotNull DdlOperationKey key2, @NotNull DdlGraphBuilder builder) {
        if (key2 == null) {
            DasDdlOperations.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            DasDdlOperations.$$$reportNull$$$0(8);
        }
        DeObject deObject = DasDdlOperations.getAlterFrom(key2.target, builder.getData(key2));
        if (deObject == null) {
            DasDdlOperations.$$$reportNull$$$0(9);
        }
        return deObject;
    }

    @NotNull
    public static DeObject getAlterTo(@NotNull DdlOperationKey key2, @NotNull DdlGraphBuilder builder) {
        if (key2 == null) {
            DasDdlOperations.$$$reportNull$$$0(10);
        }
        if (builder == null) {
            DasDdlOperations.$$$reportNull$$$0(11);
        }
        DeObject deObject = DasDdlOperations.getAlterTo(key2.target, builder.getData(key2));
        if (deObject == null) {
            DasDdlOperations.$$$reportNull$$$0(12);
        }
        return deObject;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectCreateKeys(@Nullable DeObject object) {
        JBIterable<DdlOperationKey> jBIterable = DdlGraph.notNullize(object == null ? null : new DdlOperationKey(object, DdlOperation.CREATE));
        if (jBIterable == null) {
            DasDdlOperations.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectDropKeys(@Nullable DeObject object) {
        JBIterable<DdlOperationKey> jBIterable = DdlGraph.notNullize(object == null ? null : new DdlOperationKey(object, DdlOperation.DROP));
        if (jBIterable == null) {
            DasDdlOperations.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectPreRenameKeys(@Nullable DeObject object) {
        if (object == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DasDdlOperations.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)new DdlOperationKey(object, DdlOperation.RENAME));
        if (jBIterable == null) {
            DasDdlOperations.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectPostRenameKeys(@Nullable DeObject object) {
        if (object == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DasDdlOperations.$$$reportNull$$$0(17);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)new DdlOperationKey(object, DdlOperation.POST_RENAME));
        if (jBIterable == null) {
            DasDdlOperations.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectRenameNCreateKeys(@Nullable DeObject object) {
        JBIterable jBIterable = DasDdlOperations.getObjectCreateKeys(object).append(DasDdlOperations.getObjectPostRenameKeys(object));
        if (jBIterable == null) {
            DasDdlOperations.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectRenameNDropKeys(@Nullable DeObject object) {
        JBIterable jBIterable = DasDdlOperations.getObjectDropKeys(object).append(DasDdlOperations.getObjectPreRenameKeys(object));
        if (jBIterable == null) {
            DasDdlOperations.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectsRenameNCreateKeys(@NotNull Iterable<? extends DeObject> objects) {
        if (objects == null) {
            DasDdlOperations.$$$reportNull$$$0(21);
        }
        JBIterable jBIterable = JBIterable.from(objects).flatten(DasDdlOperations::getObjectRenameNCreateKeys);
        if (jBIterable == null) {
            DasDdlOperations.$$$reportNull$$$0(22);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectsCreateKeys(@NotNull Iterable<? extends DeObject> objects) {
        if (objects == null) {
            DasDdlOperations.$$$reportNull$$$0(23);
        }
        JBIterable jBIterable = JBIterable.from(objects).flatten(DasDdlOperations::getObjectCreateKeys);
        if (jBIterable == null) {
            DasDdlOperations.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectsRenameNDropKeys(@NotNull Iterable<? extends DeObject> objects) {
        if (objects == null) {
            DasDdlOperations.$$$reportNull$$$0(25);
        }
        JBIterable jBIterable = JBIterable.from(objects).flatten(DasDdlOperations::getObjectRenameNDropKeys);
        if (jBIterable == null) {
            DasDdlOperations.$$$reportNull$$$0(26);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectsDropKeys(@NotNull Iterable<? extends DeObject> objects) {
        if (objects == null) {
            DasDdlOperations.$$$reportNull$$$0(27);
        }
        JBIterable jBIterable = JBIterable.from(objects).flatten(DasDdlOperations::getObjectDropKeys);
        if (jBIterable == null) {
            DasDdlOperations.$$$reportNull$$$0(28);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "das";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "set";
                break;
            }
            case 4: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlterFrom";
                break;
            }
            case 6: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlterTo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectCreateKeys";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectDropKeys";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectPreRenameKeys";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectPostRenameKeys";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectRenameNCreateKeys";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectRenameNDropKeys";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsRenameNCreateKeys";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsCreateKeys";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsRenameNDropKeys";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsDropKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAlterFrom";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAlterTo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsRenameNCreateKeys";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsCreateKeys";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsRenameNDropKeys";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsDropKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DefaultDdlOperationsBuilder {
        protected static final Map<Class<? extends DdlOperationGenerator<?>>, DdlOperationGenerator<?>> myOpsCache = FactoryMap.create(opClass -> {
            try {
                Constructor constructor = opClass.getConstructor(new Class[0]);
                return (DdlOperationGenerator)constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)"Operation should have () ctor");
            }
            catch (Exception e) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
                return null;
            }
        });
        protected final Map<DdlOperation, DdlOperationGenerator<?>> myOperations;
        protected final MultiMap<DdlOperation, DdlOperation> mySelectionOps;

        public DefaultDdlOperationsBuilder(@NotNull DatabaseDialect dialect) {
            if (dialect == null) {
                DefaultDdlOperationsBuilder.$$$reportNull$$$0(0);
            }
            this.myOperations = ContainerUtil.newHashMap();
            this.mySelectionOps = MultiMap.createSet();
            this.addOp(AlterCommentOperation.class);
            this.addOp(TemporaryRenameOperation.class);
            this.addOp(DropTableOperation.class);
            this.addOp(AlterTableOperation.class);
            this.addOp(CreateTableOperation.class);
            this.addOp(RenameTableOperation.class);
            this.addOp(RenameViewOperation.class);
            this.addOp(AlterViewOperation.class);
            this.addOp(DropColumnOperation.class);
            this.addOp(CreateColumnOperation.class);
            this.addOp(AlterColumnOperation.class);
            this.addOp(DropIndexOperation.class);
            this.addOp(CreateIndexOperation.class);
            this.addOp(DropPrimaryKeyOperation.class);
            this.addOp(CreatePrimaryKeyOperation.class);
            this.addOp(DropAltKeyOperation.class);
            this.addOp(CreateAltKeyOperation.class);
            this.addOp(DropCreateIndexOperation.class);
            this.addOp(DropCreateTableKeyOperation.class);
            this.addOp(DropCreateConstraintOperation.class);
            this.addOp(DropCreateForeignKeyOperation.class);
            this.addOp(DropConstraintOperation.class);
            this.addOp(CreateConstraintOperation.class);
            this.addOp(DropForeignKeyOperation.class);
            this.addOp(CreateForeignKeyOperation.class);
            this.addOp(DropTriggerOperation.class);
            this.addOp(CreateDropRoutineOperation.class);
            this.addOp(TruncateTableOperation.class);
            this.addOp(ReorderColumnsOperation.class);
            this.addOp(CreateDatabaseOperation.class);
            this.addOp(DropDatabaseOperation.class);
            this.addOp(AlterDatabaseOperation.class);
            this.addOp(RenameDatabaseOperation.class);
            this.addOp(CreateSchemaOperation.class);
            this.addOp(DropSchemaOperation.class);
            this.addOp(AlterSchemaOperation.class);
            this.addOp(RenameSchemaOperation.class);
            this.addSels(DdlOperation.CREATE).add(CREATE_TABLE).add(CREATE_COLUMN).add(CREATE_INDEX).add(CREATE_PRIMARY_KEY).add(CREATE_ALT_KEY).add(CREATE_CONSTRAINT).add(CREATE_FOREIGN_KEY).add(CREATE_SCHEMA).add(CREATE_DATABASE);
            this.addSels(DdlOperation.DROP).add(DROP_TABLE).add(DROP_COLUMN).add(DROP_INDEX).add(DROP_PRIMARY_KEY).add(DROP_ALT_KEY).add(DROP_CONSTRAINT).add(DROP_FOREIGN_KEY).add(DROP_TRIGGER).add(DROP_SCHEMA).add(DROP_DATABASE);
            this.addSels(DdlOperation.ALTER).add(ALTER_TABLE).add(ALTER_COLUMN).add(ALTER_INDEX).add(ALTER_TABLE_KEY).add(ALTER_CONSTRAINT).add(ALTER_FOREIGN_KEY).add(ALTER_ROUTINE).add(ALTER_VIEW).add(ALTER_SCHEMA).add(ALTER_DATABASE);
        }

        protected DefaultDdlOperationsBuilder addOp(@NotNull Class<? extends DdlOperationGenerator<?>> clazz) {
            if (clazz == null) {
                DefaultDdlOperationsBuilder.$$$reportNull$$$0(1);
            }
            DdlOperationGenerator<?> op = this.create(clazz);
            this.addOperation(op);
            return this;
        }

        protected void addOperation(@NotNull DdlOperationGenerator<?> op) {
            if (op == null) {
                DefaultDdlOperationsBuilder.$$$reportNull$$$0(2);
            }
            this.myOperations.remove(op.getOperation());
            this.myOperations.put(op.getOperation(), op);
        }

        protected Proxy addSels(@NotNull DdlOperation sel) {
            if (sel == null) {
                DefaultDdlOperationsBuilder.$$$reportNull$$$0(3);
            }
            return new Proxy(sel);
        }

        @NotNull
        protected DdlOperationGenerator<?> create(@NotNull Class<? extends DdlOperationGenerator<?>> clazz) {
            if (clazz == null) {
                DefaultDdlOperationsBuilder.$$$reportNull$$$0(4);
            }
            DdlOperationGenerator<?> ddlOperationGenerator = myOpsCache.get(clazz);
            if (ddlOperationGenerator == null) {
                DefaultDdlOperationsBuilder.$$$reportNull$$$0(5);
            }
            return ddlOperationGenerator;
        }

        @NotNull
        public DdlOperations build() {
            DdlOperations operations = new DdlOperations();
            for (DdlOperationGenerator<?> operation : this.myOperations.values()) {
                operations.add(operation);
            }
            for (Map.Entry entry : this.mySelectionOps.entrySet()) {
                OperationSelector selector = new OperationSelector((DdlOperation)entry.getKey());
                for (DdlOperation operation : (Collection)entry.getValue()) {
                    selector.add(operation);
                }
                operations.add(selector);
            }
            DdlOperations ddlOperations = operations;
            if (ddlOperations == null) {
                DefaultDdlOperationsBuilder.$$$reportNull$$$0(6);
            }
            return ddlOperations;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "op";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sel";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addOp";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addSels";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public class Proxy {
            private final DdlOperation mySelector;

            public Proxy(DdlOperation selector) {
                if (DefaultDdlOperationsBuilder.this == null) {
                    Proxy.$$$reportNull$$$0(0);
                }
                if (selector == null) {
                    Proxy.$$$reportNull$$$0(1);
                }
                this.mySelector = selector;
            }

            public Proxy add(@NotNull DdlOperation value) {
                if (value == null) {
                    Proxy.$$$reportNull$$$0(2);
                }
                Collection modifiable = DefaultDdlOperationsBuilder.this.mySelectionOps.getModifiable((Object)this.mySelector);
                modifiable.removeAll(Arrays.asList(value.getInterfaces()));
                modifiable.add(value);
                return this;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "this$0";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selector";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder$Proxy";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "add";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class DropCreateForeignKeyOperation
    extends DropCreateOperation<DeForeignKey> {
        public DropCreateForeignKeyOperation() {
            super(ALTER_FOREIGN_KEY, DeForeignKey.class, ObjectKind.FOREIGN_KEY, DdlOperation.DROP, DdlOperation.CREATE);
        }
    }

    public static class DropCreateConstraintOperation
    extends DropCreateOperation<DeConstraint> {
        public DropCreateConstraintOperation() {
            super(ALTER_CONSTRAINT, DeConstraint.class, null, DdlOperation.DROP, DdlOperation.CREATE);
        }
    }

    public static class DropCreateTableKeyOperation
    extends DropCreateOperation<DeTableKey> {
        public DropCreateTableKeyOperation() {
            super(ALTER_TABLE_KEY, DeTableKey.class, ObjectKind.KEY, DdlOperation.DROP, DdlOperation.CREATE);
        }
    }

    public static class DropCreateIndexOperation
    extends DropCreateOperation<DeIndex> {
        public DropCreateIndexOperation() {
            super(ALTER_INDEX, DeIndex.class, ObjectKind.INDEX, DdlOperation.DROP, DdlOperation.CREATE);
        }
    }

    static class DropSchemaOperation
    extends DdlOperationGeneratorSimple<DeNamespace> {
        public DropSchemaOperation() {
            super(DROP_SCHEMA, DeNamespace.class, ObjectKind.SCHEMA);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeNamespace object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                DropSchemaOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                DropSchemaOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                DropSchemaOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropSchema(builder, object).newStatement();
            if (ddlBuilder == null) {
                DropSchemaOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropSchemaOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropSchemaOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DropDatabaseOperation
    extends DdlOperationGeneratorSimple<DeNamespace> {
        public DropDatabaseOperation() {
            super(DROP_DATABASE, DeNamespace.class, ObjectKind.DATABASE);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeNamespace object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                DropDatabaseOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                DropDatabaseOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                DropDatabaseOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropDatabase(builder, object).newStatement();
            if (ddlBuilder == null) {
                DropDatabaseOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropDatabaseOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropDatabaseOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class RenameSchemaOperation
    extends DdlOperationGeneratorSimple<DeNamespace> {
        public RenameSchemaOperation() {
            super(RENAME_SCHEMA, DeNamespace.class, ObjectKind.SCHEMA);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeNamespace object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                RenameSchemaOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                RenameSchemaOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                RenameSchemaOperation.$$$reportNull$$$0(2);
            }
            DeObject to = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            DdlBuilder ddlBuilder = builder.getDialect().sqlRenameSchema(builder, object, to.getName()).newStatement();
            if (ddlBuilder == null) {
                RenameSchemaOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameSchemaOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameSchemaOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class RenameDatabaseOperation
    extends DdlOperationGeneratorSimple<DeNamespace> {
        public RenameDatabaseOperation() {
            super(RENAME_DATABASE, DeNamespace.class, ObjectKind.DATABASE);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeNamespace object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                RenameDatabaseOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                RenameDatabaseOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                RenameDatabaseOperation.$$$reportNull$$$0(2);
            }
            DeObject to = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            DdlBuilder ddlBuilder = builder.getDialect().sqlRenameDatabase(builder, object, to.getName()).newStatement();
            if (ddlBuilder == null) {
                RenameDatabaseOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameDatabaseOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameDatabaseOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class AlterSchemaOperation
    extends DdlOperationGeneratorSimple<DeNamespace> {
        public AlterSchemaOperation() {
            super(ALTER_SCHEMA, DeNamespace.class, ObjectKind.SCHEMA);
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeNamespace from, @Nullable UserDataHolder data) {
            if (generator == null) {
                AlterSchemaOperation.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                AlterSchemaOperation.$$$reportNull$$$0(1);
            }
            if (from == null) {
                AlterSchemaOperation.$$$reportNull$$$0(2);
            }
            assert (data != null);
            DeObject to = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            if (DasUtil.nameEqual((DasObject)to, (String)from.getName(), (CasingProvider)from.model)) {
                DdlGenerator ddlGenerator = generator;
                if (ddlGenerator == null) {
                    AlterSchemaOperation.$$$reportNull$$$0(3);
                }
                return ddlGenerator;
            }
            generator.addOperation(builder, RENAME_SCHEMA, from, data);
            DdlGenerator ddlGenerator = generator;
            if (ddlGenerator == null) {
                AlterSchemaOperation.$$$reportNull$$$0(4);
            }
            return ddlGenerator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterSchemaOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterSchemaOperation";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addToBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addToBuilder";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class AlterDatabaseOperation
    extends DdlOperationGeneratorSimple<DeNamespace> {
        public AlterDatabaseOperation() {
            super(ALTER_DATABASE, DeNamespace.class, ObjectKind.DATABASE);
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeNamespace from, @Nullable UserDataHolder data) {
            if (generator == null) {
                AlterDatabaseOperation.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                AlterDatabaseOperation.$$$reportNull$$$0(1);
            }
            if (from == null) {
                AlterDatabaseOperation.$$$reportNull$$$0(2);
            }
            assert (data != null);
            DeObject to = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            if (DasUtil.nameEqual((DasObject)to, (String)from.getName(), (CasingProvider)from.model)) {
                DdlGenerator ddlGenerator = generator;
                if (ddlGenerator == null) {
                    AlterDatabaseOperation.$$$reportNull$$$0(3);
                }
                return ddlGenerator;
            }
            generator.addOperation(builder, RENAME_DATABASE, from, data);
            DdlGenerator ddlGenerator = generator;
            if (ddlGenerator == null) {
                AlterDatabaseOperation.$$$reportNull$$$0(4);
            }
            return ddlGenerator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterDatabaseOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterDatabaseOperation";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addToBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addToBuilder";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CreateSchemaOperation
    extends DdlOperationGeneratorSimple<DeNamespace> {
        public CreateSchemaOperation() {
            super(CREATE_SCHEMA, DeNamespace.class, ObjectKind.SCHEMA);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeNamespace object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                CreateSchemaOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                CreateSchemaOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                CreateSchemaOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlCreateSchema(builder, object).newStatement();
            if (ddlBuilder == null) {
                CreateSchemaOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateSchemaOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateSchemaOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CreateDatabaseOperation
    extends DdlOperationGeneratorSimple<DeNamespace> {
        public CreateDatabaseOperation() {
            super(CREATE_DATABASE, DeNamespace.class, ObjectKind.DATABASE);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeNamespace object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                CreateDatabaseOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                CreateDatabaseOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                CreateDatabaseOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlCreateDatabase(builder, object).newStatement();
            if (ddlBuilder == null) {
                CreateDatabaseOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateDatabaseOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateDatabaseOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CreateForeignKeyOperation
    extends DdlOperationGeneratorSimple<DeForeignKey> {
        public CreateForeignKeyOperation() {
            super(CREATE_FOREIGN_KEY, DeForeignKey.class, ObjectKind.FOREIGN_KEY);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeForeignKey object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                CreateForeignKeyOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                CreateForeignKeyOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                CreateForeignKeyOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlAddForeignKey(builder, object, true, false).newStatement();
            if (ddlBuilder == null) {
                CreateForeignKeyOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeForeignKey object, @Nullable UserDataHolder data) {
            if (object == null) {
                CreateForeignKeyOperation.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object.table).append(DasDdlOperations.getObjectsRenameNCreateKeys(object.getColumns())).append(DasDdlOperations.getObjectRenameNCreateKeys(object.target)).append(DasDdlOperations.getObjectsRenameNCreateKeys(object.getTargetColumns()));
            if (jBIterable == null) {
                CreateForeignKeyOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateForeignKeyOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateForeignKeyOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencies";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DropTriggerOperation
    extends DdlOperationGeneratorSimple<DeTrigger> {
        public DropTriggerOperation() {
            super(DROP_TRIGGER, DeTrigger.class, ObjectKind.TRIGGER);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTrigger object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                DropTriggerOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                DropTriggerOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                DropTriggerOperation.$$$reportNull$$$0(2);
            }
            if (object.getBaseTrigger() == null) {
                builder.comment("No trigger");
                DdlBuilder ddlBuilder = builder;
                if (ddlBuilder == null) {
                    DropTriggerOperation.$$$reportNull$$$0(3);
                }
                return ddlBuilder;
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropTrigger(builder, object.getBaseTrigger()).newStatement();
            if (ddlBuilder == null) {
                DropTriggerOperation.$$$reportNull$$$0(4);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull DeTrigger object, @Nullable UserDataHolder data) {
            if (object == null) {
                DropTriggerOperation.$$$reportNull$$$0(5);
            }
            JBIterable<DdlOperationKey> jBIterable = DasDdlOperations.getObjectRenameNDropKeys(object.parent);
            if (jBIterable == null) {
                DropTriggerOperation.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropTriggerOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropTriggerOperation";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependants";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DropForeignKeyOperation
    extends DdlOperationGeneratorSimple<DeForeignKey> {
        public DropForeignKeyOperation() {
            super(DROP_FOREIGN_KEY, DeForeignKey.class, ObjectKind.FOREIGN_KEY);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeForeignKey object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                DropForeignKeyOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                DropForeignKeyOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                DropForeignKeyOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropForeignKey(builder, object.getTable(), object, object.getName()).newStatement();
            if (ddlBuilder == null) {
                DropForeignKeyOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull DeForeignKey object, @Nullable UserDataHolder data) {
            if (object == null) {
                DropForeignKeyOperation.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNDropKeys(object.table).append(DasDdlOperations.getObjectsRenameNDropKeys(object.getColumns())).append(DasDdlOperations.getObjectRenameNDropKeys(object.target)).append(DasDdlOperations.getObjectsRenameNDropKeys(object.getTargetColumns()));
            if (jBIterable == null) {
                DropForeignKeyOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropForeignKeyOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropForeignKeyOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependants";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CreateConstraintOperation
    extends DdlOperationGeneratorSimple<DeConstraint> {
        public CreateConstraintOperation() {
            super(CREATE_CONSTRAINT, DeConstraint.class, null);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeConstraint object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                CreateConstraintOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                CreateConstraintOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                CreateConstraintOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlAddUniqueConstraint(builder, object.getTable(), object, object.getName(), JBIterable.from((Iterable)object.getColumnsRef().resolveObjects()).filter(DasColumn.class).toList()).newStatement();
            if (ddlBuilder == null) {
                CreateConstraintOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeConstraint object, @Nullable UserDataHolder data) {
            if (object == null) {
                CreateConstraintOperation.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object.table).append(DasDdlOperations.getObjectsRenameNCreateKeys(object.columns));
            if (jBIterable == null) {
                CreateConstraintOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateConstraintOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateConstraintOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencies";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DropConstraintOperation
    extends DdlOperationGeneratorSimple<DeConstraint> {
        public DropConstraintOperation() {
            super(DROP_CONSTRAINT, DeConstraint.class, null);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeConstraint object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                DropConstraintOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                DropConstraintOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                DropConstraintOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropConstraint(builder, object.getTable(), object, object.getName()).newStatement();
            if (ddlBuilder == null) {
                DropConstraintOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull DeConstraint object, @Nullable UserDataHolder data) {
            if (object == null) {
                DropConstraintOperation.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNDropKeys(object.table).append(DasDdlOperations.getObjectsRenameNDropKeys(object.columns));
            if (jBIterable == null) {
                DropConstraintOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropConstraintOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropConstraintOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependants";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CreateAltKeyOperation
    extends DdlOperationGeneratorSimple<DeTableKey> {
        public CreateAltKeyOperation() {
            super(CREATE_ALT_KEY, DeTableKey.class, ObjectKind.KEY);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTableKey object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                CreateAltKeyOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                CreateAltKeyOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                CreateAltKeyOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlAddUniqueConstraint(builder, object.table, object, object.name, ContainerUtil.newArrayList(object.getColumns())).newStatement();
            if (ddlBuilder == null) {
                CreateAltKeyOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeTableKey object, @Nullable UserDataHolder data) {
            if (object == null) {
                CreateAltKeyOperation.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object.table).append(DasDdlOperations.getObjectsRenameNCreateKeys(object.columns));
            if (jBIterable == null) {
                CreateAltKeyOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @Override
        public boolean isSupported(@NotNull DdlOperation.DdlOperationSupport support, @NotNull DeObject obj) {
            if (support == null) {
                CreateAltKeyOperation.$$$reportNull$$$0(6);
            }
            if (obj == null) {
                CreateAltKeyOperation.$$$reportNull$$$0(7);
            }
            return super.isSupported(support, obj) && !((DeTableKey)obj).isPrimary();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateAltKeyOperation";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateAltKeyOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencies";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CreatePrimaryKeyOperation
    extends DdlOperationGeneratorSimple<DeTableKey> {
        public CreatePrimaryKeyOperation() {
            super(CREATE_PRIMARY_KEY, DeTableKey.class, ObjectKind.KEY);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTableKey object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                CreatePrimaryKeyOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                CreatePrimaryKeyOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                CreatePrimaryKeyOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlAddPrimaryKey(builder, object).newStatement();
            if (ddlBuilder == null) {
                CreatePrimaryKeyOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeTableKey object, @Nullable UserDataHolder data) {
            DeTable table;
            if (object == null) {
                CreatePrimaryKeyOperation.$$$reportNull$$$0(4);
            }
            JBIterable drop_pk_deps = (table = (DeTable)ObjectUtils.tryCast((Object)object.table.editedObject, DeTable.class)) != null && table.keys.getPrimaryKey() != null ? JBIterable.of((Object)new DdlOperationKey(table.keys.getPrimaryKey(), DROP_PRIMARY_KEY)) : JBIterable.empty();
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object.table).append((Iterable)drop_pk_deps).append(DasDdlOperations.getObjectsRenameNCreateKeys(object.columns));
            if (jBIterable == null) {
                CreatePrimaryKeyOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTableKey das, @Nullable UserDataHolder data) {
            if (generator == null) {
                CreatePrimaryKeyOperation.$$$reportNull$$$0(6);
            }
            if (builder == null) {
                CreatePrimaryKeyOperation.$$$reportNull$$$0(7);
            }
            if (das == null) {
                CreatePrimaryKeyOperation.$$$reportNull$$$0(8);
            }
            DdlGenerator ddlGenerator = super.addToBuilder(generator, builder, das, data);
            if (ddlGenerator == null) {
                CreatePrimaryKeyOperation.$$$reportNull$$$0(9);
            }
            return ddlGenerator;
        }

        @Override
        public boolean isSupported(@NotNull DdlOperation.DdlOperationSupport support, @NotNull DeObject obj) {
            if (support == null) {
                CreatePrimaryKeyOperation.$$$reportNull$$$0(10);
            }
            if (obj == null) {
                CreatePrimaryKeyOperation.$$$reportNull$$$0(11);
            }
            return super.isSupported(support, obj) && ((DeTableKey)obj).isPrimary();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreatePrimaryKeyOperation";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "das";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreatePrimaryKeyOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addToBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: 
                case 9: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencies";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addToBuilder";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DropPrimaryKeyOperation
    extends DdlOperationGeneratorSimple<DeTableKey> {
        public DropPrimaryKeyOperation() {
            super(DROP_PRIMARY_KEY, DeTableKey.class, ObjectKind.KEY);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTableKey object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                DropPrimaryKeyOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                DropPrimaryKeyOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                DropPrimaryKeyOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropPrimaryKey(builder, object).newStatement();
            if (ddlBuilder == null) {
                DropPrimaryKeyOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull DeTableKey object, @Nullable UserDataHolder data) {
            if (object == null) {
                DropPrimaryKeyOperation.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNDropKeys(object.table).append(DasDdlOperations.getObjectsRenameNDropKeys(object.columns));
            if (jBIterable == null) {
                DropPrimaryKeyOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @Override
        public boolean isSupported(@NotNull DdlOperation.DdlOperationSupport support, @NotNull DeObject obj) {
            if (support == null) {
                DropPrimaryKeyOperation.$$$reportNull$$$0(6);
            }
            if (obj == null) {
                DropPrimaryKeyOperation.$$$reportNull$$$0(7);
            }
            return super.isSupported(support, obj) && ((DeTableKey)obj).isPrimary();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropPrimaryKeyOperation";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropPrimaryKeyOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependants";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DropAltKeyOperation
    extends DdlOperationGeneratorSimple<DeTableKey> {
        public DropAltKeyOperation() {
            super(DROP_ALT_KEY, DeTableKey.class, ObjectKind.KEY);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTableKey object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                DropAltKeyOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                DropAltKeyOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                DropAltKeyOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropConstraint(builder, object.table, object, object.name).newStatement();
            if (ddlBuilder == null) {
                DropAltKeyOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull DeTableKey object, @Nullable UserDataHolder data) {
            if (object == null) {
                DropAltKeyOperation.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNDropKeys(object.table).append(DasDdlOperations.getObjectsRenameNDropKeys(object.columns));
            if (jBIterable == null) {
                DropAltKeyOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @Override
        public boolean isSupported(@NotNull DdlOperation.DdlOperationSupport support, @NotNull DeObject obj) {
            if (support == null) {
                DropAltKeyOperation.$$$reportNull$$$0(6);
            }
            if (obj == null) {
                DropAltKeyOperation.$$$reportNull$$$0(7);
            }
            return super.isSupported(support, obj) && !((DeTableKey)obj).isPrimary();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropAltKeyOperation";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropAltKeyOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependants";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CreateIndexOperation
    extends DdlOperationGeneratorSimple<DeIndex> {
        public CreateIndexOperation() {
            super(CREATE_INDEX, DeIndex.class, ObjectKind.INDEX);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeIndex object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                CreateIndexOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                CreateIndexOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                CreateIndexOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlCreateIndex(builder, object, "", "", "").newStatement();
            if (ddlBuilder == null) {
                CreateIndexOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeIndex object, @Nullable UserDataHolder data) {
            if (object == null) {
                CreateIndexOperation.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object.table).append(DasDdlOperations.getObjectsRenameNCreateKeys(object.getColumns()));
            if (jBIterable == null) {
                CreateIndexOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateIndexOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateIndexOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencies";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DropIndexOperation
    extends DdlOperationGeneratorSimple<DeIndex> {
        public DropIndexOperation() {
            super(DROP_INDEX, DeIndex.class, ObjectKind.INDEX);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeIndex object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                DropIndexOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                DropIndexOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                DropIndexOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropIndex(builder, object.getTable(), object, object.getName(), false).newStatement();
            if (ddlBuilder == null) {
                DropIndexOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull DeIndex object, @Nullable UserDataHolder data) {
            if (object == null) {
                DropIndexOperation.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNDropKeys(object.table).append(DasDdlOperations.getObjectsRenameNDropKeys(object.getColumns()));
            if (jBIterable == null) {
                DropIndexOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropIndexOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropIndexOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependants";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AlterColumnOperation
    extends DdlOperationGeneratorSimple<DeColumn> {
        public AlterColumnOperation() {
            super(ALTER_COLUMN, DeColumn.class, ObjectKind.COLUMN);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeColumn object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                AlterColumnOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                AlterColumnOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                AlterColumnOperation.$$$reportNull$$$0(2);
            }
            DeColumn target = this.getTarget(data);
            DdlBuilder ddlBuilder = builder.getDialect().sqlAlterColumnDefinition(builder, object, target, false).newStatement();
            if (ddlBuilder == null) {
                AlterColumnOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeColumn das, @Nullable UserDataHolder data) {
            if (generator == null) {
                AlterColumnOperation.$$$reportNull$$$0(4);
            }
            if (builder == null) {
                AlterColumnOperation.$$$reportNull$$$0(5);
            }
            if (das == null) {
                AlterColumnOperation.$$$reportNull$$$0(6);
            }
            assert (data != null);
            DeObject to = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            if (!to.isAltered(das)) {
                DdlGenerator ddlGenerator = generator;
                if (ddlGenerator == null) {
                    AlterColumnOperation.$$$reportNull$$$0(7);
                }
                return ddlGenerator;
            }
            DdlGenerator ddlGenerator = super.addToBuilder(generator, builder, das, data);
            if (ddlGenerator == null) {
                AlterColumnOperation.$$$reportNull$$$0(8);
            }
            return ddlGenerator;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getImplemented(@NotNull DeColumn object, @Nullable UserDataHolder data) {
            if (object == null) {
                AlterColumnOperation.$$$reportNull$$$0(9);
            }
            JBIterable<DdlOperationKey> jBIterable = DdlGraph.notNullize(new DdlOperationKey(this.getTarget(data), DdlOperation.POST_RENAME));
            if (jBIterable == null) {
                AlterColumnOperation.$$$reportNull$$$0(10);
            }
            return jBIterable;
        }

        @NotNull
        public DeColumn getTarget(@Nullable UserDataHolder data) {
            DeColumn deColumn = (DeColumn)ObjectUtils.assertNotNull((Object)ObjectUtils.tryCast((Object)DdlGraph.ALTER_TO.get(data), DeColumn.class));
            if (deColumn == null) {
                AlterColumnOperation.$$$reportNull$$$0(11);
            }
            return deColumn;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "das";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addToBuilder";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImplemented";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addToBuilder";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getImplemented";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CreateColumnOperation
    extends DdlOperationGeneratorSimple<DeColumn> {
        public CreateColumnOperation() {
            super(CREATE_COLUMN, DeColumn.class, ObjectKind.COLUMN);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeColumn object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                CreateColumnOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                CreateColumnOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                CreateColumnOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlAddColumn(builder, object, object.getTable().getColumnAttrs((DasColumn)object)).newStatement();
            if (ddlBuilder == null) {
                CreateColumnOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeColumn object, @Nullable UserDataHolder data) {
            if (object == null) {
                CreateColumnOperation.$$$reportNull$$$0(4);
            }
            JBIterable<DdlOperationKey> jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object.table);
            if (jBIterable == null) {
                CreateColumnOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateColumnOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateColumnOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencies";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DropColumnOperation
    extends DdlOperationGeneratorSimple<DeColumn> {
        public DropColumnOperation() {
            super(DROP_COLUMN, DeColumn.class, ObjectKind.COLUMN);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeColumn object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                DropColumnOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                DropColumnOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                DropColumnOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropColumn(builder, object).newStatement();
            if (ddlBuilder == null) {
                DropColumnOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull DeColumn object, @Nullable UserDataHolder data) {
            if (object == null) {
                DropColumnOperation.$$$reportNull$$$0(4);
            }
            JBIterable<DdlOperationKey> jBIterable = DasDdlOperations.getObjectRenameNDropKeys(object.table);
            if (jBIterable == null) {
                DropColumnOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropColumnOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropColumnOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependants";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class RenameViewOperation
    extends DdlOperationGeneratorSimple<DeView> {
        public RenameViewOperation() {
            super(RENAME_VIEW, DeView.class, ObjectKind.VIEW);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeView object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                RenameViewOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                RenameViewOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                RenameViewOperation.$$$reportNull$$$0(2);
            }
            DeObject target = this.getTarget(data);
            String name = target.getName();
            DdlBuilder ddlBuilder = builder.getDialect().sqlRenameView(builder, object.getBaseView(), name).newStatement().renameObject(object, name);
            if (ddlBuilder == null) {
                RenameViewOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getImplemented(@NotNull DeView object, @Nullable UserDataHolder data) {
            if (object == null) {
                RenameViewOperation.$$$reportNull$$$0(4);
            }
            JBIterable<DdlOperationKey> jBIterable = DdlGraph.notNullize(new DdlOperationKey(this.getTarget(data), DdlOperation.POST_RENAME));
            if (jBIterable == null) {
                RenameViewOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @NotNull
        public DeObject getTarget(@Nullable UserDataHolder data) {
            DeObject deObject = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            if (deObject == null) {
                RenameViewOperation.$$$reportNull$$$0(6);
            }
            return deObject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameViewOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameViewOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImplemented";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getImplemented";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class RenameTableOperation
    extends DdlOperationGeneratorSimple<DeTable> {
        public RenameTableOperation() {
            super(RENAME_TABLE, DeTable.class, ObjectKind.TABLE);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                RenameTableOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                RenameTableOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                RenameTableOperation.$$$reportNull$$$0(2);
            }
            DeObject target = this.getTarget(data);
            String name = target.getName();
            DdlBuilder ddlBuilder = builder.getDialect().sqlRenameTable(builder, object, name).newStatement().renameObject(object, name);
            if (ddlBuilder == null) {
                RenameTableOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getImplemented(@NotNull DeTable object, @Nullable UserDataHolder data) {
            if (object == null) {
                RenameTableOperation.$$$reportNull$$$0(4);
            }
            JBIterable<DdlOperationKey> jBIterable = DdlGraph.notNullize(new DdlOperationKey(this.getTarget(data), DdlOperation.POST_RENAME));
            if (jBIterable == null) {
                RenameTableOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @NotNull
        public DeObject getTarget(@Nullable UserDataHolder data) {
            DeObject deObject = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            if (deObject == null) {
                RenameTableOperation.$$$reportNull$$$0(6);
            }
            return deObject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameTableOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameTableOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImplemented";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getImplemented";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AlterTableOperation
    extends DdlOperationGeneratorSimple<DeTable> {
        public AlterTableOperation() {
            super(ALTER_TABLE, DeTable.class, ObjectKind.TABLE);
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable from, @Nullable UserDataHolder data) {
            boolean rename;
            if (generator == null) {
                AlterTableOperation.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                AlterTableOperation.$$$reportNull$$$0(1);
            }
            if (from == null) {
                AlterTableOperation.$$$reportNull$$$0(2);
            }
            assert (data != null);
            DeTable to = (DeTable)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            boolean bl = rename = !StringUtil.equals((CharSequence)from.getName(), (CharSequence)to.getName());
            if (from.isTemporary() != to.isTemporary()) {
                throw new UnsupportedOperationException("Can not change temporariness of existing table");
            }
            if (rename) {
                generator.addOperation(builder, RENAME_TABLE, from, data);
            }
            LinkedHashSet alter = ContainerUtil.newLinkedHashSet();
            LinkedHashSet drop = ContainerUtil.newLinkedHashSet();
            LinkedHashSet create = ContainerUtil.newLinkedHashSet();
            ArrayList order = ContainerUtil.newArrayList();
            AlterTableOperation.classifyChildren(from, to, create, alter, drop, order);
            for (DeObject object : create) {
                generator.addOperation(builder, DdlOperation.CREATE, object, null);
            }
            for (DeObject object : alter) {
                generator.addOperation(builder, DdlOperation.ALTER, (DeObject)object.editedObject, DasDdlOperations.set(builder.newData(null), DdlGraph.ALTER_TO, object));
            }
            for (DeObject object : drop) {
                generator.addOperation(builder, DdlOperation.DROP, object, null);
            }
            generator.addOperation(builder, REORDER_COLUMNS, to, DasDdlOperations.set(builder.newData(null), ReorderColumnsOperation.FROM_ORDER, order));
            if (!Comparing.equal((String)from.comment, (String)to.comment)) {
                generator.addOperation(builder, DdlOperation.ALTER_COMMENT, from, DasDdlOperations.set(builder.newData(null), DdlGraph.ALTER_TO, to));
            }
            DdlGenerator ddlGenerator = generator;
            if (ddlGenerator == null) {
                AlterTableOperation.$$$reportNull$$$0(3);
            }
            return ddlGenerator;
        }

        protected static void classifyChildren(@NotNull DeTable from, @NotNull DeTable to, @NotNull Set<DeObject> create, @NotNull Set<DeObject> alter, @NotNull Set<DeObject> drop, @NotNull List<DeColumn> order) {
            if (from == null) {
                AlterTableOperation.$$$reportNull$$$0(4);
            }
            if (to == null) {
                AlterTableOperation.$$$reportNull$$$0(5);
            }
            if (create == null) {
                AlterTableOperation.$$$reportNull$$$0(6);
            }
            if (alter == null) {
                AlterTableOperation.$$$reportNull$$$0(7);
            }
            if (drop == null) {
                AlterTableOperation.$$$reportNull$$$0(8);
            }
            if (order == null) {
                AlterTableOperation.$$$reportNull$$$0(9);
            }
            HashMap altered = ContainerUtil.newHashMap();
            for (DeObject object : to.getChildren()) {
                DeObject altering = (DeObject)object.editedObject;
                if (altering == null) {
                    create.add(object);
                    continue;
                }
                alter.add(object);
                altered.put(altering, object);
            }
            for (DeObject object : from.getChildren()) {
                if (altered.containsKey(object)) continue;
                drop.add(object);
            }
            for (DeColumn column : from.columns) {
                if (drop.contains(column)) continue;
                order.add((DeColumn)altered.get(column));
            }
            for (DeColumn column : to.columns) {
                if (!create.contains(column)) continue;
                order.add(column);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterTableOperation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "create";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alter";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "drop";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "order";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterTableOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addToBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addToBuilder";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "classifyChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ReorderColumnsOperation
    extends DdlOperationGeneratorSimple<DeTable> {
        public static final Key<List<DeColumn>> FROM_ORDER = Key.create((String)"FROM_ORDER");
        public static final Key<TIntArrayList> REORDER_INSERTIONS = Key.create((String)"REORDER_INSERTIONS");

        public ReorderColumnsOperation() {
            super(REORDER_COLUMNS, DeTable.class, ObjectKind.TABLE);
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable to, @Nullable UserDataHolder data) {
            ArrayList listTo;
            if (generator == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(1);
            }
            if (to == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(2);
            }
            assert (data != null);
            List listFrom = (List)ObjectUtils.assertNotNull((Object)FROM_ORDER.get(data));
            TIntArrayList list = ReorderColumnsOperation.generateInsertions(listFrom, listTo = ContainerUtil.newArrayList(to.columns));
            if (list.isEmpty()) {
                DdlGenerator ddlGenerator = generator;
                if (ddlGenerator == null) {
                    ReorderColumnsOperation.$$$reportNull$$$0(3);
                }
                return ddlGenerator;
            }
            DdlGenerator ddlGenerator = this.addSelfToBuilder(generator, builder, to, DasDdlOperations.set(data, REORDER_INSERTIONS, list));
            if (ddlGenerator == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(4);
            }
            return ddlGenerator;
        }

        @NotNull
        public static <T> TIntArrayList generateInsertions(@NotNull List<T> fromList, @NotNull List<T> toList) {
            if (fromList == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(5);
            }
            if (toList == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(6);
            }
            assert (fromList.size() == toList.size());
            TObjectIntHashMap numeration = new TObjectIntHashMap();
            for (int i2 = 0; i2 < toList.size(); ++i2) {
                numeration.put(toList.get(i2), i2);
            }
            int[] p = new int[fromList.size()];
            for (int i3 = 0; i3 < fromList.size(); ++i3) {
                T t = fromList.get(i3);
                assert (numeration.containsKey(t));
                p[i3] = numeration.get(t);
            }
            TIntArrayList res = new TIntArrayList();
            while (true) {
                int offs;
                for (offs = 0; offs < p.length && p[offs] == offs; ++offs) {
                }
                if (offs >= p.length) break;
                int maxi = offs;
                int maxj = offs;
                int maxb = 0;
                for (int i4 = offs; i4 < p.length; ++i4) {
                    int j;
                    int b = 0;
                    for (j = i4 - 1; j >= 0; --j) {
                        if ((b += p[j] > p[i4] ? 1 : -1) <= maxb) continue;
                        maxi = i4;
                        maxj = j;
                        maxb = b;
                    }
                    b = 0;
                    for (j = i4 + 1; j < p.length; ++j) {
                        if ((b += p[j] < p[i4] ? 1 : -1) <= maxb) continue;
                        maxi = i4;
                        maxj = j + 1;
                        maxb = b;
                    }
                }
                assert (maxb != 0);
                res.add(maxi);
                res.add(maxj);
                ReorderColumnsOperation.performInsertion(p, maxi, maxj);
            }
            TIntArrayList tIntArrayList = res;
            if (tIntArrayList == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(7);
            }
            return tIntArrayList;
        }

        public static void performInsertion(int[] p, int f, int t) {
            if (f < t) {
                ReorderColumnsOperation.rotateLeft(p, f, t - 1);
            } else {
                ReorderColumnsOperation.rotateRight(p, t, f);
            }
        }

        public static void rotateLeft(@NotNull int[] array, int i1, int i2) {
            if (array == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(8);
            }
            int t = array[i1];
            System.arraycopy(array, i1 + 1, array, i1, i2 - i1);
            array[i2] = t;
        }

        public static void rotateRight(@NotNull int[] array, int i1, int i2) {
            if (array == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(9);
            }
            int t = array[i2];
            System.arraycopy(array, i1, array, i1 + 1, i2 - i1);
            array[i1] = t;
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(10);
            }
            if (object == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(11);
            }
            if (context == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(12);
            }
            DdlBuilder ddlBuilder = builder.comment("Column reordering is unsupported!\n");
            if (ddlBuilder == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(13);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeTable object, @Nullable UserDataHolder data) {
            if (object == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(14);
            }
            JBIterable<DdlOperationKey> jBIterable = DasDdlOperations.getObjectsRenameNCreateKeys(object.columns);
            if (jBIterable == null) {
                ReorderColumnsOperation.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 13: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 13: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 1: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromList";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toList";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addToBuilder";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateInsertions";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addToBuilder";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 13: 
                case 15: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generateInsertions";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "rotateLeft";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "rotateRight";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencies";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 13: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CreateTableOperation
    extends DdlOperationGeneratorSimple<DeTable> {
        public static final Key<Set<DeForeignKey>> DEFERRED_FKS = Key.create((String)"DEFERRED_FKS");

        public CreateTableOperation() {
            this(CREATE_TABLE);
        }

        protected CreateTableOperation(@NotNull DdlOperation op) {
            if (op == null) {
                CreateTableOperation.$$$reportNull$$$0(0);
            }
            super(op, DeTable.class, ObjectKind.TABLE);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                CreateTableOperation.$$$reportNull$$$0(1);
            }
            if (object == null) {
                CreateTableOperation.$$$reportNull$$$0(2);
            }
            if (context == null) {
                CreateTableOperation.$$$reportNull$$$0(3);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlCreateTable(builder, Collections.singletonList(this.getView(object, data)), false, CreateTableOperation.getDeferredFks(data)).newStatement();
            if (ddlBuilder == null) {
                CreateTableOperation.$$$reportNull$$$0(4);
            }
            return ddlBuilder;
        }

        @NotNull
        protected DeTable getView(@NotNull DeTable table, @Nullable UserDataHolder data) {
            if (table == null) {
                CreateTableOperation.$$$reportNull$$$0(5);
            }
            DeTable deTable = table;
            if (deTable == null) {
                CreateTableOperation.$$$reportNull$$$0(6);
            }
            return deTable;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getImplemented(@NotNull DeTable object, @Nullable UserDataHolder data) {
            if (object == null) {
                CreateTableOperation.$$$reportNull$$$0(7);
            }
            JBIterable res = super.getImplemented(object, data);
            Set<DeForeignKey> deferredFks = CreateTableOperation.getDeferredFks(data);
            for (DeForeignKey key2 : object.foreignKeys) {
                if (deferredFks.contains(key2)) continue;
                res = res.append((Object)new DdlOperationKey(key2, CREATE_FOREIGN_KEY));
            }
            JBIterable jBIterable = res;
            if (jBIterable == null) {
                CreateTableOperation.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeTable object, @Nullable UserDataHolder data) {
            if (object == null) {
                CreateTableOperation.$$$reportNull$$$0(9);
            }
            JBIterable res = JBIterable.empty();
            Set<DeForeignKey> deferredFks = CreateTableOperation.getDeferredFks(data);
            for (DeForeignKey key2 : object.foreignKeys) {
                if (deferredFks.contains(key2)) continue;
                res = res.append(DasDdlOperations.getObjectsRenameNCreateKeys(key2.getTargetColumns()));
                if (key2.target == object) continue;
                res = res.append(DasDdlOperations.getObjectRenameNCreateKeys(key2.target));
            }
            JBIterable jBIterable = res;
            if (jBIterable == null) {
                CreateTableOperation.$$$reportNull$$$0(10);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable das, @Nullable UserDataHolder data) {
            if (generator == null) {
                CreateTableOperation.$$$reportNull$$$0(11);
            }
            if (builder == null) {
                CreateTableOperation.$$$reportNull$$$0(12);
            }
            if (das == null) {
                CreateTableOperation.$$$reportNull$$$0(13);
            }
            Set<DeForeignKey> deferredFks = CreateTableOperation.getDeferredFks(data);
            for (DeForeignKey key2 : das.foreignKeys) {
                if (!deferredFks.contains(key2)) continue;
                generator.addOperation(builder, CREATE_FOREIGN_KEY, key2, null);
            }
            if (das.comment != null) {
                generator.addOperation(builder, DdlOperation.ALTER_COMMENT, das, null);
            }
            DdlGenerator ddlGenerator = super.addToBuilder(generator, builder, das, data);
            if (ddlGenerator == null) {
                CreateTableOperation.$$$reportNull$$$0(14);
            }
            return ddlGenerator;
        }

        @Override
        @NotNull
        public DdlGenerator removeFromBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable das, @Nullable UserDataHolder data) {
            if (generator == null) {
                CreateTableOperation.$$$reportNull$$$0(15);
            }
            if (builder == null) {
                CreateTableOperation.$$$reportNull$$$0(16);
            }
            if (das == null) {
                CreateTableOperation.$$$reportNull$$$0(17);
            }
            Set<DeForeignKey> deferredFks = CreateTableOperation.getDeferredFks(data);
            for (DeForeignKey key2 : das.foreignKeys) {
                if (!deferredFks.contains(key2)) continue;
                generator.removeOperation(builder, CREATE_FOREIGN_KEY, key2, null);
            }
            if (das.comment != null) {
                generator.removeOperation(builder, DdlOperation.ALTER_COMMENT, das, null);
            }
            DdlGenerator ddlGenerator = super.removeFromBuilder(generator, builder, das, data);
            if (ddlGenerator == null) {
                CreateTableOperation.$$$reportNull$$$0(18);
            }
            return ddlGenerator;
        }

        @NotNull
        public static Set<DeForeignKey> getDeferredFks(@Nullable UserDataHolder data) {
            Set keys = (Set)DEFERRED_FKS.get(data);
            Set set = keys == null ? Collections.emptySet() : keys;
            if (set == null) {
                CreateTableOperation.$$$reportNull$$$0(19);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 14: 
                case 18: 
                case 19: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 14: 
                case 18: 
                case 19: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "op";
                    break;
                }
                case 1: 
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 2: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 14: 
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 13: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "das";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getView";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImplemented";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addToBuilder";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "removeFromBuilder";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeferredFks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 14: 
                case 18: 
                case 19: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getView";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getImplemented";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencies";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "addToBuilder";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "removeFromBuilder";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 14: 
                case 18: 
                case 19: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AlterCommentOperation
    extends DdlOperationGeneratorSimple<DeObject> {
        public AlterCommentOperation() {
            super(DdlOperation.ALTER_COMMENT, null, null);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeObject from, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                AlterCommentOperation.$$$reportNull$$$0(0);
            }
            if (from == null) {
                AlterCommentOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                AlterCommentOperation.$$$reportNull$$$0(2);
            }
            DeObject to = (DeObject)DdlGraph.ALTER_TO.get(data);
            DdlBuilder ddlBuilder = builder.getDialect().sqlAlterObjectComment(builder, (DasObject)ObjectUtils.chooseNotNull((Object)to, (Object)from));
            if (ddlBuilder == null) {
                AlterCommentOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeObject object, @Nullable UserDataHolder data) {
            if (object == null) {
                AlterCommentOperation.$$$reportNull$$$0(4);
            }
            JBIterable<DdlOperationKey> jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object);
            if (jBIterable == null) {
                AlterCommentOperation.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterCommentOperation";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterCommentOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencies";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TemporaryRenameOperation
    extends DdlOperationGeneratorSimple<DeObject> {
        public static final Key<Boolean> TEMPORARY = Key.create((String)"TEMPORARY");

        public TemporaryRenameOperation() {
            super(DdlOperation.TEMPORARY_RENAME, null, null);
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeObject das, @Nullable UserDataHolder data) {
            if (generator == null) {
                TemporaryRenameOperation.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                TemporaryRenameOperation.$$$reportNull$$$0(1);
            }
            if (das == null) {
                TemporaryRenameOperation.$$$reportNull$$$0(2);
            }
            DeObject from = DasDdlOperations.getAlterFrom(das, data);
            DeObject to = DasDdlOperations.getAlterTo(das, data);
            DeObject tmp = from.emptyClone(from.model).copyFrom(from, true, DeObject.DeCopier.SHALLOW);
            tmp.name = tmp.name + "_temp";
            tmp.editedObject = from;
            UserDataHolder awayData = builder.newData(data);
            UserDataHolder backData = builder.newData(data);
            DdlGraph.ALTER_FROM.set(awayData, null);
            DdlGraph.ALTER_FROM.set(backData, null);
            DdlGraph.ALTER_TO.set(awayData, (Object)tmp);
            DdlGraph.ALTER_TO.set(backData, (Object)to);
            TEMPORARY.set(awayData, (Object)Boolean.TRUE);
            TEMPORARY.set(backData, (Object)Boolean.TRUE);
            generator.addOperation(builder, DdlOperation.ALTER, from, awayData);
            generator.addOperation(builder, DdlOperation.ALTER, tmp, backData);
            DdlGenerator ddlGenerator = generator;
            if (ddlGenerator == null) {
                TemporaryRenameOperation.$$$reportNull$$$0(3);
            }
            return ddlGenerator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "das";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$TemporaryRenameOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$TemporaryRenameOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addToBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addToBuilder";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DropTableOperation
    extends DdlOperationGeneratorSimple<DeTable> {
        public DropTableOperation() {
            super(DROP_TABLE, DeTable.class, ObjectKind.TABLE);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                DropTableOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                DropTableOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                DropTableOperation.$$$reportNull$$$0(2);
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropTable(builder, object, false, false, DasUtil.emptyModel()).newStatement();
            if (ddlBuilder == null) {
                DropTableOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropTableOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropTableOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DdlOperationGeneratorSimple<De extends DeObject>
    extends DdlOperationGenerator<De> {
        private final Class<De> myClazz;
        private final ObjectKind myKind;

        public DdlOperationGeneratorSimple(@NotNull DdlOperation op, @Nullable Class<De> clazz, @Nullable ObjectKind kind) {
            if (op == null) {
                DdlOperationGeneratorSimple.$$$reportNull$$$0(0);
            }
            super(op);
            this.myClazz = clazz;
            this.myKind = kind;
        }

        @Override
        public boolean isSupported(@NotNull DdlOperation.DdlOperationSupport support, @NotNull DeObject obj) {
            if (support == null) {
                DdlOperationGeneratorSimple.$$$reportNull$$$0(1);
            }
            if (obj == null) {
                DdlOperationGeneratorSimple.$$$reportNull$$$0(2);
            }
            return super.isSupported(support, obj) && (this.myClazz == null || this.myClazz.isAssignableFrom(obj.getClass()));
        }

        @Override
        public boolean isSupportedLight(@NotNull DdlOperation.DdlOperationSupport support, @NotNull ObjectKind kind) {
            if (support == null) {
                DdlOperationGeneratorSimple.$$$reportNull$$$0(3);
            }
            if (kind == null) {
                DdlOperationGeneratorSimple.$$$reportNull$$$0(4);
            }
            return this.myKind == null || this.myKind == kind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "op";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DdlOperationGeneratorSimple";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSupported";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSupportedLight";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class UnableOperation
    extends DdlOperationGeneratorSimple<DeObject> {
        public static final Key<DdlOperation> UNABLE_WHAT = Key.create((String)"UNABLE_WHAT");

        public UnableOperation() {
            super(UNABLE, null, null);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeObject object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                UnableOperation.$$$reportNull$$$0(0);
            }
            if (object == null) {
                UnableOperation.$$$reportNull$$$0(1);
            }
            if (context == null) {
                UnableOperation.$$$reportNull$$$0(2);
            }
            DdlOperation op = (DdlOperation)UNABLE_WHAT.get(data);
            DdlBuilder ddlBuilder = builder.comment("Unable to perform '" + op + "' on " + object.getKind().code() + " " + object.getName());
            if (ddlBuilder == null) {
                UnableOperation.$$$reportNull$$$0(3);
            }
            return ddlBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$UnableOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$UnableOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class OperationSelector
    extends DdlOperationGenerator<DeObject> {
        private final List<DdlOperation> myList;

        public OperationSelector(@NotNull DdlOperation operation) {
            if (operation == null) {
                OperationSelector.$$$reportNull$$$0(0);
            }
            super(operation);
            this.myList = ContainerUtil.newArrayList();
        }

        @NotNull
        public OperationSelector add(@NotNull DdlOperation op) {
            if (op == null) {
                OperationSelector.$$$reportNull$$$0(1);
            }
            this.myList.add(op);
            OperationSelector operationSelector = this;
            if (operationSelector == null) {
                OperationSelector.$$$reportNull$$$0(2);
            }
            return operationSelector;
        }

        @Override
        public boolean isSupported(@NotNull DdlOperation.DdlOperationSupport support, @NotNull DeObject obj) {
            if (support == null) {
                OperationSelector.$$$reportNull$$$0(3);
            }
            if (obj == null) {
                OperationSelector.$$$reportNull$$$0(4);
            }
            return !this.collectOperations(support, obj).isEmpty();
        }

        @Override
        public boolean isSupportedLight(@NotNull DdlOperation.DdlOperationSupport support, @NotNull ObjectKind kind) {
            if (support == null) {
                OperationSelector.$$$reportNull$$$0(5);
            }
            if (kind == null) {
                OperationSelector.$$$reportNull$$$0(6);
            }
            for (DdlOperation operation : this.myList) {
                if (!support.isSupportedLight(operation, kind)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeObject das, @Nullable UserDataHolder data) {
            List<DdlOperation> found;
            if (generator == null) {
                OperationSelector.$$$reportNull$$$0(7);
            }
            if (builder == null) {
                OperationSelector.$$$reportNull$$$0(8);
            }
            if (das == null) {
                OperationSelector.$$$reportNull$$$0(9);
            }
            if ((found = this.collectOperations(generator, das)).size() == 1) {
                generator.addOperation(builder, found.get(0), das, data);
            } else if (found.isEmpty()) {
                UserDataHolder unData = builder.newData(data);
                UnableOperation.UNABLE_WHAT.set(unData, (Object)this.getOperation());
                generator.addOperation(builder, UNABLE, das, unData);
            } else {
                this.myLogger.error("Operation " + this.getOperation() + " for object " + das.getKind() + " is non unique");
            }
            DdlGenerator ddlGenerator = generator;
            if (ddlGenerator == null) {
                OperationSelector.$$$reportNull$$$0(10);
            }
            return ddlGenerator;
        }

        @NotNull
        private List<DdlOperation> collectOperations(@NotNull DdlOperation.DdlOperationSupport support, @NotNull DeObject das) {
            if (support == null) {
                OperationSelector.$$$reportNull$$$0(11);
            }
            if (das == null) {
                OperationSelector.$$$reportNull$$$0(12);
            }
            List found = ContainerUtil.newSmartList();
            for (DdlOperation op : this.myList) {
                assert (!op.equals(this.getOperation()));
                if (!support.isSupported(op, das)) continue;
                found.add(op);
            }
            List list = found;
            if (list == null) {
                OperationSelector.$$$reportNull$$$0(13);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 10: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 10: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "op";
                    break;
                }
                case 2: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector";
                    break;
                }
                case 3: 
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "das";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "add";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addToBuilder";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectOperations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 2: 
                case 10: 
                case 13: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupportedLight";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addToBuilder";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "collectOperations";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 10: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class DropCreateOperation<De extends DeObject>
    extends DdlOperationGeneratorSimple<De> {
        @NotNull
        private final DdlOperation myDrop;
        @NotNull
        private final DdlOperation myCreate;

        public DropCreateOperation(@NotNull DdlOperation alter, @Nullable Class<De> clazz, @Nullable ObjectKind kind, @NotNull DdlOperation drop, @NotNull DdlOperation create) {
            if (alter == null) {
                DropCreateOperation.$$$reportNull$$$0(0);
            }
            if (drop == null) {
                DropCreateOperation.$$$reportNull$$$0(1);
            }
            if (create == null) {
                DropCreateOperation.$$$reportNull$$$0(2);
            }
            super(alter, clazz, kind);
            this.myDrop = drop;
            this.myCreate = create;
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull De from, @Nullable UserDataHolder data) {
            if (generator == null) {
                DropCreateOperation.$$$reportNull$$$0(3);
            }
            if (builder == null) {
                DropCreateOperation.$$$reportNull$$$0(4);
            }
            if (from == null) {
                DropCreateOperation.$$$reportNull$$$0(5);
            }
            assert (data != null);
            DeObject to = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            if (!to.isAltered((DeObject)from)) {
                DdlGenerator ddlGenerator = generator;
                if (ddlGenerator == null) {
                    DropCreateOperation.$$$reportNull$$$0(6);
                }
                return ddlGenerator;
            }
            DasDdlOperations.set(data, DdlGraph.ALTER_TO, null);
            generator.addOperation(builder, this.myDrop, (DeObject)from, DasDdlOperations.set(builder.newData(data), DdlGraph.ALTER_TO, to));
            generator.addOperation(builder, this.myCreate, to, DasDdlOperations.set(builder.newData(data), DdlGraph.ALTER_FROM, from));
            builder.addDependency(new DdlOperationKey(to, this.myCreate), new DdlOperationKey((DeObject)from, this.myDrop));
            DdlGenerator ddlGenerator = generator;
            if (ddlGenerator == null) {
                DropCreateOperation.$$$reportNull$$$0(7);
            }
            return ddlGenerator;
        }

        @Override
        public boolean isSupported(@NotNull DdlOperation.DdlOperationSupport support, @NotNull DeObject obj) {
            if (support == null) {
                DropCreateOperation.$$$reportNull$$$0(8);
            }
            if (obj == null) {
                DropCreateOperation.$$$reportNull$$$0(9);
            }
            return super.isSupported(support, obj) && support.isSupported(this.myDrop, obj) && support.isSupported(this.myCreate, obj);
        }

        @Override
        public boolean isSupportedLight(@NotNull DdlOperation.DdlOperationSupport support, @NotNull ObjectKind kind) {
            if (support == null) {
                DropCreateOperation.$$$reportNull$$$0(10);
            }
            if (kind == null) {
                DropCreateOperation.$$$reportNull$$$0(11);
            }
            return super.isSupportedLight(support, kind) && support.isSupportedLight(this.myDrop, kind) && support.isSupportedLight(this.myCreate, kind);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "drop";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "create";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropCreateOperation";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropCreateOperation";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addToBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addToBuilder";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupportedLight";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

