/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.exasol.ExasolConnection;
import com.intellij.database.model.exasol.ExasolDatabase;
import com.intellij.database.model.exasol.ExasolModel;
import com.intellij.database.model.exasol.ExasolRole;
import com.intellij.database.model.exasol.ExasolRoutine;
import com.intellij.database.model.exasol.ExasolSchema;
import com.intellij.database.model.exasol.ExasolScript;
import com.intellij.database.model.exasol.ExasolTable;
import com.intellij.database.model.exasol.ExasolUser;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ExasolScriptingService;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.openapi.util.Condition;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0002\u0014\u0015B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/scripting/ExasolScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/exasol/ExasolModel;", "Lcom/intellij/database/model/exasol/ExasolDatabase;", "Lcom/intellij/database/model/exasol/ExasolSchema;", "model", "database", "(Lcom/intellij/database/model/exasol/ExasolModel;Lcom/intellij/database/model/exasol/ExasolDatabase;)V", "statementDelimiterOwnsLine", "", "getStatementDelimiterOwnsLine", "()Z", "statementDelimiterStr", "", "getStatementDelimiterStr", "()Ljava/lang/String;", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "ExasolCreatingGenerator", "VERSION", "database-scripting"})
public final class ExasolScriptingService
extends AbstractScriptingService<ExasolModel, ExasolDatabase, ExasolSchema> {
    @NotNull
    private final String statementDelimiterStr = "/";
    private final boolean statementDelimiterOwnsLine = true;

    @Override
    @NotNull
    public String getStatementDelimiterStr() {
        return this.statementDelimiterStr;
    }

    @Override
    public boolean getStatementDelimiterOwnsLine() {
        return this.statementDelimiterOwnsLine;
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new ExasolCreatingGenerator(this.getContext(), task);
    }

    public ExasolScriptingService(@NotNull ExasolModel model, @NotNull ExasolDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        super((BasicModel)model, (BasicDatabase)database);
        this.statementDelimiterStr = "/";
        this.statementDelimiterOwnsLine = true;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014\u00a8\u0006!"}, d2={"Lcom/intellij/database/scripting/ExasolScriptingService$ExasolCreatingGenerator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ExasolScriptingService;Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateAdditionalTableItems", "", "table", "Lcom/intellij/database/model/basic/BasicTable;", "generateConnection", "connection", "Lcom/intellij/database/model/exasol/ExasolConnection;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateFunction", "routine", "Lcom/intellij/database/model/exasol/ExasolRoutine;", "generateRole", "role", "Lcom/intellij/database/model/exasol/ExasolRole;", "generateScript", "script", "Lcom/intellij/database/model/exasol/ExasolScript;", "generateUser", "user", "Lcom/intellij/database/model/exasol/ExasolUser;", "makeNormalColumnSpecification", "", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "database-scripting"})
    private final class ExasolCreatingGenerator
    extends BaseCreatingGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof ExasolScript) {
                this.generateScript((ExasolScript)element);
            } else if (basicElement instanceof ExasolRoutine) {
                this.generateFunction((ExasolRoutine)element);
            } else if (basicElement instanceof ExasolUser) {
                this.generateUser((ExasolUser)element);
            } else if (basicElement instanceof ExasolRole) {
                this.generateRole((ExasolRole)element);
            } else if (basicElement instanceof ExasolConnection) {
                this.generateConnection((ExasolConnection)element);
            } else {
                super.generateElement(element);
            }
        }

        private final void generateConnection(ExasolConnection connection) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, connection){
                final /* synthetic */ ExasolCreatingGenerator this$0;
                final /* synthetic */ ExasolConnection $connection;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    block1: {
                        void $receiver$iv;
                        void this_$iv;
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        StringBuilder stringBuilder = new StringBuilder().append("");
                        ObjectKind objectKind = ObjectKind.CONNECTION;
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.CONNECTION");
                        String string = this.$connection.getName();
                        Object object = this.this$0;
                        StringBuilder stringBuilder2 = stringBuilder.append(this.this$0.createOrReplace(objectKind)).append(" connection ");
                        CodeTextBuilder codeTextBuilder2 = codeTextBuilder;
                        String string2 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append(" to ");
                        String string3 = this.$connection.getConnectionString();
                        if (string3 == null) {
                            string3 = "";
                        }
                        CodeTextBuilder.append$default(codeTextBuilder2, stringBuilder3.append(this.this$0.getSqlString(string3)).toString(), null, false, 6, null);
                        String string4 = this.$connection.getUser();
                        if (string4 == null) break block1;
                        Object it = object = string4;
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), " user " + this.this$0.getSqlString((String)it) + " identified by password_unavailable", null, false, 6, null);
                    }
                }
                {
                    this.this$0 = exasolCreatingGenerator;
                    this.$connection = exasolConnection;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateUser(ExasolUser user) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, user){
                final /* synthetic */ ExasolCreatingGenerator this$0;
                final /* synthetic */ ExasolUser $user;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $receiver$iv;
                    void this_$iv;
                    String string = this.$user.getName();
                    ExasolCreatingGenerator exasolCreatingGenerator = this.this$0;
                    StringBuilder stringBuilder = new StringBuilder().append("create user ");
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    String string2 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                    CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string2).append(" identified by password_unavailable").toString(), null, false, 6, null);
                }
                {
                    this.this$0 = exasolCreatingGenerator;
                    this.$user = exasolUser;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateRole(ExasolRole role) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, role){
                final /* synthetic */ ExasolCreatingGenerator this$0;
                final /* synthetic */ ExasolRole $role;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $receiver$iv;
                    void this_$iv;
                    String string = this.$role.getName();
                    ExasolCreatingGenerator exasolCreatingGenerator = this.this$0;
                    StringBuilder stringBuilder = new StringBuilder().append("create role ");
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    String string2 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                    CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string2).toString(), null, false, 6, null);
                }
                {
                    this.this$0 = exasolCreatingGenerator;
                    this.$role = exasolRole;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateFunction(ExasolRoutine routine) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, routine){
                final /* synthetic */ ExasolCreatingGenerator this$0;
                final /* synthetic */ ExasolRoutine $routine;

                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    StringBuilder stringBuilder = new StringBuilder().append("");
                    ObjectKind objectKind = ObjectKind.CONNECTION;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.CONNECTION");
                    CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(this.this$0.createOrReplace(objectKind)).append(' ').toString(), null, false, 2, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$routine.getOriginalSourceText(), CompositeText.Kind.ORIGINAL_TEXT, false, 4, null);
                }
                {
                    this.this$0 = exasolCreatingGenerator;
                    this.$routine = exasolRoutine;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateScript(ExasolScript script) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, script){
                final /* synthetic */ ExasolCreatingGenerator this$0;
                final /* synthetic */ ExasolScript $script;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$script.getOriginalSourceText(), CompositeText.Kind.ORIGINAL_TEXT, false, 4, null);
                    this.this$0.getBuilder().append("/", CompositeText.Kind.SQL_DELIMITER, false);
                }
                {
                    this.this$0 = exasolCreatingGenerator;
                    this.$script = exasolScript;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateAdditionalTableItems(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            ExasolTable cfr_ignored_0 = (ExasolTable)table;
            String distKey2 = CollectionsKt.joinToString$default((Iterable)((Iterable)((ExasolTable)table).getColumns().jbi().filter((Condition)generateAdditionalTableItems.distKey.1.INSTANCE)), null, null, null, (int)0, null, (Function1)generateAdditionalTableItems.distKey.2.INSTANCE, (int)31, null);
            CharSequence charSequence = distKey2;
            if (charSequence.length() > 0) {
                CodeTextBuilder.append$default(this.getBuilder(), "distribute by " + distKey2 + ',', null, false, 6, null);
            }
        }

        @Override
        @Nullable
        protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column) {
            BigInteger next;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            String spec = super.makeNormalColumnSpecification(column);
            BasicLikeColumn basicLikeColumn = column;
            if (!(basicLikeColumn instanceof BasicTableColumn)) {
                basicLikeColumn = null;
            }
            BigInteger bigInteger = (object = (BasicTableColumn)basicLikeColumn) != null && (object = object.getSequenceIdentity()) != null ? ((SequenceIdentity)object).next : (next = null);
            if (spec != null && next != null) {
                spec = spec + (ExasolScriptingService.this.getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE) != false ? " identity(" + next + ')' : " identity");
            }
            return spec;
        }

        public ExasolCreatingGenerator(@NotNull ScriptingContext context, ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(context, task);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/scripting/ExasolScriptingService$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "database-scripting"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
        }

        static {
            VERSION vERSION;
            INSTANCE = vERSION = new VERSION();
        }
    }
}

