/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DataType;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.mysql.MysqlArgument;
import com.intellij.database.model.mysql.MysqlCollation;
import com.intellij.database.model.mysql.MysqlModel;
import com.intellij.database.model.mysql.MysqlRoot;
import com.intellij.database.model.mysql.MysqlRoutine;
import com.intellij.database.model.mysql.MysqlSchema;
import com.intellij.database.model.mysql.MysqlTable;
import com.intellij.database.model.mysql.MysqlTableColumn;
import com.intellij.database.model.mysql.MysqlTrigger;
import com.intellij.database.model.mysql.MysqlView;
import com.intellij.database.model.properties.MysqlColumnKind;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0002\u000b\fB\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/database/scripting/MysqlScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/mysql/MysqlModel;", "Lcom/intellij/database/model/mysql/MysqlRoot;", "Lcom/intellij/database/model/mysql/MysqlSchema;", "model", "(Lcom/intellij/database/model/mysql/MysqlModel;)V", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "MysqlCreatingGenerator", "VERSION", "database-scripting"})
public final class MysqlScriptingService
extends AbstractScriptingService<MysqlModel, MysqlRoot, MysqlSchema> {
    @Override
    @NotNull
    protected AbstractCodeGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new MysqlCreatingGenerator(this.getContext(), task);
    }

    public MysqlScriptingService(@NotNull MysqlModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        BasicModel basicModel = model;
        MysqlRoot mysqlRoot = model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)mysqlRoot, (String)"model.root");
        super(basicModel, (BasicDatabase)mysqlRoot);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001e\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0002J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0012\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0012\u0010)\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020*H\u0014J\u0012\u0010+\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u001e\u001a\u00020.H\u0014\u00a8\u0006/"}, d2={"Lcom/intellij/database/scripting/MysqlScriptingService$MysqlCreatingGenerator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/MysqlScriptingService;Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "argDataType", "", "arg", "Lcom/intellij/database/model/basic/BasicArgument;", "canQualify", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "defaultCollationForCharset", "model", "Lcom/intellij/database/model/basic/BasicModel;", "name", "findCollation", "Lcom/intellij/database/model/mysql/MysqlCollation;", "generateColumnComment", "", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generateElement", "generateRoutine", "routine", "Lcom/intellij/database/model/mysql/MysqlRoutine;", "generateTableComment", "table", "Lcom/intellij/database/model/basic/BasicTableOrView;", "generateTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateView", "view", "Lcom/intellij/database/model/mysql/MysqlView;", "getSingleColumnElements", "", "makeColumnDefinition", "makeComputedColumnSpecification", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "makeNormalColumnSpecification", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "Lcom/intellij/database/model/basic/BasicTable;", "database-scripting"})
    private final class MysqlCreatingGenerator
    extends BaseCreatingGenerator {
        @Override
        protected boolean canQualify(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return !(element instanceof BasicIndex) && super.canQualify(element);
        }

        @Override
        @NotNull
        protected Iterable<BasicElement> getSingleColumnElements(@NotNull BasicLikeColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            BasicLikeTable basicLikeTable = column.getLikeTable();
            if (basicLikeTable == null) {
                return SetsKt.emptySet();
            }
            BasicLikeTable table = basicLikeTable;
            JBIterable jBIterable = table.getDasChildren(null).filter(BasicKey.class).filter((Condition)new Condition<BasicKey>(this, column){
                final /* synthetic */ MysqlCreatingGenerator this$0;
                final /* synthetic */ BasicLikeColumn $column;

                public final boolean value(BasicKey it) {
                    BasicKey basicKey = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicKey, (String)"it");
                    return this.this$0.canCreateInColumn(basicKey) && it.isNameSurrogate() && it.getColNames().size() == 1 && Intrinsics.areEqual((Object)((String)CollectionsKt.first(it.getColNames())), (Object)this.$column.getName());
                }
                {
                    this.this$0 = mysqlCreatingGenerator;
                    this.$column = basicLikeColumn;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"table.getDasChildren(nul\u2026s.first() == column.name}");
            return (Iterable)jBIterable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            String string = super.makeNormalColumnSpecification(column);
            if (string == null) {
                return null;
            }
            String s = string;
            if (column instanceof MysqlTableColumn) {
                if (((MysqlTableColumn)column).isAutoInc()) {
                    s = s + " auto_increment";
                }
                if (((MysqlTableColumn)column).getOnUpdate() != null) {
                    s = s + " on update " + ((MysqlTableColumn)column).getOnUpdate();
                }
                String collation = ((MysqlTableColumn)column).getCollation();
                String charSet = this.defaultCollationForCharset((BasicModel)MysqlScriptingService.this.getModel(), collation);
                if (charSet != null) {
                    void $receiver$iv;
                    void this_$iv;
                    String string2 = charSet;
                    MysqlCreatingGenerator mysqlCreatingGenerator = this;
                    StringBuilder stringBuilder = new StringBuilder().append(s).append(" charset ");
                    String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                    s = stringBuilder.append(string3).toString();
                } else if (collation != null) {
                    String $receiver$iv = collation;
                    MysqlCreatingGenerator this_$iv = this;
                    StringBuilder stringBuilder = new StringBuilder().append(s).append(" collate ");
                    String string4 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                    s = stringBuilder.append(string4).toString();
                }
            }
            return s;
        }

        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof MysqlView) {
                this.generateView((MysqlView)element);
            } else if (basicElement instanceof MysqlRoutine) {
                this.generateRoutine((MysqlRoutine)element);
            } else {
                super.generateElement(element);
            }
        }

        private final String argDataType(BasicArgument arg) {
            String string;
            if (arg == null) {
                string = "/*none*/";
            } else {
                DataType dataType = arg.getDataType();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"arg.dataType");
                string = this.script(dataType);
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            HeaderFooter hf = super.makeTableHeaderFooter(table);
            StringBuilder footer = new StringBuilder();
            if (table.getComment() != null) {
                StringBuilder stringBuilder = new StringBuilder().append(" comment ");
                String string = table.getComment();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                footer.append(stringBuilder.append(this.getSqlString(string)).toString());
            }
            if (table instanceof MysqlTable) {
                String string;
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2;
                if (((MysqlTable)table).getEngine() != null) {
                    void $receiver$iv;
                    void this_$iv;
                    StringBuilder stringBuilder3 = new StringBuilder().append(" engine=");
                    String string2 = ((MysqlTable)table).getEngine();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string3 = string2;
                    object = this;
                    stringBuilder2 = stringBuilder3;
                    stringBuilder = footer;
                    string = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                    stringBuilder.append(stringBuilder2.append(string).toString());
                }
                String collation = ((MysqlTable)table).getCollation();
                String charSet = this.defaultCollationForCharset((BasicModel)MysqlScriptingService.this.getModel(), collation);
                if (charSet != null) {
                    void $receiver$iv;
                    void this_$iv;
                    String string4 = charSet;
                    MysqlCreatingGenerator $i$f$getScr = this;
                    stringBuilder2 = new StringBuilder().append(" charset=");
                    stringBuilder = footer;
                    string = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                    stringBuilder.append(stringBuilder2.append(string).toString());
                } else if (collation != null) {
                    String $receiver$iv = collation;
                    MysqlCreatingGenerator this_$iv = this;
                    stringBuilder2 = new StringBuilder().append(" collate=");
                    stringBuilder = footer;
                    string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                    stringBuilder.append(stringBuilder2.append(string).toString());
                }
            }
            if (!((object = (CharSequence)footer).length() == 0)) {
                hf = new HeaderFooter(hf.getHeader(), footer.substring(1));
            }
            return hf;
        }

        private final MysqlCollation findCollation(BasicModel model, String name) {
            BasicNode basicNode;
            if (name == null) {
                return null;
            }
            BasicModel basicModel = model;
            BasicRoot basicRoot = basicModel != null ? basicModel.getRoot() : null;
            if (!(basicRoot instanceof MysqlRoot)) {
                basicRoot = null;
            }
            return (basicNode = (MysqlRoot)basicRoot) != null && (basicNode = basicNode.getCollations()) != null ? (MysqlCollation)basicNode.get(name) : null;
        }

        private final String defaultCollationForCharset(BasicModel model, String name) {
            MysqlCollation c = this.findCollation(model, name);
            return c != null && Intrinsics.areEqual((Object)c.getDefaultForCharset(), (Object)Boolean.TRUE) ? c.getCharset() : null;
        }

        @Override
        @Nullable
        protected String makeComputedColumnSpecification(@NotNull BasicTableOrViewColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            if (!(column instanceof MysqlTableColumn)) {
                return super.makeComputedColumnSpecification(column);
            }
            StringBuilder stringBuilder = new StringBuilder().append("");
            DataType dataType = ((MysqlTableColumn)column).getDataType();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
            String res = stringBuilder.append(this.script(dataType)).append(" as (").append(((MysqlTableColumn)column).getDefault()).append(')').toString();
            if (Intrinsics.areEqual((Object)((Object)((MysqlTableColumn)column).getColumnKind()), (Object)((Object)MysqlColumnKind.GENERATED_STORED))) {
                res = res + " stored";
            }
            return res;
        }

        @Override
        @Nullable
        protected String makeColumnDefinition(@NotNull BasicLikeColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            String definition = super.makeColumnDefinition(column);
            String columnComment = column.getComment();
            if (columnComment != null) {
                definition = Intrinsics.stringPlus((String)definition, (Object)(" comment " + this.getSqlString(columnComment)));
            }
            return definition;
        }

        /*
         * WARNING - void declaration
         */
        private final void generateRoutine(MysqlRoutine routine) {
            String string;
            String returns;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            boolean isFunction = routine.getReturnArgument() != null;
            Iterable iterable = $receiver$iv = routine.getArguments();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                MysqlArgument it = (MysqlArgument)element$iv$iv;
                if (!(!it.getArgumentDirection().isReturnOrResult())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String params2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, (Function1)((Function1)new Function1<MysqlArgument, String>(this, isFunction){
                final /* synthetic */ MysqlCreatingGenerator this$0;
                final /* synthetic */ boolean $isFunction;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final String invoke(MysqlArgument p) {
                    void $receiver$iv;
                    void this_$iv;
                    String string = p.getName();
                    MysqlCreatingGenerator mysqlCreatingGenerator = this.this$0;
                    StringBuilder stringBuilder = new StringBuilder().append(this.$isFunction ? "" : p.getArgumentDirection().name() + " ").append("");
                    String string2 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                    StringBuilder stringBuilder2 = stringBuilder.append(string2).append(' ');
                    DataType dataType = p.getDataType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"p.dataType");
                    return stringBuilder2.append(this.this$0.script(dataType)).toString();
                }
                {
                    this.this$0 = mysqlCreatingGenerator;
                    this.$isFunction = bl;
                    super(1);
                }
            }), (int)31, null);
            String routineType = isFunction ? "function" : "procedure";
            String string2 = returns = isFunction ? " returns " + this.argDataType(routine.getReturnArgument()) : "";
            if (routine.getComment() != null) {
                StringBuilder stringBuilder = new StringBuilder().append(" comment ");
                String string3 = routine.getComment();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                string = stringBuilder.append(this.getSqlString(string3)).toString();
            } else {
                string = "";
            }
            String comment = string;
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, routineType, routine, params2, returns, comment){
                final /* synthetic */ MysqlCreatingGenerator this$0;
                final /* synthetic */ String $routineType;
                final /* synthetic */ MysqlRoutine $routine;
                final /* synthetic */ String $params;
                final /* synthetic */ String $returns;
                final /* synthetic */ String $comment;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create " + this.$routineType + ' ' + this.this$0.currentScopeName(this.$routine) + " (" + this.$params + ')' + this.$returns + "" + this.$comment, null, false, 6, null);
                    CompositeText compositeText = this.$routine.getSourceText();
                    this.this$0.getBuilder().append(compositeText != null ? compositeText.getContent() : null);
                }
                {
                    this.this$0 = mysqlCreatingGenerator;
                    this.$routineType = string;
                    this.$routine = mysqlRoutine;
                    this.$params = string2;
                    this.$returns = string3;
                    this.$comment = string4;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateTrigger(@NotNull BasicTrigger trigger) {
            Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
            if (!(trigger instanceof MysqlTrigger)) {
                super.generateTrigger(trigger);
                return;
            }
            String event = ((TrigEvent)CollectionsKt.first((Iterable)((MysqlTrigger)trigger).getEvents())).name();
            String turn = Intrinsics.areEqual((Object)((MysqlTrigger)trigger).getTurn(), (Object)TrigTurn.BEFORE_ROW) ? "before" : "after";
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger, turn, event){
                final /* synthetic */ MysqlCreatingGenerator this$0;
                final /* synthetic */ BasicTrigger $trigger;
                final /* synthetic */ String $turn;
                final /* synthetic */ String $event;

                public final void invoke() {
                    MysqlTable mysqlTable = ((MysqlTrigger)this.$trigger).getTable();
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create trigger " + this.this$0.currentScopeName(this.$trigger) + "\n             " + this.$turn + ' ' + this.$event + " on " + (mysqlTable != null ? this.this$0.currentScopeName(mysqlTable) : null) + "\n             for each row", null, false, 6, null);
                    CompositeText compositeText = ((MysqlTrigger)this.$trigger).getSourceText();
                    this.this$0.getBuilder().append(compositeText != null ? compositeText.getContent() : null);
                }
                {
                    this.this$0 = mysqlCreatingGenerator;
                    this.$trigger = basicTrigger;
                    this.$turn = string;
                    this.$event = string2;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateView(MysqlView view) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view){
                final /* synthetic */ MysqlCreatingGenerator this$0;
                final /* synthetic */ MysqlView $view;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create view " + this.this$0.currentScopeName(this.$view) + " as ", null, false, 6, null);
                    CompositeText compositeText = this.$view.getSourceText();
                    this.this$0.getBuilder().append(compositeText != null ? compositeText.getContent() : null);
                }
                {
                    this.this$0 = mysqlCreatingGenerator;
                    this.$view = mysqlView;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateTableComment(@NotNull BasicTableOrView table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        }

        @Override
        protected void generateColumnComment(@NotNull BasicLikeColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        }

        public MysqlCreatingGenerator(@NotNull ScriptingContext context, ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(context, task);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/scripting/MysqlScriptingService$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "database-scripting"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
        }

        static {
            VERSION vERSION;
            INSTANCE = vERSION = new VERSION();
        }
    }
}

