/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.mssql.MsMajorObject;
import com.intellij.database.scripting.AbstractScriptingService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007B\u0017\b\u0014\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/scripting/TsqlScriptingService;", "M", "Lcom/intellij/database/model/basic/BasicModel;", "D", "Lcom/intellij/database/model/basic/BasicDatabase;", "S", "Lcom/intellij/database/model/basic/BasicSchema;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "model", "database", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicDatabase;)V", "statementDelimiterOwnsLine", "", "getStatementDelimiterOwnsLine", "()Z", "statementDelimiterStr", "", "getStatementDelimiterStr", "()Ljava/lang/String;", "areCurrentDatabaseNamesCaseSensitive", "getPreliminaryOrderPart", "element", "Lcom/intellij/database/model/basic/BasicElement;", "database-scripting"})
public abstract class TsqlScriptingService<M extends BasicModel, D extends BasicDatabase, S extends BasicSchema>
extends AbstractScriptingService<M, D, S> {
    @NotNull
    private final String statementDelimiterStr = "go";
    private final boolean statementDelimiterOwnsLine = true;

    public boolean areCurrentDatabaseNamesCaseSensitive() {
        return false;
    }

    @Override
    @NotNull
    public String getStatementDelimiterStr() {
        return this.statementDelimiterStr;
    }

    @Override
    public boolean getStatementDelimiterOwnsLine() {
        return this.statementDelimiterOwnsLine;
    }

    @Override
    @NotNull
    public String getPreliminaryOrderPart(@NotNull BasicElement element) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof MsMajorObject) {
            if (this.getConsiderOrderHeuristic()) {
                string = super.getPreliminaryOrderPart(element);
            } else {
                String string2 = ((MsMajorObject)element).getName();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.name");
            }
        } else {
            string = super.getPreliminaryOrderPart(element);
        }
        return string;
    }

    protected TsqlScriptingService(@NotNull M model, @NotNull D database) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        Intrinsics.checkParameterIsNotNull(database, (String)"database");
        super(model, database);
        this.statementDelimiterStr = "go";
        this.statementDelimiterOwnsLine = true;
    }
}

