/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.IllegalDateTimeFormatException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0007\u001a\n\u0010\f\u001a\u00020\u000b*\u00020\u0007\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\u0007\u001a\u0012\u0010\r\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u000f*\u00020\u0007\u001a\n\u0010\u0011\u001a\u00020\u000f*\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"formalSqlDateTimePattern", "Lkotlin/text/Regex;", "formalTimestampFormat10", "Ljava/text/SimpleDateFormat;", "formalTimestampFormat19", "formalTimestampFormat23", "importSqlDateTime", "Ljava/util/Date;", "string", "", "export", "", "exportDateOnly", "exportDateTime", "withMilliseconds", "", "hasMilliseconds", "hasTime", "database-model-api"})
@JvmName(name="CalendarFun")
public final class CalendarFun {
    private static final SimpleDateFormat formalTimestampFormat10 = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat formalTimestampFormat19 = new SimpleDateFormat("yyyy-MM-dd.HH:mm:ss");
    private static final SimpleDateFormat formalTimestampFormat23 = new SimpleDateFormat("yyyy-MM-dd.HH:mm:ss.SSS");
    private static final Regex formalSqlDateTimePattern = new Regex("^\\s*(-?\\d+)-(\\d+)-(\\d+)(\\s*\\.\\s*(\\d+):(\\d+)(:(\\d+)(\\.(\\d{3}))?)?)?\\s*$");

    @NotNull
    public static final String export(@NotNull Date $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Date date = $receiver;
        return date instanceof java.sql.Date ? CalendarFun.exportDateOnly($receiver) : (date instanceof Timestamp ? CalendarFun.exportDateTime($receiver) : (CalendarFun.hasTime($receiver) ? CalendarFun.exportDateTime($receiver) : CalendarFun.exportDateOnly($receiver)));
    }

    @NotNull
    public static final String exportDateOnly(@NotNull Date $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = formalTimestampFormat10.format($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"formalTimestampFormat10.format(this)");
        return string;
    }

    @NotNull
    public static final String exportDateTime(@NotNull Date $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return CalendarFun.exportDateTime($receiver, CalendarFun.hasMilliseconds($receiver));
    }

    @NotNull
    public static final String exportDateTime(@NotNull Date $receiver, boolean withMilliseconds) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        SimpleDateFormat format = withMilliseconds ? formalTimestampFormat23 : formalTimestampFormat19;
        String string = format.format($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format.format(this)");
        return string;
    }

    public static final boolean hasTime(@NotNull Date $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis($receiver.getTime());
        return c.get(11) > 0 || c.get(12) > 0 || c.get(13) > 0 || c.get(14) > 0;
    }

    public static final boolean hasMilliseconds(@NotNull Date $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getTime() % 1000L > 0L;
    }

    @NotNull
    public static final Date importSqlDateTime(@NotNull CharSequence string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        MatchResult m = formalSqlDateTimePattern.matchEntire(string);
        if (m == null) {
            throw (Throwable)new IllegalDateTimeFormatException("The string \"" + string + "\" is not a valid date and time (wrong format).");
        }
        List values = m.getGroupValues();
        try {
            String string2 = (String)values.get(1);
            int y = Integer.parseInt(string2);
            String string3 = (String)values.get(2);
            int m2 = Integer.parseInt(string3);
            CharSequence charSequence = (String)values.get(3);
            int d = Integer.parseInt((String)charSequence);
            charSequence = (CharSequence)values.get(4);
            if (charSequence.length() == 0) {
                GregorianCalendar c = new GregorianCalendar(y, m2 - 1, d, 0, 0, 0);
                return new java.sql.Date(c.getTimeInMillis());
            }
            String string4 = (String)values.get(5);
            int h = Integer.parseInt(string4);
            String string5 = (String)values.get(6);
            int n = Integer.parseInt(string5);
            Integer n2 = StringsKt.toIntOrNull((String)((String)values.get(8)));
            int s = n2 != null ? n2 : 0;
            Integer n3 = StringsKt.toIntOrNull((String)((String)values.get(10)));
            int l = n3 != null ? n3 : 0;
            GregorianCalendar c = new GregorianCalendar(y, m2 - 1, d, h, n, s);
            long millis = c.getTimeInMillis() + (long)l;
            return new Timestamp(millis);
        }
        catch (Exception e) {
            throw (Throwable)new IllegalDateTimeFormatException("The string \"" + string + "\" is not a valid date and time (wrong values).", e);
        }
    }
}

