/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.openapi.ui.ValidationInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbTableDialog
extends AbstractDbRefactoringDialog<DatabaseTableEditor> {
    protected TableEditorModel myTableModel;

    public DbTableDialog(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            DbTableDialog.$$$reportNull$$$0(0);
        }
        super(context);
    }

    @Override
    @NotNull
    protected String getTitle(boolean modify) {
        String string = modify ? "Modify Table" : DatabaseMessages.message((String)"action.add.new.table.title", (Object[])new Object[0]);
        if (string == null) {
            DbTableDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected DatabaseEditorCapabilities.TableEditorCaps getTableEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = this.getContext().getDialect().getSchemaEditor().getDbEditorCaps().getTableEditorCaps(existing);
        if (tableEditorCaps == null) {
            DbTableDialog.$$$reportNull$$$0(2);
        }
        return tableEditorCaps;
    }

    public void setObject(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            DbTableDialog.$$$reportNull$$$0(3);
        }
        if (object.model != this.myModel) {
            throw new AssertionError((Object)"Invalid object");
        }
        DeTable table = null;
        if (object instanceof DeTable) {
            table = (DeTable)object;
        }
        if (object instanceof DeTableChild) {
            table = ((DeTableChild)object).table;
        }
        if (table == null) {
            throw new AssertionError((Object)"Invalid object");
        }
        this.setTable(table, allowEverything);
    }

    public void setTable(@NotNull DeTable table, boolean allowEverything) {
        if (table == null) {
            DbTableDialog.$$$reportNull$$$0(4);
        }
        if (table.model != this.myModel) {
            throw new AssertionError((Object)"Invalid table");
        }
        this.myTableModel = this.myEditorModelsCache.get(table, TableEditorModel.class);
        this.setEditor(new DatabaseTableEditor(this.myState, this.getTableEditorCaps(!allowEverything && table.editedObject != null), this.myTableModel));
    }

    @Override
    protected boolean isRefactoringValid() {
        boolean supportsEmptyTables = this.getContext().getDialect().supportsEmptyTables();
        boolean notEmpty = !this.myTableModel.getColumns().isEmpty();
        return (supportsEmptyTables || notEmpty) && super.isRefactoringValid();
    }

    @Override
    protected ValidationInfo doValidate() {
        ValidationInfo info = ((DatabaseTableEditor)this.myEditor).validate();
        return info == null ? super.doValidate() : info;
    }

    @NotNull
    public DeTable createTable(@Nullable DasNamespace schema, @NotNull String defaultName, @NotNull Collection<String> columnNames) {
        if (defaultName == null) {
            DbTableDialog.$$$reportNull$$$0(5);
        }
        if (columnNames == null) {
            DbTableDialog.$$$reportNull$$$0(6);
        }
        this.checkObjectInContext((DasObject)schema);
        DeNamespace deSchema = null;
        if (schema != null) {
            deSchema = (DeNamespace)this.export((DasObject)schema, false);
        }
        DeTable table = new DeTable(defaultName, deSchema, this.myModel);
        for (String name : columnNames) {
            table.columns.add(new DeColumn(name, table, this.myModel));
        }
        if (deSchema != null) {
            deSchema.addLightChild(table);
        } else {
            this.myModel.addRoot(table);
        }
        DeTable deTable = table;
        if (deTable == null) {
            DbTableDialog.$$$reportNull$$$0(7);
        }
        return deTable;
    }

    @NotNull
    public DeTable createTable(@Nullable DasNamespace schema, @NotNull DeTable template) {
        if (template == null) {
            DbTableDialog.$$$reportNull$$$0(8);
        }
        this.checkObjectInContext((DasObject)schema);
        DeNamespace deSchema = null;
        if (schema != null) {
            deSchema = (DeNamespace)this.export((DasObject)schema, false);
        }
        DeTable table = this.copyExport(template, true);
        table.parent = deSchema;
        if (deSchema != null) {
            deSchema.addLightChild(table);
        } else {
            this.myModel.addRoot(table);
        }
        DeTable deTable = table;
        if (deTable == null) {
            DbTableDialog.$$$reportNull$$$0(9);
        }
        return deTable;
    }

    @NotNull
    public DeObject createEmptyTemplate(@Nullable DasObject parent) {
        this.checkObjectInContext(parent);
        DeTable table = new DeTable("new_table", (DeObject)this.exportOp(parent, false), this.myModel);
        if (table.parent != null) {
            table.parent.addLightChild(table);
        } else {
            this.myModel.addRoot(table);
        }
        DeTable deTable = table;
        if (deTable == null) {
            DbTableDialog.$$$reportNull$$$0(10);
        }
        return deTable;
    }

    public void configureForModification(@NotNull DasObject object, boolean allowEverything) {
        if (object == null) {
            DbTableDialog.$$$reportNull$$$0(11);
        }
        this.checkObjectInContext(object);
        if (object instanceof DasTableChild) {
            this.export((DasObject)((DasTableChild)object).getTable(), true);
        }
        this.configureForModification((DeObject)this.export(object, true), allowEverything);
    }

    public void configureForModification(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            DbTableDialog.$$$reportNull$$$0(12);
        }
        if (object.model != this.myModel) {
            throw new AssertionError((Object)"Invalid object");
        }
        this.setObject(object, allowEverything);
        this.setRefactoring(true);
    }

    public void configureForCreation(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            DbTableDialog.$$$reportNull$$$0(13);
        }
        this.setObject(object, allowEverything);
    }

    @Nullable
    public DatabaseEditorBaseEx startItemEditing(@NotNull DeObject object) {
        if (object == null) {
            DbTableDialog.$$$reportNull$$$0(14);
        }
        return ((DatabaseTableEditor)this.myEditor).startItemEditing(object);
    }

    @Override
    @NotNull
    public DatabaseEditorBaseEx getActiveEditor() {
        DatabaseEditorBaseEx databaseEditorBaseEx = ((DatabaseTableEditor)this.myEditor).getActiveEditor();
        if (databaseEditorBaseEx == null) {
            DbTableDialog.$$$reportNull$$$0(15);
        }
        return databaseEditorBaseEx;
    }

    @Nullable
    protected String getHelpId() {
        return "reference.tools.datasource.table.modify";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbTableDialog";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbTableDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableEditorCaps";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyTemplate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTable";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "configureForModification";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "configureForCreation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "startItemEditing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

