/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlIntroduceVariableHandler
implements RefactoringActionHandler {
    private static void performInplaceIntroduce(@NotNull Editor editor, @NotNull SqlExpression expression, boolean replaceAll) {
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(1);
        }
        List occurrences = replaceAll ? SqlIntroduceVariableHandler.getOccurrences(expression) : ContainerUtil.list((Object[])new PsiElement[]{expression});
        SqlExtractVariableHelper helper = SqlImplUtil.getSqlDialectSafe((PsiElement)expression).getExtractVariableHelper();
        if (helper == null) {
            return;
        }
        PsiElement declaration = SqlIntroduceVariableHandler.performElement(editor, expression, occurrences, helper);
        if (declaration != null && declaration.isValid()) {
            PsiElement target = (PsiElement)SqlImplUtil.sqlTraverser().filter(SqlVariableDefinition.class).first();
            if (target == null || !target.isValid()) {
                return;
            }
            editor.getCaretModel().moveToOffset(target.getTextRange().getStartOffset());
            SqlTypeElement type = helper.getTypeElement(target);
            SqlInplaceVariableIntroducer introducer = new SqlInplaceVariableIntroducer(expression.getProject(), editor, (PsiNamedElement)target, type, occurrences);
            introducer.performInplaceRefactoring(ContainerUtil.newLinkedHashSet());
        }
    }

    @Nullable
    private static PsiElement performElement(@NotNull Editor editor, @NotNull SqlExpression expression, final @NotNull List<PsiElement> occurrences, final @NotNull SqlExtractVariableHelper helper) {
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(2);
        }
        if (expression == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(3);
        }
        if (occurrences == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(4);
        }
        if (helper == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(5);
        }
        final Project project = expression.getProject();
        String name = "new_var";
        String type = "int";
        final PsiElement initializer = helper.createInitializerDeclaration(project, "new_var", expression.getText());
        final PsiElement declaration = helper.createDeclaration(project, "new_var", type);
        final PsiElement anchor = helper.findInitializerAnchor(occurrences);
        final PsiElement block = helper.findTopmostBlock((PsiElement)expression);
        if (declaration == null || initializer == null || anchor == null || block == null) {
            SqlIntroduceVariableHandler.showCannotPerformError(project, editor);
            return null;
        }
        final SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)expression);
        final PsiFile file = expression.getContainingFile();
        return (PsiElement)new WriteCommandAction<PsiElement>(project, "Extract variable", new PsiFile[]{file}){

            protected void run(@NotNull Result<PsiElement> result2) throws Throwable {
                PsiDocumentManager dm;
                Document document;
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((document = (dm = PsiDocumentManager.getInstance((Project)project)).getDocument(file)) == null) {
                    return;
                }
                dm.commitDocument(document);
                PsiElement createdDeclaration = helper.addDeclaration(declaration, block);
                SqlIntroduceVariableHandler.addInitializer(project, anchor, initializer, language);
                SqlExpression newExpression = SqlPsiElementFactory.createExpressionFromText("new_var", language, project, null);
                if (newExpression != null) {
                    for (PsiElement occurrence : occurrences) {
                        occurrence.replace((PsiElement)newExpression);
                    }
                }
                if (createdDeclaration != null) {
                    createdDeclaration = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)createdDeclaration);
                }
                result2.setResult((Object)createdDeclaration);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/SqlIntroduceVariableHandler$1", "run"));
            }
        }.execute().getResultObject();
    }

    private static void addInitializer(Project project, PsiElement anchor, PsiElement initializer, @NotNull SqlLanguageDialect language) {
        PsiElement createdInitializer;
        if (language == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(6);
        }
        if ((createdInitializer = anchor.getParent().addBefore(initializer, anchor)) != null) {
            PsiElement semi = SqlPsiElementFactory.createLeafFromText(project, language, ";");
            PsiElement newLineNode = SqlPsiElementFactory.newLine(project);
            PsiElement parent = createdInitializer.getParent();
            PsiElement psiElement = parent.addAfter(semi, createdInitializer);
            parent.addAfter(newLineNode, psiElement);
        }
    }

    @Nullable
    private static SqlExpression getSelectedExpression(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiElement parent;
        if (element1 == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(7);
        }
        if (element2 == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(8);
        }
        if ((parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2)) == null) {
            return null;
        }
        if (parent instanceof SqlExpression) {
            return (SqlExpression)parent;
        }
        return (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, SqlExpression.class);
    }

    private static boolean checkIntroduceContext(@NotNull PsiFile file, @NotNull Editor editor, @Nullable PsiElement element) {
        if (file == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(10);
        }
        if (!SqlIntroduceVariableHandler.isValidIntroduceContext(element)) {
            SqlIntroduceVariableHandler.showCannotPerformError(file.getProject(), editor);
            return false;
        }
        return true;
    }

    private static void showCannotPerformError(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(12);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot perform refactoring", (String)"Cannot Perform Refactoring", (String)"refactoring.extractMethod");
    }

    private static boolean isValidIntroduceContext(@Nullable PsiElement element) {
        return SqlIntroduceVariableHandler.getTopmostScope(element) != null;
    }

    @Nullable
    public static PsiElement getTopmostScope(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, SqlBlockStatementImpl.class);
    }

    private static void smartIntroduce(final @NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        PsiElement e;
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(13);
        }
        if (file == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(14);
        }
        if (!SqlIntroduceVariableHandler.checkIntroduceContext(file, editor, e = file.findElementAt(offset = editor.getCaretModel().getOffset()))) {
            return;
        }
        ArrayList<SqlExpression> expressions = new ArrayList<SqlExpression>();
        while (e != null && !(e instanceof SqlStatement) && !(e instanceof SqlQueryExpression)) {
            if (e instanceof SqlExpression && !SqlIntroduceVariableHandler.isCallExpression(e)) {
                expressions.add((SqlExpression)e);
            }
            e = e.getParent();
        }
        if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            SqlIntroduceVariableHandler.performOnElement(editor, (SqlExpression)expressions.get(0));
        } else if (expressions.size() > 1) {
            IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<SqlExpression>(){

                public void pass(@NotNull SqlExpression expression) {
                    if (expression == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    SqlIntroduceVariableHandler.performOnElement(editor, expression);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/sql/SqlIntroduceVariableHandler$2", "pass"));
                }
            }, expression -> expression.getText());
        }
    }

    private static boolean isCallExpression(@Nullable PsiElement e) {
        return e instanceof SqlReferenceExpression && ((SqlReferenceExpression)e).getReferenceElementType() == SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE;
    }

    private static void performOnElement(final @NotNull Editor editor, final @NotNull SqlExpression expression) {
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(15);
        }
        if (expression == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(16);
        }
        if (!editor.getSettings().isVariableInplaceRenameEnabled()) {
            return;
        }
        OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)expression, SqlIntroduceVariableHandler.getOccurrences(expression), (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice replaceChoice) {
                SqlIntroduceVariableHandler.performInplaceIntroduce(editor, expression, replaceChoice == OccurrencesChooser.ReplaceChoice.ALL);
            }
        });
    }

    @NotNull
    static List<PsiElement> getOccurrences(@NotNull SqlExpression expression) {
        PsiElement scope;
        if (expression == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(17);
        }
        List list = (scope = SqlIntroduceVariableHandler.getTopmostScope((PsiElement)expression)) == null ? Collections.emptyList() : ((SyntaxTraverser)SqlImplUtil.sqlTraverser(scope).filter(element -> {
            if (expression == null) {
                SqlIntroduceVariableHandler.$$$reportNull$$$0(24);
            }
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)expression);
        })).toList();
        if (list == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(18);
        }
        return list;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(19);
        }
        if (elements == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(20);
        }
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, DataContext dataContext) {
        if (project == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(21);
        }
        if (editor == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(22);
        }
        if (file == null) {
            SqlIntroduceVariableHandler.$$$reportNull$$$0(23);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
            return;
        }
        SqlExtractVariableHelper helper = SqlImplUtil.getSqlDialectSafe((PsiElement)file).getExtractVariableHelper();
        if (helper == null) {
            SqlIntroduceVariableHandler.showCannotPerformError(project, editor);
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            PsiElement element1 = file.findElementAt(selectionModel.getSelectionStart());
            PsiElement element2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
            if (element1 instanceof PsiWhiteSpace) {
                element1 = file.findElementAt(element1.getTextRange().getEndOffset());
            }
            if (element2 instanceof PsiWhiteSpace) {
                element2 = file.findElementAt(element2.getTextRange().getStartOffset() - 1);
            }
            if (element1 == null || element2 == null) {
                SqlIntroduceVariableHandler.showCannotPerformError(project, editor);
                return;
            }
            SqlExpression selectedExpression = SqlIntroduceVariableHandler.getSelectedExpression(element1, element2);
            if (selectedExpression == null || helper.findTopmostBlock((PsiElement)selectedExpression) == null) {
                SqlIntroduceVariableHandler.showCannotPerformError(project, editor);
            } else {
                SqlIntroduceVariableHandler.performOnElement(editor, selectedExpression);
            }
            return;
        }
        SqlIntroduceVariableHandler.smartIntroduce(editor, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 16: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 9: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlIntroduceVariableHandler";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlIntroduceVariableHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performInplaceIntroduce";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInitializer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkIntroduceContext";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showCannotPerformError";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "smartIntroduce";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performOnElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
            case 18: {
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOccurrences$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SqlInplaceVariableIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        @NotNull
        private final PsiElement myTarget;
        @Nullable
        private final SqlTypeElement myTypeElement;

        public SqlInplaceVariableIntroducer(@NotNull Project project, @NotNull Editor editor, @NotNull PsiNamedElement target, @Nullable SqlTypeElement typeElement, @NotNull List<PsiElement> occurrences) {
            if (project == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(1);
            }
            if (target == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(2);
            }
            if (occurrences == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(3);
            }
            super(target, editor, project, "Introduce Variable", occurrences.toArray(new PsiElement[occurrences.size()]), null);
            this.myTarget = target;
            this.myTypeElement = typeElement;
        }

        protected PsiElement checkLocalScope() {
            return this.myTarget.getContainingFile();
        }

        protected void addAdditionalVariables(@NotNull TemplateBuilderImpl builder) {
            if (builder == null) {
                SqlInplaceVariableIntroducer.$$$reportNull$$$0(4);
            }
            if (this.myTypeElement != null) {
                builder.replaceElement((PsiElement)this.myTypeElement, this.myTypeElement.getText());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "occurrences";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/SqlIntroduceVariableHandler$SqlInplaceVariableIntroducer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAdditionalVariables";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

