/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterInStringLiteralHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class SqlEnterInStringHandler
extends EnterInStringLiteralHandler {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        int caretOffset;
        if (file == null) {
            SqlEnterInStringHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SqlEnterInStringHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            SqlEnterInStringHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvanceRef == null) {
            SqlEnterInStringHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            SqlEnterInStringHandler.$$$reportNull$$$0(4);
        }
        if (!SqlEnterInStringHandler.isInsideStringLiteral(file, caretOffset = ((Integer)caretOffsetRef.get()).intValue())) {
            return EnterHandlerDelegate.Result.Continue;
        }
        SqlEditorOptions instance = SqlEditorOptions.getInstance();
        if (!instance.isConcatenateStringsOnEnter()) {
            return EnterHandlerDelegate.Result.DefaultSkipIndent;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        SqlStringTokenElement psiAtOffset = (SqlStringTokenElement)((Object)ObjectUtils.tryCast((Object)file.findElementAt(caretOffset), SqlStringTokenElement.class));
        if (psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset) {
            Document document = editor.getDocument();
            ASTNode token = psiAtOffset.getNode();
            JavaLikeQuoteHandler quoteHandler = this.getJavaLikeQuoteHandler(editor, (PsiElement)psiAtOffset);
            if (quoteHandler != null && quoteHandler.getConcatenatableStringTokenTypes() != null && quoteHandler.getConcatenatableStringTokenTypes().contains(token.getElementType())) {
                int start = psiAtOffset.getTextRange().getStartOffset();
                TextRange range = psiAtOffset.getRangeInElement();
                String str = token.getText();
                String open = str.substring(0, range.getStartOffset());
                String close = str.substring(range.getEndOffset(), str.length());
                if (caretOffset < range.getStartOffset() + start) {
                    caretOffset = range.getStartOffset() + start;
                }
                if (caretOffset >= range.getEndOffset() + start) {
                    caretOffset = range.getEndOffset() + start;
                }
                String insertedFragment = close + " " + quoteHandler.getStringConcatenationOperatorRepresentation();
                document.insertString(caretOffset, (CharSequence)(insertedFragment + " " + open));
                caretOffset += insertedFragment.length();
                int caretAdvance = 1;
                CommonCodeStyleSettings langSettings = CodeStyleSettingsManager.getSettings((Project)file.getProject()).getCommonSettings(file.getLanguage());
                if (langSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                    --caretOffset;
                    caretAdvance = 3;
                }
                caretOffsetRef.set((Object)caretOffset);
                caretAdvanceRef.set((Object)caretAdvance);
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isInsideStringLiteral(@NotNull PsiFile file, int offset) {
        SqlStringTokenElement psiAtOffset;
        if (file == null) {
            SqlEnterInStringHandler.$$$reportNull$$$0(5);
        }
        return (psiAtOffset = (SqlStringTokenElement)((Object)ObjectUtils.tryCast((Object)file.findElementAt(offset), SqlStringTokenElement.class))) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvanceRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/editor/SqlEnterInStringHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideStringLiteral";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

