/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.lexer.SqlPreprocessingLexer;
import com.intellij.sql.psi.impl.lexer.SqlStringTokenLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSyntaxHighlighter
extends SyntaxHighlighterBase {
    public static final TextAttributesKey SQL_BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"SQL_BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
    public static final TextAttributesKey SQL_COMMENT = TextAttributesKey.createTextAttributesKey((String)"SQL_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey SQL_IDENT_DELIMITED = TextAttributesKey.createTextAttributesKey((String)"SQL_IDENT_DELIMITED", (TextAttributesKey)HighlighterColors.TEXT);
    public static final TextAttributesKey SQL_IDENT = TextAttributesKey.createTextAttributesKey((String)"SQL_IDENT", (TextAttributesKey)HighlighterColors.TEXT);
    public static final TextAttributesKey SQL_SEMICOLON = TextAttributesKey.createTextAttributesKey((String)"SQL_SEMICOLON", (TextAttributesKey)DefaultLanguageHighlighterColors.SEMICOLON);
    public static final TextAttributesKey SQL_COMMA = TextAttributesKey.createTextAttributesKey((String)"SQL_COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey SQL_DOT = TextAttributesKey.createTextAttributesKey((String)"SQL_DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
    public static final TextAttributesKey SQL_STRING = TextAttributesKey.createTextAttributesKey((String)"SQL_STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey SQL_PARENS = TextAttributesKey.createTextAttributesKey((String)"SQL_PARENS", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
    public static final TextAttributesKey SQL_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"SQL_BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
    public static final TextAttributesKey SQL_BRACES = TextAttributesKey.createTextAttributesKey((String)"SQL_BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
    public static final TextAttributesKey SQL_NUMBER = TextAttributesKey.createTextAttributesKey((String)"SQL_NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey SQL_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"SQL_KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey SQL_PROCEDURE = TextAttributesKey.createTextAttributesKey((String)"SQL_PROCEDURE", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_METHOD);
    public static final TextAttributesKey SQL_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"SQL_PARAMETER", (TextAttributesKey)DatabaseColors.CONSOLE_PARAMETER);
    public static final TextAttributesKey SQL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"SQL_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.GLOBAL_VARIABLE);
    public static final TextAttributesKey SQL_LABEL = TextAttributesKey.createTextAttributesKey((String)"SQL_LABEL", (TextAttributesKey)DefaultLanguageHighlighterColors.LABEL);
    public static final TextAttributesKey SQL_LOCAL_ALIAS = TextAttributesKey.createTextAttributesKey((String)"SQL_LOCAL_ALIAS", (TextAttributesKey)DefaultLanguageHighlighterColors.LOCAL_VARIABLE);
    public static final TextAttributesKey SQL_TABLE = TextAttributesKey.createTextAttributesKey((String)"SQL_TABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
    public static final TextAttributesKey SQL_COLUMN = TextAttributesKey.createTextAttributesKey((String)"SQL_COLUMN", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
    public static final TextAttributesKey SQL_SCHEMA = TextAttributesKey.createTextAttributesKey((String)"SQL_SCHEMA", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
    public static final TextAttributesKey SQL_TYPE = TextAttributesKey.createTextAttributesKey((String)"SQL_TYPE", (TextAttributesKey)SQL_KEYWORD);
    public static final TextAttributesKey SQL_DATABASE_OBJECT = TextAttributesKey.createTextAttributesKey((String)"SQL_DATABASE_OBJECT", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
    public static final TextAttributesKey SQL_SYNTHETIC_ENTITY = TextAttributesKey.createTextAttributesKey((String)"SQL_SYNTHETIC_ENTITY", (TextAttributesKey)DefaultLanguageHighlighterColors.PREDEFINED_SYMBOL);
    public static final TextAttributesKey SQL_EXTERNAL_TOOL = TextAttributesKey.createTextAttributesKey((String)"SQL_EXTERNAL_TOOL", (TextAttributesKey)EditorColors.INJECTED_LANGUAGE_FRAGMENT);
    private final SqlLanguageDialect myDialect;
    private final Project myProject;
    private final VirtualFile myFile;

    public SqlSyntaxHighlighter(@Nullable SqlLanguageDialect dialect, @Nullable Project project) {
        this(dialect, project, null);
    }

    public SqlSyntaxHighlighter(@Nullable SqlLanguageDialect dialect, @Nullable Project project, @Nullable VirtualFile file) {
        this.myDialect = dialect;
        this.myProject = project;
        this.myFile = file;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)(this.myDialect != null ? this.myDialect : SqlLanguage.INSTANCE));
        MyLayeredLexer myLayeredLexer = new MyLayeredLexer(SqlPreprocessingLexer.withPreprocessingIfNeeded(this.myProject, definition, (PsiElement)this.findInjectionHost()), this.myDialect == null ? GenericDialect.INSTANCE : this.myDialect.getDatabaseDialect());
        if (myLayeredLexer == null) {
            SqlSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return myLayeredLexer;
    }

    @Nullable
    protected PsiLanguageInjectionHost findInjectionHost() {
        return InjectedLanguageUtil.findInjectionHost((VirtualFile)this.myFile);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public SqlLanguageDialect getDialect() {
        return this.myDialect;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (tokenType == SqlTokens.BAD_CHARACTER || tokenType == SqlTokens.SQL_UNCLOSED_TOKEN) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SQL_BAD_CHARACTER);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }
        if (SqlTokens.COMMENT_TOKENS.contains(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SQL_COMMENT);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(2);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_SEMICOLON) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SQL_SEMICOLON);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(3);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_COMMA) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SQL_COMMA);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(4);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_PERIOD) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SQL_DOT);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(5);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_STRING_TOKEN || tokenType == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN || tokenType == SqlTokens.SQL_CUSTOM_LQUOTE || tokenType == SqlTokens.SQL_CUSTOM_RQUOTE) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SQL_STRING);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(6);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_LEFT_PAREN || tokenType == SqlTokens.SQL_RIGHT_PAREN) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SQL_PARENS);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(7);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_LEFT_BRACKET || tokenType == SqlTokens.SQL_RIGHT_BRACKET) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SQL_BRACKETS);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(8);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_LEFT_BRACE || tokenType == SqlTokens.SQL_RIGHT_BRACE) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SQL_BRACES);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(9);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_INTEGER_TOKEN || tokenType == SqlTokens.SQL_FLOAT_TOKEN) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SQL_NUMBER);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(10);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_EXTERNAL_PARAM || tokenType == SqlTokens.SQL_EXTERNAL_PARAM_PREFIX || tokenType == SqlTokens.SQL_CUSTOM_PARAM_LQUOTE || tokenType == SqlTokens.SQL_CUSTOM_PARAM_RQUOTE) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SQL_PARAMETER);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(11);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_KEYWORD_TOKEN || tokenType instanceof SqlKeywordTokenType) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SQL_KEYWORD);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(12);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_RAW_INPUT) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SQL_EXTERNAL_TOOL);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(13);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack(null);
        if (textAttributesKeyArray == null) {
            SqlSyntaxHighlighter.$$$reportNull$$$0(14);
        }
        return textAttributesKeyArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/highlighting/SqlSyntaxHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    protected static class MyLayeredLexer
    extends LayeredLexer {
        public MyLayeredLexer(Lexer lexer, DatabaseDialect dialect) {
            super(lexer);
            this.registerSelfStoppingLayer((Lexer)new SqlStringTokenLexer(dialect), new IElementType[]{SqlTokens.SQL_STRING_TOKEN}, IElementType.EMPTY_ARRAY);
        }

        @Nullable
        public IElementType getTokenType() {
            IElementType type = super.getTokenType();
            return type instanceof SqlKeywordTokenType && type.getIndex() < 0 ? SqlTokens.SQL_KEYWORD_TOKEN : type;
        }
    }
}

