/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsdUtil {
    public static final String ELEMENT = "element";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String COMPLEX_TYPE = "complexType";
    public static final String SIMPLE_TYPE = "simpleType";

    private XsdUtil() {
    }

    public static Map<String, XsdElement> getChildrenElements(@NotNull XmlElement xsdElement, @NotNull String namespace) {
        if (xsdElement == null) {
            XsdUtil.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            XsdUtil.$$$reportNull$$$0(1);
        }
        HashMap<String, XsdElement> set = new HashMap<String, XsdElement>();
        xsdElement.acceptChildren((PsiElementVisitor)new XmlRecursiveXsdElementVisitor(XsdElementsCollectProcessors.getCollectProcessor(namespace, set)));
        return set;
    }

    public static XsdElement findXsdElement(@NotNull XmlElement xsdElement, @NotNull String namespace, @NotNull String elementName) {
        if (xsdElement == null) {
            XsdUtil.$$$reportNull$$$0(2);
        }
        if (namespace == null) {
            XsdUtil.$$$reportNull$$$0(3);
        }
        if (elementName == null) {
            XsdUtil.$$$reportNull$$$0(4);
        }
        return XsdUtil.getChildrenElements(xsdElement, namespace).get(elementName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xsdElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/ws/util/XsdUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildrenElements";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findXsdElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class XmlRecursiveXsdElementVisitor
    extends XmlRecursiveElementVisitor {
        private Processor<XmlTag> myProcessor;

        public XmlRecursiveXsdElementVisitor(@NotNull Processor<XmlTag> processor) {
            if (processor == null) {
                XmlRecursiveXsdElementVisitor.$$$reportNull$$$0(0);
            }
            this.myProcessor = processor;
        }

        public void visitXmlTag(XmlTag tag) {
            if (XsdUtil.ELEMENT.equals(tag.getLocalName())) {
                if (this.myProcessor.process((Object)tag)) {
                    super.visitXmlTag(tag);
                } else {
                    return;
                }
            }
            super.visitXmlTag(tag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/ws/util/XsdUtil$XmlRecursiveXsdElementVisitor", "<init>"));
        }
    }

    private static abstract class XsdElementsCollectProcessors
    implements Processor<XmlTag> {
        private final Map<String, XsdElement> mySet;
        private final String myNamespace;

        public static XsdElementsCollectProcessors getCollectAllProcessor(@NotNull String namespace, @NotNull Map<String, XsdElement> set) {
            if (namespace == null) {
                XsdElementsCollectProcessors.$$$reportNull$$$0(0);
            }
            if (set == null) {
                XsdElementsCollectProcessors.$$$reportNull$$$0(1);
            }
            return new XsdElementsCollectProcessors(namespace, (Map)set){

                @Override
                protected boolean isCollectChildren() {
                    return true;
                }
            };
        }

        public static XsdElementsCollectProcessors getCollectProcessor(@NotNull String namespace, @NotNull Map<String, XsdElement> set) {
            if (namespace == null) {
                XsdElementsCollectProcessors.$$$reportNull$$$0(2);
            }
            if (set == null) {
                XsdElementsCollectProcessors.$$$reportNull$$$0(3);
            }
            return new XsdElementsCollectProcessors(namespace, (Map)set){

                @Override
                protected boolean isCollectChildren() {
                    return false;
                }
            };
        }

        private XsdElementsCollectProcessors(@NotNull String namespace, @NotNull Map<String, XsdElement> set) {
            if (namespace == null) {
                XsdElementsCollectProcessors.$$$reportNull$$$0(4);
            }
            if (set == null) {
                XsdElementsCollectProcessors.$$$reportNull$$$0(5);
            }
            this.myNamespace = namespace;
            this.mySet = set;
        }

        public boolean process(XmlTag xmlTag) {
            XmlAttribute nameElement = xmlTag.getAttribute(XsdUtil.NAME);
            if (nameElement != null) {
                String name = nameElement.getValue();
                this.mySet.put(name, new XsdElement(name, this.myNamespace, xmlTag));
            }
            return this.isCollectChildren();
        }

        protected abstract boolean isCollectChildren();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/ws/util/XsdUtil$XsdElementsCollectProcessors";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCollectAllProcessor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCollectProcessor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class XsdTypeBean {
        public static XsdTypeBean UNKNOWN = new XsdTypeBean(null);
        @Nullable
        private XmlTag myDeclaration;

        public XsdTypeBean(@Nullable XmlTag declaration) {
            this.myDeclaration = declaration;
            if (declaration != null) assert (declaration.getName().equals(XsdUtil.SIMPLE_TYPE) || declaration.getName().equals(XsdUtil.COMPLEX_TYPE));
        }

        @Nullable
        public XmlTag getDeclaration() {
            return this.myDeclaration;
        }

        @Nullable
        public String getName() {
            if (this.myDeclaration == null) {
                return null;
            }
            return this.myDeclaration.getAttributeValue(XsdUtil.NAME);
        }

        @Nullable
        public String getSimpleType() {
            if (this.myDeclaration == null || XsdUtil.COMPLEX_TYPE.equals(this.myDeclaration.getName())) {
                return null;
            }
            return this.myDeclaration.getAttributeValue("id");
        }
    }

    public static class XsdElement {
        private final String myName;
        private final String myNamespace;
        private final XmlTag declaration;

        XsdElement(@NotNull String name, @NotNull String namespace, @NotNull XmlTag element) {
            if (name == null) {
                XsdElement.$$$reportNull$$$0(0);
            }
            if (namespace == null) {
                XsdElement.$$$reportNull$$$0(1);
            }
            if (element == null) {
                XsdElement.$$$reportNull$$$0(2);
            }
            this.myName = name;
            this.myNamespace = namespace;
            this.declaration = element;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                XsdElement.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getNamespace() {
            String string = this.myNamespace;
            if (string == null) {
                XsdElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public XmlTag getDeclaration() {
            XmlTag xmlTag = this.declaration;
            if (xmlTag == null) {
                XsdElement.$$$reportNull$$$0(5);
            }
            return xmlTag;
        }

        @NotNull
        public XsdTypeBean getType() {
            XmlTag tag;
            PsiElement element;
            PsiReference[] references;
            XmlAttribute typeAttribute = this.getDeclaration().getAttribute(XsdUtil.TYPE);
            if (typeAttribute != null && (references = typeAttribute.getReferences()).length > 0 && (element = references[references.length - 1].resolve()) instanceof XmlTag && (XsdUtil.SIMPLE_TYPE.equals((tag = (XmlTag)element).getName()) || XsdUtil.COMPLEX_TYPE.equals(tag.getName()))) {
                XsdTypeBean xsdTypeBean = new XsdTypeBean(tag);
                if (xsdTypeBean == null) {
                    XsdElement.$$$reportNull$$$0(6);
                }
                return xsdTypeBean;
            }
            XsdTypeBean xsdTypeBean = XsdTypeBean.UNKNOWN;
            if (xsdTypeBean == null) {
                XsdElement.$$$reportNull$$$0(7);
            }
            return xsdTypeBean;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = XsdUtil.NAME;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = XsdUtil.ELEMENT;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/ws/util/XsdUtil$XsdElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/ws/util/XsdUtil$XsdElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespace";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeclaration";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

