/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.inspections.GuavaConversionSettings;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.BaseGuavaTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaFluentIterableConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaPredicateConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaTypeConversionDescriptor;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(GuavaInspection.class);
    private static final Set<String> FLUENT_ITERABLE_STOP_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"append", "cycle", "uniqueIndex", "index", "toMultiset"});
    public static final String PROBLEM_DESCRIPTION = "Guava's functional primitives can be replaced by Java API";
    public boolean checkVariables = true;
    public boolean checkChains = true;
    public boolean checkReturnTypes = true;
    public boolean ignoreJavaxNullable = true;

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Report variables", "checkVariables");
        panel.addCheckbox("Report method chains", "checkChains");
        panel.addCheckbox("Report return types", "checkReturnTypes");
        panel.addCheckbox("Erase @javax.annotations.Nullable from converted functions", "ignoreJavaxNullable");
        return panel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            GuavaInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                GuavaInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){
            private final AtomicNotNullLazyValue<Map<String, PsiClass>> myGuavaClassConversions = new AtomicNotNullLazyValue<Map<String, PsiClass>>(){

                @NotNull
                protected Map<String, PsiClass> compute() {
                    HashMap map = new HashMap();
                    for (TypeConversionRule rule : (TypeConversionRule[])TypeConversionRule.EP_NAME.getExtensions()) {
                        if (!(rule instanceof BaseGuavaTypeConversionRule)) continue;
                        String fromClass = ((BaseGuavaTypeConversionRule)rule).ruleFromClass();
                        String toClass = ((BaseGuavaTypeConversionRule)rule).ruleToClass();
                        Project project = holder.getProject();
                        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
                        PsiClass targetClass = javaPsiFacade.findClass(toClass, GlobalSearchScope.allScope((Project)project));
                        if (targetClass == null) continue;
                        map.put(fromClass, targetClass);
                    }
                    HashMap hashMap = map;
                    if (hashMap == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return hashMap;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$1$1", "compute"));
                }
            };

            public void visitVariable(PsiVariable variable) {
                if (!GuavaInspection.this.checkVariables) {
                    return;
                }
                PsiType type = variable.getType();
                PsiType targetType = this.getConversionClassType(type);
                if (targetType != null) {
                    holder.registerProblem((PsiElement)variable.getNameIdentifier(), GuavaInspection.PROBLEM_DESCRIPTION, new LocalQuickFix[]{new MigrateGuavaTypeFix((PsiElement)variable, targetType)});
                }
            }

            public void visitMethod(PsiMethod method) {
                PsiTypeElement typeElement;
                super.visitMethod(method);
                if (!GuavaInspection.this.checkReturnTypes) {
                    return;
                }
                PsiType targetType = this.getConversionClassType(method.getReturnType());
                if (targetType != null && (typeElement = method.getReturnTypeElement()) != null) {
                    holder.registerProblem((PsiElement)typeElement, GuavaInspection.PROBLEM_DESCRIPTION, new LocalQuickFix[]{new MigrateGuavaTypeFix((PsiElement)method, targetType)});
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                this.checkFluentIterableGenerationMethod(expression);
                this.checkPredicatesUtilityMethod(expression);
            }

            private void checkPredicatesUtilityMethod(PsiMethodCallExpression expression) {
                if (GuavaPredicateConversionRule.isPredicates(expression)) {
                    PsiClassType initialType = (PsiClassType)expression.getType();
                    PsiClassType targetType = this.createTargetType(initialType);
                    if (targetType == null) {
                        return;
                    }
                    holder.registerProblem(expression.getMethodExpression().getReferenceNameElement(), GuavaInspection.PROBLEM_DESCRIPTION, new LocalQuickFix[]{new MigrateGuavaTypeFix((PsiElement)expression, (PsiType)targetType)});
                }
            }

            private void checkFluentIterableGenerationMethod(PsiMethodCallExpression expression) {
                if (!GuavaInspection.this.checkChains) {
                    return;
                }
                if (!this.isFluentIterableFromCall(expression)) {
                    return;
                }
                PsiMethodCallExpression chain = this.findGuavaMethodChain(expression);
                if (chain == null) {
                    return;
                }
                PsiClassType initialType = (PsiClassType)chain.getType();
                LOG.assertTrue(initialType != null);
                PsiClassType targetType = this.createTargetType(initialType);
                if (targetType == null) {
                    return;
                }
                PsiMethodCallExpression highlightedElement = chain;
                if (chain.getParent() instanceof PsiReferenceExpression && chain.getParent().getParent() instanceof PsiMethodCallExpression) {
                    highlightedElement = chain.getParent().getParent();
                }
                holder.registerProblem((PsiElement)highlightedElement, GuavaInspection.PROBLEM_DESCRIPTION, new LocalQuickFix[]{new MigrateGuavaTypeFix((PsiElement)chain, (PsiType)targetType)});
            }

            @Nullable
            private PsiClassType createTargetType(PsiClassType initialType) {
                PsiClass target;
                PsiClass resolvedClass = initialType.resolve();
                if (resolvedClass == null || (target = (PsiClass)((Map)this.myGuavaClassConversions.getValue()).get(resolvedClass.getQualifiedName())) == null) {
                    return null;
                }
                return this.addTypeParameters((PsiType)initialType, initialType.resolveGenerics(), target);
            }

            private PsiType getConversionClassType(PsiType initialType) {
                PsiClassType.ClassResolveResult resolveResult;
                PsiClass psiClass;
                if (initialType == null) {
                    return null;
                }
                PsiType type = initialType.getDeepComponentType();
                if (type instanceof PsiClassType && (psiClass = (resolveResult = ((PsiClassType)type).resolveGenerics()).getElement()) != null) {
                    String qName = psiClass.getQualifiedName();
                    PsiClass targetClass = (PsiClass)((Map)this.myGuavaClassConversions.getValue()).get(qName);
                    if (targetClass != null) {
                        PsiClassType createdType = this.addTypeParameters(type, resolveResult, targetClass);
                        return initialType instanceof PsiArrayType ? this.wrapAsArray((PsiArrayType)initialType, (PsiType)createdType) : createdType;
                    }
                }
                return null;
            }

            private PsiType wrapAsArray(PsiArrayType initial, PsiType created) {
                PsiArrayType result = new PsiArrayType(created);
                while (initial.getComponentType() instanceof PsiArrayType) {
                    initial = (PsiArrayType)initial.getComponentType();
                    result = new PsiArrayType((PsiType)result);
                }
                return result;
            }

            private boolean isFluentIterableFromCall(PsiMethodCallExpression expression) {
                PsiMethod method = expression.resolveMethod();
                if (method == null || !GuavaFluentIterableConversionRule.CHAIN_HEAD_METHODS.contains(method.getName())) {
                    return false;
                }
                PsiClass aClass = method.getContainingClass();
                return aClass != null && ("com.google.common.base.Optional".equals(aClass.getQualifiedName()) || "com.google.common.collect.FluentIterable".equals(aClass.getQualifiedName()));
            }

            private PsiMethodCallExpression findGuavaMethodChain(PsiMethodCallExpression expression) {
                PsiMethodCallExpression chain = expression;
                while (true) {
                    PsiMethodCallExpression current;
                    if ((current = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)chain, PsiMethodCallExpression.class)) != null && current.getMethodExpression().getQualifierExpression() == chain) {
                        PsiMethod method = current.resolveMethod();
                        if (method == null) {
                            return chain;
                        }
                        if (FLUENT_ITERABLE_STOP_METHODS.contains(method.getName())) {
                            return null;
                        }
                        PsiClass containingClass = method.getContainingClass();
                        if (containingClass == null || !"com.google.common.collect.FluentIterable".equals(containingClass.getQualifiedName()) && !"com.google.common.base.Optional".equals(containingClass.getQualifiedName())) {
                            return chain;
                        }
                        PsiType returnType = method.getReturnType();
                        PsiClass returnClass = PsiTypesUtil.getPsiClass((PsiType)returnType);
                        if (returnClass == null || !"com.google.common.collect.FluentIterable".equals(returnClass.getQualifiedName()) && !"com.google.common.base.Optional".equals(returnClass.getQualifiedName())) {
                            return chain;
                        }
                        if (GuavaTypeConversionDescriptor.isIterable((PsiExpression)current)) {
                            return chain;
                        }
                    } else {
                        return chain;
                    }
                    chain = current;
                }
            }

            @NotNull
            private PsiClassType addTypeParameters(PsiType currentType, PsiClassType.ClassResolveResult currentTypeResolveResult, PsiClass targetClass) {
                Map substitutionMap = currentTypeResolveResult.getSubstitutor().getSubstitutionMap();
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)holder.getProject());
                if (substitutionMap.size() == 1) {
                    PsiClassType psiClassType = elementFactory.createType(targetClass, (PsiType)ContainerUtil.getFirstItem(substitutionMap.values()));
                    if (psiClassType == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return psiClassType;
                }
                LOG.assertTrue(substitutionMap.size() == 2);
                LOG.assertTrue(GuavaLambda.FUNCTION.getJavaAnalogueClassQName().equals(targetClass.getQualifiedName()));
                PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)currentType);
                ArrayList types = new ArrayList(substitutionMap.values());
                types.remove(returnType);
                PsiType parameterType = (PsiType)types.get(0);
                PsiClassType psiClassType = elementFactory.createType(targetClass, new PsiType[]{parameterType, returnType});
                if (psiClassType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return psiClassType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$1", "addTypeParameters"));
            }
        };
        if (javaElementVisitor == null) {
            GuavaInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/inspections/GuavaInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/inspections/GuavaInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MigrateGuavaTypeFix
    extends LocalQuickFixAndIntentionActionOnPsiElement
    implements BatchQuickFix<CommonProblemDescriptor> {
        public static final String FAMILY_NAME = "Migrate Guava's type to Java";
        private final PsiType myTargetType;

        private MigrateGuavaTypeFix(PsiElement element, PsiType targetType) {
            if (element == null) {
                MigrateGuavaTypeFix.$$$reportNull$$$0(0);
            }
            super(element);
            this.myTargetType = targetType;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                MigrateGuavaTypeFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                MigrateGuavaTypeFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                MigrateGuavaTypeFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                MigrateGuavaTypeFix.$$$reportNull$$$0(4);
            }
            this.performTypeMigration(Collections.singletonList(startElement), Collections.singletonList(this.myTargetType));
        }

        protected boolean isAvailable() {
            return super.isAvailable() && this.myTargetType.isValid();
        }

        @NotNull
        public String getText() {
            PsiElement element = this.getStartElement();
            if (!this.myTargetType.isValid() || !element.isValid()) {
                String string = this.getFamilyName();
                if (string == null) {
                    MigrateGuavaTypeFix.$$$reportNull$$$0(5);
                }
                return string;
            }
            String presentation = element instanceof PsiMethodCallExpression ? "method chain" : TypeMigrationProcessor.getPresentation((PsiElement)element);
            String string = "Migrate " + presentation + " type to '" + this.myTargetType.getCanonicalText(false) + "'";
            if (string == null) {
                MigrateGuavaTypeFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if (FAMILY_NAME == null) {
                MigrateGuavaTypeFix.$$$reportNull$$$0(7);
            }
            return FAMILY_NAME;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            if (project == null) {
                MigrateGuavaTypeFix.$$$reportNull$$$0(8);
            }
            if (descriptors == null) {
                MigrateGuavaTypeFix.$$$reportNull$$$0(9);
            }
            if (psiElementsToIgnore == null) {
                MigrateGuavaTypeFix.$$$reportNull$$$0(10);
            }
            ArrayList<PsiElement> elementsToFix = new ArrayList<PsiElement>();
            ArrayList<PsiType> migrationTypes = new ArrayList<PsiType>();
            for (CommonProblemDescriptor descriptor : descriptors) {
                MigrateGuavaTypeFix fix = this.getFix(descriptor);
                elementsToFix.add(fix.getStartElement());
                migrationTypes.add(fix.myTargetType);
            }
            if (!elementsToFix.isEmpty()) {
                this.performTypeMigration(elementsToFix, migrationTypes);
            }
        }

        private MigrateGuavaTypeFix getFix(CommonProblemDescriptor descriptor) {
            QuickFix[] fixes = descriptor.getFixes();
            LOG.assertTrue(fixes != null);
            for (QuickFix fix : fixes) {
                if (!(fix instanceof MigrateGuavaTypeFix)) continue;
                return (MigrateGuavaTypeFix)fix;
            }
            throw new AssertionError();
        }

        private void performTypeMigration(List<PsiElement> elements, List<PsiType> types) {
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                return;
            }
            Project project = elements.get(0).getProject();
            TypeMigrationRules rules = new TypeMigrationRules(project);
            rules.setBoundScope((SearchScope)GlobalSearchScopesCore.projectProductionScope((Project)project).union((SearchScope)GlobalSearchScopesCore.projectTestScope((Project)project)));
            rules.addConversionRuleSettings((Object)new GuavaConversionSettings(GuavaInspection.this.ignoreJavaxNullable));
            TypeMigrationProcessor.runHighlightingTypeMigration((Project)project, null, (TypeMigrationRules)rules, (PsiElement[])elements.toArray(new PsiElement[elements.size()]), this.createMigrationTypeFunction(elements, types), (boolean)true, (boolean)true);
        }

        private Function<PsiElement, PsiType> createMigrationTypeFunction(@NotNull List<PsiElement> elements, @NotNull List<PsiType> types) {
            if (elements == null) {
                MigrateGuavaTypeFix.$$$reportNull$$$0(11);
            }
            if (types == null) {
                MigrateGuavaTypeFix.$$$reportNull$$$0(12);
            }
            LOG.assertTrue(elements.size() == types.size());
            HashMap mappings = new HashMap();
            Iterator<PsiType> typeIterator = types.iterator();
            for (PsiElement element : elements) {
                PsiType type = typeIterator.next();
                mappings.put(element, type);
            }
            return arg_0 -> MigrateGuavaTypeFix.lambda$createMigrationTypeFunction$0((Map)mappings, arg_0);
        }

        private static /* synthetic */ PsiType lambda$createMigrationTypeFunction$0(Map mappings, PsiElement element) {
            return (PsiType)mappings.get(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElementsToIgnore";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/typeMigration/inspections/GuavaInspection$MigrateGuavaTypeFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createMigrationTypeFunction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

