/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryUtil {
    private static final Key<ScriptingLibraryMappings> MAPPINGS_KEY = Key.create((String)ScriptingLibraryMappings.class.getSimpleName());

    private ScriptingLibraryUtil() {
    }

    public static void registerJSLibraryMappings(@NotNull Project project, @NotNull ScriptingLibraryMappings mappings) {
        if (project == null) {
            ScriptingLibraryUtil.$$$reportNull$$$0(0);
        }
        if (mappings == null) {
            ScriptingLibraryUtil.$$$reportNull$$$0(1);
        }
        MAPPINGS_KEY.set((UserDataHolder)project, (Object)mappings);
    }

    @NotNull
    public static GlobalSearchScope getJSLibraryScopeForFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            ScriptingLibraryUtil.$$$reportNull$$$0(2);
        }
        if (file == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                ScriptingLibraryUtil.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        ScriptingLibraryMappings mappings = (ScriptingLibraryMappings)MAPPINGS_KEY.get((UserDataHolder)project);
        GlobalSearchScope globalSearchScope = mappings != null ? mappings.getLibraryScopeForFile(file) : GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            ScriptingLibraryUtil.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getFilesAndDirectoriesScope(@NotNull Project project, @NotNull Set<VirtualFile> filesOrDirectories) {
        if (project == null) {
            ScriptingLibraryUtil.$$$reportNull$$$0(5);
        }
        if (filesOrDirectories == null) {
            ScriptingLibraryUtil.$$$reportNull$$$0(6);
        }
        THashSet files = new THashSet();
        THashSet directories2 = new THashSet();
        for (VirtualFile fileOrDir : filesOrDirectories) {
            if (fileOrDir.isDirectory()) {
                directories2.add(fileOrDir);
                continue;
            }
            files.add(fileOrDir);
        }
        GlobalSearchScope scope = GlobalSearchScope.EMPTY_SCOPE;
        if (directories2.size() > 0) {
            scope = scope.uniteWith(GlobalSearchScopesCore.directoriesScope(project, true, VfsUtilCore.toVirtualFileArray((Collection<? extends VirtualFile>)directories2)));
        }
        if (files.size() > 0) {
            scope = scope.uniteWith(GlobalSearchScope.filesScope(project, (Collection<VirtualFile>)files));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            ScriptingLibraryUtil.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @NotNull
    public static List<VirtualFile> sortFilesByPath(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            ScriptingLibraryUtil.$$$reportNull$$$0(8);
        }
        List<VirtualFile> list = files.stream().map(file -> Pair.create((Object)file, (Object)file.getPath())).sorted(Comparator.comparing(o -> (String)o.second)).map(pair -> (VirtualFile)pair.first).collect(Collectors.toList());
        if (list == null) {
            ScriptingLibraryUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ScriptingLibraryUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesOrDirectories";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ScriptingLibraryUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSLibraryScopeForFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesAndDirectoriesScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sortFilesByPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerJSLibraryMappings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJSLibraryScopeForFile";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFilesAndDirectoriesScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sortFilesByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

