/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.generate;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementAction;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.generate.GenerateManagedDependencyAction;
import org.jetbrains.idea.maven.dom.generate.MavenGenerateProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchDialog;
import org.jetbrains.idea.maven.model.MavenId;

public class GenerateDependencyAction
extends GenerateDomElementAction {
    public GenerateDependencyAction() {
        super((GenerateDomElementProvider)new MavenGenerateProvider<MavenDomDependency>(MavenDomBundle.message("generate.dependency", new Object[0]), MavenDomDependency.class){

            @Override
            @Nullable
            protected MavenDomDependency doGenerate(final @NotNull MavenDomProjectModel mavenModel, final Editor editor) {
                Map<DependencyConflictId, MavenDomDependency> managedDependencies;
                Project project;
                List<MavenId> ids;
                if (mavenModel == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((ids = MavenArtifactSearchDialog.searchForArtifact(project = mavenModel.getManager().getProject(), (managedDependencies = GenerateManagedDependencyAction.collectManagingDependencies(mavenModel)).values())).isEmpty()) {
                    return null;
                }
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                XmlFile psiFile = DomUtil.getFile((DomElement)mavenModel);
                return (MavenDomDependency)new WriteCommandAction<MavenDomDependency>(psiFile.getProject(), "Generate Dependency", new PsiFile[]{psiFile}){

                    protected void run(@NotNull Result<MavenDomDependency> result) throws Throwable {
                        MavenDomDependencyManagement dependencyManagement;
                        XmlElement managedDependencyXml;
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        boolean isInsideManagedDependencies = (managedDependencyXml = (dependencyManagement = mavenModel.getDependencyManagement()).getXmlElement()) != null && managedDependencyXml.getTextRange().contains(editor.getCaretModel().getOffset());
                        for (MavenId each : ids) {
                            MavenDomDependency res;
                            if (isInsideManagedDependencies) {
                                res = MavenDomUtil.createDomDependency(dependencyManagement.getDependencies(), editor, each);
                            } else {
                                DependencyConflictId conflictId = new DependencyConflictId(each.getGroupId(), each.getArtifactId(), null, null);
                                MavenDomDependency managedDependenciesDom = (MavenDomDependency)managedDependencies.get(conflictId);
                                if (managedDependenciesDom != null && Comparing.equal((String)each.getVersion(), (String)managedDependenciesDom.getVersion().getStringValue())) {
                                    res = MavenDomUtil.createDomDependency(mavenModel.getDependencies(), editor);
                                    res.getGroupId().setStringValue(conflictId.getGroupId());
                                    res.getArtifactId().setStringValue(conflictId.getArtifactId());
                                } else {
                                    res = MavenDomUtil.createDomDependency(mavenModel.getDependencies(), editor, each);
                                }
                            }
                            result.setResult((Object)res);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/dom/generate/GenerateDependencyAction$1$1", "run"));
                    }
                }.execute().getResultObject();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenModel", "org/jetbrains/idea/maven/dom/generate/GenerateDependencyAction$1", "doGenerate"));
            }
        }, AllIcons.Nodes.PpLib);
    }

    protected boolean startInWriteAction() {
        return false;
    }
}

