/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.builder.LightMemberOriginForDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightIdentifier;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.asJava.elements.KtLightSimpleModifierList;
import org.jetbrains.kotlin.asJava.elements.LightParameter;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

public class KtLightParameter
extends LightParameter
implements KtLightDeclaration<KtParameter, PsiParameter> {
    private final PsiModifierList modifierList;
    private final PsiParameter delegate;
    private final int index;
    private final KtLightMethod method;
    private KtLightIdentifier lightIdentifier = null;

    private static String getName(PsiParameter delegate2, int index2) {
        String name = delegate2.getName();
        return name != null ? name : "p" + index2;
    }

    public KtLightParameter(PsiParameter delegate2, int index2, KtLightMethod method) {
        super(KtLightParameter.getName(delegate2, index2), delegate2.getType(), method, (Language)KotlinLanguage.INSTANCE);
        this.delegate = delegate2;
        this.index = index2;
        this.method = method;
        this.modifierList = method.getLightMemberOrigin() instanceof LightMemberOriginForDeclaration ? new KtLightSimpleModifierList(this, Collections.emptySet()) : super.getModifierList();
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        return this.modifierList;
    }

    @Override
    @NotNull
    public PsiParameter getClsDelegate() {
        return this.delegate;
    }

    @Override
    @Nullable
    public KtParameter getKotlinOrigin() {
        int jetIndex;
        KtDeclaration declaration = (KtDeclaration)this.method.getKotlinOrigin();
        if (declaration == null) {
            return null;
        }
        int n = jetIndex = KtPsiUtilKt.isExtensionDeclaration(declaration) ? this.index - 1 : this.index;
        if (jetIndex < 0) {
            return null;
        }
        if (declaration instanceof KtFunction) {
            List<KtParameter> paramList = ((KtFunction)declaration).getValueParameters();
            return jetIndex < paramList.size() ? paramList.get(jetIndex) : null;
        }
        if (jetIndex != 0) {
            return null;
        }
        KtPropertyAccessor setter2 = null;
        if (declaration instanceof KtPropertyAccessor) {
            KtPropertyAccessor accessor = (KtPropertyAccessor)declaration;
            setter2 = accessor.isSetter() ? accessor : null;
        } else if (declaration instanceof KtProperty) {
            setter2 = ((KtProperty)declaration).getSetter();
        } else if (declaration instanceof KtParameter) {
            return (KtParameter)declaration;
        }
        return setter2 != null ? setter2.getParameter() : null;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        KtParameter origin = this.getKotlinOrigin();
        return origin != null ? origin : super.getNavigationElement();
    }

    @Override
    public boolean isValid() {
        return this.method.isValid();
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        KtParameter origin = this.getKotlinOrigin();
        if (origin != null) {
            origin.setName(name);
        }
        return this;
    }

    @Override
    public PsiFile getContainingFile() {
        return this.method.getContainingFile();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return KotlinLanguage.INSTANCE;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        KtParameter origin = this.getKotlinOrigin();
        return origin != null ? origin.getUseScope() : new LocalSearchScope(this);
    }

    public KtLightMethod getMethod() {
        return this.method;
    }

    @Override
    public String getText() {
        KtParameter origin = this.getKotlinOrigin();
        return origin != null ? origin.getText() : "";
    }

    @Override
    public TextRange getTextRange() {
        KtParameter origin = this.getKotlinOrigin();
        return origin != null ? origin.getTextRange() : TextRange.EMPTY_RANGE;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        if (this.lightIdentifier == null) {
            this.lightIdentifier = new KtLightIdentifier(this, this.getKotlinOrigin());
        }
        return this.lightIdentifier;
    }

    @Override
    public PsiElement getParent() {
        return this.getMethod().getParameterList();
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        KtParameter kotlinOrigin2 = this.getKotlinOrigin();
        if (another instanceof KtLightParameter && kotlinOrigin2 != null) {
            KtLightParameter anotherParam = (KtLightParameter)another;
            return kotlinOrigin2.equals(anotherParam.getKotlinOrigin()) && this.getClsDelegate().equals(anotherParam.getClsDelegate());
        }
        return super.isEquivalentTo(another);
    }

    public boolean equals(Object obj) {
        return obj instanceof PsiElement && this.isEquivalentTo((PsiElement)obj);
    }

    public int hashCode() {
        KtParameter kotlinOrigin2 = this.getKotlinOrigin();
        if (kotlinOrigin2 != null) {
            return kotlinOrigin2.hashCode();
        }
        return 0;
    }
}

