/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0014\u0010\u000e\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0014\u0010\u0010\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/CompilerDeserializationConfiguration;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "callsInPlaceEffectAllowed", "", "getCallsInPlaceEffectAllowed", "()Z", "isJvmPackageNameSupported", "returnsEffectAllowed", "getReturnsEffectAllowed", "skipMetadataVersionCheck", "getSkipMetadataVersionCheck", "skipPreReleaseCheck", "getSkipPreReleaseCheck", "typeAliasesAllowed", "getTypeAliasesAllowed", "frontend"})
public final class CompilerDeserializationConfiguration
implements DeserializationConfiguration {
    private final boolean skipMetadataVersionCheck;
    private final boolean skipPreReleaseCheck;
    private final boolean typeAliasesAllowed;
    private final boolean isJvmPackageNameSupported;
    private final boolean returnsEffectAllowed;
    private final boolean callsInPlaceEffectAllowed;

    @Override
    public boolean getSkipMetadataVersionCheck() {
        return this.skipMetadataVersionCheck;
    }

    @Override
    public boolean getSkipPreReleaseCheck() {
        return this.skipPreReleaseCheck;
    }

    @Override
    public boolean getTypeAliasesAllowed() {
        return this.typeAliasesAllowed;
    }

    @Override
    public boolean isJvmPackageNameSupported() {
        return this.isJvmPackageNameSupported;
    }

    @Override
    public boolean getReturnsEffectAllowed() {
        return this.returnsEffectAllowed;
    }

    @Override
    public boolean getCallsInPlaceEffectAllowed() {
        return this.callsInPlaceEffectAllowed;
    }

    public CompilerDeserializationConfiguration(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        this.skipMetadataVersionCheck = languageVersionSettings.getFlag(AnalysisFlag.Flags.getSkipMetadataVersionCheck());
        this.skipPreReleaseCheck = this.getSkipMetadataVersionCheck() || !languageVersionSettings.getLanguageVersion().isStable();
        this.typeAliasesAllowed = languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases);
        this.isJvmPackageNameSupported = languageVersionSettings.supportsFeature(LanguageFeature.JvmPackageName);
        this.returnsEffectAllowed = languageVersionSettings.supportsFeature(LanguageFeature.ReturnsEffect);
        this.callsInPlaceEffectAllowed = languageVersionSettings.supportsFeature(LanguageFeature.CallsInPlaceEffect);
    }
}

