/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.files.VtlFileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VtlFileIndex
extends ScalarIndexExtension<Boolean> {
    private static final ID<Boolean, Void> NAME = ID.create((String)"VtlFileIndex");
    @NonNls
    public static final String IMPLICIT_INCLUDE_MARKER = "#* @implicitly included *#\n";

    @NotNull
    public ID<Boolean, Void> getName() {
        ID<Boolean, Void> iD = NAME;
        if (iD == null) {
            VtlFileIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public static Collection<VtlFile> getImplicitlyIncludedFiles(PsiFile targetFile) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)targetFile);
        if (module == null || DumbService.getInstance((Project)module.getProject()).isDumb()) {
            List<VtlFile> list = Collections.emptyList();
            if (list == null) {
                VtlFileIndex.$$$reportNull$$$0(1);
            }
            return list;
        }
        Collection files = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)Boolean.TRUE, GlobalSearchScope.moduleScope((Module)module));
        ArrayList<VtlFile> result = new ArrayList<VtlFile>(files.size());
        for (VirtualFile virtualFile : files) {
            PsiFile psiFile = targetFile.getManager().findFile(virtualFile);
            if (!(psiFile instanceof VtlFile)) continue;
            if (psiFile.equals(targetFile)) {
                List<VtlFile> list = Collections.emptyList();
                if (list == null) {
                    VtlFileIndex.$$$reportNull$$$0(2);
                }
                return list;
            }
            result.add((VtlFile)psiFile);
        }
        ArrayList<VtlFile> arrayList = result;
        if (arrayList == null) {
            VtlFileIndex.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public DataIndexer<Boolean, Void, FileContent> getIndexer() {
        DataIndexer<Boolean, Void, FileContent> dataIndexer = new DataIndexer<Boolean, Void, FileContent>(){

            @NotNull
            public Map<Boolean, Void> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                CharSequence text = inputData.getContentAsText();
                int markerLength = VtlFileIndex.IMPLICIT_INCLUDE_MARKER.length();
                if (markerLength > text.length() || !VtlFileIndex.IMPLICIT_INCLUDE_MARKER.equals(text.subSequence(0, markerLength).toString())) {
                    Map<Boolean, Void> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                HashMap map = new HashMap();
                map.put((Object)Boolean.TRUE, null);
                HashMap hashMap = map;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/velocity/VtlFileIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/velocity/VtlFileIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            VtlFileIndex.$$$reportNull$$$0(4);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<Boolean> getKeyDescriptor() {
        BooleanDataDescriptor booleanDataDescriptor = BooleanDataDescriptor.INSTANCE;
        if (booleanDataDescriptor == null) {
            VtlFileIndex.$$$reportNull$$$0(5);
        }
        return booleanDataDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{VtlFileType.INSTANCE});
        if (defaultFileTypeSpecificInputFilter == null) {
            VtlFileIndex.$$$reportNull$$$0(6);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/velocity/VtlFileIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyIncludedFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

