/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JavaModuleIndex;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public class JavaModuleIndexImpl
extends JpsElementBase<JavaModuleIndexImpl>
implements JavaModuleIndex {
    public static final String SOURCE_SUFFIX = ":S";
    public static final String TEST_SUFFIX = ":T";
    private static final String INDEX_PATH = "jigsaw/module-info.map";
    private static final String NULL_PATH = "-";
    private static final String MODULE_INFO_FILE = "module-info.java";
    private final Map<String, File> myMapping;
    private final JpsCompilerExcludes myExcludes;

    private JavaModuleIndexImpl(JpsCompilerExcludes excludes) {
        this.myMapping = ContainerUtil.newHashMap();
        this.myExcludes = excludes;
    }

    private JavaModuleIndexImpl(Map<String, File> mapping) {
        this.myMapping = Collections.unmodifiableMap(mapping);
        this.myExcludes = null;
    }

    @NotNull
    public JavaModuleIndexImpl createCopy() {
        JpsCompilerExcludes excludes = this.myExcludes;
        if (excludes == null) {
            JavaModuleIndexImpl javaModuleIndexImpl = new JavaModuleIndexImpl(this.myMapping);
            if (javaModuleIndexImpl == null) {
                JavaModuleIndexImpl.$$$reportNull$$$0(0);
            }
            return javaModuleIndexImpl;
        }
        JavaModuleIndexImpl copy = new JavaModuleIndexImpl(excludes);
        copy.myMapping.putAll(this.myMapping);
        JavaModuleIndexImpl javaModuleIndexImpl = copy;
        if (javaModuleIndexImpl == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(1);
        }
        return javaModuleIndexImpl;
    }

    public void applyChanges(@NotNull JavaModuleIndexImpl modified) {
        if (modified == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(2);
        }
    }

    @Nullable
    public File getModuleInfoFile(@NotNull JpsModule module, boolean forTests) {
        if (module == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(3);
        }
        String key = module.getName() + (forTests ? TEST_SUFFIX : SOURCE_SUFFIX);
        if (this.myExcludes == null || this.myMapping.containsKey(key)) {
            return this.myMapping.get(key);
        }
        File file = this.findModuleInfoFile(module, forTests ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
        this.myMapping.put(key, file);
        return file;
    }

    private File findModuleInfoFile(JpsModule module, JavaSourceRootType rootType) {
        for (JpsModuleSourceRoot root : module.getSourceRoots()) {
            File file;
            if (!rootType.equals(root.getRootType()) || !(file = new File(JpsPathUtil.urlToOsPath((String)root.getUrl()), MODULE_INFO_FILE)).isFile() || this.myExcludes.isExcluded(file)) continue;
            return file;
        }
        return null;
    }

    public static void store(@NotNull File storageRoot, @NotNull Map<String, String> mapping) throws IOException {
        if (storageRoot == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(4);
        }
        if (mapping == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(5);
        }
        Properties p = new Properties();
        Iterator<String> iterator = mapping.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String path = mapping.get(key = iterator.next());
            p.setProperty(key, path != null ? FileUtil.toSystemDependentName((String)path) : NULL_PATH);
        }
        File index = new File(storageRoot, INDEX_PATH);
        FileUtil.createParentDirs((File)index);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(index), CharsetToolkit.UTF8_CHARSET);){
            p.store(writer, null);
        }
    }

    public static JavaModuleIndex load(@NotNull File storageRoot, @NotNull JpsCompilerExcludes excludes) {
        Object object;
        File index;
        if (storageRoot == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(6);
        }
        if (excludes == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(7);
        }
        if (!(index = new File(storageRoot, INDEX_PATH)).exists()) {
            return new JavaModuleIndexImpl(excludes);
        }
        Properties p = new Properties();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(index), CharsetToolkit.UTF8_CHARSET);
            object = null;
            try {
                p.load(reader);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((Reader)reader).close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read module index file: " + index, e);
        }
        HashMap mapping = ContainerUtil.newHashMap();
        object = p.stringPropertyNames().iterator();
        while (object.hasNext()) {
            String key;
            String path = p.getProperty(key = (String)object.next());
            mapping.put(key, NULL_PATH.equals(path) ? null : new File(path));
        }
        return new JavaModuleIndexImpl(mapping);
    }

    public void dropCache() {
        this.myMapping.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/java/impl/JavaModuleIndexImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modified";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/java/impl/JavaModuleIndexImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyChanges";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleInfoFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

