/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.jest.JestFilter;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUpdateSnapshotHyperlinkInfo;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.coverage.JestCoverageRunState;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testFramework.navigation.JSTestLocationProvider;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestRunState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private static final Logger LOG = Logger.getInstance(JestRunState.class);
    private static final String FRAMEWORK_NAME = "JestJavaScriptTestRunner";
    private static final String TEST_RESULTS_PROCESSOR = "jest-intellij/lib/jest-intellij-test-results-processor.js";
    private static final String STDIN_FIX = "jest-intellij/lib/jest-intellij-stdin-fix.js";
    private static volatile File TEMP_INPUT_FILE;
    private final Project myProject;
    private final JestRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnvironment;
    private final NodePackage myJestPackage;
    private final JestRunSettings myRunSettings;
    private final JestCoverageRunState myCoverageRunState;
    private final ConsoleCommandLineFolder myFolder;

    public JestRunState(@NotNull JestRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodePackage jestPackage) {
        if (runConfiguration == null) {
            JestRunState.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            JestRunState.$$$reportNull$$$0(1);
        }
        if (jestPackage == null) {
            JestRunState.$$$reportNull$$$0(2);
        }
        this.myFolder = new ConsoleCommandLineFolder("jest");
        this.myProject = runConfiguration.getProject();
        this.myRunConfiguration = runConfiguration;
        this.myEnvironment = environment;
        this.myJestPackage = jestPackage;
        this.myRunSettings = runConfiguration.getRunSettings();
        this.myCoverageRunState = JestCoverageRunState.create(environment, jestPackage, this.myRunSettings);
    }

    @Nullable
    public JestCoverageRunState getCoverageRunState() {
        return this.myCoverageRunState;
    }

    @Override
    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        NodeJsLocalInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveAsLocal(this.myProject);
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, false);
        ConsoleView consoleView = this.createSmtRunnerConsoleView(commandLine.getWorkDirectory());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        JestUtil.emitNewLineToFlushTrailingOutput((ProcessHandler)processHandler);
        JestRunState.sendInput(processHandler, consoleView);
        consoleView.attachToProcess((ProcessHandler)processHandler);
        this.foldCommandLine(consoleView, (ProcessHandler)processHandler);
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler);
        if (defaultExecutionResult == null) {
            JestRunState.$$$reportNull$$$0(3);
        }
        return defaultExecutionResult;
    }

    private static void sendInput(final @NotNull OSProcessHandler processHandler, @NotNull ConsoleView consoleView) {
        SMTRunnerConsoleView testConsole;
        ConsoleViewImpl consoleImpl;
        Editor editor;
        if (processHandler == null) {
            JestRunState.$$$reportNull$$$0(4);
        }
        if (consoleView == null) {
            JestRunState.$$$reportNull$$$0(5);
        }
        if ((editor = (consoleImpl = (ConsoleViewImpl)(testConsole = (SMTRunnerConsoleView)consoleView).getConsole()).getEditor()) == null) {
            LOG.warn("Cannot send input to jest process: no editor");
            return;
        }
        final Map keyCodeMapping = ContainerUtil.newHashMap((Pair)Pair.create((Object)40, (Object)1792834), (Pair[])new Pair[]{Pair.create((Object)37, (Object)1792836), Pair.create((Object)39, (Object)1792835), Pair.create((Object)38, (Object)1792833), Pair.create((Object)8, (Object)(SystemInfo.isWindows ? 8 : 127)), Pair.create((Object)10, (Object)13), Pair.create((Object)27, (Object)27)});
        editor.getContentComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                if (event.getKeyChar() != '\u0000') {
                    this.sendCode(event.getKeyChar());
                }
            }

            @Override
            public void keyReleased(KeyEvent event) {
                Integer newKeyCode = (Integer)keyCodeMapping.get(event.getKeyCode());
                if (newKeyCode != null) {
                    this.sendCode(newKeyCode);
                }
            }

            private void sendCode(int keyCode) {
                OutputStream input;
                if (!processHandler.isProcessTerminated() && (input = processHandler.getProcessInput()) != null) {
                    try {
                        input.write(keyCode);
                        input.flush();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to send input to jest process", (Throwable)e);
                    }
                }
            }
        });
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull NodeJsLocalInterpreter interpreter, int debugPort) throws ExecutionException {
        JestScopeKind scopeKind;
        if (interpreter == null) {
            JestRunState.$$$reportNull$$$0(6);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        if (SystemInfo.isWindows) {
            commandLine.withInput(JestRunState.getOrCreateEmptyInputFile());
        }
        commandLine.setRedirectErrorStream(true);
        commandLine.setCharset(StandardCharsets.UTF_8);
        String workingDir = this.myRunSettings.getWorkingDirSystemDependentPath();
        if (!workingDir.isEmpty()) {
            commandLine.setWorkDirectory(workingDir);
        }
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        List nodeOptionList = ParametersListUtil.parse((String)this.myRunSettings.getNodeOptions().trim());
        NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, nodeOptionList, debugPort, true, interpreter, true);
        commandLine.addParameters(new String[]{"--require", HelperFilesLocator.resolvePathForExecution(STDIN_FIX)});
        commandLine.addParameter(JestUtil.getJestMainJsFile(this.myJestPackage).getAbsolutePath());
        this.configureEnvironment(commandLine);
        if (JestUtil.isReactScriptsFamilyPackage(this.myJestPackage)) {
            commandLine.getEnvironment().put("CI", "1");
        }
        if (!this.myRunSettings.getConfigFileSystemDependentPath().trim().isEmpty()) {
            commandLine.addParameter("--config");
            commandLine.addParameter(this.myRunSettings.getConfigFileSystemDependentPath());
            this.myFolder.addPlaceholderTexts("--config=" + PathUtil.getFileName((String)this.myRunSettings.getConfigFileSystemDependentPath()));
        }
        if (StringUtil.isNotEmpty((String)this.myRunSettings.getJestOptions())) {
            String[] options = ParametersList.parse((String)this.myRunSettings.getJestOptions());
            commandLine.addParameters(options);
            this.myFolder.addPlaceholderTexts(options);
        }
        if (debugPort != -1) {
            commandLine.addParameter("--runInBand");
            this.myFolder.addLastParameterFrom(commandLine);
        }
        if (this.myRunConfiguration.isOptionUpdateSnapshot()) {
            commandLine.addParameter("--updateSnapshot");
            this.myFolder.addLastParameterFrom(commandLine);
            this.myRunConfiguration.clearOptionUpdateSnapshot();
        }
        commandLine.addParameter("--colors");
        commandLine.addParameter("--testResultsProcessor");
        commandLine.addParameter(HelperFilesLocator.resolvePathForExecution(TEST_RESULTS_PROCESSOR));
        if (this.myCoverageRunState != null) {
            this.myCoverageRunState.configure(commandLine);
        }
        if ((scopeKind = this.myRunSettings.getScopeKind()) == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            commandLine.addParameter("--testPathPattern");
            commandLine.addParameter("^" + JestUtil.escapeJavaScriptRegex(this.myRunSettings.getTestFileSystemDependentPath(), "") + "$");
            if (scopeKind == JestScopeKind.TEST_FILE) {
                this.myFolder.addPlaceholderText("--testPathPattern=" + PathUtil.getFileName((String)this.myRunSettings.getTestFileSystemDependentPath()));
            }
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            commandLine.addParameter("--testNamePattern");
            if (scopeKind == JestScopeKind.SUITE) {
                commandLine.addParameter("^" + this.formatTestNameEscapedRegex() + " ");
            } else {
                String topLevelSuiteRegex = this.myRunSettings.getTestNames().size() == 1 ? "(test )?" : "";
                commandLine.addParameter("^" + topLevelSuiteRegex + this.formatTestNameEscapedRegex() + "$");
            }
            this.myFolder.addPlaceholderTexts("--testNamePattern=" + StringUtil.join(this.myRunSettings.getTestNames(), (String)" "));
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            JestRunState.$$$reportNull$$$0(7);
        }
        return generalCommandLine;
    }

    @Nullable
    private static File getOrCreateEmptyInputFile() {
        File input = TEMP_INPUT_FILE;
        if (input == null || !input.isFile()) {
            try {
                input = FileUtil.createTempFile((String)"intellij-jest-empty-input", null, (boolean)true);
            }
            catch (IOException e) {
                LOG.warn("jest: cannot create temp file", (Throwable)e);
            }
            TEMP_INPUT_FILE = input;
        }
        return input;
    }

    @NotNull
    private String formatTestNameEscapedRegex() {
        String string = JestUtil.escapeJavaScriptRegex(StringUtil.join(this.myRunSettings.getTestNames(), (String)" "), "");
        if (string == null) {
            JestRunState.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void configureEnvironment(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            JestRunState.$$$reportNull$$$0(9);
        }
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
    }

    @NotNull
    private ConsoleView createSmtRunnerConsoleView(@Nullable File workingDirectory) {
        JestConsoleProperties testConsoleProperties = new JestConsoleProperties(this.myRunConfiguration, this.myEnvironment.getExecutor(), (SMTestLocator)new JSTestLocationProvider(true));
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)FRAMEWORK_NAME, (TestConsoleProperties)testConsoleProperties);
        consoleView.addMessageFilter((Filter)new NodeStackTraceFilter(this.myProject, workingDirectory));
        consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myProject, workingDirectory));
        consoleView.addMessageFilter((Filter)new JestFilter());
        Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            JestRunState.$$$reportNull$$$0(10);
        }
        return baseTestsOutputConsoleView;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            JestRunState.$$$reportNull$$$0(11);
        }
        if (processHandler == null) {
            JestRunState.$$$reportNull$$$0(12);
        }
        this.myFolder.foldCommandLine(consoleView, processHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jestPackage";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestRunState";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestRunState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTestNameEscapedRegex";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmtRunnerConsoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sendInput";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureEnvironment";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "foldCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JestOutputToGeneralTestEventsConverter
    extends OutputToGeneralTestEventsConverter {
        private static final String TEST_PROTOCOL_PREFIX = "test://";
        private volatile boolean myTestingStarted;
        private volatile long myTestingFinishedTimeMillis;

        public JestOutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, boolean stdinEnabled) {
            if (testFrameworkName == null) {
                JestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(0);
            }
            super(testFrameworkName, stdinEnabled);
            this.myTestingStarted = false;
            this.myTestingFinishedTimeMillis = 0L;
        }

        public void setProcessor(@Nullable GeneralTestEventsProcessor processor) {
            if (processor != null) {
                processor.addEventsListener((SMTRunnerEventsListener)new SMTRunnerEventsAdapter(){

                    public void onTestFailed(@NotNull SMTestProxy test) {
                        String testName;
                        String locationPath;
                        if (test == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ("unmatched_snapshot".equals(test.getMetainfo()) && (locationPath = JestOutputToGeneralTestEventsConverter.getTestLocationPath(test)) != null && (testName = (String)ContainerUtil.getLastItem((List)EscapeUtils.split((String)locationPath, (char)'.'))) != null) {
                            test.addLast(printer -> {
                                printer.printHyperlink("Click to update snapshot", (HyperlinkInfo)new JestUpdateSnapshotHyperlinkInfo(locationPath));
                                printer.print(" for '" + testName + "' test\n", ConsoleViewContentType.NORMAL_OUTPUT);
                            });
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "test", "com/intellij/javascript/jest/JestRunState$JestOutputToGeneralTestEventsConverter$1", "onTestFailed"));
                    }
                });
            }
            super.setProcessor(processor);
        }

        @Nullable
        private static String getTestLocationPath(@NotNull SMTestProxy test) {
            String locationUrl;
            if (test == null) {
                JestOutputToGeneralTestEventsConverter.$$$reportNull$$$0(1);
            }
            if ((locationUrl = test.getLocationUrl()) != null && locationUrl.startsWith(TEST_PROTOCOL_PREFIX)) {
                return locationUrl.substring(TEST_PROTOCOL_PREFIX.length());
            }
            return null;
        }

        protected void processConsistentText(String text, Key outputType, boolean tcLikeFakeOutput) {
            int ind = text.indexOf("##teamcity[");
            if (ind < 0) {
                if (ProcessOutputType.isStdout((Key)outputType) && !this.myTestingStarted && System.currentTimeMillis() - this.myTestingFinishedTimeMillis > 500L && (text.contains("PASS") || text.contains("FAIL"))) {
                    this.startTestingIfNeeded();
                }
                if (text.endsWith("Inspect your code changes or re-run with `-u` to update them.")) {
                    text = text.substring(0, text.length() - "Inspect your code changes or re-run with `-u` to update them.".length()) + "Inspect your code changes or click to update snapshots.\n".substring(0, "Inspect your code changes or click to update snapshots.\n".length() - 1);
                }
                super.processConsistentText(text, outputType, false);
                return;
            }
            this.startTestingIfNeeded();
            super.processConsistentText(text.substring(0, ind), outputType, false);
            String command = text.substring(ind);
            super.processConsistentText(command, outputType, false);
            if (command.contains("##teamcity[testingFinished]")) {
                this.myTestingStarted = false;
                this.myTestingFinishedTimeMillis = System.currentTimeMillis();
            }
        }

        private void startTestingIfNeeded() {
            if (!this.myTestingStarted) {
                this.myTestingStarted = true;
                super.processConsistentText("##teamcity[testingStarted]", ProcessOutputTypes.STDOUT, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testFrameworkName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "test";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/jest/JestRunState$JestOutputToGeneralTestEventsConverter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTestLocationPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JestConsoleProperties
    extends SMTRunnerConsoleProperties
    implements SMCustomMessagesParsing {
        private final SMTestLocator myLocator;

        public JestConsoleProperties(@NotNull JestRunConfiguration configuration, @NotNull Executor executor, @NotNull SMTestLocator locator) {
            if (configuration == null) {
                JestConsoleProperties.$$$reportNull$$$0(0);
            }
            if (executor == null) {
                JestConsoleProperties.$$$reportNull$$$0(1);
            }
            if (locator == null) {
                JestConsoleProperties.$$$reportNull$$$0(2);
            }
            super((RunConfiguration)configuration, JestRunState.FRAMEWORK_NAME, executor);
            this.myLocator = locator;
            this.setUsePredefinedMessageFilter(false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_IGNORED_TEST, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SCROLL_TO_SOURCE, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SELECT_FIRST_DEFECT, true);
            this.setIdBasedTestTree(true);
            this.setPrintTestingStartedTime(false);
        }

        public SMTestLocator getTestLocator() {
            return this.myLocator;
        }

        public JestOutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
            if (testFrameworkName == null) {
                JestConsoleProperties.$$$reportNull$$$0(3);
            }
            if (consoleProperties == null) {
                JestConsoleProperties.$$$reportNull$$$0(4);
            }
            return new JestOutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties.isEditable());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testFrameworkName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleProperties";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/jest/JestRunState$JestConsoleProperties";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTestEventsConverter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

