/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpreterManager {
    private static final Logger LOG = Logger.getInstance(NodeJsInterpreterManager.class);
    private static final String NODEJS_INTERPRETER_PATH = "nodejs_interpreter_path";
    private static final String NODEJS_INTERPRETER_PATH_STUCK_IN_DEFAULT_PROJECT = "nodejs_interpreter_path.stuck_in_default_project";
    private final Project myProject;
    private volatile NodeJsInterpreterRef myInterpreterRef;

    public NodeJsInterpreterManager(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public static NodeJsInterpreterManager getInstance(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(1);
        }
        NodeJsInterpreterManager nodeJsInterpreterManager = (NodeJsInterpreterManager)ServiceManager.getService((Project)project, NodeJsInterpreterManager.class);
        if (nodeJsInterpreterManager == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(2);
        }
        return nodeJsInterpreterManager;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef interpreterRef = this.myInterpreterRef;
        if (interpreterRef == null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
            String reference = propertiesComponent.getValue(NODEJS_INTERPRETER_PATH);
            interpreterRef = StringUtil.isNotEmpty((String)reference) && !"project".equals(reference) ? NodeJsInterpreterRef.create(reference) : NodeJsLocalInterpreterType.createNodeFromPathRef();
            this.myInterpreterRef = interpreterRef;
        }
        NodeJsInterpreterRef nodeJsInterpreterRef = interpreterRef;
        if (nodeJsInterpreterRef == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(3);
        }
        return nodeJsInterpreterRef;
    }

    public void setInterpreterRef(@Nullable NodeJsInterpreterRef interpreterRef) {
        this.myInterpreterRef = interpreterRef;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        if (interpreterRef == null) {
            propertiesComponent.unsetValue(NODEJS_INTERPRETER_PATH);
        } else {
            if (interpreterRef.isProjectRef()) {
                throw new IllegalStateException("Project interpreter cannot be set to itself");
            }
            propertiesComponent.setValue(NODEJS_INTERPRETER_PATH, interpreterRef.getReferenceName());
        }
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.getInterpreterRef().resolveWithoutAliases();
    }

    boolean isClonedFromDefaultProject() {
        if (!this.myProject.isDefault() && !this.myProject.isDisposed() && ApplicationManager.getApplication().isDispatchThread()) {
            Project defaultProject = ProjectManager.getInstance().getDefaultProject();
            PropertiesComponent defaultProjectPropertiesComponent = PropertiesComponent.getInstance((Project)defaultProject);
            String defaultProjectInterpreterStuckValue = defaultProjectPropertiesComponent.getValue(NODEJS_INTERPRETER_PATH_STUCK_IN_DEFAULT_PROJECT);
            if (defaultProjectInterpreterStuckValue == null && (defaultProjectInterpreterStuckValue = defaultProjectPropertiesComponent.getValue(NODEJS_INTERPRETER_PATH)) != null) {
                LOG.info("Reset default project interpreter, prev value: " + defaultProjectInterpreterStuckValue);
                defaultProjectPropertiesComponent.setValue(NODEJS_INTERPRETER_PATH_STUCK_IN_DEFAULT_PROJECT, defaultProjectInterpreterStuckValue);
                defaultProjectPropertiesComponent.unsetValue(NODEJS_INTERPRETER_PATH);
            }
            if (defaultProjectInterpreterStuckValue != null) {
                String value = PropertiesComponent.getInstance((Project)this.myProject).getValue(NODEJS_INTERPRETER_PATH);
                return defaultProjectInterpreterStuckValue.equals(value);
            }
        }
        return false;
    }

    @Nullable
    public NodeJsInterpreter getDefault() {
        return this.getInterpreter();
    }

    public void setDefault(@Nullable NodeJsInterpreter interpreter) {
        this.setInterpreterRef(NodeJsInterpreterRef.create(interpreter));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

