/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.react.ReactAttributeDescriptor;
import com.intellij.lang.javascript.frameworks.react.ReactXmlElementDescriptor;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactTagUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.HtmlXmlExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlTagNameProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactXmlExtension
extends HtmlXmlExtension
implements XmlTagNameProvider {
    public static final String REACT_DEFAULT_MODULE = "react";
    public static final String FRAGMENT_NAME = "Fragment";
    private static final ResolveCache.AbstractResolver<ReactTagNameReference, PsiElement> RESOLVER = (reference, incompleteCode) -> {
        XmlTag tag = reference.getTagElement();
        assert (tag != null);
        PsiElement var = ReactXmlExtension.resolveTagOrComponent(tag);
        if (var != null) {
            return var;
        }
        return null;
    };
    private static final String PROPERTY_RENDER = "render";
    private static final String PROPERTY_PROPS = "propTypes";
    public static final String GET_DEFAULT_PROPS = "getDefaultProps";
    public static final String DEFAULT_PROPS = "defaultProps";
    public static final String CHILDREN = "children";
    private static final XmlExtension.AttributeValuePresentation BRACES_PRESENTATION = new XmlExtension.AttributeValuePresentation(){

        @NotNull
        public String getPrefix() {
            if ("{" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "{";
        }

        @NotNull
        public String getPostfix() {
            if ("}" == null) {
                1.$$$reportNull$$$0(1);
            }
            return "}";
        }

        public boolean showAutoPopup() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPostfix";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private static final XmlExtension.AttributeValuePresentation EMPTY_VALUE_PRESENTATION = new XmlExtension.AttributeValuePresentation(){

        @NotNull
        public String getPrefix() {
            if ("" == null) {
                2.$$$reportNull$$$0(0);
            }
            return "";
        }

        @NotNull
        public String getPostfix() {
            if ("" == null) {
                2.$$$reportNull$$$0(1);
            }
            return "";
        }

        public boolean showAutoPopup() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPostfix";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };

    @Nullable
    private static PsiElement resolveTagOrComponent(XmlTag tag) {
        final String tagName = tag.getName();
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)tag);
        if (isTypeScript && !ReactXmlExtension.isComponentName(tagName)) {
            return TypeScriptReactTagUtil.resolveTag(tag);
        }
        final Ref var = Ref.create();
        JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)tag, null, new ResolveProcessor(tagName, (PsiElement)tag){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(element.getContainingFile().getVirtualFile())) {
                    return false;
                }
                Collection<PsiElement> elements = ReactXmlExtension.getElementsByImport(element);
                for (PsiElement candidate : elements) {
                    String name = ReactXmlExtension.getEffectiveName(element, candidate);
                    if (!StringUtil.equals((CharSequence)tagName, (CharSequence)name) || !ReactXmlExtension.isPossibleReactComponent(candidate)) continue;
                    var.setIfNull((Object)ReactXmlExtension.getElementForResolve(element, candidate));
                }
                return var.isNull();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$3";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, false, null);
        if (!var.isNull()) {
            return (PsiElement)var.get();
        }
        if (isTypeScript) {
            for (JSClass jsClass : TypeScriptReactComponentUtil.resolveComponent(tag)) {
                JSElement container = ES6PsiUtil.getExportScope((PsiElement)jsClass);
                if (TypeScriptPsiUtil.isModule((PsiElement)container, false)) continue;
                return jsClass;
            }
        } else {
            PsiFile file = tag.getContainingFile();
            if (file instanceof JSFile && ((JSFile)file).isCommonJSModule()) {
                return null;
            }
            PsiElement clazz = ReactXmlExtension.resolveClassComponent(tag, tagName);
            if (clazz != null) {
                return clazz;
            }
        }
        return null;
    }

    private static PsiElement getElementForResolve(PsiElement element, PsiElement candidate) {
        if (element instanceof ES6ImportedBinding || element instanceof ES6ImportSpecifierAlias || element instanceof TypeScriptImportStatement || element instanceof JSVariable) {
            return element;
        }
        if (element instanceof ES6ImportSpecifier) {
            Object[] results = ((ES6ImportSpecifier)element).multiResolve(false);
            ResolveResult resolveResult = (ResolveResult)ArrayUtil.getFirstElement((Object[])results);
            return resolveResult == null ? candidate : resolveResult.getElement();
        }
        return candidate;
    }

    @Nullable
    private static PsiElement resolveClassComponent(XmlTag tag, String tagName) {
        JSQualifiedNameImpl fqn = JSQualifiedNameImpl.fromQualifiedName(tagName);
        Ref result = Ref.create();
        if (ReactXmlExtension.isComponentName(tagName)) {
            JSClassIndex.processElements(fqn.getName(), tag.getProject(), JSResolveUtil.getResolveScope((PsiElement)tag), (Processor<JSPsiElementBase>)((Processor)clazz -> {
                JSImplicitElement implicit;
                if (clazz instanceof JSImplicitElement && "ReactCompositeComponent".equals((implicit = (JSImplicitElement)clazz).getTypeString()) && Comparing.equal((Object)fqn.getParent(), (Object)implicit.getNamespace())) {
                    result.set(clazz);
                }
                return result.isNull();
            }));
        }
        return (PsiElement)result.get();
    }

    @Contract(value="null -> false")
    public static boolean isComponentName(@Nullable String tagName) {
        return StringUtil.isCapitalized((String)tagName);
    }

    @Nullable
    protected static JSExpression getInitializer(@NotNull PsiElement clazz) {
        if (clazz == null) {
            ReactXmlExtension.$$$reportNull$$$0(0);
        }
        if (clazz instanceof JSVariable) {
            return ((JSVariable)clazz).getInitializerOrStub();
        }
        if (clazz instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)clazz).getInitializerOrStub();
        }
        if (clazz instanceof JSProperty) {
            JSFunction function = ((JSProperty)clazz).tryGetFunctionInitializer();
            return function instanceof JSExpression ? (JSExpression)function : null;
        }
        return null;
    }

    public boolean isAvailable(PsiFile file) {
        if (file instanceof JSFile) {
            return true;
        }
        FileType type = file.getFileType();
        if (type instanceof LanguageFileType && HTMLLanguage.INSTANCE.equals(((LanguageFileType)type).getLanguage())) {
            JSLanguageDialect configuredJSVersion = DialectDetector.getConfiguredJSVersion(file);
            return configuredJSVersion.getOptionHolder().isJSX;
        }
        return false;
    }

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return nameElement.getTreeParent() instanceof JSXmlLiteralExpressionImpl ? new ReactTagNameReference(nameElement, startTagFlag) : super.createTagNameReference(nameElement, startTagFlag);
    }

    public static boolean isPossibleReactComponent(@NotNull PsiElement candidate) {
        if (candidate == null) {
            ReactXmlExtension.$$$reportNull$$$0(1);
        }
        if (ReactXmlExtension.isReactComponent(candidate)) {
            return true;
        }
        if (candidate instanceof JSVariable || candidate instanceof JSDefinitionExpression || candidate instanceof JSProperty) {
            if (candidate instanceof JSVariable && DialectDetector.isTypeScript(candidate)) {
                return ReactXmlExtension.isCompatibleComponentType(((JSVariable)candidate).getType());
            }
            JSExpression initializer = ReactXmlExtension.getInitializer(candidate);
            JSType type = JSResolveUtil.getExpressionJSType(initializer);
            return ReactXmlExtension.isCompatibleComponentType(type);
        }
        if (candidate instanceof JSClass && !(candidate instanceof TypeScriptTypeAlias)) {
            return !((JSClass)candidate).isInterface() && ((JSClass)candidate).getExtendsList() != null;
        }
        if (candidate instanceof JSCallExpression) {
            JSType type = JSResolveUtil.getExpressionJSType((JSExpression)candidate);
            return ReactXmlExtension.isCompatibleComponentType(type);
        }
        return true;
    }

    protected static boolean isCompatibleComponentType(JSType type) {
        if (type instanceof JSPrimitiveType && !(type instanceof JSStringType)) {
            return false;
        }
        return !(type instanceof JSRecordType) || ((JSRecordType)type).hasProperty(PROPERTY_RENDER);
    }

    public static boolean isReactComponent(@Nullable PsiElement candidate) {
        if (candidate == null) {
            return false;
        }
        if (candidate instanceof JSVariable || candidate instanceof JSDefinitionExpression) {
            JSExpression initializer = ReactXmlExtension.getInitializer(candidate);
            if (initializer instanceof JSXmlLiteralExpressionImpl) {
                return true;
            }
            if (JSXHarmonyLanguageDialect.isReactComponent(initializer)) {
                return true;
            }
            if (DialectDetector.isTypeScript(candidate) && candidate instanceof JSVariable) {
                JSRecordType recordType;
                JSType type = ((JSVariable)candidate).getType();
                JSRecordType jSRecordType = recordType = type != null ? type.asRecordType() : null;
                if (recordType != null && (recordType.hasProperty(PROPERTY_RENDER) || recordType.hasProperty(PROPERTY_PROPS))) {
                    return true;
                }
                if (initializer instanceof JSFunction && ReactXmlExtension.isComponentName(((JSVariable)candidate).getName())) {
                    return ReactXmlExtension.isAcceptableFunctionComponent((JSFunction)initializer);
                }
            }
        }
        if (candidate instanceof JSCallExpression && JSXHarmonyLanguageDialect.isReactComponent((JSExpression)((JSCallExpression)candidate))) {
            return true;
        }
        if (candidate instanceof ES6ImportExportDeclarationPart || candidate instanceof TypeScriptImportStatement) {
            return true;
        }
        if (candidate instanceof JSFunction) {
            JSFunction function = (JSFunction)candidate;
            return function.getName() != null && ReactXmlExtension.isComponentName(function.getName());
        }
        if (candidate instanceof JSClass) {
            return ReactXmlExtension.isAcceptableClassComponent((JSClass)candidate) == ThreeState.YES;
        }
        return false;
    }

    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag, String prefix) {
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(2);
        }
    }

    @Nullable
    static String getEffectiveName(PsiElement element, PsiElement candidate) {
        if (element instanceof ES6ImportedBinding || element instanceof ES6ImportSpecifierAlias || element instanceof TypeScriptImportStatement) {
            return ((PsiNamedElement)element).getName();
        }
        if (element instanceof ES6ImportSpecifier) {
            return ((ES6ImportSpecifier)element).getDeclaredName();
        }
        JSPsiNamedElementBase jsElement = (JSPsiNamedElementBase)ObjectUtils.tryCast((Object)candidate, JSPsiNamedElementBase.class);
        return jsElement != null ? jsElement.getName() : null;
    }

    @NotNull
    public static Collection<PsiElement> getElementsByImport(@Nullable PsiElement element) {
        Collection<PsiElement> collection = ReactXmlExtension.getElementsByImport(element, true);
        if (collection == null) {
            ReactXmlExtension.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> getElementsByImport(@Nullable PsiElement element, boolean resolveCallExpression) {
        PsiElement result;
        if (element instanceof ES6ImportSpecifier) {
            ResolveResult[] results = ((ES6ImportSpecifier)element).resolveOverAliases();
            Collection<PsiElement> collection = JSResolveResult.toElements(results);
            if (collection == null) {
                ReactXmlExtension.$$$reportNull$$$0(4);
            }
            return collection;
        }
        if (element instanceof ES6ImportedBinding || element instanceof ES6ImportExportSpecifierAlias) {
            PsiElement result2 = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element);
            if (resolveCallExpression && result2 instanceof JSCallExpression) {
                List elements = ReactXmlExtension.resolveCallExpression((JSCallExpression)result2);
                List list = elements.size() == 0 ? ContainerUtil.createMaybeSingletonList((Object)result2) : elements;
                if (list == null) {
                    ReactXmlExtension.$$$reportNull$$$0(5);
                }
                return list;
            }
            List list = ContainerUtil.createMaybeSingletonList((Object)result2);
            if (list == null) {
                ReactXmlExtension.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (element instanceof TypeScriptImportStatement) {
            ArrayList arrayList = ContainerUtil.newArrayList((Iterable)((TypeScriptImportStatement)element).findReferencedElements());
            if (arrayList == null) {
                ReactXmlExtension.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        if (element instanceof JSVariable && (result = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element)) != element && result instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)result).getName() != null) {
            List list = ContainerUtil.createMaybeSingletonList((Object)result);
            if (list == null) {
                ReactXmlExtension.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)element);
        if (list == null) {
            ReactXmlExtension.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public static Collection<PsiElement> resolveCallExpression(@NotNull JSCallExpression result) {
        PsiElement componentCandidate;
        PsiElement module;
        String componentName;
        Map strings;
        JSElementIndexingData data;
        if (result == null) {
            ReactXmlExtension.$$$reportNull$$$0(10);
        }
        if ((data = result.getIndexingData()) != null && (strings = data.getUserStrings()) != null && !StringUtil.isEmpty((String)(componentName = (String)strings.get("wrapped.component.name"))) && (module = ES6PsiUtil.findExternalModule((PsiElement)result)) != null && (componentCandidate = JSStubBasedPsiTreeUtil.resolveLocally(componentName, module)) != null && ReactXmlExtension.isPossibleReactComponent(componentCandidate)) {
            List list = ContainerUtil.createMaybeSingletonList((Object)componentCandidate);
            if (list == null) {
                ReactXmlExtension.$$$reportNull$$$0(11);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ReactXmlExtension.$$$reportNull$$$0(12);
        }
        return list;
    }

    public static boolean nonJsxTag(@Nullable XmlTag tag) {
        return !(tag instanceof JSXmlLiteralExpressionImpl) || DialectDetector.dialectOfElement((PsiElement)tag) == DialectOptionHolder.ECMA_4;
    }

    public static ThreeState isAcceptableClassComponent(@NotNull JSClass jsClass) {
        String[] texts;
        if (jsClass == null) {
            ReactXmlExtension.$$$reportNull$$$0(13);
        }
        if (jsClass.isInterface() || jsClass.getExtendsList() == null) {
            return ThreeState.NO;
        }
        for (String text : texts = jsClass.getExtendsList().getReferenceTexts()) {
            if (TypeScriptReactComponentUtil.REACT_COMPONENT_NAMES.contains(text)) {
                return ThreeState.YES;
            }
            for (String name : TypeScriptReactComponentUtil.REACT_COMPONENT_NAMES) {
                if (!text.endsWith("." + name)) continue;
                return ThreeState.YES;
            }
        }
        return ThreeState.NO;
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element, String namespace, boolean strict) {
        XmlElementDescriptor elementDescriptor = element.getDescriptor();
        if (elementDescriptor instanceof ReactXmlElementDescriptor) {
            return elementDescriptor.getNSDescriptor();
        }
        return super.getNSDescriptor(element, namespace, strict);
    }

    public boolean isCollapsibleTag(XmlTag tag) {
        return true;
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag, String attrName) {
        String tagName = tag.getName();
        if (!ReactXmlExtension.isComponentName(tagName)) {
            return false;
        }
        boolean children = CHILDREN.equals(attrName);
        boolean passedAttributes = false;
        for (PsiElement child : tag.getChildren()) {
            if ((!children || passedAttributes) && child instanceof JSEmbeddedContent) {
                return true;
            }
            if (children && (child instanceof XmlText || child instanceof XmlTag)) {
                return true;
            }
            IElementType type = child.getNode().getElementType();
            if (!children && (type == XmlTokenType.XML_EMPTY_ELEMENT_END || type == XmlTokenType.XML_TAG_END)) break;
            passedAttributes |= type == XmlTokenType.XML_TAG_END;
        }
        Processor processor = base -> {
            if (StringUtil.equals((CharSequence)base.getQualifiedName(), (CharSequence)(tagName + "." + DEFAULT_PROPS)) || StringUtil.equals((CharSequence)base.getQualifiedName(), (CharSequence)(tagName + "." + GET_DEFAULT_PROPS))) {
                JSPsiElementBase root;
                Object object = root = base instanceof JSDefinitionExpression ? ((JSDefinitionExpression)base).getInitializerOrStub() : base;
                if (root == null) {
                    return true;
                }
                Collection<JSProperty> properties = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)root, JSStubElementTypes.PROPERTY);
                for (JSProperty property : properties) {
                    if (!StringUtil.equals((CharSequence)attrName, (CharSequence)property.getName())) continue;
                    return false;
                }
            }
            return true;
        };
        return !JSClassResolver.processElementsByNameIncludingImplicit(DEFAULT_PROPS, JSResolveUtil.getResolveScope((PsiElement)tag), false, (Processor<JSPsiElementBase>)processor) || !JSClassResolver.processElementsByNameIncludingImplicit(GET_DEFAULT_PROPS, JSResolveUtil.getResolveScope((PsiElement)tag), false, (Processor<JSPsiElementBase>)processor);
    }

    public boolean shouldBeInserted(XmlAttributeDescriptor descriptor2) {
        if (CHILDREN.equals(descriptor2.getName())) {
            return false;
        }
        return super.shouldBeInserted(descriptor2);
    }

    @NotNull
    public XmlExtension.AttributeValuePresentation getAttributeValuePresentation(@Nullable XmlAttributeDescriptor descriptor2, @NotNull String defaultAttributeQuote) {
        if (defaultAttributeQuote == null) {
            ReactXmlExtension.$$$reportNull$$$0(14);
        }
        if (descriptor2 != null) {
            JSCodeStyleSettings.JSXAttributeValuePresentation presentation = ReactXmlExtension.getAttributeValue(descriptor2);
            if (presentation == JSCodeStyleSettings.JSXAttributeValuePresentation.BRACES) {
                XmlExtension.AttributeValuePresentation attributeValuePresentation = ReactXmlExtension.createValueWithBraces();
                if (attributeValuePresentation == null) {
                    ReactXmlExtension.$$$reportNull$$$0(15);
                }
                return attributeValuePresentation;
            }
            if (presentation == JSCodeStyleSettings.JSXAttributeValuePresentation.NONE) {
                XmlExtension.AttributeValuePresentation attributeValuePresentation = ReactXmlExtension.createEmptyValue();
                if (attributeValuePresentation == null) {
                    ReactXmlExtension.$$$reportNull$$$0(16);
                }
                return attributeValuePresentation;
            }
        }
        XmlExtension.AttributeValuePresentation attributeValuePresentation = super.getAttributeValuePresentation(descriptor2, defaultAttributeQuote);
        if (attributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(17);
        }
        return attributeValuePresentation;
    }

    @NotNull
    private static JSCodeStyleSettings.JSXAttributeValuePresentation getTypeBasedJSXAttributeValuePresentation(@NotNull XmlAttributeDescriptor descriptor2) {
        JSType attributeType;
        if (descriptor2 == null) {
            ReactXmlExtension.$$$reportNull$$$0(18);
        }
        JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = !((attributeType = ReactXmlExtension.getType(descriptor2)) instanceof JSStringType) ? JSCodeStyleSettings.JSXAttributeValuePresentation.BRACES : JSCodeStyleSettings.JSXAttributeValuePresentation.QUOTES;
        if (jSXAttributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(19);
        }
        return jSXAttributeValuePresentation;
    }

    @NotNull
    public static JSCodeStyleSettings.JSXAttributeValuePresentation getAttributeValue(@Nullable XmlAttributeDescriptor descriptor2) {
        if (descriptor2 instanceof ReactAttributeDescriptor) {
            PsiElement declaration = descriptor2.getDeclaration();
            if (declaration == null) {
                JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = JSCodeStyleSettings.DEFAULT_JSX_VALUE;
                if (jSXAttributeValuePresentation == null) {
                    ReactXmlExtension.$$$reportNull$$$0(20);
                }
                return jSXAttributeValuePresentation;
            }
            JSCodeStyleSettings.JSXAttributeValuePresentation value = JSCodeStyleSettings.getJSXAttributeValue(declaration);
            if (value == JSCodeStyleSettings.JSXAttributeValuePresentation.TYPE_BASED) {
                JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = ReactXmlExtension.getTypeBasedJSXAttributeValuePresentation(descriptor2);
                if (jSXAttributeValuePresentation == null) {
                    ReactXmlExtension.$$$reportNull$$$0(21);
                }
                return jSXAttributeValuePresentation;
            }
            JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = value;
            if (jSXAttributeValuePresentation == null) {
                ReactXmlExtension.$$$reportNull$$$0(22);
            }
            return jSXAttributeValuePresentation;
        }
        JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = JSCodeStyleSettings.JSXAttributeValuePresentation.QUOTES;
        if (jSXAttributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(23);
        }
        return jSXAttributeValuePresentation;
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation createValueWithBraces() {
        XmlExtension.AttributeValuePresentation attributeValuePresentation = BRACES_PRESENTATION;
        if (attributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(24);
        }
        return attributeValuePresentation;
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation createEmptyValue() {
        XmlExtension.AttributeValuePresentation attributeValuePresentation = EMPTY_VALUE_PRESENTATION;
        if (attributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(25);
        }
        return attributeValuePresentation;
    }

    @Nullable
    public static JSType getType(@Nullable XmlAttributeDescriptor descriptor2) {
        String typeString;
        if (descriptor2 == null) {
            return null;
        }
        PsiElement declaration = descriptor2.getDeclaration();
        if (declaration instanceof TypeScriptField) {
            TypeScriptField signature = (TypeScriptField)declaration;
            return signature.getType();
        }
        if (declaration instanceof JSLocalImplicitElementImpl) {
            return ((JSLocalImplicitElementImpl)declaration).getJSType();
        }
        if (declaration instanceof JSImplicitElement && !StringUtil.isEmpty((String)(typeString = ((JSImplicitElement)declaration).getTypeString()))) {
            return JSNamedType.createType(typeString, JSTypeSourceFactory.createTypeSource(declaration), JSTypeContext.INSTANCE);
        }
        return null;
    }

    static boolean isAcceptableFunctionComponent(@NotNull JSFunction element) {
        JSType returnedType;
        if (element == null) {
            ReactXmlExtension.$$$reportNull$$$0(26);
        }
        if ((returnedType = element.getReturnType()) instanceof JSPrimitiveType) {
            return false;
        }
        JSParameterListElement[] parameters = element.getParameters();
        return parameters.length == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAttributeQuote";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsByImport";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCallExpression";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValuePresentation";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeBasedJSXAttributeValuePresentation";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValue";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueWithBraces";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInitializer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleReactComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTagNameVariants";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallExpression";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableClassComponent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValuePresentation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeBasedJSXAttributeValuePresentation";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableFunctionComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ReactTagNameReference
    extends TagNameReference {
        public ReactTagNameReference(ASTNode nameElement, boolean startTagFlag) {
            super(nameElement, startTagFlag);
        }

        public PsiElement resolve() {
            XmlTag tag = this.getTagElement();
            if (ReactXmlExtension.nonJsxTag(tag)) {
                return super.resolve();
            }
            PsiElement element = (PsiElement)ResolveCache.getInstance((Project)tag.getProject()).resolveWithCaching((PsiReference)this, RESOLVER, false, false);
            if (element instanceof ES6ImportedBinding) {
                JSElement topLevelContainer = ES6PsiUtil.getExportScope(element);
                JSElement currentContainer = ES6PsiUtil.getExportScope((PsiElement)tag);
                if (topLevelContainer != null && topLevelContainer.isEquivalentTo((PsiElement)currentContainer)) {
                    return element;
                }
            }
            return element != null ? element : super.resolve();
        }

        @Nullable
        public XmlTag getTagElement() {
            return super.getTagElement();
        }
    }
}

