/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfigManager;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.InstallNodeModuleAddToDependenciesQuickFix;
import com.intellij.lang.javascript.modules.InstallNodeModuleAddToDevDependenciesQuickFix;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.JSModuleVisitor;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.RecordModuleIntoDepPackageJsonQuickFix;
import com.intellij.lang.javascript.modules.RecordModuleIntoDevPackageJsonQuickFix;
import com.intellij.lang.javascript.modules.RunNpmUpdateQuickFix;
import com.intellij.lang.javascript.modules.TypeScriptInstallGlobalTypesFix;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmUsedModulesInstalledInspection
extends JSInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.modules.NpmUsedModulesInstalledInspection");
    public static final String[] NODE_MODULES = new String[]{"node_modules"};

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, final LocalInspectionToolSession session) {
        JSModuleVisitor jSModuleVisitor = new JSModuleVisitor(){

            @Override
            protected void processRequire(@NotNull JSCallExpression call, @NotNull JSLiteralExpression argument, @NotNull JSModuleVisitor.ImportResolver importResolver, @NotNull JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (argument == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (importResolver == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pointerBuilder == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!NodeJsCoreLibraryManager.isAssociatedWithNodeCoreLibrary(session.getFile())) {
                    return;
                }
                Project project = session.getFile().getProject();
                String referenceText = StringUtil.unquoteString((String)argument.getText());
                Convertor<VirtualFile, VirtualFile> resolver = this.getRequireImportResolver(project, (JSExpression)argument, referenceText);
                NpmUsedModulesInstalledInspection.check((PsiElement)argument, referenceText, holder, importResolver, (Convertor<VirtualFile, VirtualFile>)resolver, pointerBuilder);
            }

            @Override
            protected void processImport(@NotNull PsiElement literalElement, @NotNull String refText, @NotNull PsiReference[] references, @NotNull JSModuleVisitor.ImportResolver importResolver, @NotNull JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                if (literalElement == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (refText == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (references == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (importResolver == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (pointerBuilder == null) {
                    1.$$$reportNull$$$0(8);
                }
                Convertor resolver = NpmUsedModulesInstalledInspection.getES6Resolver(importResolver);
                NpmUsedModulesInstalledInspection.check(literalElement, refText, holder, importResolver, (Convertor<VirtualFile, VirtualFile>)resolver, pointerBuilder);
            }

            @Override
            protected boolean isAvailable(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(9);
                }
                return DialectDetector.isJavaScript(element);
            }

            @NotNull
            private Convertor<VirtualFile, VirtualFile> getRequireImportResolver(@NotNull Project project, @NotNull JSExpression argument, @NotNull String referenceText) {
                if (project == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (argument == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (referenceText == null) {
                    1.$$$reportNull$$$0(12);
                }
                Convertor convertor = moduleRoot -> {
                    String[] split;
                    ResolveResult[] resolve;
                    JSModuleBaseReference reference;
                    if (argument == null) {
                        1.$$$reportNull$$$0(14);
                    }
                    if (project == null) {
                        1.$$$reportNull$$$0(15);
                    }
                    if (referenceText == null) {
                        1.$$$reportNull$$$0(16);
                    }
                    if ((reference = this.getNodeModuleReference(argument)) == null) {
                        return null;
                    }
                    Object list = reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false) : ((resolve = ((PsiReference)reference).resolve()) != null ? new ResolveResult[]{new PsiElementResolveResult((PsiElement)resolve)} : null);
                    if (list != null) {
                        for (ResolveResult result : list) {
                            PsiFileSystemItem psiFile;
                            if (result == null || !result.isValidResult() || result.getElement() == null || !result.getElement().isValid()) continue;
                            PsiElement resolve2 = result.getElement();
                            Object object = psiFile = resolve2 instanceof PsiFileSystemItem ? (PsiFileSystemItem)resolve2 : resolve2.getContainingFile();
                            if (psiFile.isDirectory() || !DialectDetector.JAVASCRIPT_FILE_TYPES.contains(psiFile.getVirtualFile().getFileType()) && !TypeScriptUtil.isDefinitionFile(psiFile.getVirtualFile()) || !(psiFile instanceof PsiFile) || !NodeModuleUtil.checkNodeModulesAssociation((PsiFile)psiFile, true) || NodeModuleUtil.getRequireModuleInfo(project, moduleRoot, psiFile.getVirtualFile()) == null) continue;
                            return psiFile.getVirtualFile();
                        }
                    }
                    String name = (split = referenceText.replace("\\", "/").split("/")).length == 0 ? referenceText : split[0];
                    VirtualFile nm = moduleRoot.findChild("node_modules");
                    if (nm != null) {
                        return nm.findChild(name);
                    }
                    return null;
                };
                if (convertor == null) {
                    1.$$$reportNull$$$0(13);
                }
                return convertor;
            }

            private JSModuleBaseReference getNodeModuleReference(JSExpression argument) {
                PsiReference[] references;
                for (PsiReference reference : references = argument.getReferences()) {
                    if (!(reference instanceof JSModuleBaseReference)) continue;
                    return (JSModuleBaseReference)reference;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 13: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 13: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: 
                    case 11: 
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "argument";
                        break;
                    }
                    case 2: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "importResolver";
                        break;
                    }
                    case 3: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pointerBuilder";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "literalElement";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refText";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "references";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 10: 
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 12: 
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceText";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection$1";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRequireImportResolver";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processRequire";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "processImport";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "getRequireImportResolver";
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$getRequireImportResolver$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 13: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (jSModuleVisitor == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(0);
        }
        return jSModuleVisitor;
    }

    @NotNull
    private static Convertor<VirtualFile, VirtualFile> getES6Resolver(@NotNull JSModuleVisitor.ImportResolver resolver) {
        if (resolver == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(1);
        }
        Convertor convertor = moduleRoot -> {
            if (resolver == null) {
                NpmUsedModulesInstalledInspection.$$$reportNull$$$0(16);
            }
            for (PsiElement element : resolver.resolveImportModules()) {
                VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
                if (file == null) continue;
                return file;
            }
            return null;
        };
        if (convertor == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(2);
        }
        return convertor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Check require() reference" == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(3);
        }
        return "Check require() reference";
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    private static void check(@Nullable PsiElement element, @Nullable String referenceText, ProblemsHolder holder, @NotNull JSModuleVisitor.ImportResolver importResolver, @NotNull Convertor<VirtualFile, VirtualFile> resolver, @NotNull JSModuleVisitor.ModulePointerBuilder pointerCreator) {
        if (importResolver == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(5);
        }
        if (resolver == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(6);
        }
        if (pointerCreator == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(7);
        }
        if (referenceText == null || element == null) {
            return;
        }
        String moduleName = JSFileReferencesUtil.getNodeModuleName(referenceText = referenceText.trim());
        if (!JSFileReferencesUtil.isAcceptableNodeModulesPackageName(moduleName)) {
            return;
        }
        Project project = element.getProject();
        if (NpmUsedModulesInstalledInspection.isAliasedModule(moduleName, project)) {
            return;
        }
        if (NodeJsCoreLibraryManager.isCoreModuleName(moduleName)) {
            return;
        }
        VirtualFile coreModule = NodeJsCoreLibraryManager.getInstance(project).findCoreModuleFileByName(moduleName);
        if (coreModule != null) {
            return;
        }
        if (PackageJsonDependenciesExternalUpdateManager.getInstance(project).isExternalUpdateRunning(moduleName)) {
            return;
        }
        Collection packageJsonFiles = FilenameIndex.getVirtualFilesByName((Project)project, (String)"package.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        packageJsonFiles = ContainerUtil.filter((Collection)packageJsonFiles, file -> !JSLibraryUtil.isProbableLibraryFile(file));
        boolean inPackageJson = false;
        InstallationDetector installationDetector = new InstallationDetector(project, resolver);
        if (!packageJsonFiles.isEmpty()) {
            for (VirtualFile packageJsonFile : packageJsonFiles) {
                VirtualFile moduleRoot = packageJsonFile.getParent();
                if (moduleRoot == null || !packageJsonFile.isValid()) continue;
                boolean notInPackageJson = NodeModuleUtil.moduleNotInPackageJson(moduleName, packageJsonFile);
                if (!notInPackageJson) {
                    inPackageJson = true;
                }
                installationDetector.accept(moduleRoot);
                if (!inPackageJson || !installationDetector.isInstalledMaybeMultiple()) continue;
                if (NpmUsedModulesInstalledInspection.modulePackageJsonHasTypings(moduleName, installationDetector.myNodeModules) == ModuleTypingsState.NO_TYPINGS && !moduleName.startsWith("@")) {
                    Collection<PsiElement> elements = importResolver.resolveImportModules();
                    for (PsiElement psiElement : elements) {
                        if (!DialectDetector.isTypeScript(psiElement)) continue;
                        return;
                    }
                    holder.registerProblem(element, JSBundle.message((String)"npm.modules.install.global.types.fix.name", (Object[])new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new TypeScriptInstallGlobalTypesFix(moduleName)});
                }
                return;
            }
        }
        if (!installationDetector.isInstalledMaybeMultiple() && packageJsonFiles.isEmpty()) {
            installationDetector.accept(project.getBaseDir());
        }
        InstallNodeModuleQuickFix.ModuleElement moduleElement = pointerCreator.createPointer();
        if (!installationDetector.isLibraryResolveOnly() && installationDetector.isInstalledMaybeMultiple()) {
            return;
        }
        VirtualFile nodeModules = installationDetector.isInstalledMaybeMultiple() ? installationDetector.getNodeModules() : null;
        NpmUsedModulesInstalledInspection.reportModulesIsNotInstalledErrorWithFixes(moduleElement, packageJsonFiles, inPackageJson, nodeModules, (text, fixes) -> holder.registerProblem(element, text, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes.toArray(LocalQuickFix.EMPTY_ARRAY)));
    }

    public static void reportModulesIsNotInstalledErrorWithFixes(@NotNull InstallNodeModuleQuickFix.ModuleElement moduleElement, @NotNull Collection<VirtualFile> packageJsonFiles, boolean inPackageJson, @Nullable VirtualFile nodeModules, @NotNull Reporter reporter) {
        if (moduleElement == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(8);
        }
        if (packageJsonFiles == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(9);
        }
        if (reporter == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(10);
        }
        if (nodeModules != null) {
            if (!inPackageJson) {
                NpmUsedModulesInstalledInspection.reportModuleIsNotInDependencies(packageJsonFiles, nodeModules, moduleElement, reporter);
            }
        } else {
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            if (!inPackageJson) {
                fixes.add(new InstallNodeModuleAddToDependenciesQuickFix(moduleElement, packageJsonFiles));
                fixes.add(new InstallNodeModuleAddToDevDependenciesQuickFix(moduleElement, packageJsonFiles));
            }
            fixes.add(new InstallNodeModuleQuickFix(moduleElement, packageJsonFiles));
            if (!packageJsonFiles.isEmpty()) {
                fixes.add(new RunNpmUpdateQuickFix(moduleElement, packageJsonFiles));
            }
            reporter.reportError(JSBundle.message((String)"npm.modules.inspection.content.of.require.module.not.installed.warning", (Object[])new Object[0]), fixes);
        }
    }

    private static void reportModuleIsNotInDependencies(@NotNull Collection<VirtualFile> packageJsonFiles, @NotNull VirtualFile nodeModules, @NotNull InstallNodeModuleQuickFix.ModuleElement moduleElement, @NotNull Reporter reporter) {
        if (packageJsonFiles == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(11);
        }
        if (nodeModules == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(12);
        }
        if (moduleElement == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(13);
        }
        if (reporter == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(14);
        }
        reporter.reportError(JSBundle.message((String)"npm.modules.inspection.content.of.require.not.in.dependencies.warning", (Object[])new Object[0]), ContainerUtil.newArrayList((Object[])new LocalQuickFix[]{new RecordModuleIntoDepPackageJsonQuickFix(moduleElement, packageJsonFiles, nodeModules), new RecordModuleIntoDevPackageJsonQuickFix(moduleElement, packageJsonFiles, nodeModules)}));
    }

    private static boolean isAliasedModule(String moduleName, Project project) {
        Map<String, String> alias = WebPackConfigManager.Companion.instance(project).config().getResolve().getAlias();
        return alias.containsKey(moduleName) || alias.containsKey(moduleName + "$");
    }

    public static ModuleTypingsState modulePackageJsonHasTypings(@NotNull String moduleName, @Nullable VirtualFile nodeModulesDirectory) {
        if (moduleName == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(15);
        }
        if (nodeModulesDirectory == null) {
            return ModuleTypingsState.MODULE_DIRECTORY_NOT_EXIST;
        }
        ArrayList mutableListOf = ContainerUtil.newArrayList();
        mutableListOf.addAll(Arrays.stream(moduleName.split("/")).filter(el -> !StringUtil.isEmpty((String)el)).collect(Collectors.toList()));
        mutableListOf.add("package.json");
        VirtualFile packageJsonForModule = VfsUtil.findRelativeFile((VirtualFile)nodeModulesDirectory, (String[])mutableListOf.toArray(ArrayUtil.EMPTY_STRING_ARRAY));
        if (packageJsonForModule != null) {
            PackageJsonData moduleData = PackageJsonData.getOrCreate(packageJsonForModule);
            return moduleData.hasTypings() ? ModuleTypingsState.HAS_TYPINGS : ModuleTypingsState.NO_TYPINGS;
        }
        return ModuleTypingsState.MODULE_DIRECTORY_NOT_EXIST;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection";
                break;
            }
            case 1: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importResolver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointerCreator";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleElement";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModules";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getES6Resolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getES6Resolver";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportModulesIsNotInstalledErrorWithFixes";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reportModuleIsNotInDependencies";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "modulePackageJsonHasTypings";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getES6Resolver$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ModuleTypingsState {
        HAS_TYPINGS,
        NO_TYPINGS,
        MODULE_DIRECTORY_NOT_EXIST;

    }

    private static class InstallationDetector {
        private boolean myIsLibraryResolveOnly;
        private boolean myMultipleInstallations;
        private VirtualFile myNodeModules;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Convertor<VirtualFile, VirtualFile> myResolver;

        public InstallationDetector(@NotNull Project project, @NotNull Convertor<VirtualFile, VirtualFile> resolver) {
            if (project == null) {
                InstallationDetector.$$$reportNull$$$0(0);
            }
            if (resolver == null) {
                InstallationDetector.$$$reportNull$$$0(1);
            }
            this.myIsLibraryResolveOnly = true;
            this.myProject = project;
            this.myResolver = resolver;
        }

        public void accept(@NotNull VirtualFile packageJsonParent) {
            VirtualFile resolveFile;
            if (packageJsonParent == null) {
                InstallationDetector.$$$reportNull$$$0(2);
            }
            if ((resolveFile = (VirtualFile)this.myResolver.convert((Object)packageJsonParent)) != null) {
                this.myIsLibraryResolveOnly &= JSLibraryUtil.hasDirectoryInPath(resolveFile, NODE_MODULES, NodeModuleUtil.findParentContentRoot(this.myProject, resolveFile));
                VirtualFile folder = JSLibraryUtil.getTopLibraryFolder(resolveFile, NODE_MODULES[0], null);
                if (folder != null) {
                    if (!this.myMultipleInstallations && this.myNodeModules == null) {
                        this.myNodeModules = folder.getParent();
                    } else {
                        this.myMultipleInstallations = true;
                        this.myNodeModules = null;
                    }
                }
            }
        }

        public boolean isLibraryResolveOnly() {
            return this.myIsLibraryResolveOnly;
        }

        public boolean isInstalledMaybeMultiple() {
            return this.myNodeModules != null || this.myMultipleInstallations;
        }

        public boolean isInstalled() {
            return this.myNodeModules != null;
        }

        public boolean isMultipleInstallations() {
            return this.myMultipleInstallations;
        }

        public VirtualFile getNodeModules() {
            return this.myNodeModules;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJsonParent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection$InstallationDetector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface Reporter {
        public void reportError(@NotNull String var1, @NotNull List<LocalQuickFix> var2);
    }
}

