/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.utils.BinaryOperatorUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParenthesesUtils {
    private static final int PARENTHESIZED_PRECEDENCE = 0;
    private static final int LITERAL_PRECEDENCE = 0;
    public static final int METHOD_CALL_PRECEDENCE = 1;
    private static final int POSTFIX_PRECEDENCE = 2;
    public static final int PREFIX_PRECEDENCE = 3;
    public static final int TYPE_CAST_PRECEDENCE = 4;
    public static final int MULTIPLICATIVE_PRECEDENCE = 5;
    private static final int ADDITIVE_PRECEDENCE = 6;
    public static final int SHIFT_PRECEDENCE = 7;
    private static final int RELATIONAL_PRECEDENCE = 8;
    private static final int EQUALITY_PRECEDENCE = 9;
    private static final int BINARY_AND_PRECEDENCE = 10;
    private static final int BINARY_XOR_PRECEDENCE = 11;
    private static final int BINARY_OR_PRECEDENCE = 12;
    public static final int AND_PRECEDENCE = 13;
    public static final int OR_PRECEDENCE = 14;
    public static final int CONDITIONAL_PRECEDENCE = 15;
    private static final int ASSIGNMENT_PRECEDENCE = 16;
    private static final int NUM_PRECEDENCES = 17;
    private static final Map<IElementType, Integer> s_binaryOperatorPrecedence = new HashMap<IElementType, Integer>(17);

    private ParenthesesUtils() {
    }

    public static int getPrecedence(JSExpression exp) {
        if (exp instanceof JSThisExpression || exp instanceof JSLiteralExpression || exp instanceof JSObjectLiteralExpression || exp instanceof JSArrayLiteralExpression || exp instanceof JSIndexedPropertyAccessExpression) {
            return 0;
        }
        if (exp instanceof JSReferenceExpression) {
            if (((JSReferenceExpression)exp).getQualifier() != null) {
                return 1;
            }
            return 0;
        }
        if (exp instanceof JSCallExpression || exp instanceof ES6TaggedTemplateExpression) {
            return 1;
        }
        if (exp instanceof JSPrefixExpression) {
            return 3;
        }
        if (exp instanceof JSPostfixExpression) {
            return 2;
        }
        if (exp instanceof JSBinaryExpression && !(exp instanceof JSAssignmentExpression)) {
            IElementType sign = ((JSBinaryExpression)exp).getOperationSign();
            return ParenthesesUtils.precedenceForBinaryOperator(sign);
        }
        if (exp instanceof JSConditionalExpression) {
            return 15;
        }
        if (exp instanceof JSAssignmentExpression) {
            return 16;
        }
        if (exp instanceof JSParenthesizedExpression) {
            return 0;
        }
        return -1;
    }

    private static int precedenceForBinaryOperator(IElementType sign) {
        if (s_binaryOperatorPrecedence.containsKey(sign)) {
            return s_binaryOperatorPrecedence.get(sign);
        }
        return 16;
    }

    @Nullable
    public static JSExpression stripParentheses(JSExpression exp) {
        while (exp instanceof JSParenthesizedExpression) {
            exp = ((JSParenthesizedExpression)exp).getInnerExpression();
        }
        return exp;
    }

    public static String removeParentheses(JSExpression expression) {
        if (expression instanceof JSCallExpression) {
            return ParenthesesUtils.removeParensFromFunctionCallExpression((JSCallExpression)expression);
        }
        if (expression instanceof ES6TaggedTemplateExpression) {
            return ParenthesesUtils.removeParensFromTaggedTemplateExpression((ES6TaggedTemplateExpression)expression);
        }
        if (expression instanceof JSReferenceExpression) {
            return ParenthesesUtils.removeParensFromReferenceExpression((JSReferenceExpression)expression);
        }
        if (expression instanceof JSAssignmentExpression) {
            return ParenthesesUtils.removeParensFromAssignmentExpression((JSAssignmentExpression)expression);
        }
        if (expression instanceof JSArrayLiteralExpression) {
            return ParenthesesUtils.removeParensFromArrayLiteralExpression((JSArrayLiteralExpression)expression);
        }
        if (expression instanceof JSPrefixExpression) {
            return ParenthesesUtils.removeParensFromPrefixExpression((JSPrefixExpression)expression);
        }
        if (expression instanceof JSPostfixExpression) {
            return ParenthesesUtils.removeParensFromPostfixExpression((JSPostfixExpression)expression);
        }
        if (expression instanceof JSBinaryExpression) {
            return ParenthesesUtils.removeParensFromBinaryExpression((JSBinaryExpression)expression);
        }
        if (expression instanceof JSConditionalExpression) {
            return ParenthesesUtils.removeParensFromConditionalExpression((JSConditionalExpression)expression);
        }
        if (expression instanceof JSParenthesizedExpression) {
            JSExpression innerExpression = ((JSParenthesizedExpression)expression).getInnerExpression();
            if (innerExpression instanceof JSCallExpression) {
                return innerExpression.getText();
            }
            return ParenthesesUtils.removeParensFromParenthesizedExpression((JSParenthesizedExpression)expression);
        }
        return expression.getText();
    }

    private static String removeParensFromReferenceExpression(JSReferenceExpression expression) {
        JSExpression qualifier = expression.getQualifier();
        if (qualifier != null) {
            return ParenthesesUtils.removeParentheses(qualifier) + '.' + expression.getReferencedName();
        }
        return expression.getText();
    }

    private static String removeParensFromParenthesizedExpression(JSParenthesizedExpression parenthesizedExp) {
        int childPrecedence;
        JSExpression body = ParenthesesUtils.stripParentheses(parenthesizedExp.getInnerExpression());
        if (!(parenthesizedExp.getParent() instanceof JSExpression)) {
            return ParenthesesUtils.removeParentheses(body);
        }
        JSExpression parentExp = (JSExpression)parenthesizedExp.getParent();
        int parentPrecedence = ParenthesesUtils.getPrecedence(parentExp);
        if (parentPrecedence < (childPrecedence = ParenthesesUtils.getPrecedence(body))) {
            return '(' + ParenthesesUtils.removeParentheses(body) + ')';
        }
        if (parentPrecedence == childPrecedence) {
            if (parentExp instanceof JSBinaryExpression && body instanceof JSBinaryExpression) {
                IElementType parentOperator = ((JSBinaryExpression)parentExp).getOperationSign();
                IElementType bodyOperator = ((JSBinaryExpression)body).getOperationSign();
                JSExpression lhs = ((JSBinaryExpression)parentExp).getLOperand();
                if (lhs.equals(parenthesizedExp) && parentOperator.equals(bodyOperator)) {
                    return ParenthesesUtils.removeParentheses(body);
                }
                return '(' + ParenthesesUtils.removeParentheses(body) + ')';
            }
            return ParenthesesUtils.removeParentheses(body);
        }
        return ParenthesesUtils.removeParentheses(body);
    }

    private static String removeParensFromConditionalExpression(JSConditionalExpression conditionalExp) {
        JSExpression condition = conditionalExp.getCondition();
        JSExpression thenBranch = conditionalExp.getThen();
        JSExpression elseBranch = conditionalExp.getElse();
        return ParenthesesUtils.removeParentheses(condition) + " ? " + ParenthesesUtils.removeParentheses(thenBranch) + " : " + ParenthesesUtils.removeParentheses(elseBranch);
    }

    private static String removeParensFromBinaryExpression(JSBinaryExpression binaryExp) {
        JSExpression lhs = binaryExp.getLOperand();
        JSExpression rhs = binaryExp.getROperand();
        IElementType sign = binaryExp.getOperationSign();
        return ParenthesesUtils.removeParentheses(lhs) + ' ' + BinaryOperatorUtils.getOperatorText(sign) + ' ' + ParenthesesUtils.removeParentheses(rhs);
    }

    private static String removeParensFromPostfixExpression(JSPostfixExpression postfixExp) {
        JSExpression body = postfixExp.getExpression();
        IElementType sign = postfixExp.getOperationSign();
        return ParenthesesUtils.removeParentheses(body) + BinaryOperatorUtils.getOperatorText(sign);
    }

    private static String removeParensFromPrefixExpression(JSPrefixExpression prefixExp) {
        JSExpression body = prefixExp.getExpression();
        IElementType sign = prefixExp.getOperationSign();
        String bodyText = ParenthesesUtils.removeParentheses(body);
        assert (sign != null) : prefixExp.getText();
        String signText = BinaryOperatorUtils.getOperatorText(sign);
        if (sign == JSTokenTypes.TYPEOF_KEYWORD || sign == JSTokenTypes.DELETE_KEYWORD || sign == JSTokenTypes.AWAIT_KEYWORD) {
            signText = signText + " ";
        }
        return signText + bodyText;
    }

    private static String removeParensFromArrayLiteralExpression(JSArrayLiteralExpression init) {
        JSExpression[] contents = init.getExpressions();
        String text = init.getText();
        int textLength = text.length();
        StringBuilder out = new StringBuilder(textLength);
        out.append('[');
        ParenthesesUtils.removeParenthesesFromCommaSeparatedExpressions(contents, out);
        return out.append(']').toString();
    }

    private static void removeParenthesesFromCommaSeparatedExpressions(JSExpression[] contents, StringBuilder out) {
        for (int index = 0; index < contents.length; ++index) {
            JSExpression arg = contents[index];
            if (index != 0) {
                out.append(',');
            }
            out.append(ParenthesesUtils.removeParentheses(arg));
        }
    }

    private static String removeParensFromAssignmentExpression(JSAssignmentExpression assignment) {
        JSExpression lhs = assignment.getLOperand();
        JSExpression rhs = assignment.getROperand();
        IElementType sign = assignment.getOperationSign();
        return ParenthesesUtils.removeParentheses(lhs) + ' ' + BinaryOperatorUtils.getOperatorText(sign) + ' ' + ParenthesesUtils.removeParentheses(rhs);
    }

    private static String removeParensFromFunctionCallExpression(JSCallExpression functionCall) {
        JSExpression target = functionCall.getMethodExpression();
        JSExpression[] args = functionCall.getArguments();
        StringBuilder out = new StringBuilder(functionCall.getTextLength());
        String strippedTarget = ParenthesesUtils.removeParentheses(target);
        out.append(strippedTarget);
        out.append('(');
        ParenthesesUtils.removeParenthesesFromCommaSeparatedExpressions(args, out);
        out.append(')');
        return out.toString();
    }

    private static String removeParensFromTaggedTemplateExpression(@NotNull ES6TaggedTemplateExpression expression) {
        JSStringTemplateExpression templateExpression;
        if (expression == null) {
            ParenthesesUtils.$$$reportNull$$$0(0);
        }
        JSExpression target = expression.getTag();
        StringBuilder out = new StringBuilder(expression.getTextLength());
        if (target != null) {
            out.append(ParenthesesUtils.removeParentheses(target));
        }
        if ((templateExpression = expression.getTemplateExpression()) != null) {
            out.append(templateExpression.getText());
        }
        return out.toString();
    }

    public static JSExpression unstripParentheses(JSExpression expression) {
        JSExpression parenthesized = expression;
        if (parenthesized != null) {
            PsiElement parent = parenthesized.getParent();
            while (parent instanceof JSParenthesizedExpression) {
                parenthesized = (JSParenthesizedExpression)parent;
                parent = parenthesized.getParent();
            }
        }
        return parenthesized;
    }

    public static String getParenthesized(@NotNull JSExpression expression, int precedence) {
        if (expression == null) {
            ParenthesesUtils.$$$reportNull$$$0(1);
        }
        return ParenthesesUtils.getPrecedence(expression) > precedence ? '(' + expression.getText() + ')' : expression.getText();
    }

    static {
        s_binaryOperatorPrecedence.put(JSTokenTypes.PLUS, 6);
        s_binaryOperatorPrecedence.put(JSTokenTypes.MINUS, 6);
        s_binaryOperatorPrecedence.put(JSTokenTypes.MULT, 5);
        s_binaryOperatorPrecedence.put(JSTokenTypes.DIV, 5);
        s_binaryOperatorPrecedence.put(JSTokenTypes.PERC, 5);
        s_binaryOperatorPrecedence.put(JSTokenTypes.ANDAND, 13);
        s_binaryOperatorPrecedence.put(JSTokenTypes.OROR, 14);
        s_binaryOperatorPrecedence.put(JSTokenTypes.AND, 10);
        s_binaryOperatorPrecedence.put(JSTokenTypes.OR, 12);
        s_binaryOperatorPrecedence.put(JSTokenTypes.XOR, 11);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LTLT, 7);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GTGT, 7);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GTGTGT, 7);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GT, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GE, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LT, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LE, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.EQEQ, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.EQEQEQ, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.NE, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.NEQEQ, 9);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expression";
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/ParenthesesUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromTaggedTemplateExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParenthesized";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

