/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.JSGetterSetterRenameUtil;
import com.intellij.lang.javascript.search.JSMembersSearch;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMemberRenameProcessor
extends JSDefaultRenameProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(0);
        }
        if (!super.canProcessElement(element)) {
            return false;
        }
        if (!JSClassUtils.isPossibleHierarchyMember(element)) {
            return false;
        }
        if (DialectDetector.isActionScript(element)) {
            return false;
        }
        return JSUtils.getMemberContainingClass(element) != null;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames, SearchScope scope) {
        super.prepareRenaming(element, newName, allRenames, scope);
        if (!JSClassUtils.isPossibleHierarchyMember(element)) {
            return;
        }
        JSClass jsClass = JSUtils.getMemberContainingClass(element);
        if (jsClass == null) {
            return;
        }
        JSMemberRenameProcessor.iterateMethodsDown(element, newName, allRenames, jsClass);
        Map<PsiElement, String> elementsToRename = JSGetterSetterRenameUtil.getRelatedElementsInClass(element, jsClass, newName);
        allRenames.putAll(elementsToRename);
        for (Map.Entry<PsiElement, String> entry : elementsToRename.entrySet()) {
            JSMemberRenameProcessor.iterateMethodsDown(entry.getKey(), entry.getValue(), allRenames, jsClass);
        }
    }

    private static void iterateMethodsDown(@NotNull PsiElement element, String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull JSClass jsClass) {
        Query<JSPsiElementBase> members;
        JSAttributeListOwner jsMember;
        if (element == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(1);
        }
        if (allRenames == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(2);
        }
        if (jsClass == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(3);
        }
        if (!JSInheritanceUtil.canBeSuperMember(jsMember = (JSAttributeListOwner)element)) {
            return;
        }
        if (JSClassUtils.isAllowImplementation(jsClass, element)) {
            members = JSMembersSearch.searchImplementingMembers((JSPsiElementBase)jsMember, false);
            members.forEach(el -> {
                if (allRenames == null) {
                    JSMemberRenameProcessor.$$$reportNull$$$0(10);
                }
                JSMemberRenameProcessor.addMemberWithOverload(el, newName, allRenames);
            });
        }
        members = JSMembersSearch.searchOverridingMembers((JSPsiElementBase)jsMember, false);
        members.forEach(el -> {
            if (allRenames == null) {
                JSMemberRenameProcessor.$$$reportNull$$$0(9);
            }
            JSMemberRenameProcessor.addMemberWithOverload(el, newName, allRenames);
        });
    }

    private static void addMemberWithOverload(JSPsiElementBase el, String newName, Map<PsiElement, String> allRenames) {
        allRenames.put((PsiElement)el, newName);
        if (el instanceof TypeScriptFunction) {
            for (TypeScriptFunction function : TypeScriptPsiUtil.getAllOverloadsWithImplementation((TypeScriptFunction)el)) {
                allRenames.put((PsiElement)function, newName);
            }
        }
    }

    @Override
    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<PsiElement> renameCallback) {
        Pair<JSPsiElementBase, JSClass> memberJSClassPair;
        if (element == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(5);
        }
        if (renameCallback == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(6);
        }
        if ((memberJSClassPair = JSMemberRenameProcessor.getSuperMember(element)) == null) {
            this.processSubstituted(element, editor, renameCallback);
            return;
        }
        JSPsiElementBase parentMember = (JSPsiElementBase)memberJSClassPair.first;
        JSPsiElementBase currentMember = (JSPsiElementBase)element;
        String title = JSMemberRenameProcessor.getMemberTitle(parentMember);
        this.substituteWithPopup(editor, renameCallback, JSMemberRenameProcessor.getDialogTitle(parentMember, (JSClass)memberJSClassPair.second), null, (PsiElement)parentMember, "Rename base " + title, (PsiElement)currentMember, "Rename current " + title);
    }

    @Override
    @Nullable
    public PsiElement substituteElementToRename(PsiElement element, @Nullable Editor editor) {
        Pair<JSPsiElementBase, JSClass> memberJSClassPair = JSMemberRenameProcessor.getSuperMember(element);
        if (memberJSClassPair == null) {
            return super.substituteElementToRename(element, editor);
        }
        JSPsiElementBase parentMember = (JSPsiElementBase)memberJSClassPair.first;
        JSClass parentClass = (JSClass)memberJSClassPair.second;
        String memberTitle = JSMemberRenameProcessor.getMemberTitle(parentMember);
        return this.substituteWithPopup(editor, null, JSMemberRenameProcessor.getDialogTitle(parentMember, parentClass), IdeBundle.message((String)"prompt.do.you.want.to.action_verb.the.method.from_class", (Object[])new Object[]{"rename", 1}), (PsiElement)parentMember, "Rename base " + memberTitle, element, "Rename current " + memberTitle);
    }

    @Nullable
    private static Pair<JSPsiElementBase, JSClass> getSuperMember(PsiElement element) {
        if (!JSClassUtils.isPossibleHierarchyMember(element)) {
            return null;
        }
        JSAttributeListOwner jsMember = (JSAttributeListOwner)element;
        JSClass jsClass = JSUtils.getMemberContainingClass(element);
        if (!JSInheritanceUtil.canHaveSuperMember(jsMember) || jsClass == null) {
            return null;
        }
        Collection<JSPsiElementBase> members = JSInheritanceUtil.findTopMembers((JSQualifiedNamedElement)jsMember);
        if (members.size() > 1) {
            return null;
        }
        JSPsiElementBase parentMember = (JSPsiElementBase)ContainerUtil.getFirstItem(members);
        JSClass parentClass = JSUtils.getMemberContainingClass((PsiElement)parentMember);
        if (parentMember == null || parentClass == null) {
            return null;
        }
        return Pair.create((Object)parentMember, (Object)parentClass);
    }

    @NotNull
    private static String getDialogTitle(JSPsiElementBase parentMember, JSClass parentClass) {
        String memberName = JSMemberRenameProcessor.getMemberTitle(parentMember);
        String string = parentMember.getName() + (parentClass.isInterface() ? " implements" : " overrides") + " " + memberName + " of " + SymbolPresentationUtil.getSymbolPresentableText((PsiElement)parentClass);
        if (string == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String getMemberTitle(JSPsiElementBase parentMember) {
        String string = parentMember instanceof JSField ? "field" : "method";
        if (string == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSMemberRenameProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSMemberRenameProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogTitle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "iterateMethodsDown";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$iterateMethodsDown$1";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$iterateMethodsDown$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

