/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceProcessConnector;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceToolWindowInfoReporter;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.util.Alarm;
import com.intellij.util.ThreeState;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLanguageServiceBase
implements Disposable,
LinterLanguageServiceClient {
    private static final long ALIVE_CHECK_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final int ALIVE_CHECK_COUNT_BEFORE_LONG_WAITING = 5;
    public static final String CONSOLE_ID = "Console";
    @NotNull
    protected final Project myProject;
    @Nullable
    protected final JSLanguageServiceToolWindowManager myToolWindowManager;
    protected final AtomicLong myFailCount;
    @NotNull
    protected final Alarm myCheckAliveAlarm;
    @NotNull
    private volatile ThreeState myCanStartProcess;
    @NotNull
    protected volatile JSLanguageServiceQueue.ServiceInfoReporter myDefaultReporter;
    @Nullable
    private volatile JSLanguageServiceQueue myService;
    @NotNull
    private final Object myLock;
    private final NullableLazyValue<Void> myInitialization;
    @Nullable
    protected final JSLanguageServiceQueue.ProcessConnector myProcessConnector;

    public JSLanguageServiceBase(@NotNull Project project) {
        if (project == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(0);
        }
        this(project, CONSOLE_ID);
    }

    public JSLanguageServiceBase(@NotNull Project project, @NotNull String consoleId) {
        if (project == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(1);
        }
        if (consoleId == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(2);
        }
        this.myFailCount = new AtomicLong();
        this.myCanStartProcess = ThreeState.UNSURE;
        this.myDefaultReporter = this.createDefaultReporter();
        this.myLock = new Object();
        this.myInitialization = NullableLazyValue.createValue(() -> {
            this.initializeOnce();
            return null;
        });
        this.myProject = project;
        this.myToolWindowManager = this.createToolWindow(project);
        if (this.myToolWindowManager != null) {
            this.myDefaultReporter = new JSLanguageServiceToolWindowInfoReporter(this.myProject, this.getProcessName(), this.myToolWindowManager, false);
        }
        this.myCheckAliveAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myProcessConnector = this.myToolWindowManager != null ? new JSLanguageServiceProcessConnector(consoleId, this.myToolWindowManager) : null;
    }

    @NotNull
    public ThreeState getCanStartProcessState() {
        ThreeState threeState = this.myCanStartProcess;
        if (threeState == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(3);
        }
        return threeState;
    }

    public void setCanStartProcessState(@NotNull ThreeState canStartProcess) {
        if (canStartProcess == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(4);
        }
        this.myCanStartProcess = canStartProcess;
    }

    @NotNull
    protected JSLanguageServiceQueue.ServiceInfoReporter createDefaultReporter() {
        JSLanguageServiceQueue.ServiceInfoReporter serviceInfoReporter = new JSLanguageServiceQueue.ServiceInfoReporter(){

            @Override
            @NotNull
            public String getServiceName() {
                String string = JSLanguageServiceBase.this.getProcessName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public void logError(@NotNull String error) {
                if (error == null) {
                    1.$$$reportNull$$$0(1);
                }
                JSLanguageServiceQueue.DEFAULT_REPORTER.logError(error);
            }

            @Override
            public void setProcess(@Nullable String text) {
                JSLanguageServiceQueue.DEFAULT_REPORTER.setProcess(text);
            }

            @Override
            public void logCurrentErrors(@NotNull List<JSAnnotationError> results) {
                if (results == null) {
                    1.$$$reportNull$$$0(2);
                }
                JSLanguageServiceQueue.DEFAULT_REPORTER.logCurrentErrors(results);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceBase$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "results";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getServiceName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "logError";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "logCurrentErrors";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (serviceInfoReporter == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(5);
        }
        return serviceInfoReporter;
    }

    protected long getAliveCheckTimeout() {
        return ALIVE_CHECK_TIMEOUT;
    }

    protected long getAliveCheckLongTimeout() {
        return this.getAliveCheckTimeout() * 10L;
    }

    protected int getAliveCheckCount() {
        return 5;
    }

    protected void initializeOnce() {
        this.createAliveChecker().run();
        this.initToolWindow();
    }

    public final void initialize() {
        ReadAction.run(() -> {
            Object object = this.myLock;
            synchronized (object) {
                this.myInitialization.getValue();
            }
        });
    }

    @NotNull
    protected final Runnable createAliveChecker() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JSLanguageServiceBase.this.checkAlive(this);
            }
        };
        if (runnable == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(6);
        }
        return runnable;
    }

    @NotNull
    protected String getProcessName() {
        if ("Language" == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(7);
        }
        return "Language";
    }

    @Nullable
    protected abstract JSLanguageServiceQueue createLanguageServiceQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkAlive(@NotNull Runnable self) {
        if (self == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(8);
        }
        if (this.myCheckAliveAlarm.isDisposed() || this.myProject.isDisposed()) {
            return;
        }
        JSLanguageServiceQueue serviceQueue = this.myService;
        if (serviceQueue != null) {
            Object object = this.myLock;
            synchronized (object) {
                serviceQueue = this.myService;
                if (serviceQueue != null) {
                    JSLanguageServiceQueue.State state = serviceQueue.getState();
                    if (!serviceQueue.isValid()) {
                        this.myFailCount.incrementAndGet();
                        ApplicationManager.getApplication().invokeLater(() -> this.terminateStartedProcessImpl(false));
                    } else if (state == JSLanguageServiceQueue.State.STARTED) {
                        this.myFailCount.set(0L);
                    }
                }
            }
        } else if (!this.checkCanUseService()) {
            if (this.myCanStartProcess == ThreeState.NO) {
                this.myFailCount.incrementAndGet();
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.initializeServiceQueue());
        }
        if (this.myCheckAliveAlarm.isDisposed() || this.myProject.isDisposed()) {
            return;
        }
        long timeout = this.getAliveCheckTimeout();
        if (this.myFailCount.get() > (long)this.getAliveCheckCount()) {
            timeout = this.getAliveCheckLongTimeout();
        }
        this.myCheckAliveAlarm.addRequest(self, timeout);
    }

    protected abstract boolean needInitToolWindow();

    @Nullable
    protected JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        return null;
    }

    @NotNull
    public final JSLanguageServiceQueue.ServiceInfoReporter getDefaultReporter() {
        JSLanguageServiceQueue.ServiceInfoReporter serviceInfoReporter = this.myDefaultReporter;
        if (serviceInfoReporter == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(9);
        }
        return serviceInfoReporter;
    }

    @Override
    public final boolean isServiceCreated() {
        return this.myService != null;
    }

    @Override
    @Nullable
    public String getServiceCreationError() {
        JSLanguageServiceQueue service = this.myService;
        return service == null ? null : service.getStartErrorMessage();
    }

    @Nullable
    protected JSLanguageServiceQueue getProcess() {
        JSLanguageServiceQueue toReturn = this.myService;
        if (toReturn != null) {
            return toReturn;
        }
        return (JSLanguageServiceQueue)ReadAction.compute(() -> {
            Object object = this.myLock;
            synchronized (object) {
                return this.computeProcessUnderLocks();
            }
        });
    }

    @Nullable
    protected final JSLanguageServiceQueue computeProcessUnderLocks() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLanguageServiceQueue service = this.myService;
        if (service == null) {
            if (this.myProject.isDisposed()) {
                return null;
            }
            this.myInitialization.getValue();
            this.myService = service = this.createLanguageServiceQueue();
        }
        return service;
    }

    protected final void initializeServiceQueue() {
        this.getProcess();
    }

    @Nullable
    public final <T> Future<T> sendCommand(@NotNull JSLanguageServiceSimpleCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        JSLanguageServiceQueue process;
        if (command == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(11);
        }
        if ((process = this.getProcess()) == null) {
            return null;
        }
        return process.execute(command, processor);
    }

    public final void sendCommand(@NotNull JSLanguageServiceSimpleCommand command) {
        JSLanguageServiceQueue process;
        if (command == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(12);
        }
        if ((process = this.getProcess()) == null) {
            return;
        }
        process.executeNoBlocking(command, null);
    }

    public final void setDefaultReporter(@NotNull JSLanguageServiceQueue.ServiceInfoReporter defaultReporter) {
        if (defaultReporter == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(13);
        }
        this.myDefaultReporter = defaultReporter;
    }

    protected JSLanguageServiceQueue getLSProcess() {
        return this.myService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLanguageService(@Nullable JSLanguageServiceQueue service) {
        Object object = this.myLock;
        synchronized (object) {
            this.myService = service;
        }
    }

    public final void terminateStartedProcess(boolean recreateToolWindow) {
        this.resetState();
        this.terminateStartedProcessImpl(recreateToolWindow);
    }

    protected void initToolWindow() {
        if (this.myToolWindowManager == null || this.myProject.isDisposed() || !this.myProject.isOpen() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myToolWindowManager.lazyInit((Condition<JSLanguageServiceToolWindowManager>)((Condition)el -> this.needInitToolWindow()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateStartedProcessImpl(boolean recreateToolWindow) {
        Object object = this.myLock;
        synchronized (object) {
            JSLanguageServiceToolWindowManager manager = this.myToolWindowManager;
            if (this.myProcessConnector != null && this.myProcessConnector.isConnected()) {
                this.myProcessConnector.disconnectFromProcessHandler();
                JSLanguageServiceQueue service = this.myService;
                if (manager != null && service != null && service.getState() == JSLanguageServiceQueue.State.STARTED) {
                    manager.cleanErrorsPanel();
                }
            }
            if (manager != null && recreateToolWindow) {
                manager.resetToolWindow();
            }
            this.disposeQueue();
            this.initToolWindow();
        }
    }

    protected Runnable getDisposeQueueRunnableUnderLock(@NotNull JSLanguageServiceQueue serviceToDispose) {
        if (serviceToDispose == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(14);
        }
        return () -> {
            if (serviceToDispose == null) {
                JSLanguageServiceBase.$$$reportNull$$$0(16);
            }
            this.disposeQueueImpl(serviceToDispose);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void disposeQueue() {
        Object object = this.myLock;
        synchronized (object) {
            JSLanguageServiceQueue service = this.myService;
            if (service != null) {
                this.myService = null;
                this.myCanStartProcess = ThreeState.UNSURE;
                Runnable disposeAction = this.getDisposeQueueRunnableUnderLock(service);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    disposeAction.run();
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(disposeAction);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeQueueImpl(@NotNull JSLanguageServiceQueue service) {
        if (service == null) {
            JSLanguageServiceBase.$$$reportNull$$$0(15);
        }
        Object object = this.myLock;
        synchronized (object) {
            Disposer.dispose((Disposable)service);
        }
    }

    public boolean checkCanUseService() {
        return this.myCanStartProcess != ThreeState.NO && this.myFailCount.get() < (long)this.getAliveCheckCount();
    }

    protected void resetState() {
        this.myFailCount.set(0L);
        this.myCanStartProcess = ThreeState.UNSURE;
    }

    public void dispose() {
        JSLanguageServiceQueue queue = this.myService;
        if (queue != null) {
            Disposer.dispose((Disposable)queue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleId";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canStartProcess";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultReporter";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceToDispose";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanStartProcessState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultReporter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAliveChecker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultReporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCanStartProcessState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkAlive";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sendCommand";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultReporter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDisposeQueueRunnableUnderLock";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "disposeQueueImpl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDisposeQueueRunnableUnderLock$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

