/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.validation.fixes.ES6ConvertDefaultImportToSpecifierFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ThrowableRunnable;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J3\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0096\u0002J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/lang/javascript/validation/fixes/ES6ConvertDefaultImportToSpecifierFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportedBinding;", "(Lcom/intellij/lang/ecmascript6/psi/ES6ImportedBinding;)V", "bindingName", "", "getBindingName", "()Ljava/lang/String;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "isAvailable", "", "memberWithBindingNameIsAvailableFromModule", "declaration", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportDeclaration;", "JavaScriptLanguage"})
public final class ES6ConvertDefaultImportToSpecifierFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String bindingName;

    @NotNull
    public final String getBindingName() {
        return this.bindingName;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"es6.change.to.named.import.fix", (Object[])new Object[]{this.bindingName});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSBundle.message(\"es6.ch\u2026import.fix\", bindingName)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
        if (!this.isAvailable(project, file, startElement, endElement)) {
            return;
        }
        ES6ImportDeclaration eS6ImportDeclaration = ((ES6ImportedBinding)startElement).getDeclaration();
        if (eS6ImportDeclaration == null) {
            Intrinsics.throwNpe();
        }
        ES6ImportDeclaration declaration = eS6ImportDeclaration;
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable<E>(this, declaration){
            final /* synthetic */ ES6ConvertDefaultImportToSpecifierFix this$0;
            final /* synthetic */ ES6ImportDeclaration $declaration;

            public final void run() {
                block4: {
                    ES6ImportedBinding newBinding;
                    Object v2;
                    block3: {
                        Sequence sequence;
                        ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = new ES6ImportPsiUtil.CreateImportExportInfo(this.this$0.getBindingName(), ES6ImportPsiUtil.ImportExportType.SPECIFIER);
                        ES6ImportSpecifier eS6ImportSpecifier = ES6ImportPsiUtil.insertImportSpecifier(this.$declaration, createImportExportInfo);
                        if (eS6ImportSpecifier == null) {
                            return;
                        }
                        ES6ImportSpecifier insertImportSpecifier = eS6ImportSpecifier;
                        ES6ImportDeclaration eS6ImportDeclaration = insertImportSpecifier.getDeclaration();
                        if (eS6ImportDeclaration == null) {
                            return;
                        }
                        ES6ImportDeclaration eS6ImportDeclaration2 = eS6ImportDeclaration;
                        Sequence sequence2 = sequence = ArraysKt.asSequence((Object[])eS6ImportDeclaration2.getImportedBindings());
                        for (E e : sequence2) {
                            ES6ImportedBinding it = (ES6ImportedBinding)e;
                            if (!Intrinsics.areEqual((Object)it.getDeclaredName(), (Object)this.this$0.getBindingName())) continue;
                            v2 = e;
                            break block3;
                        }
                        v2 = null;
                    }
                    ES6ImportedBinding eS6ImportedBinding = newBinding = (ES6ImportedBinding)v2;
                    if (eS6ImportedBinding == null) break block4;
                    eS6ImportedBinding.delete();
                }
            }
            {
                this.this$0 = eS6ConvertDefaultImportToSpecifierFix;
                this.$declaration = eS6ImportDeclaration;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
        if (!(startElement instanceof ES6ImportedBinding)) {
            return false;
        }
        ES6ImportDeclaration eS6ImportDeclaration = ((ES6ImportedBinding)startElement).getDeclaration();
        if (eS6ImportDeclaration == null) {
            return false;
        }
        ES6ImportDeclaration declaration = eS6ImportDeclaration;
        if (ErrorUtil.containsError((PsiElement)declaration)) {
            return false;
        }
        Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])declaration.getImportSpecifiers()), (Function1)((Function1)new Function1<ES6ImportSpecifier, Boolean>(this){
            final /* synthetic */ ES6ConvertDefaultImportToSpecifierFix this$0;

            public final boolean invoke(ES6ImportSpecifier it) {
                return Intrinsics.areEqual((Object)this.this$0.getBindingName(), (Object)it.getReferenceName());
            }
            {
                this.this$0 = eS6ConvertDefaultImportToSpecifierFix;
                super(1);
            }
        }));
        Iterator iterator = $receiver$iv.iterator();
        if (iterator.hasNext()) {
            Object element$iv = iterator.next();
            ES6ImportSpecifier it = (ES6ImportSpecifier)element$iv;
            return false;
        }
        ES6ImportDeclaration eS6ImportDeclaration2 = declaration;
        Intrinsics.checkExpressionValueIsNotNull((Object)eS6ImportDeclaration2, (String)"declaration");
        return this.memberWithBindingNameIsAvailableFromModule(eS6ImportDeclaration2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean memberWithBindingNameIsAvailableFromModule(ES6ImportDeclaration declaration) {
        void $receiver$iv;
        ES6FromClause fromClause = declaration.getFromClause();
        if (fromClause == null) {
            return false;
        }
        PsiElement module = ES6PsiUtil.findExternalModule((PsiElement)declaration);
        if (!(module instanceof JSElement)) {
            return false;
        }
        Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)fromClause.resolveReferencedElements()), (Function1)memberWithBindingNameIsAvailableFromModule.1.INSTANCE), (Function1)((Function1)new Function1<JSElement, Boolean>(this, declaration){
            final /* synthetic */ ES6ConvertDefaultImportToSpecifierFix this$0;
            final /* synthetic */ ES6ImportDeclaration $declaration;

            public final boolean invoke(@NotNull JSElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ResolveResult[] symbolsInModule = ES6CreateImportUtil.getSymbolInModule(this.this$0.getBindingName(), (PsiElement)this.$declaration, it);
                ResolveResult resolveResult = (ResolveResult)ArraysKt.firstOrNull((Object[])symbolsInModule);
                PsiElement element = resolveResult != null ? resolveResult.getElement() : null;
                return element instanceof JSPsiElementBase && ((JSPsiElementBase)element).isExported();
            }
            {
                this.this$0 = eS6ConvertDefaultImportToSpecifierFix;
                this.$declaration = eS6ImportDeclaration;
                super(1);
            }
        }));
        Iterator iterator = $receiver$iv.iterator();
        if (iterator.hasNext()) {
            Object element$iv = iterator.next();
            JSElement it = (JSElement)element$iv;
            return true;
        }
        return false;
    }

    public ES6ConvertDefaultImportToSpecifierFix(@NotNull ES6ImportedBinding element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super((PsiElement)element);
        String string = StringUtil.notNullize((String)element.getDeclaredName());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.notNullize(element.declaredName)");
        this.bindingName = string;
    }
}

