/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.ES6QualifiedNamedElementRenderer;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.intentions.TypeScriptImportAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddImportStatementFix
extends LocalQuickFixOnPsiElement
implements HintAction,
HighPriorityAction {
    @Nullable
    private final String myName;
    private final ES6ImportAction.ImportElementFilter myFilter;
    protected volatile boolean myNeedHint;

    public TypeScriptAddImportStatementFix(@Nullable String name, @NotNull PsiElement context, boolean needHint, @NotNull ES6ImportAction.ImportElementFilter filter) {
        if (context == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(1);
        }
        super(context);
        this.myName = name;
        this.myNeedHint = needHint;
        this.myFilter = filter;
    }

    public TypeScriptAddImportStatementFix(@Nullable String name, @NotNull PsiElement context, boolean needHint) {
        if (context == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(2);
        }
        this(name, context, needHint, new ES6ImportAction.DefaultElementFilter());
    }

    public TypeScriptAddImportStatementFix(@Nullable String name, @NotNull PsiElement context) {
        if (context == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(3);
        }
        this(name, context, true);
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = TypeScriptAddImportStatementFix.getActionName();
        if (string == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void disableHint() {
        this.myNeedHint = false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        List<JSElement> candidates;
        if (project == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(6);
        }
        return !(candidates = this.getCandidates(editor)).isEmpty();
    }

    @NotNull
    protected ES6ImportAction.ImportElementFilter getFilter() {
        ES6ImportAction.ImportElementFilter importElementFilter = this.myFilter;
        if (importElementFilter == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(7);
        }
        return importElementFilter;
    }

    @Nullable
    private String getImportedName() {
        return this.myName;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(8);
        }
        this.createAction(editor).execute();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        ES6ImportAction action;
        List<JSElement> candidates;
        if (project == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(9);
        }
        if (file == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(10);
        }
        if (startElement == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(11);
        }
        if (endElement == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(12);
        }
        if ((candidates = (action = this.createAction(null)).getCandidates()).size() == 1) {
            action.execute();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(13);
        }
        if (!JSApplicationSettings.getInstance().showTSImportPopupEffective(editor.getProject()) || !this.myNeedHint) {
            return false;
        }
        PsiElement element = this.getStartElement();
        if (element == null || !this.myFilter.isValidContext(element) || Boolean.TRUE.equals(element.getUserData(ES6ImportAction.NO_HINT_KEY))) {
            return false;
        }
        List<JSElement> candidates = this.getCandidates(editor);
        if (candidates.isEmpty()) {
            return true;
        }
        JSElement first = (JSElement)ContainerUtil.getFirstItem(candidates);
        assert (first != null);
        String message = TypeScriptAddImportStatementFix.getMessage(candidates, first);
        TextRange range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        ES6ImportAction action = this.createAction(editor);
        HintManager.getInstance().showQuestionHint(editor, message, range.getStartOffset(), range.getEndOffset(), (QuestionAction)action);
        return true;
    }

    private static String getMessage(Collection<JSElement> candidates, JSElement first) {
        String nameToShow = new ES6QualifiedNamedElementRenderer<JSElement>().getElementText(first) + " " + JSQualifiedNamedElementRenderer.getContainerText(first);
        return ShowAutoImportPass.getMessage((candidates.size() > 1 ? 1 : 0) != 0, (String)nameToShow);
    }

    private List<JSElement> getCandidates(@Nullable Editor editor) {
        return this.createAction(editor).getCandidates();
    }

    @NotNull
    public ES6ImportAction createAction(@Nullable Editor editor) {
        TypeScriptImportAction typeScriptImportAction = new TypeScriptImportAction(editor, this.getStartElement(), this.getImportedName(), this.getFilter()){

            @Override
            public void executeFor(@NotNull JSElement candidate, @Nullable Consumer<JSElement> postProcess) {
                if (candidate == null) {
                    1.$$$reportNull$$$0(0);
                }
                TypeScriptAddImportStatementFix.this.disableHint();
                super.executeFor(candidate, postProcess);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$1", "executeFor"));
            }
        };
        if (typeScriptImportAction == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(14);
        }
        return typeScriptImportAction;
    }

    public static String getActionName() {
        return JSBundle.message((String)"ts.add.import.statement.family.name", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

