/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.editors.strings.StringResourceEditorProvider;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocaleMenuAction
extends FlatComboAction {
    private final ConfigurationHolder myRenderContext;
    private final boolean myClassicStyle;

    public LocaleMenuAction(ConfigurationHolder renderContext) {
        this(renderContext, false);
    }

    public LocaleMenuAction(ConfigurationHolder renderContext, boolean classicStyle) {
        this.myRenderContext = renderContext;
        this.myClassicStyle = classicStyle;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("Locale in Editor");
        this.updatePresentation(presentation);
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        List<Locale> locales = this.getRelevantLocales();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && locales.size() > 0) {
            group.add((AnAction)new SetLocaleAction(this.myRenderContext, LocaleMenuAction.getLocaleLabel(Locale.ANY, false, this.myClassicStyle), Locale.ANY));
            group.addSeparator();
            Collections.sort(locales, Locale.LANGUAGE_CODE_COMPARATOR);
            for (Locale locale : locales) {
                String title = LocaleMenuAction.getLocaleLabel(locale, false, this.myClassicStyle);
                VirtualFile better = ConfigurationMatcher.getBetterMatch(configuration, null, null, locale, null);
                if (better != null) {
                    title = ConfigurationAction.getBetterMatchLabel(LocaleMenuAction.getLocaleLabel(locale, true, this.myClassicStyle), better, configuration.getFile());
                }
                group.add((AnAction)new SetLocaleAction(this.myRenderContext, title, locale));
            }
            group.addSeparator();
        }
        group.add((AnAction)new EditTranslationAction());
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            LocaleMenuAction.$$$reportNull$$$0(0);
        }
        return defaultActionGroup;
    }

    @NotNull
    private List<Locale> getRelevantLocales() {
        ProjectResourceRepository projectResources;
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            List<Locale> list = Collections.emptyList();
            if (list == null) {
                LocaleMenuAction.$$$reportNull$$$0(1);
            }
            return list;
        }
        Module module = configuration.getConfigurationManager().getModule();
        LocaleQualifier specificLocale = configuration.getEditedConfig().getLocaleQualifier();
        if (specificLocale != null) {
            List<VirtualFile> variations = ResourceHelper.getResourceVariations(configuration.getFile(), false);
            for (VirtualFile variation : variations) {
                FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)variation.getParent().getName());
                if (config == null || config.getLocaleQualifier() != null) continue;
                specificLocale = null;
                break;
            }
        }
        SortedSet languages = (projectResources = ProjectResourceRepository.getProjectResources(module, true)) != null ? projectResources.getLocales() : Collections.emptySet();
        for (LocaleQualifier l : languages) {
            if (specificLocale != null && !specificLocale.isMatchFor((ResourceQualifier)l)) continue;
            locales.add(Locale.create(l));
        }
        ArrayList<Locale> arrayList = locales;
        if (arrayList == null) {
            LocaleMenuAction.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static List<Locale> getAllLocales() {
        List sorted = LocaleManager.getLanguageCodes((boolean)true);
        ArrayList<Locale> locales = new ArrayList<Locale>(sorted.size());
        for (String language : sorted) {
            LocaleQualifier qualifier = new LocaleQualifier(language.length() == 2 ? language : "b+" + language, language, null, null);
            Locale locale = Locale.create(qualifier);
            locales.add(locale);
        }
        ArrayList<Locale> arrayList = locales;
        if (arrayList == null) {
            LocaleMenuAction.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            Locale locale = configuration.getLocale();
            if (!this.myClassicStyle) {
                presentation.setIcon(AndroidIcons.NeleIcons.Language);
            } else if (locale == Locale.ANY) {
                presentation.setIcon(AndroidIcons.Globe);
            } else {
                presentation.setIcon(locale.getFlagImage());
            }
            String brief = LocaleMenuAction.getLocaleLabel(locale, true, this.myClassicStyle);
            presentation.setText(brief);
        } else {
            presentation.setIcon(AndroidIcons.Globe);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    @Override
    protected int getMaxRows() {
        return 10;
    }

    @NotNull
    public static String getLocaleLabel(@Nullable Locale locale, boolean brief) {
        String string = LocaleMenuAction.getLocaleLabel(locale, brief, false);
        if (string == null) {
            LocaleMenuAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static String getLocaleLabel(@Nullable Locale locale, boolean brief, boolean classicStyle) {
        if (locale == null) {
            if (!classicStyle) {
                return "Language";
            }
            return "";
        }
        if (!locale.hasLanguage()) {
            if (!classicStyle) {
                return "Language";
            }
            if (brief) {
                return "";
            }
            return "Default";
        }
        String languageCode = locale.qualifier.getLanguage();
        String languageName = LocaleManager.getLanguageName((String)languageCode);
        if (!locale.hasRegion()) {
            if (!brief && languageName != null) {
                return String.format("%1$s (%2$s)", languageName, languageCode);
            }
            return languageCode;
        }
        String regionCode = locale.qualifier.getRegion();
        assert (regionCode != null) : locale.qualifier;
        if (!brief && languageName != null) {
            String regionName = LocaleManager.getRegionName((String)regionCode);
            if (regionName != null) {
                return String.format("%1$s (%2$s) in %3$s (%4$s)", languageName, languageCode, regionName, regionCode);
            }
            return String.format("%1$s (%2$s) in %3$s", languageName, languageCode, regionCode);
        }
        return String.format("%1$s / %2$s", languageCode, regionCode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/configurations/LocaleMenuAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevantLocales";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLocales";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocaleLabel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class EditTranslationAction
    extends AnAction {
        public EditTranslationAction() {
            super("Edit Translations", null, AndroidIcons.Globe);
        }

        public void actionPerformed(AnActionEvent e) {
            Configuration configuration = LocaleMenuAction.this.myRenderContext.getConfiguration();
            if (configuration != null) {
                Module module = configuration.getConfigurationManager().getModule();
                StringResourceEditorProvider.openEditor(module);
            }
        }
    }

    private static class SetLocaleAction
    extends ConfigurationAction {
        private final Locale myLocale;

        public SetLocaleAction(ConfigurationHolder renderContext, String title, @NotNull Locale locale) {
            if (locale == null) {
                SetLocaleAction.$$$reportNull$$$0(0);
            }
            super(renderContext, title, locale.getFlagImage());
            this.myLocale = locale;
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetLocaleAction.$$$reportNull$$$0(1);
            }
            if (commit) {
                this.setProjectWideLocale();
            } else {
                configuration.getEditedConfig().setLayoutDirectionQualifier(null);
                configuration.setLocale(this.myLocale);
            }
        }

        @Override
        protected void pickedBetterMatch(@NotNull VirtualFile file, @NotNull VirtualFile old) {
            if (file == null) {
                SetLocaleAction.$$$reportNull$$$0(2);
            }
            if (old == null) {
                SetLocaleAction.$$$reportNull$$$0(3);
            }
            super.pickedBetterMatch(file, old);
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                this.setProjectWideLocale();
            }
        }

        private void setProjectWideLocale() {
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                configuration.getConfigurationManager().setLocale(this.myLocale);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locale";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/LocaleMenuAction$SetLocaleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pickedBetterMatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

