/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DevicePropertyUtil {
    private static final Set<String> ourManufacturerNameIsAcronym = ImmutableSet.of((Object)"ASUS", (Object)"HTC", (Object)"LG", (Object)"LGE", (Object)"ZTE");

    static String fixManufacturerName(@NotNull String manufacturer) {
        String allCaps;
        if (manufacturer == null) {
            DevicePropertyUtil.$$$reportNull$$$0(0);
        }
        return ourManufacturerNameIsAcronym.contains(allCaps = manufacturer.toUpperCase(Locale.US)) ? allCaps : StringUtil.capitalizeWords((String)manufacturer, (boolean)true);
    }

    @NotNull
    public static String getManufacturer(@NotNull IDevice d, @NotNull String unknown) {
        if (d == null) {
            DevicePropertyUtil.$$$reportNull$$$0(1);
        }
        if (unknown == null) {
            DevicePropertyUtil.$$$reportNull$$$0(2);
        }
        String m = d.getProperty("ro.product.manufacturer");
        if (d.isEmulator() && "unknown".equals(m)) {
            m = unknown;
        }
        String string = m != null ? DevicePropertyUtil.fixManufacturerName(m) : unknown;
        if (string == null) {
            DevicePropertyUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getModel(@NotNull IDevice d, @NotNull String unknown) {
        String m;
        if (d == null) {
            DevicePropertyUtil.$$$reportNull$$$0(4);
        }
        if (unknown == null) {
            DevicePropertyUtil.$$$reportNull$$$0(5);
        }
        String string = (m = d.getProperty("ro.product.model")) != null ? StringUtil.capitalizeWords((String)m, (boolean)true) : unknown;
        if (string == null) {
            DevicePropertyUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getBuild(@NotNull IDevice d) {
        if (d == null) {
            DevicePropertyUtil.$$$reportNull$$$0(7);
        }
        StringBuilder sb = new StringBuilder(20);
        String v = d.getProperty("ro.build.version.release");
        if (v != null) {
            sb.append("Android ");
            sb.append(v);
        }
        if ((v = d.getProperty("ro.build.version.sdk")) != null) {
            sb.append(String.format(", API %1$s", v));
        }
        String string = sb.toString();
        if (string == null) {
            DevicePropertyUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manufacturer";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknown";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ddms/DevicePropertyUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ddms/DevicePropertyUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getManufacturer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fixManufacturerName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getManufacturer";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBuild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

