/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations.nodes;

import com.android.tools.adtui.ValuedTreeNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeNode
implements ValuedTreeNode {
    @Nullable
    protected AbstractTreeNode myParent;
    @Nullable
    private Comparator<AbstractTreeNode> myOrder = null;
    int myCount;
    int myValue;
    @NotNull
    private Vector<AbstractTreeNode> myChildren = new Vector();

    public TreeNode getChildAt(int i) {
        this.ensureOrder();
        return (TreeNode)((Object)this.myChildren.get(i));
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    public TreeNode getParent() {
        return this.myParent;
    }

    public int getIndex(TreeNode treeNode) {
        assert (treeNode instanceof AbstractTreeNode);
        return this.myChildren.indexOf(treeNode);
    }

    public boolean isLeaf() {
        return this.myChildren.size() == 0;
    }

    public Enumeration children() {
        this.ensureOrder();
        return this.myChildren.elements();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public int getCount() {
        return this.myCount;
    }

    public int getValue() {
        return this.myValue;
    }

    private void add(int count, int value) {
        this.myCount += count;
        this.myValue += value;
        if (this.myParent != null) {
            this.myParent.add(count, value);
        }
    }

    protected void addChild(@NotNull AbstractTreeNode node) {
        if (node == null) {
            AbstractTreeNode.$$$reportNull$$$0(0);
        }
        this.myChildren.add(node);
    }

    public void insertChild(@NotNull AbstractTreeNode node) {
        if (node == null) {
            AbstractTreeNode.$$$reportNull$$$0(1);
        }
        this.addChild(node);
        node.myParent = this;
        this.add(node.getCount(), node.getValue());
    }

    private void ensureOrder() {
        if (this.myParent != null && this.myParent.myOrder != this.myOrder || this.myParent == null && this.myOrder != null) {
            this.myOrder = this.myParent != null ? this.myParent.myOrder : this.myOrder;
            Collections.sort(this.myChildren, this.myOrder);
        }
    }

    public void sort(@NotNull Comparator<AbstractTreeNode> order) {
        if (order == null) {
            AbstractTreeNode.$$$reportNull$$$0(2);
        }
        assert (this.myParent == null);
        this.myOrder = order;
        this.ensureOrder();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/allocations/nodes/AbstractTreeNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addChild";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "insertChild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sort";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

