/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.rendering.Locale;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceTableModel
extends AbstractTableModel {
    public static final int KEY_COLUMN = 0;
    public static final int UNTRANSLATABLE_COLUMN = 1;
    public static final int DEFAULT_VALUE_COLUMN = 2;
    public static final int FIXED_COLUMN_COUNT = 3;
    private final StringResourceData myData;
    private final List<String> myKeys;
    private final List<Locale> myLocales;

    StringResourceTableModel() {
        this.myData = null;
        this.myKeys = Collections.emptyList();
        this.myLocales = Collections.emptyList();
    }

    public StringResourceTableModel(@NotNull StringResourceData data) {
        if (data == null) {
            StringResourceTableModel.$$$reportNull$$$0(0);
        }
        this.myData = data;
        this.myKeys = data.getKeys();
        this.myLocales = data.getLocales();
    }

    @Nullable
    public StringResourceData getData() {
        return this.myData;
    }

    @NotNull
    public StringResource getStringResourceAt(int row) {
        StringResource stringResource = this.myData.getStringResource(this.myKeys.get(row));
        if (stringResource == null) {
            StringResourceTableModel.$$$reportNull$$$0(1);
        }
        return stringResource;
    }

    @NotNull
    public String getKey(int row) {
        String string = this.myKeys.get(row);
        if (string == null) {
            StringResourceTableModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public Locale getLocale(int column) {
        assert (0 <= column && column < this.getColumnCount()) : column;
        return column < 3 ? null : this.myLocales.get(column - 3);
    }

    @Override
    public int getRowCount() {
        return this.myKeys.size();
    }

    @Override
    public int getColumnCount() {
        return 3 + this.myLocales.size();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        assert (this.myData != null && this.myKeys != null);
        switch (column) {
            case 0: {
                this.myData.changeKeyName(this.myKeys.get(row), (String)value);
                this.fireTableRowsUpdated(0, this.myKeys.size());
                break;
            }
            case 1: {
                Boolean doNotTranslate = (Boolean)value;
                if (!this.myData.setTranslatable(this.getKey(row), doNotTranslate == false)) break;
                this.fireTableCellUpdated(row, column);
                break;
            }
            default: {
                if (!this.myData.setTranslation(this.getKey(row), this.getLocale(column), (String)value)) break;
                this.fireTableCellUpdated(row, column);
            }
        }
    }

    @Override
    @NotNull
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                String string = this.getKey(row);
                if (string == null) {
                    StringResourceTableModel.$$$reportNull$$$0(3);
                }
                return string;
            }
            case 1: {
                Boolean bl = !this.getStringResourceAt(row).isTranslatable();
                if (bl == null) {
                    StringResourceTableModel.$$$reportNull$$$0(4);
                }
                return bl;
            }
            case 2: {
                String string = this.getStringResourceAt(row).getDefaultValueAsString();
                if (string == null) {
                    StringResourceTableModel.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        Locale locale = this.getLocale(column);
        assert (locale != null);
        String string = this.getStringResourceAt(row).getTranslationAsString(locale);
        if (string == null) {
            StringResourceTableModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                if ("Key" == null) {
                    StringResourceTableModel.$$$reportNull$$$0(7);
                }
                return "Key";
            }
            case 1: {
                if ("Untranslatable" == null) {
                    StringResourceTableModel.$$$reportNull$$$0(8);
                }
                return "Untranslatable";
            }
            case 2: {
                if ("Default Value" == null) {
                    StringResourceTableModel.$$$reportNull$$$0(9);
                }
                return "Default Value";
            }
        }
        String string = LocaleMenuAction.getLocaleLabel(this.getLocale(column), false);
        if (string == null) {
            StringResourceTableModel.$$$reportNull$$$0(10);
        }
        return string;
    }

    public Class getColumnClass(int column) {
        return column == 1 ? Boolean.class : String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Nullable
    public String getCellProblem(int row, int column) {
        return column == 0 ? this.myData.validateKey(this.getKey(row)) : this.myData.validateTranslation(this.getKey(row), this.getLocale(column));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/table/StringResourceTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/table/StringResourceTableModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringResourceAt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAt";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

