/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.ui;

import com.android.tools.idea.gradle.editor.entity.GradleEditorSourceBinding;
import com.android.tools.idea.gradle.editor.ui.GradleEditorUiConstants;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferencedValuesGradleEditorComponent
extends JBPanel {
    private static final Function<GradleEditorSourceBinding, VirtualFile> GROUPER = new Function<GradleEditorSourceBinding, VirtualFile>(){

        public VirtualFile apply(GradleEditorSourceBinding input) {
            return input.getFile();
        }
    };
    private static final Comparator<VirtualFile> FILES_COMPARATOR = new Comparator<VirtualFile>(){

        @Override
        public int compare(VirtualFile f1, VirtualFile f2) {
            VirtualFile d2;
            if (f1.equals(f2)) {
                return 0;
            }
            VirtualFile d1 = f1.isDirectory() ? f1 : f1.getParent();
            VirtualFile virtualFile = d2 = f2.isDirectory() ? f2 : f2.getParent();
            if (d1.equals(d2)) {
                return f1.getName().compareTo(f2.getName());
            }
            if (VfsUtilCore.isAncestor((VirtualFile)d1, (VirtualFile)d2, (boolean)false)) {
                return -1;
            }
            if (VfsUtilCore.isAncestor((VirtualFile)d2, (VirtualFile)d1, (boolean)false)) {
                return 1;
            }
            VirtualFile p1 = d1.getParent();
            VirtualFile p2 = d2.getParent();
            while (p1 != null || p2 != null) {
                if (p1 == null) {
                    return -1;
                }
                if (p2 == null) {
                    return 1;
                }
                p1 = p1.getParent();
                p2 = p2.getParent();
            }
            return 0;
        }
    };
    private static final Comparator<RangeMarker> RANGE_COMPARATOR = new Comparator<RangeMarker>(){

        @Override
        public int compare(RangeMarker rm1, RangeMarker rm2) {
            if (rm1.getStartOffset() < rm2.getStartOffset()) {
                return -1;
            }
            if (rm2.getStartOffset() < rm1.getStartOffset()) {
                return 1;
            }
            if (rm1.getEndOffset() < rm2.getEndOffset()) {
                return -1;
            }
            if (rm2.getEndOffset() < rm1.getEndOffset()) {
                return 1;
            }
            return 0;
        }
    };
    private final Map<String, List<RangeMarker>> mySourceBindings = Maps.newLinkedHashMap();
    private final Map<String, VirtualFile> myFilesByName = Maps.newHashMap();
    @Nullable
    private WeakReference<Project> myProjectRef;

    public ReferencedValuesGradleEditorComponent() {
        super((LayoutManager)new GridBagLayout());
        Color color;
        final JBLabel label = new JBLabel("<~>");
        label.setCursor(new Cursor(12));
        this.setBackground(GradleEditorUiConstants.BACKGROUND_COLOR);
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES);
        if (attributes != null && (color = attributes.getForegroundColor()) != null) {
            label.setForeground(color);
        }
        this.add((Component)label, new GridBag());
        label.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                WeakReference projectRef = ReferencedValuesGradleEditorComponent.this.myProjectRef;
                if (projectRef == null) {
                    return;
                }
                Project project = (Project)projectRef.get();
                if (project == null) {
                    return;
                }
                final Ref balloonRef = new Ref();
                Content content = new Content(project, new Runnable(){

                    @Override
                    public void run() {
                        Balloon balloon = (Balloon)balloonRef.get();
                        if (balloon != null && !balloon.isDisposed()) {
                            Disposer.dispose((Disposable)balloon);
                            balloonRef.set(null);
                        }
                    }
                });
                BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)((Object)content)).setDisposable((Disposable)project).setShowCallout(false).setAnimationCycle(300).setFillColor(JBColor.border());
                Balloon balloon = builder.createBalloon();
                balloonRef.set((Object)balloon);
                balloon.show(new RelativePoint((Component)label, new Point(label.getWidth() / 2, label.getHeight())), Balloon.Position.atRight);
            }
        });
    }

    public void bind(@NotNull Project project, @NotNull List<GradleEditorSourceBinding> sourceBindings) {
        if (project == null) {
            ReferencedValuesGradleEditorComponent.$$$reportNull$$$0(0);
        }
        if (sourceBindings == null) {
            ReferencedValuesGradleEditorComponent.$$$reportNull$$$0(1);
        }
        this.myProjectRef = new WeakReference<Project>(project);
        ImmutableListMultimap byFile = Multimaps.index(sourceBindings, GROUPER);
        ArrayList orderedFiles = Lists.newArrayList((Iterable)byFile.keySet());
        ContainerUtil.sort((List)orderedFiles, FILES_COMPARATOR);
        for (VirtualFile file : orderedFiles) {
            ImmutableList list = byFile.get((Object)file);
            ArrayList rangeMarkers = Lists.newArrayList();
            for (GradleEditorSourceBinding descriptor : list) {
                rangeMarkers.add(descriptor.getRangeMarker());
            }
            if (rangeMarkers.isEmpty()) continue;
            ContainerUtil.sort((List)rangeMarkers, RANGE_COMPARATOR);
            String name = ReferencedValuesGradleEditorComponent.getRepresentativeName(project, file);
            this.mySourceBindings.put(name, rangeMarkers);
            this.myFilesByName.put(name, file);
        }
    }

    @NotNull
    private static String getRepresentativeName(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile projectBaseDir;
        if (project == null) {
            ReferencedValuesGradleEditorComponent.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ReferencedValuesGradleEditorComponent.$$$reportNull$$$0(3);
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)(projectBaseDir = project.getBaseDir()), (VirtualFile)file, (boolean)false)) {
            String string = file.getPresentableName();
            if (string == null) {
                ReferencedValuesGradleEditorComponent.$$$reportNull$$$0(4);
            }
            return string;
        }
        ArrayList pathEntries = Lists.newArrayList();
        VirtualFile f = file.getParent();
        while (!projectBaseDir.equals(f)) {
            pathEntries.add(f.getPresentableName());
            f = f.getParent();
        }
        if (pathEntries.isEmpty()) {
            String string = file.getPresentableName();
            if (string == null) {
                ReferencedValuesGradleEditorComponent.$$$reportNull$$$0(5);
            }
            return string;
        }
        Collections.reverse(pathEntries);
        String sep = ":";
        String string = sep + Joiner.on((String)sep).join((Iterable)pathEntries) + sep + file.getPresentableName();
        if (string == null) {
            ReferencedValuesGradleEditorComponent.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static BufferedImage getContentToShow(@NotNull Editor editor, @NotNull RangeMarker marker, int minWidthPx) {
        int xEnd;
        int xStart;
        int xShift;
        if (editor == null) {
            ReferencedValuesGradleEditorComponent.$$$reportNull$$$0(7);
        }
        if (marker == null) {
            ReferencedValuesGradleEditorComponent.$$$reportNull$$$0(8);
        }
        int maxWidth = Toolkit.getDefaultToolkit().getScreenSize().width * 4 / 5;
        Document document = editor.getDocument();
        int startLine = document.getLineNumber(marker.getStartOffset());
        int endLine = document.getLineNumber(marker.getEndOffset());
        int minStartX = Integer.MAX_VALUE;
        int maxEndX = 0;
        CharSequence text = document.getCharsSequence();
        for (int line = startLine; line <= endLine; ++line) {
            int startOffsetToUse = CharArrayUtil.shiftForward((CharSequence)text, (int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line), (String)" \t");
            int endOffsetToUse = CharArrayUtil.shiftBackward((CharSequence)text, (int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line), (String)" \t");
            minStartX = Math.min(minStartX, ReferencedValuesGradleEditorComponent.offsetToXY((Editor)editor, (int)startOffsetToUse).x);
            maxEndX = Math.max(maxEndX, ReferencedValuesGradleEditorComponent.offsetToXY((Editor)editor, (int)endOffsetToUse).x);
        }
        int desiredWidth = maxEndX - minStartX;
        if (desiredWidth > maxWidth) {
            xShift = (desiredWidth - maxWidth) / 2;
            xStart = ReferencedValuesGradleEditorComponent.offsetToXY((Editor)editor, (int)minStartX).x + xShift;
            xEnd = xStart + maxWidth;
        } else if (desiredWidth < minWidthPx) {
            xShift = (minWidthPx - desiredWidth) / 2;
            xStart = ReferencedValuesGradleEditorComponent.offsetToXY((Editor)editor, (int)minStartX).x - xShift;
            xEnd = xStart + minWidthPx;
        } else {
            xStart = minStartX;
            xEnd = maxEndX;
        }
        int lineHeight = editor.getLineHeight();
        int yStart = ReferencedValuesGradleEditorComponent.offsetToXY((Editor)editor, (int)marker.getStartOffset()).y;
        int yEnd = yStart + lineHeight + lineHeight * (endLine - startLine);
        int width = xEnd - xStart;
        int height = yEnd - yStart;
        JScrollPane scrollPane = (JScrollPane)UIUtil.findComponentOfType((JComponent)editor.getComponent(), JScrollPane.class);
        BufferedImage image = UIUtil.createImage((int)width, (int)height, (int)2);
        if (scrollPane != null) {
            Component editorComponent = scrollPane.getViewport().getView();
            editorComponent.setSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
            Graphics2D graphics = image.createGraphics();
            UISettings.setupAntialiasing((Graphics)graphics);
            graphics.translate(-xStart, -yStart);
            graphics.setClip(xStart, yStart, width, height);
            editorComponent.paint(graphics);
            graphics.dispose();
        }
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            ReferencedValuesGradleEditorComponent.$$$reportNull$$$0(9);
        }
        return bufferedImage;
    }

    @NotNull
    private static Point offsetToXY(@NotNull Editor editor, int offset) {
        if (editor == null) {
            ReferencedValuesGradleEditorComponent.$$$reportNull$$$0(10);
        }
        Point point = editor.visualPositionToXY(editor.offsetToVisualPosition(offset));
        if (point == null) {
            ReferencedValuesGradleEditorComponent.$$$reportNull$$$0(11);
        }
        return point;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceBindings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/editor/ui/ReferencedValuesGradleEditorComponent";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/editor/ui/ReferencedValuesGradleEditorComponent";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepresentativeName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentToShow";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToXY";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bind";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRepresentativeName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContentToShow";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "offsetToXY";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Content
    extends JBPanel {
        private static final String FILE_KEY = "__FILE";
        private static final String MARKER_KEY = "__MARKER";
        private final List<JComponent> myTextFragmentPanels;
        @NotNull
        private final Runnable myCloseCallback;
        @Nullable
        private JComponent myTextFragmentPanelUnderMouse;

        Content(final @NotNull Project project, Runnable closeCallback) {
            if (project == null) {
                Content.$$$reportNull$$$0(0);
            }
            if (closeCallback == null) {
                Content.$$$reportNull$$$0(1);
            }
            super((LayoutManager)new GridBagLayout());
            this.myTextFragmentPanels = Lists.newArrayList();
            this.myCloseCallback = closeCallback;
            this.setBackground(GradleEditorUiConstants.BACKGROUND_COLOR);
            int gap = 8;
            GridBag constraints = new GridBag().fillCellHorizontally().weightx(1.0).coverLine().insets(gap, gap, gap, gap);
            EditorFactory editorFactory = EditorFactory.getInstance();
            int maxTitleWidthPx = 0;
            for (String string : ReferencedValuesGradleEditorComponent.this.mySourceBindings.keySet()) {
                maxTitleWidthPx = Math.max(maxTitleWidthPx, this.getFontMetrics(UIUtil.getTitledBorderFont()).stringWidth(string));
            }
            for (Map.Entry entry : ReferencedValuesGradleEditorComponent.this.mySourceBindings.entrySet()) {
                JBPanel titledPanel = new JBPanel((LayoutManager)new GridBagLayout());
                titledPanel.setBackground(GradleEditorUiConstants.BACKGROUND_COLOR);
                titledPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)((String)entry.getKey())));
                boolean hasContent = false;
                Editor editor = null;
                for (RangeMarker marker : (List)entry.getValue()) {
                    if (!marker.isValid()) continue;
                    if (editor == null) {
                        editor = editorFactory.createEditor(marker.getDocument(), project);
                    }
                    JBPanel fragmentPanel = new JBPanel((LayoutManager)new GridBagLayout());
                    fragmentPanel.putClientProperty((Object)FILE_KEY, entry.getKey());
                    fragmentPanel.putClientProperty((Object)MARKER_KEY, (Object)marker);
                    fragmentPanel.setForeground(GradleEditorUiConstants.BACKGROUND_COLOR);
                    fragmentPanel.setBackground(GradleEditorUiConstants.BACKGROUND_COLOR);
                    fragmentPanel.setBorder(BorderFactory.createLoweredBevelBorder());
                    BufferedImage contentToShow = ReferencedValuesGradleEditorComponent.getContentToShow(editor, marker, maxTitleWidthPx);
                    fragmentPanel.add((Component)new JLabel(new ImageIcon(contentToShow)), (Object)constraints);
                    hasContent = true;
                    titledPanel.add((Component)fragmentPanel, (Object)constraints);
                    this.myTextFragmentPanels.add((JComponent)fragmentPanel);
                }
                if (editor != null) {
                    editorFactory.releaseEditor(editor);
                }
                if (!hasContent) continue;
                this.add((Component)titledPanel, constraints);
            }
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (Content.this.myTextFragmentPanelUnderMouse != null && !Content.this.isInside(e, Content.this.myTextFragmentPanelUnderMouse)) {
                        Content.this.myTextFragmentPanelUnderMouse.setBorder(BorderFactory.createLoweredBevelBorder());
                        Content.this.myTextFragmentPanelUnderMouse = null;
                    }
                    for (JComponent panel : Content.this.myTextFragmentPanels) {
                        if (!Content.this.isInside(e, panel)) continue;
                        Content.this.myTextFragmentPanelUnderMouse = panel;
                        panel.setBorder(BorderFactory.createRaisedBevelBorder());
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (Content.this.myTextFragmentPanelUnderMouse != null && Content.this.isInside(e, Content.this.myTextFragmentPanelUnderMouse)) {
                        Content.this.myTextFragmentPanelUnderMouse.setBorder(BorderFactory.createLoweredBevelBorder());
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Content.this.myTextFragmentPanelUnderMouse == null || !Content.this.isInside(e, Content.this.myTextFragmentPanelUnderMouse)) {
                        return;
                    }
                    Object fileName = Content.this.myTextFragmentPanelUnderMouse.getClientProperty(Content.FILE_KEY);
                    if (!(fileName instanceof String)) {
                        return;
                    }
                    VirtualFile file = (VirtualFile)ReferencedValuesGradleEditorComponent.this.myFilesByName.get(fileName.toString());
                    if (file == null) {
                        return;
                    }
                    Object m = Content.this.myTextFragmentPanelUnderMouse.getClientProperty(Content.MARKER_KEY);
                    if (!(m instanceof RangeMarker)) {
                        return;
                    }
                    RangeMarker marker = (RangeMarker)m;
                    if (!marker.isValid()) {
                        return;
                    }
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, marker.getStartOffset());
                    if (descriptor.canNavigate()) {
                        descriptor.navigate(true);
                        Content.this.myCloseCallback.run();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (Content.this.myTextFragmentPanelUnderMouse != null && Content.this.isInside(e, Content.this.myTextFragmentPanelUnderMouse)) {
                        Content.this.myTextFragmentPanelUnderMouse.setBorder(BorderFactory.createRaisedBevelBorder());
                    }
                }
            });
        }

        private boolean isInside(@NotNull MouseEvent e, @NotNull JComponent component) {
            if (e == null) {
                Content.$$$reportNull$$$0(2);
            }
            if (component == null) {
                Content.$$$reportNull$$$0(3);
            }
            return component.contains(SwingUtilities.convertPoint((Component)((Object)this), e.getPoint(), component));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closeCallback";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/editor/ui/ReferencedValuesGradleEditorComponent$Content";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInside";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

