/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.AndroidGradleClassJarProvider;
import com.android.tools.idea.gradle.project.build.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.model.AndroidModelFeatures;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ClassJarProvider;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidModuleModel
implements AndroidModel,
ModuleModel {
    public static final String EXPLODED_AAR = "exploded-aar";
    private static final long serialVersionUID = 1L;
    private static final String[] TEST_ARTIFACT_NAMES = new String[]{"_unit_test_", "_android_test_"};
    @NotNull
    private ProjectSystemId myProjectSystemId;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private AndroidProject myAndroidProject;
    @NotNull
    private transient AndroidModelFeatures myFeatures;
    @Nullable
    private transient GradleVersion myModelVersion;
    @Nullable
    private transient CountDownLatch myProxyAndroidProjectLatch;
    @Nullable
    private AndroidProject myProxyAndroidProject;
    @NotNull
    private String mySelectedVariantName;
    private transient VirtualFile myRootDir;
    @Nullable
    private Boolean myOverridesManifestPackage;
    @Nullable
    private transient AndroidVersion myMinSdkVersion;
    @NotNull
    private Map<String, BuildTypeContainer> myBuildTypesByName;
    @NotNull
    private Map<String, ProductFlavorContainer> myProductFlavorsByName;
    @NotNull
    private Map<String, Variant> myVariantsByName;
    @NotNull
    private Set<File> myExtraGeneratedSourceFolders;
    private static final AndroidVersion NOT_SPECIFIED = new AndroidVersion(0, null);

    @Nullable
    public static AndroidModuleModel get(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            AndroidModuleModel.$$$reportNull$$$0(0);
        }
        return (facet = AndroidFacet.getInstance(module)) != null ? AndroidModuleModel.get(facet) : null;
    }

    @Nullable
    public static AndroidModuleModel get(@NotNull AndroidFacet androidFacet) {
        AndroidModel androidModel;
        if (androidFacet == null) {
            AndroidModuleModel.$$$reportNull$$$0(1);
        }
        return (androidModel = androidFacet.getAndroidModel()) instanceof AndroidModuleModel ? (AndroidModuleModel)androidModel : null;
    }

    public AndroidModuleModel(@NotNull String moduleName, @NotNull File rootDirPath, @NotNull AndroidProject androidProject, @NotNull String selectedVariantName) {
        if (moduleName == null) {
            AndroidModuleModel.$$$reportNull$$$0(2);
        }
        if (rootDirPath == null) {
            AndroidModuleModel.$$$reportNull$$$0(3);
        }
        if (androidProject == null) {
            AndroidModuleModel.$$$reportNull$$$0(4);
        }
        if (selectedVariantName == null) {
            AndroidModuleModel.$$$reportNull$$$0(5);
        }
        this.myBuildTypesByName = Maps.newHashMap();
        this.myProductFlavorsByName = Maps.newHashMap();
        this.myVariantsByName = Maps.newHashMap();
        this.myExtraGeneratedSourceFolders = Sets.newHashSet();
        this.myProjectSystemId = GradleUtil.GRADLE_SYSTEM_ID;
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.myAndroidProject = androidProject;
        this.parseAndSetModelVersion();
        this.myFeatures = new AndroidModelFeatures(this.myModelVersion);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.myProxyAndroidProjectLatch = new CountDownLatch(1);
            try {
                this.myProxyAndroidProject = ProxyUtil.reproxy(AndroidProject.class, this.myAndroidProject);
            }
            finally {
                this.myProxyAndroidProjectLatch.countDown();
            }
        });
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.mySelectedVariantName = this.findVariantToSelect(selectedVariantName);
    }

    private void populateBuildTypesByName() {
        for (BuildTypeContainer container : this.myAndroidProject.getBuildTypes()) {
            String name = container.getBuildType().getName();
            this.myBuildTypesByName.put(name, container);
        }
    }

    private void populateProductFlavorsByName() {
        for (ProductFlavorContainer container : this.myAndroidProject.getProductFlavors()) {
            String name = container.getProductFlavor().getName();
            this.myProductFlavorsByName.put(name, container);
        }
    }

    private void populateVariantsByName() {
        for (Variant variant : this.myAndroidProject.getVariants()) {
            this.myVariantsByName.put(variant.getName(), variant);
        }
    }

    @NotNull
    public Dependencies getSelectedMainCompileDependencies() {
        AndroidArtifact mainArtifact = this.getMainArtifact();
        Dependencies dependencies = GradleUtil.getDependencies((BaseArtifact)mainArtifact, this.getModelVersion());
        if (dependencies == null) {
            AndroidModuleModel.$$$reportNull$$$0(6);
        }
        return dependencies;
    }

    @Nullable
    public Dependencies getSelectedAndroidTestCompileDependencies() {
        AndroidArtifact androidTestArtifact = this.getAndroidTestArtifactInSelectedVariant();
        if (androidTestArtifact == null) {
            return null;
        }
        return GradleUtil.getDependencies((BaseArtifact)androidTestArtifact, this.getModelVersion());
    }

    @NotNull
    public AndroidModelFeatures getFeatures() {
        AndroidModelFeatures androidModelFeatures = this.myFeatures;
        if (androidModelFeatures == null) {
            AndroidModuleModel.$$$reportNull$$$0(7);
        }
        return androidModelFeatures;
    }

    @Nullable
    public GradleVersion getModelVersion() {
        return this.myModelVersion;
    }

    @NotNull
    public AndroidArtifact getMainArtifact() {
        AndroidArtifact androidArtifact = this.getSelectedVariant().getMainArtifact();
        if (androidArtifact == null) {
            AndroidModuleModel.$$$reportNull$$$0(8);
        }
        return androidArtifact;
    }

    @Override
    @NotNull
    public SourceProvider getDefaultSourceProvider() {
        SourceProvider sourceProvider = this.getAndroidProject().getDefaultConfig().getSourceProvider();
        if (sourceProvider == null) {
            AndroidModuleModel.$$$reportNull$$$0(9);
        }
        return sourceProvider;
    }

    @Override
    @NotNull
    public List<SourceProvider> getActiveSourceProviders() {
        List<SourceProvider> list = this.getMainSourceProviders(this.mySelectedVariantName);
        if (list == null) {
            AndroidModuleModel.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<SourceProvider> getMainSourceProviders(@NotNull String variantName) {
        Variant variant;
        if (variantName == null) {
            AndroidModuleModel.$$$reportNull$$$0(11);
        }
        if ((variant = this.myVariantsByName.get(variantName)) == null) {
            AndroidModuleModel.getLogger().error("Unknown variant name '" + variantName + "' found in the module '" + this.myModuleName + "'");
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                AndroidModuleModel.$$$reportNull$$$0(12);
            }
            return immutableList;
        }
        ArrayList providers = Lists.newArrayList();
        providers.add(this.getDefaultSourceProvider());
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        SourceProvider multiFlavorProvider = mainArtifact.getMultiFlavorSourceProvider();
        if (multiFlavorProvider != null) {
            providers.add(multiFlavorProvider);
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.add(buildType.getSourceProvider());
        SourceProvider variantProvider = mainArtifact.getVariantSourceProvider();
        if (variantProvider != null) {
            providers.add(variantProvider);
        }
        ArrayList arrayList = providers;
        if (arrayList == null) {
            AndroidModuleModel.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public Collection<SourceProvider> getTestSourceProviders(@NotNull Iterable<SourceProviderContainer> containers) {
        if (containers == null) {
            AndroidModuleModel.$$$reportNull$$$0(14);
        }
        Collection<SourceProvider> collection = AndroidModuleModel.getSourceProvidersForArtifacts(containers, TEST_ARTIFACT_NAMES);
        if (collection == null) {
            AndroidModuleModel.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @Override
    @NotNull
    public List<SourceProvider> getTestSourceProviders() {
        List<SourceProvider> list = this.getTestSourceProviders(this.mySelectedVariantName, TEST_ARTIFACT_NAMES);
        if (list == null) {
            AndroidModuleModel.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public List<SourceProvider> getTestSourceProviders(@NotNull String artifactName) {
        if (artifactName == null) {
            AndroidModuleModel.$$$reportNull$$$0(17);
        }
        List<SourceProvider> list = this.getTestSourceProviders(this.mySelectedVariantName, artifactName);
        if (list == null) {
            AndroidModuleModel.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public List<SourceProvider> getTestSourceProviders(@NotNull String variantName, String ... testArtifactNames) {
        if (variantName == null) {
            AndroidModuleModel.$$$reportNull$$$0(19);
        }
        if (testArtifactNames == null) {
            AndroidModuleModel.$$$reportNull$$$0(20);
        }
        AndroidModuleModel.validateTestArtifactNames(testArtifactNames);
        ArrayList providers = Lists.newArrayList();
        Collection extraSourceProviders = this.getAndroidProject().getDefaultConfig().getExtraSourceProviders();
        providers.addAll(AndroidModuleModel.getSourceProvidersForArtifacts(extraSourceProviders, testArtifactNames));
        Variant variant = this.myVariantsByName.get(variantName);
        assert (variant != null);
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.addAll(AndroidModuleModel.getSourceProvidersForArtifacts(productFlavor.getExtraSourceProviders(), testArtifactNames));
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.addAll(AndroidModuleModel.getSourceProvidersForArtifacts(buildType.getExtraSourceProviders(), testArtifactNames));
        ArrayList arrayList = providers;
        if (arrayList == null) {
            AndroidModuleModel.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static void validateTestArtifactNames(@NotNull String[] testArtifactNames) {
        if (testArtifactNames == null) {
            AndroidModuleModel.$$$reportNull$$$0(22);
        }
        for (String name : testArtifactNames) {
            if (AndroidModuleModel.isTestArtifact(name)) continue;
            String msg = String.format("'%1$s' is not a test artifact", name);
            throw new IllegalArgumentException(msg);
        }
    }

    @NotNull
    public Collection<BaseArtifact> getTestArtifactsInSelectedVariant() {
        Collection<BaseArtifact> collection = AndroidModuleModel.getTestArtifacts(this.getSelectedVariant());
        if (collection == null) {
            AndroidModuleModel.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @NotNull
    public static Collection<BaseArtifact> getTestArtifacts(@NotNull Variant variant) {
        if (variant == null) {
            AndroidModuleModel.$$$reportNull$$$0(24);
        }
        HashSet testArtifacts = Sets.newHashSet();
        for (BaseArtifact artifact : variant.getExtraAndroidArtifacts()) {
            if (!AndroidModuleModel.isTestArtifact(artifact)) continue;
            testArtifacts.add(artifact);
        }
        for (BaseArtifact artifact : variant.getExtraJavaArtifacts()) {
            if (!AndroidModuleModel.isTestArtifact(artifact)) continue;
            testArtifacts.add(artifact);
        }
        HashSet hashSet = testArtifacts;
        if (hashSet == null) {
            AndroidModuleModel.$$$reportNull$$$0(25);
        }
        return hashSet;
    }

    @Nullable
    public AndroidArtifact getAndroidTestArtifactInSelectedVariant() {
        for (AndroidArtifact artifact : this.getSelectedVariant().getExtraAndroidArtifacts()) {
            if (!AndroidModuleModel.isTestArtifact((BaseArtifact)artifact)) continue;
            return artifact;
        }
        return null;
    }

    @Nullable
    public JavaArtifact getUnitTestArtifactInSelectedVariant() {
        for (JavaArtifact artifact : this.getSelectedVariant().getExtraJavaArtifacts()) {
            if (!AndroidModuleModel.isTestArtifact((BaseArtifact)artifact)) continue;
            return artifact;
        }
        return null;
    }

    public static boolean isTestArtifact(@NotNull BaseArtifact artifact) {
        if (artifact == null) {
            AndroidModuleModel.$$$reportNull$$$0(26);
        }
        String artifactName = artifact.getName();
        return AndroidModuleModel.isTestArtifact(artifactName);
    }

    private static boolean isTestArtifact(@Nullable String artifactName) {
        return ArrayUtil.contains((String)artifactName, (String[])TEST_ARTIFACT_NAMES);
    }

    @Override
    @NotNull
    public List<SourceProvider> getAllSourceProviders() {
        Collection variants = this.myAndroidProject.getVariants();
        ArrayList providers = Lists.newArrayList();
        providers.add(this.getDefaultSourceProvider());
        Collection flavors = this.myAndroidProject.getProductFlavors();
        for (ProductFlavorContainer pfc : flavors) {
            providers.add(pfc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider = v.getMainArtifact().getMultiFlavorSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        Collection buildTypes = this.myAndroidProject.getBuildTypes();
        for (BuildTypeContainer btc : buildTypes) {
            providers.add(btc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider = v.getMainArtifact().getVariantSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        ArrayList arrayList = providers;
        if (arrayList == null) {
            AndroidModuleModel.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getApplicationId() {
        String string = this.getSelectedVariant().getMainArtifact().getApplicationId();
        if (string == null) {
            AndroidModuleModel.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Override
    @NotNull
    public Set<String> getAllApplicationIds() {
        HashSet ids = Sets.newHashSet();
        for (Variant v : this.myAndroidProject.getVariants()) {
            String applicationId = v.getMergedFlavor().getApplicationId();
            if (applicationId == null) continue;
            ids.add(applicationId);
        }
        HashSet hashSet = ids;
        if (hashSet == null) {
            AndroidModuleModel.$$$reportNull$$$0(29);
        }
        return hashSet;
    }

    @Override
    public Boolean isDebuggable() {
        BuildTypeContainer buildTypeContainer = this.findBuildType(this.getSelectedVariant().getBuildType());
        if (buildTypeContainer != null) {
            return buildTypeContainer.getBuildType().isDebuggable();
        }
        return null;
    }

    @Override
    @Nullable
    public AndroidVersion getMinSdkVersion() {
        if (this.myMinSdkVersion == null) {
            ApiVersion minSdkVersion = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
            if (minSdkVersion != null && minSdkVersion.getCodename() != null) {
                ApiVersion defaultConfigVersion = this.getAndroidProject().getDefaultConfig().getProductFlavor().getMinSdkVersion();
                if (defaultConfigVersion != null) {
                    minSdkVersion = defaultConfigVersion;
                }
                List flavors = this.getSelectedVariant().getProductFlavors();
                for (String flavor : flavors) {
                    ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                    assert (productFlavor != null);
                    ApiVersion flavorVersion = productFlavor.getProductFlavor().getMinSdkVersion();
                    if (flavorVersion == null) continue;
                    minSdkVersion = flavorVersion;
                    break;
                }
            }
            this.myMinSdkVersion = minSdkVersion != null ? LintUtils.convertVersion((ApiVersion)minSdkVersion, null) : NOT_SPECIFIED;
        }
        return this.myMinSdkVersion != NOT_SPECIFIED ? this.myMinSdkVersion : null;
    }

    @Override
    @Nullable
    public AndroidVersion getRuntimeMinSdkVersion() {
        ApiVersion minSdkVersion = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
        if (minSdkVersion != null) {
            return new AndroidVersion(minSdkVersion.getApiLevel(), minSdkVersion.getCodename());
        }
        return null;
    }

    @Override
    @Nullable
    public AndroidVersion getTargetSdkVersion() {
        ApiVersion targetSdkVersion = this.getSelectedVariant().getMergedFlavor().getTargetSdkVersion();
        if (targetSdkVersion != null) {
            return new AndroidVersion(targetSdkVersion.getApiLevel(), targetSdkVersion.getCodename());
        }
        return null;
    }

    @Override
    @Nullable
    public Integer getVersionCode() {
        Variant variant = this.getSelectedVariant();
        ProductFlavor flavor = variant.getMergedFlavor();
        return flavor.getVersionCode();
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = this.myProjectSystemId;
        if (projectSystemId == null) {
            AndroidModuleModel.$$$reportNull$$$0(30);
        }
        return projectSystemId;
    }

    @Nullable
    public BuildTypeContainer findBuildType(@NotNull String name) {
        if (name == null) {
            AndroidModuleModel.$$$reportNull$$$0(31);
        }
        return this.myBuildTypesByName.get(name);
    }

    @NotNull
    public Set<String> getBuildTypes() {
        Set<String> set = this.myBuildTypesByName.keySet();
        if (set == null) {
            AndroidModuleModel.$$$reportNull$$$0(32);
        }
        return set;
    }

    @NotNull
    public Set<String> getProductFlavors() {
        Set<String> set = this.myProductFlavorsByName.keySet();
        if (set == null) {
            AndroidModuleModel.$$$reportNull$$$0(33);
        }
        return set;
    }

    @Nullable
    public ProductFlavorContainer findProductFlavor(@NotNull String name) {
        if (name == null) {
            AndroidModuleModel.$$$reportNull$$$0(34);
        }
        return this.myProductFlavorsByName.get(name);
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            AndroidModuleModel.$$$reportNull$$$0(35);
        }
        return string;
    }

    @Override
    @NotNull
    public File getRootDirPath() {
        File file = this.myRootDirPath;
        if (file == null) {
            AndroidModuleModel.$$$reportNull$$$0(36);
        }
        return file;
    }

    @Override
    @NotNull
    public VirtualFile getRootDir() {
        if (this.myRootDir == null) {
            VirtualFile found = VfsUtil.findFileByIoFile((File)this.myRootDirPath, (boolean)true);
            assert (found != null);
            this.myRootDir = found;
        }
        VirtualFile virtualFile = this.myRootDir;
        if (virtualFile == null) {
            AndroidModuleModel.$$$reportNull$$$0(37);
        }
        return virtualFile;
    }

    @Override
    public boolean isGenerated(@NotNull VirtualFile file) {
        VirtualFile buildFolder;
        if (file == null) {
            AndroidModuleModel.$$$reportNull$$$0(38);
        }
        return (buildFolder = VfsUtil.findFileByIoFile((File)this.myAndroidProject.getBuildFolder(), (boolean)false)) != null && VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false);
    }

    @NotNull
    public AndroidProject getAndroidProject() {
        AndroidProject androidProject = this.myAndroidProject;
        if (androidProject == null) {
            AndroidModuleModel.$$$reportNull$$$0(39);
        }
        return androidProject;
    }

    @NotNull
    public AndroidProject waitForAndGetProxyAndroidProject() {
        this.waitForProxyAndroidProject();
        assert (this.myProxyAndroidProject != null);
        AndroidProject androidProject = this.myProxyAndroidProject;
        if (androidProject == null) {
            AndroidModuleModel.$$$reportNull$$$0(40);
        }
        return androidProject;
    }

    public void waitForProxyAndroidProject() {
        if (this.myProxyAndroidProjectLatch != null) {
            try {
                this.myProxyAndroidProjectLatch.await();
            }
            catch (InterruptedException e) {
                AndroidModuleModel.getLogger().error((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(AndroidModuleModel.class);
        if (logger == null) {
            AndroidModuleModel.$$$reportNull$$$0(41);
        }
        return logger;
    }

    @NotNull
    public Variant getSelectedVariant() {
        Variant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        Variant variant = selected;
        if (variant == null) {
            AndroidModuleModel.$$$reportNull$$$0(42);
        }
        return variant;
    }

    @Nullable
    public Variant findVariantByName(@NotNull String variantName) {
        if (variantName == null) {
            AndroidModuleModel.$$$reportNull$$$0(43);
        }
        return this.myVariantsByName.get(variantName);
    }

    public void setSelectedVariantName(@NotNull String name) {
        if (name == null) {
            AndroidModuleModel.$$$reportNull$$$0(44);
        }
        this.mySelectedVariantName = this.findVariantToSelect(name);
        this.myOverridesManifestPackage = null;
        this.myMinSdkVersion = null;
    }

    @NotNull
    private String findVariantToSelect(@NotNull String variantName) {
        String newVariantName;
        Collection<String> variantNames;
        if (variantName == null) {
            AndroidModuleModel.$$$reportNull$$$0(45);
        }
        if ((variantNames = this.getVariantNames()).contains(variantName)) {
            newVariantName = variantName;
        } else {
            ArrayList sorted = Lists.newArrayList(variantNames);
            Collections.sort(sorted);
            newVariantName = (String)sorted.get(0);
        }
        String string = newVariantName;
        if (string == null) {
            AndroidModuleModel.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    private static Collection<SourceProvider> getSourceProvidersForArtifacts(@NotNull Iterable<SourceProviderContainer> containers, String ... artifactNames) {
        if (containers == null) {
            AndroidModuleModel.$$$reportNull$$$0(47);
        }
        if (artifactNames == null) {
            AndroidModuleModel.$$$reportNull$$$0(48);
        }
        HashSet providers = Sets.newHashSet();
        block0: for (SourceProviderContainer container : containers) {
            for (String artifactName : artifactNames) {
                if (!artifactName.equals(container.getArtifactName())) continue;
                providers.add(container.getSourceProvider());
                continue block0;
            }
        }
        HashSet hashSet = providers;
        if (hashSet == null) {
            AndroidModuleModel.$$$reportNull$$$0(49);
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getBuildTypeNames() {
        Set<String> set = this.myBuildTypesByName.keySet();
        if (set == null) {
            AndroidModuleModel.$$$reportNull$$$0(50);
        }
        return set;
    }

    @NotNull
    public Collection<String> getProductFlavorNames() {
        Set<String> set = this.myProductFlavorsByName.keySet();
        if (set == null) {
            AndroidModuleModel.$$$reportNull$$$0(51);
        }
        return set;
    }

    @NotNull
    public Collection<String> getVariantNames() {
        Set<String> set = this.myVariantsByName.keySet();
        if (set == null) {
            AndroidModuleModel.$$$reportNull$$$0(52);
        }
        return set;
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        JavaCompileOptions compileOptions = this.myAndroidProject.getJavaCompileOptions();
        String sourceCompatibility = compileOptions.getSourceCompatibility();
        return LanguageLevel.parse((String)sourceCompatibility);
    }

    public int getProjectType() {
        try {
            return this.getAndroidProject().getProjectType();
        }
        catch (UnsupportedMethodException e) {
            return this.getAndroidProject().isLibrary() ? 1 : 0;
        }
    }

    @Override
    public boolean overridesManifestPackage() {
        if (this.myOverridesManifestPackage == null) {
            this.myOverridesManifestPackage = this.getAndroidProject().getDefaultConfig().getProductFlavor().getApplicationId() != null;
            Variant variant = this.getSelectedVariant();
            List flavors = variant.getProductFlavors();
            for (String flavor : flavors) {
                ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                assert (productFlavor != null);
                if (productFlavor.getProductFlavor().getApplicationId() == null) continue;
                this.myOverridesManifestPackage = true;
                break;
            }
        }
        return this.myOverridesManifestPackage;
    }

    public void registerExtraGeneratedSourceFolder(@NotNull File folderPath) {
        if (folderPath == null) {
            AndroidModuleModel.$$$reportNull$$$0(53);
        }
        this.myExtraGeneratedSourceFolders.add(folderPath);
    }

    @NotNull
    public List<File> getExcludedFolderPaths() {
        File buildFolderPath = this.getAndroidProject().getBuildFolder();
        ArrayList excludedFolderPaths = Lists.newArrayList();
        if (buildFolderPath.isDirectory()) {
            for (File folderPath : FileUtil.notNullize((File[])buildFolderPath.listFiles())) {
                String folderName = folderPath.getName();
                if (folderName.equals("intermediates") || folderName.equals("generated")) continue;
                excludedFolderPaths.add(folderPath);
            }
            File intermediates = new File(buildFolderPath, "intermediates");
            if (intermediates.isDirectory()) {
                for (File folderPath : FileUtil.notNullize((File[])intermediates.listFiles())) {
                    String folderName = folderPath.getName();
                    if (folderName.equals(EXPLODED_AAR) || folderName.equals("manifest")) continue;
                    excludedFolderPaths.add(folderPath);
                }
            }
        } else {
            excludedFolderPaths.add(new File(buildFolderPath, "outputs"));
            excludedFolderPaths.add(new File(buildFolderPath, "tmp"));
        }
        ArrayList arrayList = excludedFolderPaths;
        if (arrayList == null) {
            AndroidModuleModel.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    @NotNull
    public File[] getExtraGeneratedSourceFolderPaths() {
        File[] fileArray = this.myExtraGeneratedSourceFolders.toArray(new File[this.myExtraGeneratedSourceFolders.size()]);
        if (fileArray == null) {
            AndroidModuleModel.$$$reportNull$$$0(55);
        }
        return fileArray;
    }

    @Nullable
    public Collection<SyncIssue> getSyncIssues() {
        if (this.getFeatures().isIssueReportingSupported()) {
            return this.myAndroidProject.getSyncIssues();
        }
        return null;
    }

    @Nullable
    public SourceFileContainerInfo containsSourceFile(@NotNull File file) {
        ProductFlavorContainer defaultConfig;
        if (file == null) {
            AndroidModuleModel.$$$reportNull$$$0(56);
        }
        if (AndroidModuleModel.containsSourceFile(defaultConfig = this.myAndroidProject.getDefaultConfig(), file)) {
            return new SourceFileContainerInfo();
        }
        for (Variant variant : this.myAndroidProject.getVariants()) {
            AndroidArtifact artifact = variant.getMainArtifact();
            if (AndroidModuleModel.containsSourceFile((BaseArtifact)artifact, file)) {
                return new SourceFileContainerInfo(variant, (BaseArtifact)artifact);
            }
            for (AndroidArtifact extraArtifact : variant.getExtraAndroidArtifacts()) {
                if (!AndroidModuleModel.containsSourceFile((BaseArtifact)extraArtifact, file)) continue;
                return new SourceFileContainerInfo(variant, (BaseArtifact)extraArtifact);
            }
            String buildTypeName = variant.getBuildType();
            BuildTypeContainer buildTypeContainer = this.findBuildType(buildTypeName);
            if (buildTypeContainer != null) {
                if (AndroidModuleModel.containsFile(buildTypeContainer.getSourceProvider(), file)) {
                    return new SourceFileContainerInfo(variant);
                }
                for (SourceProviderContainer extraSourceProvider : buildTypeContainer.getExtraSourceProviders()) {
                    if (!AndroidModuleModel.containsFile(extraSourceProvider.getSourceProvider(), file)) continue;
                    return new SourceFileContainerInfo(variant);
                }
            }
            for (String flavorName : variant.getProductFlavors()) {
                ProductFlavorContainer flavor = this.findProductFlavor(flavorName);
                if (flavor == null || !AndroidModuleModel.containsSourceFile(flavor, file)) continue;
                return new SourceFileContainerInfo(variant);
            }
        }
        return null;
    }

    private static boolean containsSourceFile(@NotNull ProductFlavorContainer flavorContainer, @NotNull File file) {
        if (flavorContainer == null) {
            AndroidModuleModel.$$$reportNull$$$0(57);
        }
        if (file == null) {
            AndroidModuleModel.$$$reportNull$$$0(58);
        }
        if (AndroidModuleModel.containsFile(flavorContainer.getSourceProvider(), file)) {
            return true;
        }
        for (SourceProviderContainer extraSourceProvider : flavorContainer.getExtraSourceProviders()) {
            if (!AndroidModuleModel.containsFile(extraSourceProvider.getSourceProvider(), file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSourceFile(@NotNull BaseArtifact artifact, @NotNull File file) {
        AndroidArtifact androidArtifact;
        if (artifact == null) {
            AndroidModuleModel.$$$reportNull$$$0(59);
        }
        if (file == null) {
            AndroidModuleModel.$$$reportNull$$$0(60);
        }
        if (artifact instanceof AndroidArtifact && (AndroidModuleModel.containsFile(GradleUtil.getGeneratedSourceFolders((BaseArtifact)(androidArtifact = (AndroidArtifact)artifact)), file) || AndroidModuleModel.containsFile(androidArtifact.getGeneratedResourceFolders(), file))) {
            return true;
        }
        SourceProvider sourceProvider = artifact.getVariantSourceProvider();
        if (sourceProvider != null && AndroidModuleModel.containsFile(sourceProvider, file)) {
            return true;
        }
        sourceProvider = artifact.getMultiFlavorSourceProvider();
        return sourceProvider != null && AndroidModuleModel.containsFile(sourceProvider, file);
    }

    private static boolean containsFile(@NotNull SourceProvider sourceProvider, @NotNull File file) {
        if (sourceProvider == null) {
            AndroidModuleModel.$$$reportNull$$$0(61);
        }
        if (file == null) {
            AndroidModuleModel.$$$reportNull$$$0(62);
        }
        return AndroidModuleModel.containsFile(sourceProvider.getAidlDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getAssetsDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getCDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getCppDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getJavaDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getRenderscriptDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getResDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getResourcesDirectories(), file);
    }

    private static boolean containsFile(@NotNull Collection<File> directories, @NotNull File file) {
        if (directories == null) {
            AndroidModuleModel.$$$reportNull$$$0(63);
        }
        if (file == null) {
            AndroidModuleModel.$$$reportNull$$$0(64);
        }
        for (File directory : directories) {
            if (!FileUtil.isAncestor((File)directory, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.waitForProxyAndroidProject();
        out.writeObject(this.myProjectSystemId);
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myProxyAndroidProject);
        out.writeObject(this.mySelectedVariantName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myProjectSystemId = (ProjectSystemId)in.readObject();
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myAndroidProject = (AndroidProject)in.readObject();
        this.parseAndSetModelVersion();
        this.myFeatures = new AndroidModelFeatures(this.myModelVersion);
        this.myProxyAndroidProject = this.myAndroidProject;
        this.myBuildTypesByName = Maps.newHashMap();
        this.myProductFlavorsByName = Maps.newHashMap();
        this.myVariantsByName = Maps.newHashMap();
        this.myExtraGeneratedSourceFolders = Sets.newHashSet();
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.setSelectedVariantName((String)in.readObject());
    }

    private void parseAndSetModelVersion() {
        this.myModelVersion = GradleVersion.tryParse((String)this.myAndroidProject.getModelVersion());
    }

    @NotNull
    public SourceProvider getBuildTypeSourceProvider() {
        Variant selectedVariant = this.getSelectedVariant();
        BuildTypeContainer buildType = this.findBuildType(selectedVariant.getBuildType());
        assert (buildType != null);
        SourceProvider sourceProvider = buildType.getSourceProvider();
        if (sourceProvider == null) {
            AndroidModuleModel.$$$reportNull$$$0(65);
        }
        return sourceProvider;
    }

    @NotNull
    public List<SourceProvider> getFlavorSourceProviders() {
        Variant selectedVariant = this.getSelectedVariant();
        List productFlavors = selectedVariant.getProductFlavors();
        ArrayList providers = Lists.newArrayList();
        for (String flavor : productFlavors) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        ArrayList arrayList = providers;
        if (arrayList == null) {
            AndroidModuleModel.$$$reportNull$$$0(66);
        }
        return arrayList;
    }

    public void syncSelectedVariantAndTestArtifact(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidModuleModel.$$$reportNull$$$0(67);
        }
        Variant variant = this.getSelectedVariant();
        JpsAndroidModuleProperties state = facet.getProperties();
        state.SELECTED_BUILD_VARIANT = variant.getName();
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        AndroidModuleModel.updateGradleTaskNames(state, mainArtifact, null);
    }

    @VisibleForTesting
    static void updateGradleTaskNames(@NotNull JpsAndroidModuleProperties state, @NotNull AndroidArtifact mainArtifact, @Nullable BaseArtifact testArtifact) {
        if (state == null) {
            AndroidModuleModel.$$$reportNull$$$0(68);
        }
        if (mainArtifact == null) {
            AndroidModuleModel.$$$reportNull$$$0(69);
        }
        state.ASSEMBLE_TASK_NAME = mainArtifact.getAssembleTaskName();
        state.COMPILE_JAVA_TASK_NAME = mainArtifact.getCompileTaskName();
        state.AFTER_SYNC_TASK_NAMES = Sets.newHashSet(AndroidModuleModel.getIdeSetupTasks((BaseArtifact)mainArtifact));
        if (testArtifact != null) {
            state.ASSEMBLE_TEST_TASK_NAME = testArtifact.getAssembleTaskName();
            state.COMPILE_JAVA_TEST_TASK_NAME = testArtifact.getCompileTaskName();
            state.AFTER_SYNC_TASK_NAMES.addAll(AndroidModuleModel.getIdeSetupTasks(testArtifact));
        } else {
            state.ASSEMBLE_TEST_TASK_NAME = "";
            state.COMPILE_JAVA_TEST_TASK_NAME = "";
        }
    }

    @NotNull
    public static Set<String> getIdeSetupTasks(@NotNull BaseArtifact artifact) {
        block9: {
            Set set;
            if (artifact == null) {
                AndroidModuleModel.$$$reportNull$$$0(70);
            }
            try {
                set = artifact.getIdeSetupTaskNames();
            }
            catch (NoSuchMethodError e) {
                if (artifact instanceof AndroidArtifact) {
                    HashSet hashSet = Sets.newHashSet((Object[])new String[]{((AndroidArtifact)artifact).getSourceGenTaskName()});
                    if (hashSet == null) {
                        AndroidModuleModel.$$$reportNull$$$0(72);
                    }
                    return hashSet;
                }
            }
            catch (UnsupportedMethodException e) {
                if (!(artifact instanceof AndroidArtifact)) break block9;
                HashSet hashSet = Sets.newHashSet((Object[])new String[]{((AndroidArtifact)artifact).getSourceGenTaskName()});
                if (hashSet == null) {
                    AndroidModuleModel.$$$reportNull$$$0(73);
                }
                return hashSet;
            }
            if (set == null) {
                AndroidModuleModel.$$$reportNull$$$0(71);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            AndroidModuleModel.$$$reportNull$$$0(74);
        }
        return set;
    }

    @Nullable
    public SourceProvider getMultiFlavorSourceProvider() {
        AndroidArtifact mainArtifact = this.getSelectedVariant().getMainArtifact();
        return mainArtifact.getMultiFlavorSourceProvider();
    }

    @Nullable
    public SourceProvider getVariantSourceProvider() {
        AndroidArtifact mainArtifact = this.getSelectedVariant().getMainArtifact();
        return mainArtifact.getVariantSourceProvider();
    }

    @Override
    public boolean getDataBindingEnabled() {
        return GradleUtil.dependsOn(this, "com.android.databinding:library");
    }

    @Override
    @NotNull
    public ClassJarProvider getClassJarProvider() {
        AndroidGradleClassJarProvider androidGradleClassJarProvider = new AndroidGradleClassJarProvider();
        if (androidGradleClassJarProvider == null) {
            AndroidModuleModel.$$$reportNull$$$0(75);
        }
        return androidGradleClassJarProvider;
    }

    @Override
    @Nullable
    public Long getLastBuildTimestamp(@NotNull Project project) {
        if (project == null) {
            AndroidModuleModel.$$$reportNull$$$0(76);
        }
        return PostProjectBuildTasksExecutor.getInstance(project).getLastBuildTimestamp();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDirPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariantName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/model/AndroidModuleModel";
                break;
            }
            case 11: 
            case 19: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantName";
                break;
            }
            case 14: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containers";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testArtifactNames";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 26: 
            case 59: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 31: 
            case 34: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 38: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactNames";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderPath";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavorContainer";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceProvider";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainArtifact";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/model/AndroidModuleModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMainCompileDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainArtifact";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSourceProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveSourceProviders";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainSourceProviders";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestSourceProviders";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestArtifactsInSelectedVariant";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestArtifacts";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSourceProviders";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationId";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllApplicationIds";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSystemId";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypes";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductFlavors";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDirPath";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDir";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidProject";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "waitForAndGetProxyAndroidProject";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVariant";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "findVariantToSelect";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceProvidersForArtifacts";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeNames";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductFlavorNames";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariantNames";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedFolderPaths";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraGeneratedSourceFolderPaths";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeSourceProvider";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlavorSourceProviders";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeSetupTasks";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassJarProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMainSourceProviders";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTestSourceProviders";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "validateTestArtifactNames";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTestArtifacts";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isTestArtifact";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findBuildType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findProductFlavor";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isGenerated";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findVariantByName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedVariantName";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findVariantToSelect";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getSourceProvidersForArtifacts";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "registerExtraGeneratedSourceFolder";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "containsSourceFile";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "syncSelectedVariantAndTestArtifact";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "updateGradleTaskNames";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getIdeSetupTasks";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getLastBuildTimestamp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SourceFileContainerInfo {
        @Nullable
        public final Variant variant;
        @Nullable
        public final BaseArtifact artifact;

        SourceFileContainerInfo() {
            this(null);
        }

        SourceFileContainerInfo(@Nullable Variant variant) {
            this(variant, null);
        }

        SourceFileContainerInfo(@Nullable Variant variant, @Nullable BaseArtifact artifact) {
            this.variant = variant;
            this.artifact = artifact;
        }

        public void updateSelectedVariantIn(@NotNull DataNode<ModuleData> moduleNode) {
            DataNode androidProjectNode;
            if (moduleNode == null) {
                SourceFileContainerInfo.$$$reportNull$$$0(0);
            }
            if (this.variant != null && (androidProjectNode = ExternalSystemApiUtil.find(moduleNode, AndroidProjectKeys.ANDROID_MODEL)) != null) {
                ((AndroidModuleModel)androidProjectNode.getData()).setSelectedVariantName(this.variant.getName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleNode", "com/android/tools/idea/gradle/project/model/AndroidModuleModel$SourceFileContainerInfo", "updateSelectedVariantIn"));
        }
    }
}

