/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.common;

import com.android.tools.idea.gradle.actions.RefreshLinkedCppProjectsAction;
import com.android.tools.idea.gradle.project.common.GradleInitScripts;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.hyperlink.SyncProjectWithExtraCommandLineOptionsHyperlink;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.builder.ModelBuildScriptClasspathBuilderImpl;

public class CommandLineArgs {
    @NotNull
    private final GradleInitScripts myInitScripts;
    @Nullable
    private final File myClasspathInitScript;

    public CommandLineArgs(boolean generateClasspathInitScript) {
        this(GradleInitScripts.getInstance(), generateClasspathInitScript);
    }

    @VisibleForTesting
    CommandLineArgs(@NotNull GradleInitScripts initScripts, boolean generateClasspathInitScript) {
        if (initScripts == null) {
            CommandLineArgs.$$$reportNull$$$0(0);
        }
        this.myInitScripts = initScripts;
        this.myClasspathInitScript = generateClasspathInitScript ? GradleExecutionHelper.generateInitScript((boolean)false, CommandLineArgs.getToolingExtensionsClasses()) : null;
    }

    @NotNull
    private static Set<Class> getToolingExtensionsClasses() {
        HashSet hashSet = Sets.newHashSet((Object[])new Class[]{SyncAction.class, ExternalSystemException.class, ExternalSystemSourceType.class, ProjectImportAction.class, ModelBuildScriptClasspathBuilderImpl.class, ModelBuilderService.class, Multimap.class, GsonBuilder.class, ShortTypeHandling.class});
        if (hashSet == null) {
            CommandLineArgs.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public List<String> get(@Nullable Project project) {
        Boolean refreshExternalNativeModels;
        String[] options;
        ArrayList<String> args = new ArrayList<String>();
        if (this.myClasspathInitScript != null) {
            ContainerUtil.addAll(args, (Object[])new String[]{"--init-script", this.myClasspathInitScript.getPath()});
        }
        args.add("-Djava.awt.headless=true");
        if (project != null && (options = (String[])project.getUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY)) != null) {
            project.putUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY, null);
            Collections.addAll(args, options);
        }
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only.advanced", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
        if (project != null && (refreshExternalNativeModels = (Boolean)project.getUserData(RefreshLinkedCppProjectsAction.REFRESH_EXTERNAL_NATIVE_MODELS_KEY)) != null) {
            project.putUserData(RefreshLinkedCppProjectsAction.REFRESH_EXTERNAL_NATIVE_MODELS_KEY, null);
            args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.refresh.external.native.model", (boolean)refreshExternalNativeModels));
        }
        if (AndroidPlugin.isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().putUserData(AndroidPlugin.GRADLE_SYNC_COMMAND_LINE_OPTIONS_KEY, (Object)ArrayUtil.toStringArray(args));
        }
        this.myInitScripts.addLocalMavenRepoInitScriptCommandLineArgTo(args);
        ArrayList<String> arrayList = args;
        if (arrayList == null) {
            CommandLineArgs.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScripts";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/common/CommandLineArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/common/CommandLineArgs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolingExtensionsClasses";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

