/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.google.common.collect.Sets;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleAndroidModule;
import com.google.wireless.android.sdk.stats.GradleBuildDetails;
import com.google.wireless.android.sdk.stats.GradleLibrary;
import com.google.wireless.android.sdk.stats.GradleModule;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureUsageTracker {
    private static final Logger LOG = Logger.getInstance(ProjectStructureUsageTracker.class);
    @NotNull
    private final Project myProject;

    ProjectStructureUsageTracker(@NotNull Project project) {
        if (project == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    void trackProjectStructure() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            try {
                this.trackProjectStructure(moduleManager.getModules());
            }
            catch (Throwable e) {
                LOG.warn("Failed to track project structure", e);
            }
        });
    }

    void trackProjectStructure(@NotNull Module[] modules) {
        AndroidModuleModel model;
        if (modules == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(1);
        }
        AndroidModuleModel appModel = null;
        AndroidModuleModel libModel = null;
        int appCount = 0;
        int libCount = 0;
        ArrayList<GradleLibrary> gradleLibraries = new ArrayList<GradleLibrary>();
        for (Module module : modules) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null) continue;
            if (androidModel.getProjectType() == 1) {
                libModel = androidModel;
                ++libCount;
                continue;
            }
            appModel = androidModel;
            ++appCount;
            GradleLibrary gradleLibrary = ProjectStructureUsageTracker.trackExternalDependenciesInAndroidApp(androidModel);
            if (gradleLibrary == null) continue;
            gradleLibraries.add(gradleLibrary);
        }
        AndroidModuleModel androidModuleModel = model = appModel != null ? appModel : libModel;
        if (model != null) {
            ArrayList<GradleAndroidModule> gradleAndroidModules = new ArrayList<GradleAndroidModule>();
            ArrayList<GradleNativeAndroidModule> gradleNativeAndroidModules = new ArrayList<GradleNativeAndroidModule>();
            String appId = AndroidStudioUsageTracker.anonymizeUtf8(model.getApplicationId());
            AndroidProject androidProject = model.getAndroidProject();
            GradleVersion gradleVersion = GradleVersions.getInstance().getGradleVersion(this.myProject);
            if (gradleVersion == null) {
                gradleVersion = new GradleVersion(0, 0, 0);
            }
            GradleModule gradleModule = GradleModule.newBuilder().setTotalModuleCount((long)modules.length).setAppModuleCount((long)appCount).setLibModuleCount((long)libCount).build();
            for (Module module : modules) {
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                if (androidModel != null) {
                    gradleAndroidModules.add(GradleAndroidModule.newBuilder().setModuleName(AndroidStudioUsageTracker.anonymizeUtf8(module.getName())).setSigningConfigCount((long)androidModel.getAndroidProject().getSigningConfigs().size()).setIsLibrary(androidModel.getProjectType() == 1).setBuildTypeCount((long)androidModel.getBuildTypeNames().size()).setFlavorCount((long)androidModel.getProductFlavorNames().size()).setFlavorDimension((long)ProjectStructureUsageTracker.getFlavorDimensions(androidModel).size()).build());
                }
                boolean shouldReportNative = false;
                NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
                GradleNativeAndroidModule.NativeBuildSystemType buildSystemType = GradleNativeAndroidModule.NativeBuildSystemType.UNKNOWN_NATIVE_BUILD_SYSTEM_TYPE;
                String moduleName = "";
                if (ndkModuleModel != null) {
                    shouldReportNative = true;
                    if (ndkModuleModel.modelVersionIsAtLeast("2.2.0")) {
                        for (String buildSystem : ndkModuleModel.getAndroidProject().getBuildSystems()) {
                            buildSystemType = ProjectStructureUsageTracker.stringToBuildSystemType(buildSystem);
                        }
                    } else {
                        buildSystemType = GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL;
                    }
                    moduleName = AndroidStudioUsageTracker.anonymizeUtf8(ndkModuleModel.getModuleName());
                } else if (androidModel != null && ProjectStructureUsageTracker.areNativeLibrariesPresent(androidModel.getAndroidProject())) {
                    shouldReportNative = true;
                    buildSystemType = AndroidPluginGeneration.find(module) == AndroidPluginGeneration.COMPONENT ? GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL : GradleNativeAndroidModule.NativeBuildSystemType.NDK_COMPILE;
                }
                if (!shouldReportNative) continue;
                gradleNativeAndroidModules.add(GradleNativeAndroidModule.newBuilder().setModuleName(moduleName).setBuildSystemType(buildSystemType).build());
            }
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE).setKind(AndroidStudioEvent.EventKind.GRADLE_BUILD_DETAILS).setGradleBuildDetails(GradleBuildDetails.newBuilder().setAppId(appId).setAndroidPluginVersion(androidProject.getModelVersion()).setGradleVersion(gradleVersion.toString()).setUserEnabledIr(InstantRunSettings.isInstantRunEnabled()).setModelSupportsIr(InstantRunGradleUtils.modelSupportsInstantRun(model)).setVariantSupportsIr(InstantRunGradleUtils.variantSupportsInstantRun(model)).addAllLibraries(gradleLibraries).addModules(gradleModule).addAllAndroidModules(gradleAndroidModules).addAllNativeAndroidModules(gradleNativeAndroidModules)));
        }
    }

    static GradleNativeAndroidModule.NativeBuildSystemType stringToBuildSystemType(@NotNull String buildSystem) {
        if (buildSystem == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(2);
        }
        switch (buildSystem) {
            case "ndkBuild": {
                return GradleNativeAndroidModule.NativeBuildSystemType.NDK_BUILD;
            }
            case "cmake": {
                return GradleNativeAndroidModule.NativeBuildSystemType.CMAKE;
            }
            case "ndkCompile": {
                return GradleNativeAndroidModule.NativeBuildSystemType.NDK_COMPILE;
            }
            case "gradle": {
                return GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL;
            }
        }
        return GradleNativeAndroidModule.NativeBuildSystemType.UNKNOWN_NATIVE_BUILD_SYSTEM_TYPE;
    }

    private static boolean areNativeLibrariesPresent(@NotNull AndroidProject androidProject) {
        String modelVersion;
        if (androidProject == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(3);
        }
        if ((modelVersion = androidProject.getModelVersion()).startsWith("1.0") || modelVersion.startsWith("1.1") || androidProject.getApiVersion() < 3) {
            return false;
        }
        for (Variant variant : androidProject.getVariants()) {
            Collection nativeLibraries = variant.getMainArtifact().getNativeLibraries();
            if (nativeLibraries == null || nativeLibraries.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Collection<String> getFlavorDimensions(@NotNull AndroidModuleModel androidModel) {
        Collection collection;
        if (androidModel == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(4);
        }
        AndroidProject androidProject = androidModel.getAndroidProject();
        try {
            collection = androidProject.getFlavorDimensions();
        }
        catch (UnsupportedMethodException e) {
            LOG.warn("Invoking 'getFlavorDimensions' on old Gradle model", (Throwable)e);
            List<String> list = Collections.emptyList();
            if (list == null) {
                ProjectStructureUsageTracker.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (collection == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private static GradleLibrary trackExternalDependenciesInAndroidApp(@NotNull AndroidModuleModel model) {
        Collection variants;
        if (model == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(7);
        }
        if ((variants = model.getAndroidProject().getVariants()).isEmpty()) {
            return null;
        }
        Variant chosen = null;
        for (Variant variant : variants) {
            if (!"release".equals(variant.getBuildType())) continue;
            chosen = variant;
            break;
        }
        if (chosen == null) {
            chosen = (Variant)ContainerUtil.getFirstItem((Collection)variants);
        }
        if (chosen != null) {
            return ProjectStructureUsageTracker.trackLibraryCount(chosen, model);
        }
        return null;
    }

    private static GradleLibrary trackLibraryCount(@NotNull Variant variant, @NotNull AndroidModuleModel model) {
        if (variant == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(8);
        }
        if (model == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(9);
        }
        DependencyFiles files = new DependencyFiles();
        AndroidArtifact artifact = variant.getMainArtifact();
        Dependencies dependencies = GradleUtil.getDependencies((BaseArtifact)artifact, model.getModelVersion());
        for (JavaLibrary javaLibrary : dependencies.getJavaLibraries()) {
            ProjectStructureUsageTracker.addJarLibraryAndDependencies(javaLibrary, files);
        }
        for (AndroidLibrary androidLibrary : dependencies.getLibraries()) {
            ProjectStructureUsageTracker.addAarLibraryAndDependencies(androidLibrary, files);
        }
        return GradleLibrary.newBuilder().setAarDependencyCount((long)files.aars.size()).setJarDependencyCount((long)files.jars.size()).build();
    }

    private static void addJarLibraryAndDependencies(@NotNull JavaLibrary javaLibrary, @NotNull DependencyFiles files) {
        File jarFile;
        if (javaLibrary == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(10);
        }
        if (files == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(11);
        }
        if (files.jars.contains(jarFile = javaLibrary.getJarFile())) {
            return;
        }
        files.jars.add(jarFile);
        for (JavaLibrary dependency : javaLibrary.getDependencies()) {
            ProjectStructureUsageTracker.addJarLibraryAndDependencies(dependency, files);
        }
    }

    private static void addAarLibraryAndDependencies(@NotNull AndroidLibrary androidLibrary, @NotNull DependencyFiles files) {
        String gradlePath;
        if (androidLibrary == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(12);
        }
        if (files == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmpty((String)(gradlePath = androidLibrary.getProject()))) {
            File file = androidLibrary.getJarFile();
            if (files.aars.contains(file)) {
                return;
            }
            files.aars.add(file);
            for (AndroidLibrary library : androidLibrary.getLibraryDependencies()) {
                ProjectStructureUsageTracker.addAarLibraryAndDependencies(library, files);
            }
        }
    }

    @Nullable
    public static String getApplicationId(@NotNull Project project) {
        if (project == null) {
            ProjectStructureUsageTracker.$$$reportNull$$$0(14);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null || androidModel.getProjectType() != 0) continue;
            return androidModel.getApplicationId();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSystem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/post/ProjectStructureUsageTracker";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaLibrary";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/ProjectStructureUsageTracker";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlavorDimensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "trackProjectStructure";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stringToBuildSystemType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "areNativeLibrariesPresent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFlavorDimensions";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "trackExternalDependenciesInAndroidApp";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "trackLibraryCount";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addJarLibraryAndDependencies";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addAarLibraryAndDependencies";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DependencyFiles {
        final Set<File> aars = Sets.newHashSet();
        final Set<File> jars = Sets.newHashSet();

        private DependencyFiles() {
        }
    }
}

